c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/pushstate',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'change:currentDomain', this.changePushState );\n\t\t},\n\n\t\tchangePushState: function() {\n\t\t\tvar currentDomain = nfRadio.channel( 'app' ).request( 'get:currentDomain' );\n\t\t\thistory.pushState( null, null, window.location.href + '&domain=' + currentDomain.get( 'id' ) );\n\t\t\tvar reExp = /domain=\\\\d+/;\n\t\t\tvar url = window.location.toString();\n\t\t\tvar newUrl = url.replace( reExp, '' );\n\t\t\tconsole.log( newUrl );\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles our hotkey execution. Needs to be cleaned up and made more programmatic.\n * \n * Our hotkeys are defined by the domain that we're currently viewing. In each domain's model, there is a hotkey object.\n * \n * Currently too much hotkey data is hard-coded here.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/hotkeys',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// When we change our domain, change the hotkeys to those within that object.\n\t\t\tthis.listenTo( nfRadio.channel( 'main' ), 'render:main', this.changeHotkeys );\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'opened', this.changeHotkeys );\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'render:settingGroup', this.changeHotkeys );\n\t\t\t// Currently, these are the functions that run when the new field or new action hotkey is pressed.\n\t\t\t// TODO: move these into a config module or into something more programmatic and scalable.\n\t\t\tthis.listenTo( nfRadio.channel( 'hotkeys' ), 'add:newField', this.addNewField );\n\t\t\tthis.listenTo( nfRadio.channel( 'hotkeys' ), 'add:newAction', this.addNewAction );\n\t\t\t// Same as above, these functions need to be moved into a more modular/programmatic solution.\n\t\t\tthis.listenTo( nfRadio.channel( 'hotkeys' ), 'changeDomain:fields', this.changeDomainFields );\n\t\t\tthis.listenTo( nfRadio.channel( 'hotkeys' ), 'changeDomain:actions', this.changeDomainActions );\n\t\t\tthis.listenTo( nfRadio.channel( 'hotkeys' ), 'changeDomain:settings', this.changeDomainSettings );\n\t\t\tthis.listenTo( nfRadio.channel( 'hotkeys' ), 'close:drawer', this.closeDrawer );\n\t\t},\n\n\t\tchangeHotkeys: function() {\n\t\t\tvar currentDomain = nfRadio.channel( 'app' ).request( 'get:currentDomain' );\n\t\t\tjQuery( document ).off( '.nfDomainHotkeys' );\n\t\t\tjQuery( 'input' ).off( '.nfDomainHotkeys' );\n\t\t\tif ( currentDomain.get( 'hotkeys' ) ) {\n\t\t\t\tjQuery.each( currentDomain.get( 'hotkeys' ), function( hotkey, msg ) {\n\t\t\t\t\tjQuery( document ).on( 'keydown.nfDomainHotkeys', null, hotkey, function( e ) {\n\t\t\t\t\t\tnfRadio.channel( 'hotkeys' ).trigger( msg, e );\n\t\t\t\t\t} );\n\t\t\t\t\tjQuery( 'input' ).on( 'keydown.nfDomainHotkeys', null, hotkey, function( e ) {\n\t\t\t\t\t\tnfRadio.channel( 'hotkeys' ).trigger( msg, e );\n\t\t\t\t\t} );\n\t\t\t\t\tjQuery( 'textarea' ).on( 'keydown.nfDomainHotkeys', null, hotkey, function( e ) {\n\t\t\t\t\t\tnfRadio.channel( 'hotkeys' ).trigger( msg, e );\n\t\t\t\t\t} );\n\t\t\t\t} );\n\t\t\t}\n\t\t},\n\n\t\taddNewField: function() {\n\t\t\tif ( 'addField' != nfRadio.channel( 'app' ).request( 'get:currentDrawer' ) ) {\n\t\t\t\tnfRadio.channel( 'app' ).request( 'open:drawer', 'addField' );\n\t\t\t} else {\n\t\t\t\tnfRadio.channel( 'app' ).request( 'close:drawer' );\n\t\t\t}\n\t\t\t\n\t\t},\n\n\t\taddNewAction: function() {\n\t\t\tif ( 'addAction' != nfRadio.channel( 'app' ).request( 'get:currentDrawer' ) ) {\n\t\t\t\tnfRadio.channel( 'app' ).request( 'open:drawer', 'addAction' );\n\t\t\t} else {\n\t\t\t\tnfRadio.channel( 'app' ).request( 'close:drawer' );\n\t\t\t}\n\t\t},\n\n\t\tchangeDomainFields: function() {\n\t\t\tvar appDomainCollection = nfRadio.channel( 'app' ).request( 'get:domainCollection' );\n\t\t\tvar fieldsDomain = appDomainCollection.get( 'fields' );\n\t\t\tnfRadio.channel( 'app' ).request( 'change:currentDomain', {}, fieldsDomain );\n\t\t},\n\n\t\tchangeDomainActions: function() {\n\t\t\tvar appDomainCollection = nfRadio.channel( 'app' ).request( 'get:domainCollection' );\n\t\t\tvar actionsDomain = appDomainCollection.get( 'actions' );\n\t\t\tnfRadio.channel( 'app' ).request( 'change:currentDomain', {}, actionsDomain );\n\t\t},\n\n\t\tchangeDomainSettings: function() {\n\t\t\tvar appDomainCollection = nfRadio.channel( 'app' ).request( 'get:domainCollection' );\n\t\t\tvar settingsDomain = appDomainCollection.get( 'settings' );\n\t\t\tnfRadio.channel( 'app' ).request( 'change:currentDomain', {}, settingsDomain );\n\t\t},\n\n\t\tcloseDrawer: function() {\n\t\t\tnfRadio.channel( 'app' ).request( 'close:drawer' );\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Change the clean state of our app when settings are changed.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/cleanState',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t/*\n\t\t\t * Set an array of field model attributes to ignore.\n\t\t\t * This list will be filtered just before we ignore anything.\n\t\t\t */ \n\t\t\tthis.ignoreAttributes = [\n\t\t\t\t'editActive'\n\t\t\t];\n\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'update:setting', this.setAppClean );\n\t\t},\n\n\t\tsetAppClean: function( model ) {\n\t\t\tfor( var attr in model.changedAttributes() ) {\n\t\t\t\tvar changedAttr = attr;\n\t\t\t\tvar after = model.changedAttributes()[ attr ];\n\t\t\t}\n\n\t\t\tvar ignoreAttributes = nfRadio.channel( 'undo-' + model.get( 'type' ) ).request( 'ignore:attributes', this.ignoreAttributes ) || this.ignoreAttributes;\n\t\t\t\n\t\t\tif ( -1 != this.ignoreAttributes.indexOf( attr ) ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\tnfRadio.channel( 'app' ).request( 'update:setting', 'clean', false );\n\n\t\t\t//loop through repeater fields to reset active state if needed\n\t\t\tnfRadio.channel( 'fields-repeater' ).trigger( 'clearEditActive', model );\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * All of the core undo functions. Listens on the 'changes' channel for an undo request.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/coreUndo',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tnfRadio.channel( 'changes' ).reply( 'undo:changeSetting', this.undoChangeSetting, this );\n\t\t\tnfRadio.channel( 'changes' ).reply( 'undo:addObject', this.undoAddObject, this );\n\t\t\tnfRadio.channel( 'changes' ).reply( 'undo:removeObject', this.undoRemoveObject, this );\n\t\t\tnfRadio.channel( 'changes' ).reply( 'undo:duplicateObject', this.undoDuplicateObject, this );\n\n\t\t\tnfRadio.channel( 'changes' ).reply( 'undo:sortFields', this.undoSortFields, this );\n\t\t\tnfRadio.channel( 'changes' ).reply( 'undo:addListOption', this.undoAddListOption, this );\n\t\t\tnfRadio.channel( 'changes' ).reply( 'undo:removeListOption', this.undoRemoveListOption, this );\n\t\t\tnfRadio.channel( 'changes' ).reply( 'undo:sortListOptions', this.undoSortListOptions, this );\n\t\t},\n\n\t\t/**\n\t\t * Undo settings that have been changed.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  backbone.model \tchange \tmodel of our change\n\t\t * @param  boolean \t\t\tundoAll are we in the middle of an undo all action?\n\t\t * @return void\n\t\t */\n\t\tundoChangeSetting: function( change, undoAll ) {\n\t\t\tvar fieldModel = change.get( 'model' );\n\t\t\tvar changes = change.get( 'changes' );\n\t\t\tvar attr = changes.attr;\n\t\t\tvar before = changes.before;\n\t\t\tfieldModel.set( attr, before );\n\t\t\tthis.maybeRemoveChange( change, undoAll );\n\t\t},\n\n\t\t/**\n\t\t * Undo adding a field or an action.\n\t\t * Loops through our change collection and removes any change models based upon the one we're removing.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  backbone.model \tchange \tmodel of our change\n\t\t * @param  boolean \t\t\tundoAll are we in the middle of an undo all action?\n\t\t * @return void\n\t\t */\n\t\tundoAddObject: function( change, undoAll ) {\n\t\t\tvar objectModel = change.get( 'model' );\n\t\t\tvar collection = change.get( 'data' ).collection;\n\n\t\t\tif ( 'undefined' != typeof collection.newIDs ) {\n\t\t\t\tdelete collection.newIDs[ objectModel.get( 'id' ) ];\n\t\t\t}\n\t\t\t\t\t\t\n\t\t\tif ( ! undoAll ) {\n\t\t\t\tvar changeCollection = nfRadio.channel( 'changes' ).request( 'get:collection' );\n\t\t\t\tvar results = changeCollection.where( { model: objectModel } );\n\n\t\t\t\t_.each( results, function( model ) {\n\t\t\t\t\tif ( model !== change ) {\n\t\t\t\t\t\tchangeCollection.remove( model );\n\t\t\t\t\t}\n\t\t\t\t} );\t\t\t\t\n\t\t\t}\n\t\t\t\n\t\t\tcollection.remove( objectModel );\n\t\t\tthis.maybeRemoveChange( change, undoAll );\n\t\t},\t\t\n\n\t\t/**\n\t\t * Undo adding a field or an action.\n\t\t * Loops through our change collection and removes any cha