\n\t\t * @param jsAction\n\t\t * @param action\n\t\t */\n\t\tsaveChunkedForm: function( chunks, currentChunk, jsAction, action, formId, new_publish ) {\n\t\t\tvar total_chunks = chunks.length;\n\t\t\tvar postObj = {\n\t\t\t\taction: jsAction,\n\t\t\t\tbatch_type: 'chunked_publish',\n\t\t\t\tdata: {\n\t\t\t\t\tnew_publish: new_publish,\n\t\t\t\t\tchunk_total: total_chunks,\n\t\t\t\t\tchunk_current: currentChunk,\n\t\t\t\t\tchunk: chunks[ currentChunk ],\n\t\t\t\t\tform_id: formId\n\t\t\t\t},\n\t\t\t\tsecurity: nfAdmin.batchNonce\n\t\t\t};\n\n\t\t\tvar that = this;\n\t\t\tjQuery.post( ajaxurl, postObj )\n\t\t\t\t.then( function ( response ) {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tvar res = JSON.parse(response);\n\t\t\t\t\t\tif ( 'success' === res.last_request && ! res.batch_complete) {\n\t\t\t\t\t\t\tconsole.log('Chunk ' + currentChunk + ' processed');\n\n\t\t\t\t\t\t\t// send the next chunk\n\t\t\t\t\t\t\tthat.saveChunkedForm(chunks, res.requesting, jsAction, action, formId, false);\n\t\t\t\t\t\t} else if ( res.batch_complete ) {\n\t\t\t\t\t\t\t/**\n\t\t\t\t\t\t\t * We need to respond with data to make the\n\t\t\t\t\t\t\t * publish button return to gray\n                             */\n\t\t\t\t\t\t\tthat.handleFinalResponse(response, action);\n\t\t\t\t\t\t}\n\t\t\t\t\t} catch ( exception ) {\n\t\t\t\t\t\tconsole.log( 'There was an error in parsing the' +\n\t\t\t\t\t\t\t' response');\n\t\t\t\t\t\tconsole.log( exception );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t).fail( function( xhr, status, error ) {\n\t\t\t\t\tconsole.log( 'There was an error sending form data' );\n\t\t\t\t\tconsole.log( error );\n\t\t\t\t\tthat.handleFinalFailure( xhr, status, error, action );\n\t\t\t\t});\n\t\t},\n\n\t\thandleFinalResponse: function( response, action ) {\n\t\t\ttry {\n\t\t\t\tresponse = JSON.parse( response );\n\t\t\t\tresponse.action = action;\n\n\t\t\t\t// Run anything that needs to happen after we update.\n\t\t\t\tnfRadio.channel( 'app' ).trigger( 'response:updateDB', response );\n\t\t\t\tif ( ! nfRadio.channel( 'app' ).request( 'is:mobile' ) && 'preview' == action ) {\n\t\t\t\t\t// nfRadio.channel( 'notices' ).request( 'add', 'previewUpdate', 'Preview Updated'\t);\n\t\t\t\t}\n\t\t\t} catch( exception ) {\n\t\t\t\tconsole.log( 'Something went wrong!' );\n\t\t\t\tconsole.log( exception );\n\t\t\t}\n\t\t},\n\n\t\thandleFinalFailure: function( xhr, status, error, action ) {\n\t\t\t// For previews, only log to the console.\n\t\t\tif( 'preview' == action ) {\n\t\t\t\tconsole.log( error );\n\t\t\t\treturn;\n\t\t\t}\n\t\t\t// @todo Convert alert to jBox Modal.\n\t\t\talert(xhr.status + ' ' + error + '\\r\\n' + 'An error on the server caused your form not to publish.\\r\\nPlease contact Ninja Forms Support with your PHP Error Logs.\\r\\nhttps://ninjaforms.com/contact');\n\t\t},\n\n\t\tdefaultSaveFilter: function( formContentData ) {\n\t\t\treturn formContentData.pluck( 'key' );\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n\n","/**\n * Model that represents our form data.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/formModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\t\tinitialize: function() {\n\t\t\tif ( ! jQuery.isNumeric( this.get( 'id' ) ) ) {\n\t\t\t\tthis.set( 'show_publish_options', true, { silent: true } );\n\t\t\t} else {\n\t\t\t\tthis.set( 'show_publish_options', false, { silent: true } );\n\t\t\t}\n\t\t}\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Stores our form data and responds to requests for it.\n * Form data stores fields, actions, and settings.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/formData',['models/app/formModel'], function( formModel) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Instantiate Form Model\n\t\t\tthis.model = new formModel( { id: preloadedFormData.id } );\n\t\t\t// Set our field collection\n\t\t\tthis.model.set( 'fields', nfRadio.channel( 'fields' ).request( 'get:collection' ) );\n\t\t\t// Set our actions collection\n\t\t\tthis.model.set( 'actions', nfRadio.channel( 'actions' ).request( 'get:collection' ) );\n\t\t\t// Set our settings collection\n\t\t\tthis.model.set( 'settings', nfRadio.channel( 'settings' ).request( 'get:settings' ) );\n\t\t\t// Respond to requests for form data.\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:formModel', this.getFormModel, this );\n\t\t},\n\n\t\t/**\n\t\t * Return form data model.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return backbone.model\n\t\t */\n\t\tgetFormModel: function() {\n\t\t\treturn this.model;\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles changing our preview link when we change the 'clean' state of our app.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/previewLink',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Listen for events that would change our preview link\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'before:sendChanges', this.disablePreview, this );\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'response:sendChanges', this.enablePreview, this );\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'change:clean', this.changePreviewNicename, this );\n\t\t},\n\n\t\t/**\n\t\t * Disable our preview link before we send data to update our preview.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tdisablePreview: function() {\n\t\t\t// Get our preview domain\n\t\t\tvar appDomains = nfRadio.channel( 'app' ).request( 'get:domainCollection' );\n\t\t\tvar preview = appDomains.get( 'preview' );\n\t\t\t// Set disabled to true. This will trigger the preview link view to redraw.\n\t\t\tpreview.set( 'disabled', true );\n\t\t},\n\n\t\t/**\n\t\t * Change the preview link text from \"Preview Form\" to \"Preview Changes\" or vice-versa\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  boolean \tclean app data state\n\t\t * @return void\n\t\t */\n\t\tchangePreviewNicename: function( clean ) {\n\t\t\t// Get our preview domain\n\t\t\tvar appDomains = nfRadio.channel( 'app' ).request( 'get:domainCollection' );\n\t\t\tvar preview = appDomains.get( 'preview' );\n\n\t\t\t// If we have unsaved changes, set our text to 'changes' otherwise, set it to 'form'\n\t\t\tif ( ! clean ) {\n\t\t\t\tvar nicename = 'Preview Changes';\n\t\t\t} else {\n\t\t\t\tvar nicename = 'Preview Form';\n\t\t\t}\n\n\t\t\tpreview.set( 'nicename', nicename );\n\t\t},\n\n\t\t/**\n\t\t * Enable our preview button.\n\t\t * This is triggered when we get a response from our preview update.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tenablePreview: function() {\n\t\t\t// Get our preview domain\n\t\t\tvar appDomains = nfRadio.channel( 'app' ).request( 'get:domainCollection' );\n\t\t\tvar preview = appDomains.get( 'preview' );\n\t\t\t// Set disabled to false. This will trigger the preview link view to redraw.\n\t\t\tpreview.set( 'disabled', false );\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Listens to our app channel for requests to change the current domain.\n *\n * The app menu and the main submenu both contain clickable links that change the current domain.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/menuButtons',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'click:publish', this.publish );\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'click:viewChanges', this.viewChanges );\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'click:publicLink', this.publicLink );\n\t\t},\n\n\t\tpublish: function() {\n\t\t\tnfRadio.channel( 'app' ).request( 'update:db', 'publish' );\n\t\t},\n\n\t\tviewChanges: function() {\n\t\t\tvar changeCollection = nfRadio.channel( 'changes' ).request( 'get:collection' );\n\t\t\tnfRadio.channel( 'app' ).request( 'open:drawer', 'viewChanges', { collection: changeCollection } );\n\t\t},\n\n\t\tpublicLink: function() {\n\t\t\tnfRadio.channel( 'app' ).request( 'open:drawer', 'publicLink' );\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Model that represents our change data.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/changeModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\t\tdefaults: {\n\t\t\tdisabled: false\n\t\t}\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Holds all of our change models.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/changeCollection',['models/app/changeModel'], function( domainModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: domainModel,\n\n\t\tcomparator: function( model ) {\n\t\t\tvar id = parseInt( model.cid.replace( 'c', '' ) );\n\t\t\treturn -id;\n\t\t}\n\t} );\n\treturn collection;\n} );\n","/**\n * Track settings changes across our app.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/trackChanges',['models/app/changeCollection', 'models/app/changeModel'], function( changeCollection, ChangeModel ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.collection = new changeCollection();\n\t\t\t// Respond to any requests to add a change directly.\n\t\t\tnfRadio.channel( 'changes' ).reply( 'register:change', this.registerChange, this );\n\t\t\t// Respond to requests for the change collection\n\t\t\tnfRadio.channel( 'changes' ).reply( 'get:collection', this.getCollection, this );\n\t\t\t// Listen for changes in our clean state. If it goes to clean, clear our collection.\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'change:clean', this.maybeResetCollection );\n\t\t},\n\n\t\tregisterChange: function( action, model, changes, label, data ) {\n\t\t\tvar data = typeof data !== 'undefined' ? data : {};\n\t\t\tif ( 'undefined' == typeof label.dashicon ) {\n\t\t\t\tlabel.dashicon = 'admin-generic';\n\t\t\t}\n\t\t\tvar changeModel = new ChangeModel({\n\t\t\t\taction: action,\n\t\t\t\tmodel: model,\n\t\t\t\tchanges: changes,\n\t\t\t\tlabel: label,\n\t\t\t\tdata: data\t\t\n\t\t\t} );\n\t\t\tthis.collection.add( changeModel );\n\n\t\t\t//loop through repeater fields to reset active state if needed\n\t\t\tnfRadio.channel( 'fields-repeater' ).trigger( 'clearEditActive', model );\n\t\t\t\n\t\t\treturn changeModel;\n\t\t},\n\n\t\tgetCollection: function() {\n\t\t\treturn this.collection;\n\t\t},\n\n\t\tmaybeResetCollection: function( clean ) {\n\t\t\tif ( clean ) {\n\t\t\t\tthis.collection.reset();\n\t\t\t}\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","define( 'controllers/app/undoChanges',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'click:undoChanges', this.undoChanges, this );\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'click:undoSingle', this.undoSingle, this );\n\t\t},\n\n\t\tundoChanges: function() {\n\t\t\tvar changeCollection = nfRadio.channel( 'changes' ).request( 'get:collection' );\n\t\t\tchangeCollection.sort();\n\t\t\tvar that = this;\n\t\t\t_.each( changeCollection.models, function( change ) {\n\t\t\t\tthat.undoSingle( change, true );\n\t\t\t} );\n\t\t\tchangeCollection.reset();\n\t\t\t// Update preview.\n\t\t\tnfRadio.channel( 'app' ).request( 'update:db' );\t\t\t\n\t\t\tnfRadio.channel( 'app' ).request( 'update:setting', 'clean', true );\n\t\t\tnfRadio.channel( 'app' ).request( 'close:drawer' );\n            this.dispatchClick();\n\t\t},\n\n\t\tundoSingle: function( change, undoAll ) {\n\t\t\tnfRadio.channel( 'changes' ).request( 'undo:' + change.get( 'action' ), change, undoAll );\n            this.dispatchClick();\n\t\t},\n        \n        dispatchClick: function() {\n            // If we already have a cookie, exit.\n            if ( document.cookie.includes( 'nf_undo' ) ) return;\n            // Otherwise, prepare our cookie.\n            var cname = \"nf_undo\";\n            var d = new Date();\n            // Set expiration at 1 week.\n            d.setTime( d.getTime() + ( 7*24*60*60*1000 ) );\n            var expires = \"expires=\"+ d.toUTCString();\n            // Bake the cookie.\n            document.cookie = cname + \"=1;\" + expires + \";path=/\";\n            var data = {\n                action: 'nf_undo_click',\n                security: nfAdmin.ajaxNonce\n            }\n            // Make our AJAX call.\n            jQuery.post( ajaxurl, data );\n        }\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Listens for our update:db response and replaces tmp ids with new ids if we were performing the publish action.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/publishResponse',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Listen to our app channel for the updateDB response.\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'response:updateDB', this.publishResponse );\n\t\t},\n\n\t\tpublishResponse: function( response ) {\n\t\t\t// If we aren't performing a publish action, bail.\n\t\t\tif ( 'publish' !== response.action ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\t\n\t\t\t// Check to see if we have any new ids. \n\t\t\tif ( 'undefined' != typeof response.data.new_ids ) {\n\n\t\t\t\t// If we have any new fields, update their models with the new id.\n\t\t\t\tif ( 'undefined' != typeof response.data.new_ids.fields ) {\n\t\t\t\t\t_.each( response.data.new_ids.fields, function( newID, oldID ) {\n\t\t\t\t\t\tvar field = nfRadio.channel( 'fields' ).request( 'get:field', oldID );\n\t\t\t\t\t\tif ( field ) {\n\t\t\t\t\t\t\tfield.set( 'id', newID );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tfield = nfRadio.channel( 'fields-repeater' ).request( 'get:childField', oldID, null, newID );\n\t\t\t\t\t\t\tfield.set( 'id', newID );\n\t\t\t\t\t\t}\n\t\t\t\t\t} );\n\t\t\t\t}\n\n\t\t\t\t// If we have any new actions, update their models with the new id.\n\t\t\t\tif ( 'undefined' != typeof response.data.new_ids.actions ) {\n\t\t\t\t\t_.each( response.data.new_ids.actions, function( newID, oldID ) {\n\t\t\t\t\t\tvar action = nfRadio.channel( 'actions' ).request( 'get:action', oldID );\n\t\t\t\t\t\tif ( action ) {\n\t\t\t\t\t\t\taction.set( 'id', newID );\n\t\t\t\t\t\t}\n\t\t\t\t\t} );\n\t\t\t\t}\n\n\t\t\t\t// If we have a new form id, update the model with the new id.\n\t\t\t\tif ( 'undefined' != typeof response.data.new_ids.forms ) {\n\t\t\t\t\t_.each( response.data.new_ids.forms, function( newID, oldID ) {\n\t\t\t\t\t\tvar formModel = nfRadio.channel( 'app' ).request( 'get:formModel' );\n\t\t\t\t\t\tformModel.set( 'id', newID );\n\t\t\t\t\t\thistory.replaceState( '', '', 'admin.php?page=ninja-forms&form_id=' + newID );\n\t\t\t\t\t} );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tnfRadio.channel( 'app' ).request( 'update:setting', 'loading', false );\n\t\t\tnfRadio.channel( 'app' ).trigger( 'change:loading' );\n\n\t\t\t// If we're on mobile, show a notice that we're publishing\n\t\t\tif ( nfRadio.channel( 'app' ).request( 'is:mobile' ) ) {\n\t\t\t\tnfRadio.channel( 'notices' ).request( 'close', 'publishing' );\n\t\t\t}\n\t\t\t// Add a notice that we've published.\n//\t\t\tnfRadio.channel( 'notices' ).request( 'add', 'published', 'Changes Published' );\n\t\t\tnfRadio.channel( 'app' ).trigger( 'app:published', response );\n\n\t\t\t// Mark our app as clean. This will disable the publish button and fire anything else that cares about the state.\n\t\t\tnfRadio.channel( 'app' ).request( 'update:setting', 'clean', true );\n\t\t}\n\t\t\n\t});\n\n\treturn controller;\n} );\n","/**\n * Listens to our app channel for requests to change the current domain.\n *\n * The app menu and the main submenu both contain clickable links that change the current domain.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/changeDomain',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Listen for both menu and submenu clicks.\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'click:menu', this.changeAppDomain );\n\t\t\t// Reply to specific requests to change the domain\n\t\t\tnfRadio.channel( 'app' ).reply( 'change:currentDomain', this.changeAppDomain, this );\n\n\t\t\t// Reply to requests to prevent our drawer from closing\n\t\t\tnfRadio.channel( 'app' ).reply( 'prevent:changeDomain', this.preventChange, this );\n\t\t\t// Reply to requests to enable drawer closing\n\t\t\tnfRadio.channel( 'app' ).reply( 'enable:changeDomain', this.enableChange, this );\n\n\t\t\t/*\n\t\t\t * Object that holds our array of 'prevent change' values.\n\t\t\t * We use an array so that registered requests can unregister and not affect each other.\n\t\t\t */\n\t\t\tthis.objPreventChange = {};\n\t\t},\n\n\t\tchangeAppDomain: function( e, model ) {\n\t\t\t/*\n\t\t\t * If we have disabled movement between domains, return false.\n\t\t\t */\n\t\t\tif ( this.maybePreventChange() ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\t/*\n\t\t\t * If we are passed a model, use that model.\n\t\t\t * Otherwise, get the domain from the event target data.\n\t\t\t */ \n\t\t\tif ( 'undefined' == typeof model ) {\n\t\t\t\tvar domainID = jQuery( e.target ).data( 'domain' );\n\t\t\t\tvar model = nfRadio.channel( 'app' ).request( 'get:domainModel', domainID );\n\t\t\t}\n\t\t\t// If a drawer is open, close it.\n\t\t\tif ( nfRadio.channel( 'app' ).request( 'get:currentDrawer' ) ) {\n\t\t\t\tnfRadio.channel( 'app' ).request( 'close:drawer' );\n\t\t\t}\n\t\t\t/*\n\t\t\t * If we aren't dealing with an external url (such as preview), update our app data\n\t\t\t * and trigger a radio message saying we've changed the domain.\n\t\t\t */ \n\t\t\tif ( 0 == model.get( 'url' ).length ) {\n\t\t\t\tvar mainEl = nfRadio.channel( 'app' ).request( 'get:mainEl' );\n\t\t\t\tnfRadio.channel( 'app' ).request( 'update:currentDomain', model );\n\t\t\t\tjQuery( mainEl ).scrollTop( 0 );\t\t\t\t\n\t\t\t\tnfRadio.channel( 'app' ).trigger( 'change:currentDomain', model );\n\t\t\t}\n\t\t},\n\n\t\t/**\n         * Check to see if anything has registered a key to prevent changing the domain.\n         * \n         * @since  3.0\n         * @return boolean\n         */\n        maybePreventChange: function() {\n        \tif ( 0 == Object.keys( this.objPreventChange ).length ) {\n        \t\treturn false;\n        \t} else {\n        \t\treturn true;\n        \t}\n        },\n\n        /**\n         * Register a key to prevent changing the domain.\n         * \n         * @since  3.0\n         * @param  string \tkey unique id for our 'prevent change domain' setting.\n         * @return void\n         */\n        preventChange: function( key ) {\n        \tthis.objPreventChange[ key ] = true;\n        },\n\n        /**\n         * Remove a previously registered key that is preventing our domain from changing.\n         * \n         * @since  3.0\n         * @param  string \tkey unique id for our 'prevent change domain' setting.\n         * @return void\n         */\n        enableChange: function( key ) {\n        \tdelete this.objPreventChange[ key ];\n        },\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Modify the user's browser history wh