w;\n} );\n","/**\n * Default drawer footer\n * \n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/drawer/footerDefault',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-empty'\n\t});\n\n\treturn view;\n} );\n","define( 'models/app/drawerModel',['views/app/drawer/headerDefault', 'views/app/drawer/footerDefault'], function( defaultHeaderView, defaultFooterView ) {\n\tvar model = Backbone.Model.extend( {\n\t\tdefaults: {\n\t\t\tgetHeaderView: function( data ) {\n\t\t\t\treturn new defaultHeaderView( data );\n\t\t\t},\n\n\t\t\tgetFooterView: function( data ) {\n\t\t\t\treturn new defaultFooterView( data );\n\t\t\t}\n\t\t}\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Collection that holds all of our drawer models.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/drawerCollection',['models/app/drawerModel'], function( drawerModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: drawerModel\n\t} );\n\treturn collection;\n} );\n","define( 'views/fields/drawer/stagedField',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-drawer-staged-field',\n\n\t\tonRender: function() {\n\t\t\tthis.$el = this.$el.children();\n\t\t\tthis.$el.unwrap();\n\t\t\tthis.setElement( this.$el );\n\t\t},\n\n\t\tevents: {\n\t\t\t'click .dashicons-dismiss': 'removeStagedField'\n\t\t},\n\n\t\tremoveStagedField: function( el ) {\n\t\t\tnfRadio.channel( 'drawer-addField' ).trigger( 'click:removeStagedField', el, this.model );\n\t\t}\n\t});\n\n\treturn view;\n} );\n\n","define( 'views/fields/drawer/stagingEmpty',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-drawer-staged-fields-empty',\n\n\t\tonRender: function() {\n\t\t\tthis.$el = this.$el.children();\n\t\t\tthis.$el.unwrap();\n\t\t\tthis.setElement( this.$el );\n\t\t}\n\t});\n\n\treturn view;\n} );\n","define( 'views/fields/drawer/stagingCollection',['views/fields/drawer/stagedField', 'views/fields/drawer/stagingEmpty'], function( stagedFieldView, stagedFieldsEmptyView ) {\n\tvar view = Marionette.CollectionView.extend( {\n\t\ttagName: 'div',\n\t\tchildView: stagedFieldView,\n\t\temptyView: stagedFieldsEmptyView,\n\n\t\tactiveClass: 'nf-staged-fields-active', // CSS Class for showing the reservoir.\n\n\t\tinitialize: function() {\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:stagedFieldsEl', this.getStagedFieldsEl, this );\n\t\t},\n\n\t\tonShow: function() {\n\n\t\t\tthis.$el = jQuery( this.el ).parent();\n\t\t\tjQuery( this.$el ).find( 'span:first' ).unwrap();\n\t\t\tthis.setElement( this.$el );\n\n\t\t\tvar that = this;\n\n\t\t\tjQuery( this.el ).sortable( {\n\t\t\t\tplaceholder: 'nf-staged-fields-sortable-placeholder',\n\t\t\t\thelper: 'clone',\n\t\t\t\ttolerance: 'pointer',\n\t\t\t\tover: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'drawer-addField' ).trigger( 'over:stagedFields', e, ui );\n\t\t\t\t},\n\n\t\t\t\tout: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'drawer-addField' ).trigger( 'out:stagedFields', ui );\n\t\t\t\t},\n\n\t\t\t\treceive: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'drawer-addField' ).trigger( 'receive:stagedFields', ui );\n\t\t\t\t},\n\n\t\t\t\tupdate: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'fields' ).request( 'sort:staging' );\n\t\t\t\t},\n\n\t\t\t\tstart: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'drawer-addField' ).trigger( 'start:stagedFields', ui );\n\n\t\t\t\t},\n\n\t\t\t\tstop: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'drawer-addField' ).trigger( 'stop:stagedFields', ui );\n\t\t\t\t}\n\t\t\t} );\n\n\t\t\tjQuery( this.el ).parent().draggable( {\n\t\t\t\topacity: 0.9,\n\t\t\t\tconnectToSortable: '.nf-field-type-droppable',\n\t\t\t\tappendTo: '#nf-main',\n\t\t\t\trefreshPositions: true,\n\t\t\t\tgrid: [ 3, 3 ],\n\t\t\t\ttolerance: 'pointer',\n\n\t\t\t\thelper: function( e ) {\n\t\t\t\t\tvar width = jQuery( e.target ).parent().width();\n\t\t\t\t\tvar height = jQuery( e.target ).parent().height();\n\t\t\t\t\tvar element = jQuery( e.target ).parent().clone();\n\t\t\t\t\tvar left = width / 4;\n\t\t\t\t\tvar top = height / 2;\n\t\t\t\t\tjQuery( this ).draggable( 'option', 'cursorAt', { top: top, left: left } );\n\t\t\t\t\tjQuery( element ).css( 'z-index', 1000 );\n\t\t\t\t\treturn element;\n\t\t\t\t},\n\n\t\t\t\tstart: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'drawer-addField' ).trigger( 'startDrag:fieldStaging', this, ui );\n\t\t\t\t},\n\t\t\t\tstop: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'drawer-addField' ).trigger( 'stopDrag:fieldStaging', this, ui );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tgetStagedFieldsEl: function() {\n\t\t\treturn jQuery( this.el );\n\t\t},\n\n\t\tonAddChild: function() {\n\t\t\tjQuery( this.el ).addClass( this.activeClass );\n\t\t},\n\n\t\tonRemoveChild: function() {\n\t\t\tif( this.hasStagedFields() ) return;\n\t\t\tjQuery( this.el ).removeClass( this.activeClass );\n\t\t},\n\n\t\thasStagedFields: function() {\n\t\t\treturn  0 != this.collection.length;\n\t\t}\n\n\t} );\n\n\treturn view;\n} );\n","/**\n * Model for our staged field.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/fields/stagingModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Collection of staged fields.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/fields/stagingCollection',['models/fields/stagingModel'], function( stagingModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: stagingModel,\n\t\tcomparator: 'order'\n\t} );\n\treturn collection;\n} );\n","define( 'views/fields/drawer/typeSection',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-drawer-field-type-section',\n\n\t\tinitialize: function() {\n\t\t\t_.bindAll( this, 'render' );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:typeSection', this.getTypeSection, this );\n\t\t},\n\n\t\tonRender: function() {\n\t\t\tthis.$el = this.$el.children();\n\t\t\tthis.$el.unwrap();\n\t\t\tthis.setElement( this.$el );\n\n\t\t\tthis.dragging = false;\n\t\t\tvar that = this;\n\t\t\t/*\n\t\t\t * If we're on a mobile device, we don't want to enable dragging for our field type buttons.\n\t\t\t */\n\t\t\tif ( ! nfRadio.channel( 'app' ).request( 'is:mobile' ) ) {\n\t\t\t\tjQuery( this.el ).find( 'div.nf-field-type-draggable' ).draggable( {\n\t\t\t\t\topacity: 0.9,\n\t\t\t\t\ttolerance: 'pointer',\n\t\t\t\t\tconnectToSortable: '.nf-field-type-droppable',\n\t\t\t\t\trefreshPositions: true,\n\t\t\t\t\tgrid: [ 5, 5 ],\n\t\t\t\t\tappendTo: '#nf-builder',\n\n\t\t\t\t\thelper: function( e ) {\n\t\t\t\t\t\tvar width = jQuery( e.target ).parent().width();\n\t\t\t\t\t\tvar height = jQuery( e.target ).parent().height();\n\t\t\t\t\t\tvar element = jQuery( e.target ).parent().clone();\n\t\t\t\t\t\tvar left = width / 4;\n\t\t\t\t\t\tvar top = height / 2;\n\t\t\t\t\t\tjQuery( this ).draggable( 'option', 'cursorAt', { top: top, left: left } );\n\t\t\t\t\t\tjQuery( element ).css( 'z-index', 1000 );\n\t\t\t\t\t\treturn element;\n\t\t\t\t\t},\n\n\t\t\t\t\tstart: function( e