s/app/drawer/mergeTagItem'], function( mergeTagItemView ) {\n\tvar view = Marionette.CompositeView.extend({\n\t\ttagName: 'div',\n\t\tchildView: mergeTagItemView,\n\t\ttemplate: '#tmpl-nf-merge-tags-section',\n\n\t\tinitialize: function() {\n\t\t\tthis.collection = this.model.get( 'tags' );\n\t\t\tthis.model.on( 'change', this.render, this );\n\t\t\tif ( 'fields' == this.model.get( 'id' ) ) {\n\t\t\t\t// var fieldCollection = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\t\t\t\t// fieldCollection.on( 'all', this.updateFields, this );\n\t\t\t}\n\t\t},\n\n\t\tonBeforeDestroy: function() {\n\t\t\tthis.model.off( 'change', this.render );\n\t\t\tif ( 'fields' == this.model.get( 'id' ) ) {\n\t\t\t\tvar fieldCollection = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\t\t\t\tfieldCollection.off( 'all', this.updateFields, this );\n\t\t\t}\n\t\t},\n\n\t\tattachHtml: function( collectionView, childView ) {\n\t\t\tjQuery( collectionView.el ).find( '.merge-tags' ).append( childView.el );\n\t\t},\n\n\t\tupdateFields: function() {\n\t\t\tvar fieldCollection = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\t\t\tthis.model.set( 'tags', fieldCollection );\n\t\t}\n\t});\n\n\treturn view;\n} );\n","/**\n * Model that represents our merge tags.\n * \n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/mergeTagModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\t\tdefaults: {\n\t\t\tactive: false,\n\t\t\texclude: false\n\t\t}\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Collections of merge tags.\n * \n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/mergeTagCollection',['models/app/mergeTagModel'], function( mergeTagModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: mergeTagModel\n\t} );\n\treturn collection;\n} );\n","/**\n * Merge tags popup\n *\n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/drawer/mergeTagsContent',['views/app/drawer/mergeTagsSection', 'models/app/mergeTagCollection'], function( mergeTagsSectionView, MergeTagCollection ) {\n\tvar view = Marionette.CollectionView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-merge-tags-content',\n\t\tchildView: mergeTagsSectionView,\n\n\t\tinitialize: function() {\n\t\t\tnfRadio.channel( 'mergeTags' ).reply( 'get:view', this.getMergeTagsView, this );\n\t\t},\n\n\t\treRender: function( settingModel ) {\n\t\t\tvar mergeTagCollection = nfRadio.channel( 'mergeTags' ).request( 'get:collection' );\n\t\t\tvar defaultGroups = mergeTagCollection.where( { default_group: true } );\n\n\t\t\t/*\n\t\t\t * For the Actions Domain, Add Calc Merge Tags as a Default Group.\n\t\t\t */\n\t\t\tvar currentDomain = nfRadio.channel( 'app' ).request( 'get:currentDomain' );\n\t\t\tif( 'actions' == currentDomain.get( 'id' ) ){\n\t\t\t\tvar calcMergeTagGroup = mergeTagCollection.where( { id: 'calcs' } );\n                defaultGroups = defaultGroups.concat( calcMergeTagGroup );\n            }\n\n\t\t\tthis.collection = new MergeTagCollection( defaultGroups );\n\t\t\tvar that = this;\n\t\t\tvar useMergeTags = settingModel.get( 'use_merge_tags' );\n\t\t\tif ( 'object' == typeof useMergeTags ) {\n\t\t\t\tif ( 'undefined' != typeof useMergeTags.exclude ) {\n\t\t\t\t\t_.each( useMergeTags.exclude, function( exclude ) {\n\t\t\t\t\t\tthat.collection.remove( exclude )\n\t\t\t\t\t} );\n\t\t\t\t}\n\n\t\t\t\tif ( 'undefined' != typeof useMergeTags.include ) {\n\t\t\t\t\t_.each( mergeTagCollection.models, function( sectionModel ) {\n\t\t\t\t\t\tif ( -1 != useMergeTags.include.indexOf( sectionModel.get( 'id' ) ) ) {\n\t\t\t\t\t\t\t// console.log( sectionModel );\n\t\t\t\t\t\t\tthat.collection.add( sectionModel );\n\t\t\t\t\t\t}\n\t\t\t\t\t} );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tthis.render();\n\t\t},\n\n\t\tgetMergeTagsView: function() {\n\t\t\treturn this;\n\t\t}\n\t});\n\n\treturn view;\n} );\n","/**\n * Builder view.\n *\n * This layout view has regions that represent our application areas:\n * header\n * main\n * menuDrawer - Mobile side-menu\n * drawer\n *\n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/builder',['views/app/builderHeader', 'views/app/main', 'views/app/mobileMenu', 'views/app/drawer', 'views/app/drawer/mergeTagsContent'], function( headerView, mainView, mobileMenuView, drawerView, mergeTagsContentView ) {\n\tvar view = Marionette.LayoutView.extend( {\n\t\ttemplate: \"#tmpl-nf-builder\",\n\t\tel: '#nf-builder',\n\n\t\tregions: {\n\t\t\theader: \"#nf-header\",\n\t\t\tmain: \"#nf-main\",\n\t\t\tmenuDrawer: \"#nf-menu-drawer\",\n\t\t\tdrawer: \"#nf-drawer\",\n\t\t\tmergeTagsContent: '.merge-tags-content'\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\t// Respond to requests asking for the builder dom element.\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:builderEl', this.getBuilderEl, this );\n\t\t\t// Respond to requests asking for the builder view\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:builderView', this.getBuilderView, this );\n\t\t\t// Layout views aren't self-rendering.\n\t\