\t\t\tvar mergeTagsClone = mergeTags.clone();\n\t\t\tthis.mergeTagsContent.show( new mergeTagsContentView( { collection: mergeTagsClone } ) );\n\t\t\t// Show our header.\n\t\t\tthis.header.show( new headerView() );\n\t\t\t// Show our main content.\n\t\t\tthis.main.show( new mainView() );\n\t\t\t// Show our mobile menu\n\t\t\tvar appDomainCollection = nfRadio.channel( 'app' ).request( 'get:domainCollection' );\n\t\t\tthis.menuDrawer.show( new mobileMenuView( { collection: appDomainCollection } ) );\n\t\t\t// Show our drawer.\n\t\t\tthis.drawer.show( new drawerView() );\n\n\n\t\t},\n\n\t\tonRender: function() {\n\n\t\t},\n\n\t\tgetBuilderEl: function() {\n\t\t\treturn this.el;\n\t\t},\n\n\t\tgetBuilderView: function() {\n\t\t\treturn this;\n\t\t},\n\n\t\t// Listen for clicks\n\t\tevents: {\n\t\t\t'click .nf-open-drawer': 'openDrawer',\n\t\t\t'click .nf-change-domain': 'changeDomain',\n\t\t\t'click .nf-close-drawer': 'closeDrawer'\n\t\t},\n\n\t\t/**\n\t\t * Someone clicked to open a drawer, so fire a radio event.\n\t\t * This lets us separate the logic from the click event and view.\n\t\t *\n\t\t * @since  3.0\n\t\t * @param  Object \te \tevent\n\t\t * @return void\n\t\t */\n\t\topenDrawer: function( e ) {\n\t\t\tnfRadio.channel( 'app' ).trigger( 'click:openDrawer', e );\n\t\t},\n\t\t/**\n\t\t * Someone clicked to close a drawer, so fire a radio event.\n\t\t * This lets us separate the logic from the click event and view.\n\t\t *\n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tcloseDrawer: function() {\n\t\t\tnfRadio.channel( 'app' ).trigger( 'click:closeDrawer' );\n\t\t},\n\t\t/**\n\t\t * Someone clicked to change the domain, so fire a radio event.\n\t\t * This lets us separate the logic from the click event and view.\n\t\t *\n\t\t * @since  3.0\n\t\t * @param  Object \te \tevent\n\t\t * @return void\n\t\t */\n\t\tchangeDomain: function( e ) {\n\t\t\tnfRadio.channel( 'app' ).trigger( 'click:menu', e );\n\t\t}\n\n\t} );\n\n\treturn view;\n} );\n\n","\ndefine( 'controllers/app/remote',[], function() {\n    return Marionette.Object.extend( {\n        initialize: function() {\n            this.listenTo( nfRadio.channel( 'setting' ), 'remote', this.addListener );\n        },\n\n        addListener: function( model, dataModel ) {\n\n            var listenTo = model.get( 'remote' ).listen;\n\n            // TODO: Change seems to be triggering twice on each update.\n            this.listenTo( nfRadio.channel( 'fieldSetting-' + listenTo ), 'update:setting', this.updateSetting );\n            this.listenTo( nfRadio.channel( 'actionSetting-' + listenTo ), 'update:setting', this.updateSetting );\n\n            this.listenTo( nfRadio.channel( 'setting-type-' + model.get( 'type' ) ), 'click:extra', this.clickExtra );\n\n            model.listenTo( nfRadio.channel( 'setting-remote' ), 'get:remote', this.getRemote, model );\n\n            // Auto-trigger get:remote on drawer load.\n            nfRadio.channel( 'setting-remote' ).trigger( 'get:remote', dataModel );\n        },\n\n        clickExtra: function( e, settingModel, dataModel, settingView ) {\n            jQuery( e.srcElement ).addClass( 'spin' );\n            nfRadio.channel( 'setting-remote' ).trigger( 'get:remote', dataModel );\n        },\n\n        updateSetting: function( dataModel, settingModel ) {\n            nfRadio.channel( 'setting-remote' ).trigger( 'get:remote', dataModel );\n        },\n\n        getRemote: function( dataModel ) {\n\n            var remote = this.get( 'remote' );\n\n            var data = {\n                parentValue: dataModel.get( remote.listen ),\n                action: remote.action,\n                security: ( remote.security ) ? remote.security : nfAdmin.ajaxNonce\n            };\n\n            // TODO: Disable setting and lock drawer while updating.\n            var that = this;\n            jQuery.post( ajaxurl, data, function( response ){\n                var response = JSON.parse( response );\n\n                if( 'textbox' == that.get( 'type' ) ) {\n                    dataModel.set( that.get('name'), response.value );\n                }\n\n                if( 'select' == that.get( 'type' ) ) {\n                    that.set( 'options', response.options );\n                    that.trigger( 'rerender' );\n                }\n            });\n        },\n\n    });\n} );\n","/**\n * Handles opening and closing our drawer. This is where we display settings for fields, actions, and settings.\n *\n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/drawer',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Listen to our drawer-related click events.\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'click:openDrawer', this.clickOpenDrawer );\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'click:closeDrawer', this.closeDrawer );\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'click:toggleDrawerSize', this.toggleDrawerSize );\n\n\t\t\t// Reply to direct requests to open or close the drawer.\n\t\t\tnfRadio.channel( 'app' ).reply( 'open:drawer', this.openDrawer, this );\n\t\t\tnfRadio.channel( 'app' ).reply( 'close:drawer', this.closeDrawer, this );\n\n\t\t\t/*\n\t\t\t * When we close the drawer, we have to figure out what the right position should be.\n\t\t\t * This listens to requests from other parts of our app asking what the closed right position is.\n\t\t\t */\n\t\t\tnfRadio.channel( 'drawer' ).reply( 'get:closedRightPos', this.getClosedDrawerPos, this );\n\n\t\t\t// Reply to requests to prevent our drawer from closing\n\t\t\tnfRadio.channel( 'drawer' ).reply( 'prevent:close', this.preventClose, this );\n\t\t\t// Reply to requests to enable drawer closing\n\t\t\tnfRadio.channel( 'drawer' ).reply( 'enable:close', this.enableClose, this );\n\t\t\t// Reply to requests for our disabled/enabled state.\n\t\t\tnfRadio.channel( 'drawer' ).reply( 'get:preventClose', this.maybePreventClose, this );\n\n\t\t\t/*\n\t\t\t * Object that holds our array of 'prevent close' values.\n\t\t\t * We use an array so that registered requests can unregister and not affect each other.\n\t\t\t */\n\t\t\tthis.objPreventClose = {};\n\n\t\t\t/*\n\t\t\t *  Listen to focus events on the filter and stop our interval when it happens.\n\t\t\t *  This is to fix a bug that can cause the filter to gain focus every few seconds.\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'filter:focused', this.filterFocused );\n\t\t},\n\n\t\t/**\n\t\t * Handles closing our drawer\n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tcloseDrawer: function() {\n\t\t\t// Get our current domain.\n\t\t\tvar currentDrawer = nfRadio.channel( 'app' ).request( 'get:currentDrawer' );\n            if ( ! currentDrawer || this.maybePreventClose() ) {\n                return false;\n            }\n\n\t\t\t// Triggers the before close drawer action on our current domain's drawer channel.\n\t\t\tnfRadio.channel( 'drawer-' + currentDrawer.get( 'id' ) ).trigger( 'before:closeDrawer' );\n\t\t\t/*\n\t\t\t * The 'before:closeDrawer' message is deprecated as of version 3.0 in favour of 'before:close'.\n\t\t\t * TODO: Remove this radio message in the future.\n\t\t\t */\n\t\t\tnfRadio.channel( 'drawer' ).trigger( 'before:closeDrawer' );\n\t\t\tnfRadio.channel( 'drawer' ).trigger( 'before:close' );\n\t\t\t// Send a message to our drawer to empty its contents.\n\t\t\tnfRadio.channel( 'drawer' ).request( 'empty:drawerContent' );\n\n\t\t\t// To close our drawer, we have to add our closed class to the builder and remove the opened class.\n\t\t\tvar builderEl = nfRadio.channel( 'app' ).request( 'get:builderEl' );\n\t\t\tjQuery( builderEl ).addClass( 'nf-drawer-closed' ).removeClass( 'nf-drawer-opened' );\n\t\t\tjQuery( builderEl ).removeClass( 'disable-main' );\n\n\t\t\t// Get the right position of our closed drawer. Should be container size in -px.\n\t\t\tvar rightClosed = this.getClosedDrawerPos();\n\n\t\t\t// Get our drawer element and give change the 'right' property to our closed position.\n\t\t\tvar drawerEl = nfRadio.channel( 'app' ).request( 'get:drawerEl' );\n\t\t\tjQuery( drawerEl ).css( { 'right': rightClosed } );\n\n\t\t\t// In order to access properties in 'this' context in our interval below, we have to set it here.\n\t\t\tvar that = this;\n\n\t\t\t/*\n\t\t\t * Since jQuery can't bind to a CSS change, we poll every .15 seconds to see if we've closed the drawer.\n\t\t\t *\n\t\t\t * Once our drawer is closed, we:\n\t\t\t * clear our interval\n\t\t\t * request that the app change it's current drawer to false\n\t\t\t * trigger a drawer closed message\n\t\t\t */\n\t\t\tthis.checkCloseDrawerPos = setInterval( function() {\n\t        \tif ( rightClosed == jQuery( drawerEl ).css( 'right' ) ) {\n\t        \t\tclearInterval( that.checkCloseDrawerPos );\n\t\t    \t\tnfRadio.channel( 'app' ).request( 'update:currentDrawer', false );\n\t\t    \t\tnfRadio.channel( 'drawer' ).trigger( 'closed' );\n\t\t    \t\t/*\n\t\t    \t\t * Reset the add new button z-index to 98.\n\t\t    \t\t */\n\t\t    \t\tjQuery( '.nf-master-control' ).css( 'z-index', 98 );\n\t\t    \t\tjQuery( '.nf-secondary-control' ).css( 'z-index', 98 );\n\t\t    \t\t// jQuery( drawerEl ).scrollTop( 0 );\n\t        \t}\n\t\t\t}, 150 );\n\t\t},\n\n\t\t/**\n\t\t * Click handler for our 'open drawer' event.\n\t\t * @since  3.0\n\t\t * @param  e jQuery event\n\t\t * @return void\n\t\t */\n\t\tclickOpenDrawer: function( e ) {\n\t\t\tvar drawerID = jQuery( e.target ).data( 'drawerid' );\n\t\t\tthis.openDrawer( drawerID );\n\t\t},\n\n\t\t/**\n\t\t * Open our drawer.\n\t\t *\n\t\t * @since  3.0\n\t\t * @param  string drawerID \tID of the drawer we want to open.\n\t\t * @param  object data     \tOptional data that we want to pass to the drawer.\n\t\t * @return void\n\t\t */\n\t\topenDrawer: function( drawerID, data ) {\n\t\t\tif ( this.maybePreventClose() ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\t// If we haven't sent a data object, set the variable to an empty object.\n\t\t\tdata = data || {};\n\n\t\t\t/*\n\t\t\t * If we're dealing with something that has a model, set the proper active state.\n\t\t\t *\n\t\t\t * TODO: Make this more dynamic. I'm not sure that it fits in the drawer controller.\n\t\t\t */\n\t\t\tif ( 'undefined' != typeof data.model ) {\n\t\t\t\tvar currentDomain = nfRadio.channel( 'app' ).request( 'get:currentDomain' );\n\t\t\t\tvar currentDomainID = currentDomain.get( 'id' );\n\t\t\t\tnfRadio.channel( currentDomainID ).request( 'clear:editActive' );\n\t\t\t\tdata.model.set( 'editActive', true );\n\t\t\t\tthis.dataModel = data.model;\n\t\t\t}\n\n\t\t\t// Send out a message requesting our drawer view to load the content for our drawer ID.\n\t\t\tnfRadio.channel( 'drawer' ).request( 'load:drawerContent', drawerID, data );\n\t\t\tnfRadio.channel( 'drawer' ).trigger( 'before:open' );\n\n\t\t\t// To open our drawer, we have to add our opened class to our builder element and remove the closed class.\n\t\t\tvar builderEl = nfRadio.channel( 'app' ).request( 'get:builderEl' );\n\t\t\tjQuery( builderEl ).addClass( 'nf-drawer-opened' ).removeClass( 'nf-drawer-closed' );\n\n\t\t\t// To open our drawer, we have to set the right position of our drawer to 0px.\n\t\t\tvar drawerEl = nfRadio.channel( 'app' ).request( 'get:drawerEl' );\n\t\t\tjQuery( drawerEl ).css( { 'right': '0px' } );\n\n\t\t\t// In order to access properties in 'this' context in our interval below, we have to set it here.\n\t\t\tvar that = this;\n\n\t\t\t/*\n\t\t\t * Since jQuery can't bind to a CSS change, we poll every .15 seconds to see if we've opened the drawer.\n\t\t\t *\n\t\t\t * Once our drawer is opened, we:\n\t\t\t * clear our interval\n\t\t\t * focus our filter\n\t\t\t * request that the app update its current drawer to the one we opened\n\t\t\t * trigger a drawer opened message\n\t\t\t */\n\t\t\tthis.hasFocus = false;\n\n\t\t\t/*\n\t\t\t * Set our add new button z-index to 0;\n\t\t\t */\n\t\t\tjQuery( '.nf-master-control' ).css( 'z-index', 0 );\n\t\t\tjQuery( '.nf-secondary-control' ).css( 'z-index', 0 );\n\n\t\t\tthis.checkOpenDrawerPos = setInterval( function() {\n\t        \tif ( '0px' == jQuery( drawerEl ).css( 'right' ) ) {\n\t        \t\tclearInterval( that.checkOpenDrawerPos );\n\t\t\t\t\tif ( ! that.hasFocus ) {\n\t\t        \t\tthat.focusFilter();\n\t\t\t\t\t\tthat.hasFocus = true;\n\t\t\t    \t\tnfRadio.channel( 'app' ).request( 'update:currentDrawer', drawerID );\n\t\t\t    \t\tjQuery( drawerEl ).scrollTop( 0 );\n\t\t\t    \t\tnfRadio.channel( 'drawer' ).trigger( 'opened' );\n\t\t\t\t\t}\n\t        \t}\n\t\t\t}, 150 );\n\t\t},\n\n\t\t/**\n\t\t * Toggle the drawer from half to full screen and vise-versa\n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\ttoggleDrawerSize: function() {\n\t\t\t// Get our drawer element.\n\t\t\tvar drawerEl = nfRadio.channel( 'app' ).request( 'get:drawerEl' );\n\t\t\t// toggle our drawer size class.\n\t\t\tjQuery( drawerEl ).toggleClass( 'nf-drawer-expand' );\n\t\t},\n\n\t\t/**\n\t\t * Focus our filter\n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n        focusFilter: function() {\n        \t// Get our filter element\n        \tvar filterEl = nfRadio.channel( 'drawer' ).request( 'get:filterEl' );\n        \t// Focus\n        \tjQuery( filterEl ).focus();\n        },\n\n        /**\n         * Get the CSS right position (in px) of the closed drawer element.\n         * This is calculated by:\n         * getting the width of the builder element\n         * add 300 pixels\n         * make it negative\n         *\n         * @since  3.0\n         * @return void\n         */\n        getClosedDrawerPos: function() {\n\t\t\tvar builderEl = nfRadio.channel( 'app' ).request( 'get:builderEl' );\n\t\t\tvar closedPos = jQuery( builderEl ).width() + 300;\n\t\t\treturn '-' + closedPos + 'px';\n        },\n\n        /**\n         * Check to see if anything has registered a prevent close key.\n         *\n         * @since  3.0\n         * @return boolean\n         */\n        maybePreventClose: function() {\n        \tif ( 0 == Object.keys( this.objPreventClose ).length ) {\n        \t\treturn false;\n        \t} else {\n        \t\treturn true;\n        \t}\n        },\n\n        /**\n         * Register a prevent close key.\n         *\n         * @since  3.0\n         * @param  string \tkey unique id for our 'prevent close' setting.\n         * @return void\n         */\n        preventClose: function( key ) {\n        \tthis.objPreventClose[ key ] = true;\n        \t/*\n        \t * When we disable closing the drawer, add the disable class.\n        \t */\n        \t// Get our current drawer.\n\t\t\tthis.dataModel.set( 'drawerDisabled', true );\n        },\n\n        /**\n         * Remove a previously registered prevent close key.\n         *\n         * @since  3.0\n         * @param  string \tkey unique id for our 'prevent close' setting.\n         * @return void\n         */\n        enableClose: function( key ) {\n        \tdelete this.objPreventClose[ key ];\n        \t /*\n        \t * When we remove all of our disables preventing closing the drawer, remove the disable class.\n        \t */\n        \tif ( ! this.maybePreventClose() && 'undefined' != typeof this.dataModel ) {\n\t        \t// Get our current drawer.\n\t\t\t\tthis.dataModel.set( 'drawerDisabled', false );\n        \t}\n        },\n\n        /**\n         * When we focus our filter, make sure that our open drawer interval is cleared.\n         *\n         * @since  3.0\n         * @return void\n         */\n        filterFocused: function() {\n        \tclearInterval( this.checkOpenDrawerPos );\n        },\n\n        getPreventClose: function() {\n        \treturn this.objPreventClose;\n        }\n\t});\n\n\treturn controller;\n} );\n","/**\n * Default drawer header.\n *\n * Includes our filter/search and 'Done' button.\n *\n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/drawer/headerDefault',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-drawer-header-default',\n\n\t\tinitialize: function() {\n\t\t\tif ( this.model ) {\n\t\t\t\t// Listen for our drawer being disabled.\n\t\t\t\tthis.model.on( 'change:drawerDisabled', this.render, this );\t\t\t\t\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * When we render, remove the extra div added by backbone and add listeners related to our filter.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tonRender: function() {\n\t\t\t// Remove extra wrapping div.\n\t\t\tthis.$el = this.$el.children();\n\t\t\tthis.$el.unwrap();\n\t\t\tthis.setElement( this.$el );\n\t\t\t// Respond to requests related to our filter.\n\t\t\tnfRadio.channel( 'drawer' ).reply( 'clear:filter', this.clearFilter, this );\n\t\t\tnfRadio.channel( 'drawer' ).reply( 'blur:filter', this.blurFilter, this );\n\t\t\tnfRadio.channel( 'drawer' ).reply( 'get:filterEl', this.getEl, this );\n\t\t},\n\n\t\tonBeforeDestroy: function() {\n\t\t\tif ( this.model ) {\n\t\t\t\tthis.model.off( 'change:drawerDisabled', this.render );\n\t\t\t}\n\t\t},\n\n\t\tevents: {\n\t\t\t'keyup .nf-filter'\t: 'maybeChangeFilter',\n\t\t\t'input .nf-filter'\t: 'changeFilter',\n\t\t\t'focus input'\t\t: 'getFocus'\n\t\t},\n\n\t\t/**\n\t\t * When the filter text is changed, trigger an event on our current drawer.\n\t\t * This lets us keep the logic separate from the click event and view.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \te event\n\t\t * @return void\n\t\t */\n\t\tchangeFilter: function( e ) {\n\t\t\tvar currentDrawer = nfRadio.channel( 'app' ).request( 'get:currentDrawer' );\n\t\t\tnfRadio.channel( 'drawer-' + currentDrawer.get( 'id' ) ).trigger( 'change:filter', e.target.value, e );\n\t\t},\n\n\t\t/**\n\t\t * The user pressed a key. If it's the enter key, then run the change filter function.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \te event\n\t\t * @return void\n\t\t */\n\t\tmaybeChangeFilter: function( e ) {\n\t\t\tif ( 13 == e.keyCode ) {\n\t\t\t\te.addObject = true;\n\t\t\t\tthis.changeFilter( e );\t\t\t\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Clear our filter.\n\t\t *\n\t\t * This triggers 'input' on the field, which will trigger a change if necessary.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tclearFilter: function() {\n\t\t\tvar filterEl =  jQuery( this.el ).find( '.nf-filter' );\n\t\t\tif ( '' != String(filterEl.val()).trim() ) {\n\t\t\t\tfilterEl.val('');\n\t\t\t\tfilterEl.trigger( 'input' );\n\t\t\t\tfilterEl.focus();\t\t\t\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Fire the 'blur' event on our filter. Used to force a change event when the user tabs.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tblurFilter: function() {\n\t\t\tjQuery( this.el ).find( '.nf-filter' ).blur();\n\t\t},\n\n\t\t/**\n\t\t * Return our filter dom element.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return Object\n\t\t */\n\t\tgetEl: function() {\n\t\t\treturn jQuery( this.el ).find( '.nf-filter' );\n\t\t},\n\n\t\tgetFocus: function() {\n\t\t\tnfRadio.channel( 'drawer' ).trigger( 'filter:focused' );\n\t\t},\n\n\t\ttemplateHelpers: function() {\n\t\t\treturn {\n\t\t\t\trenderDisabled: function() {\n\t\t\t\t\t// Get our current domain.\n\t\t\t\t\tif ( this.drawerDisabled ) {\n\t\t\t\t\t\treturn 'disabled';\n\t\t