r( 'startDrag:type', this, ui );\n\t\t\t\t\t},\n\n\t\t\t\t\tstop: function( e, ui ) {\n\t\t\t\t\t\tthat.dragging = false;\n\t\t\t\t\t\tnfRadio.channel( 'drawer-addField' ).trigger( 'stopDrag:type', this, ui );\n\t\t\t\t\t},\n\n\t\t\t\t\tdrag: function(e, ui) {\n\t\t\t\t\t\tnfRadio.channel( 'drawer-addField' ).trigger( 'drag:type', this, ui, e );\t\n\t\t\t\t\t}\n\n\t\t\t\t} ).disableSelection();\n\n\t\t\t\tjQuery( this.el ).find( '.nf-item' ).focus( function() {\n\t\t\t    \tjQuery( this ).addClass( 'active' );\n\t\t\t    } ).blur( function() {\n\t\t\t    \tjQuery( this ).removeClass( 'active' );\n\t\t\t    } );\n\t\t\t}\n\t\t},\n\n\t\tevents: {\n\t\t\t'click .nf-item': 'clickFieldType',\n\t\t\t'keydown .nf-item': 'maybeClickFieldType',\n\t\t\t'mousedown .nf-item': 'mousedownFieldType'\n\t\t},\n\n\t\tclickFieldType: function( e ) {\n\t\t\tif( e.target.classList.contains('available') ) {\n\t\t\t\tvar id = jQuery( e.target ).data( 'id' );\n\t\t\t\tvar type = nfRadio.channel( 'fields' ).request( 'get:type', id );\n\t\t\t\tvar modalContent = type.get( 'modal_content' );\n\n\t\t\t\tvar fieldModal = new jBox( 'Modal', {\n\t\t\t\t  content: modalContent,\n\t\t\t\t  zIndex:99999999,\n\t\t\t\t  closeButton: 'box',\n\t\t\t\t  overlay: true,\n\t\t\t\t  width: 600,\n\t\t\t\t  repositionOnOpen: true,\n\t\t\t\t  reposition: true\n\t\t\t\t});\n\n\t\t\t\tfieldModal.open();\n\t\t\t} else if ( ! this.dragging ) {\n\t\t\t\tnfRadio.channel( 'drawer' ).trigger( 'click:fieldType', e );\n\t\t\t}\n\t\t},\n\n\t\tmousedownFieldType: function( e ) {\n\t\t\tjQuery( e.target).addClass( 'clicked' );\n\t\t\tsetTimeout( function() {\n\t\t\t\tjQuery( e.target ).removeClass( 'clicked' );\n\t\t\t}, 1500 );\n\t\t},\n\n\t\tmaybeClickFieldType: function( e ) {\n\t\t\tif ( 13 == e.keyCode ) {\n\t\t\t\tthis.clickFieldType( e );\n\t\t\t\tnfRadio.channel( 'drawer' ).request( 'clear:filter' );\n\t\t\t}\n\t\t},\n\n\t\ttemplateHelpers: function() {\n\t\t\treturn {\n\t\t\t\trenderFieldTypes: function() {\n\t\t\t        var html = document.createElement( 'span' );\n\t\t\t        var that = this;\n\t\t\t        _.each( this.fieldTypes, function( id ) {\n\t\t\t            var type = nfRadio.channel( 'fields' ).request( 'get:type', id );\n\t\t\t            var nicename = _.escape(type.get('nicename'));\n\t\t\t            var icon = type.get( 'icon' );\n\t\t\t            var renderType = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-drawer-field-type-button' );\n\t\t\t            var templateHTML = renderType( { id: id, nicename: nicename, icon: icon, type: type, savedField: that.savedField, availableField: that.availableField } );\n                        var htmlFragments = document.createRange().createContextualFragment( templateHTML );\n                        html.appendChild( htmlFragments );\n\t\t\t        } );\n\t\t\t        return html.innerHTML;\n\t\t\t\t},\n\n\t\t\t\tsavedField: function() {\n\t\t\t\t\tif( this.type.get( 'savedField' ) ) {\n\t\t\t\t\t\treturn 'nf-saved';\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn '';\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tavailableField: function() {\n\t\t\t\t\tif('undefined' !== typeof(this.type.get('modal_content'))) {\n\t\t\t\t\t\treturn 'available';\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn '';\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tgetTypeSection: function() {\n\t\t\treturn this.el;\n\t\t}\n\t});\n\n\treturn view;\n} );\n\n","define( 'views/fields/drawer/typeSectionCollection',['views/fields/drawer/typeSection'], function( fieldTypeSectionView ) {\n\tvar view = Marionette.CollectionView.extend( {\n\t\ttagName: 'div',\n\t\tchildView: fieldTypeSectionView,\n\n\t\tonShow: function() {\n\t\t\tjQuery( this.el ).find( '.nf-settings' ).unwrap();\n\t\t\tnfRadio.channel( 'fields' ).request( 'clear:editActive' );\n\t\t}\n\t} );\n\n\treturn view;\n} );\n","define( 'views/fields/drawer/addField',['views/fields/drawer/stagingCollection', 'models/fields/stagingCollection', 'views/fields/drawer/typeSectionCollection'], function( drawerStagingView, StagingCollection, fieldTypeSectionCollectionView ) {\n\n\tvar view = Marionette.LayoutView.extend( {\n\t\ttemplate: '#tmpl-nf-drawer-content-add-field',\n\n\t\tregions: {\n\t\t\tstaging: '#nf-drawer-staging .nf-reservoir',\n\t\t\tprimary: '#nf-drawer-primary',\n\t\t\tsecondary: '#nf-drawer-secondary'\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'filter:fieldTypes', this.filterFieldTypes );\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'clear:filter', this.removeFieldTypeFilter );\n\n\t\t\tthis.savedCollection = nfRadio.channel( 'fields' ).request( 'get:savedFields' );\n\t\t\tthis.primaryCollection = this.savedCollection;\n\n\t\t\tthis.fieldTypeSectionCollection = nfRadio.channel( 'fields' ).request( 'get:typeSections' );\n\t\t\tthis.secondaryCollection = this.fieldTypeSectionCollection;\n\n\t\t},\n\n\t\tonShow: function() {\n\t\t\tvar stagingCollection = nfRadio.channel( 'fields' ).request( 'get:staging' );\n\t\t\tthis.staging.show( new drawerStagingView( { collection: stagingCollection } ) );\n\n\t\t\tthis.primary.show( new fieldTypeSectionCollectionView( { collection: this.primaryCollection } ) );\n\t\t\tthis.secondary.show( new fieldTypeSectionCollectionView( { collection: this.secondaryCollection } ) );\n\t\t},\n\n\t\tgetEl: function() {\n\t\t\treturn jQuery( this.el ).parent();\n\t\t},\n\n\t\tfilterFieldTypes: function( filteredSectionCollection ) {\n\t\t\tthis.primary.reset();\n\t\t\tthis.secondary.reset();\n\t\t\tthis.filteredSectionCollection = filteredSectionCollection;\n\t\t\tthis.primary.show( new fieldTypeSectionCollectionView( { collection: this.filteredSectionCollection } ) );\n\t\t},\n\n\t\tremoveFieldTypeFilter: function () {\n\t\t\tthis.primary.show( new fieldTypeSectionCollectionView( { collection: this.savedCollection } ) );\n\t\t\tthis.secondary.show( new fieldTypeSectionCollectionView( { collection: this.fieldTypeSectionCollection } ) );\n\t\t}\n\n\t} );\n\n\treturn view;\n} );\n","define( 'views/app/drawer/itemSettingCollection',[], function() {\n\tvar view = Marionette.CollectionView.extend( {\n\t\ttagName: 'div',\n\n\t\tinitialize: function( data ) {\n\t\t\tthis.childViewOptions = { dataModel: data.dataModel };\n\t\t},\n\n\t\tgetChildView: function( model ) {\n\t\t\treturn nfRadio.channel( 'app' ).request( 'get:settingChildView', model );\n\t\t}\n\t} );\n\n\treturn view;\n} );\n","define( 'views/app/drawer/itemSettingGroup',['views/app/drawer/itemSettingCollection'], function( itemSettingCollectionView ) {\n\tvar view = Marionette.LayoutView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-drawer-content-edit-field-setting-group',\n\t\t\n\t\tregions: {\n\t\t\tsettings: '.nf-field-settings'\n\t\t},\n\n\t\tinitialize: function( data ) {\n\t\t\tthis.model.on( 'change', this.render, this );\n\t\t\tthis.dataModel = data.dataModel;\n\t\t},\n\n\t\tonBeforeDestroy: function() {\n\t\t\tthis.model.off( 'change', this.render );\n\t\t},\n\n\t\tonRender: function() {\n\n\t\t\tthis.settings.show( new itemSettingCollectionView( { collection: this.model.get( 'settings' ), dataModel: this.dataModel } ) );\n\n\t\t\tif(!nfAdmin.devMode) {\n\t\t\t\t// Only check if not for calculations.\n\t\t\t\tif(0 == this.$el.find('.calculations').length){\n\t\t\t\t\tvar visibleSettings = false;\n\t\t\t\t\tthis.$el.find('.nf-setting').each(function(index, setting) {\n\t\t\t\t\t\tif( 'none' !== setting.style.display ){\n\t\t\t\t\t\t\tvisibleSettings = true;\n\t\t\t\t\t\t\treturn false; //Exit jQuery each loop.\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tif(!visibleSettings) {\n\t\t\t\t\t\tthis.$el.hide();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( this.model.get( 'display' ) ) {\n\t\t\t\t// ...\n\t\t\t} else {\n\t\t\t\tthis.settings.empty();\n\t\t\t}\n\n\t\t\tnfRadio.channel( 'drawer' ).trigger( 'render:settingGroup', this );\n\t\t},\n\n\t\tevents: {\n\t\t\t'click .toggle': 'clickToggleGroup'\n\t\t},\n\n\t\tclickToggleGroup: function( e ) {\n\t\t\tnfRadio.channel( 'drawer' ).trigger( 'click:toggleSettingGroup', e, this.model );\n\t\t},\n\n\t\ttemplateHelpers: function() {\n\t\t\treturn {\n\t\t\t\trenderLabel: function() {\n\t\t\t\t\tif ( '' != this.label ) {\n\t\t\t\t\t\tvar groupLabel = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-drawer-content-edit-setting-group-label' );\n\t\t\t\t\t\treturn groupLabel( this );\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn '';\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\trenderArrowDir: function() {\n\t\t\t\t\tif ( this.display ) {\n\t\t\t\t\t\treturn 'down';\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn 'right';\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\n\treturn view;\n} );\n","define( 'views/app/drawer/itemSettingGroupCollection',['views/app/drawer/itemSettingGroup'], function( itemSettingGroupView ) {\n\tvar view = Marionette.CollectionView.extend( {\n\t\ttagName: 'div',\n\t\tchildView: itemSettingGroupView,\n\n\t\tinitialize: function( data ) {\n\t\t\tthis.childViewOptions = { dataModel: data.dataModel };\n\t\t}\n\t} );\n\n\treturn view;\n} );\n","define( 'views/app/drawer/editSettings',['views/app/drawer/itemSettingGroupCollection'], function( itemSettingGroupCollectionView ) {\n\tvar view = Marionette.LayoutView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-drawer-content-edit-settings',\n\n\t\tregions: {\n\t\t\tsettingTitle: '.nf-setting-title',\n\t\t\tsettingGroups: '.nf-setting-groups'\n\t\t},\n\n\t\tinitialize: function( data ) {\n\t\t\tthis.dataModel = data.model;\n\t\t\tthis.groupCollection = data.groupCollection;\n\t\t},\n\n\t\tonRender: function() {\n\t\t\tif( 'undefined' != typeof this.options.typeModel && 'undefined' != typeof this.options.typeModel.id ) {\n\t\t\t\t// Set the object domain for advanced settings groups.\n\t\t\t\tthis.model.set( 'objectDomain', this.options.typeModel.id );\n\t\t\t}\n\t\t\tvar currentDomain = nfRadio.channel( 'app' ).request( 'get:currentDomain' );\n\t\t\tvar titleView = currentDomain.get( 'getSettingsTitleView' ).call( currentDomain, { model: this.model } );\n\n\t\t\tthis.settingTitle.show( titleView );\n\t\t\tthis.settingGroups.show( new itemSettingGroupCollectionView( { collection: this.groupCollection, dataModel: this.dataModel } ) );\n\t\t},\n\n\t\ttemplateHelpers: function () {\n\t    \treturn {\n\t    \t\tmaybeRenderTitle: function() {\n\t    \t\t\tif ( 'undefined' !== typeof this.type ) {\n\t    \t\t\t\tvar title = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-drawer-content-edit-settings-title' );\n\t    \t\t\t\treturn title( this );\n\t    \t\t\t} else {\n\t    \t\t\t\treturn '';\n\t    \t\t\t}\n\t    \t\t},\n\n\t    \t\trenderTypeNicename: function() {\n\t    \t\t\tvar currentDomain = nfRadio.channel( 'app' ).request( 'get:currentDomain' );\n\t\t\t\t\tvar domainID = currentDomain.get( 'id' );\n\t    \t\t\tvar type = nfRadio.channel( domainID ).request( 'get:type', this.type );\n\t    \t\t\treturn type.get( 'nicename' );\n\t\t\t\t},\n\t\t\t};\n\t\t},\n\t});\n\n\treturn view;\n} );\n","/**\n * Edit Settings drawer header.\n *\n * Includes our 'Done' button.\n *\n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/drawer/headerEditSettings',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-drawer-header-edit-settings',\n\n\t\tinitialize: function() {\n\t\t\tif ( this.model ) {\n\t\t\t\t// Listen for our drawer being disabled.\n\t\t\t\tthis.model.on( 'change:drawerDisabled', this.render, this );\t\t\t\t\n\t\t\t}\n\t\t},\n\n\t\tonBeforeDestroy: function() {\n\t\t\tif ( this.model ) {\n\t\t\t\tthis.model.off( 'change:drawerDisabled', this.render );\n\t\t\t}\n\t\t},\n\n\t\ttemplateHelpers: function() {\n\t\t\treturn {\n\t\t\t\trenderDisabled: function() {\n\t\t\t\t\t// Get our current domain.\n\t\t\t\t\tif ( this.drawerDisabled ) {\n\t\t\t\t\t\treturn 'disabled';\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn '';\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\n\treturn view;\n} );\n","/**\n * Button to add an action to the form.\n *\n * TODO: make dynamic\n * \n * @package Ninja Forms builder\n * @subpackage Actions\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/actions/drawer/typeButton',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-drawer-action-type-button',\n\n\t\tonRender: function() {\n\t\t\t\n\t\t\tjQuery( this.el ).disableSelection();\n\t\t\t\n\t\t\tif ( 'installed' == this.model.get( 'section') ) {\n\t\t\t\tvar that = this;\n\t\t\t\tjQuery( this.el ).draggable( {\n\t\t\t\t\topacity: 0.9,\n\t\t\t\t\ttolerance: 'intersect',\n\t\t\t\t\tscroll: false,\n\t\t\t\t\thelper: 'clone',\n\n\t\t\t\t\tstart: function( e, ui ) {\n\t\t\t\t\t\tthat.dragging = true;\n\t\t\t\t\t\tnfRadio.channel( 'drawer-addAction' ).trigger( 'startDrag:type', this, ui );\n\t\t\t\t\t},\n\n\t\t\t\t\tstop: function( e, ui ) {\n\t\t\t\t\t\tthat.dragging = false;\n\t\t\t\t\t\tnfRadio.channel( 'drawer-addAction' ).trigger( 'stopDrag:type', this, ui );\n\t\t\t\t\t}\n\n\t\t\t\t} );\n\t\t\t}\n\t\t\t\n\t\t},\n\n\t\tevents: {\n\t\t\t'click .nf-item': 'clickAddAction'\n\t\t},\n\n\t\tclickAddAction: function( e ) {\n\t\t\tif ( ! this.dragging ) {\n\t\t\t\tif ( 'installed' == this.model.get( 'section' ) ) { // Is this an installed action?\n\t\t\t\t\tnfRadio.channel( 'actions' ).trigger( 'click:addAction', this.model );\n\t\t\t\t} else { // This isn't an installed action\n\t\t\t\t\twindow.open( this.model.get( 'link' ), '_blank' );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\ttemplateHelpers: function() {\n\t\t\treturn {\n\t\t\t\trenderClasses: function() {\n\t\t\t\t\tvar classes = 'nf-item';\n\n\t\t\t\t\tif ( 'installed' == this.section ) {\n\t\t\t\t\t\tclasses += ' nf-action-type';\n\t\t\t\t\t}\n\t\t\t\t\treturn classes;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\n\treturn view;\n} );\n\n","define( 'views/actions/drawer/typeCollection',['views/actions/drawer/typeButton'], function( actionTypeButtonView ) {\n\tvar view = Marionette.CompositeView.extend( {\n\t\ttemplate: '#tmpl-nf-drawer-action-type-section',\n\t\tchildView: actionTypeButtonView,\n\n\t\ttemplateHelpers: function() {\n\t\t\tvar that = this;\n\t\t\treturn {\n\t\t\t\thasContents: function() {\n\t\t\t\t\treturn that.collection.length > 0;\n\t\t\t\t},\n\n\t\t\t\trenderNicename: function() {\n\t\t\t\t\treturn that.collection.nicename;\n\t\t\t\t},\n\n\t\t\t\trenderClasses: function() {\n\t\t\t\t\treturn that.collection.slug;\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tattachHtml: function( collectionView, childView ) {\n\t\t\tjQuery( collectionView.el ).find( '.action-types' ).append( childView.el );\n\t\t}\n\t} );\n\n\treturn view;\n} );\n","/**\n * Model that represents our setting.\n *\n * When the model is created, we trigger the init event in two radio channels.\n *\n * This lets specific types of settings modify the model before anything uses it.\n *\n * Fieldset, for instance, uses this hook to instantiate its settings as a collection.\n * \n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/settingModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\t\tdefaults: {\n\t\t\tsettings: false,\n\t\t\thide_merge_tags: false,\n\t\t\terror: false\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\t// Send out two messages saying that we've initialized a setting model.\n\t\t\tnfRadio.channel( 'app' ).trigger( 'init:settingModel', this );\n\t\t\tnfRadio.channel( this.get( 'type' ) ).trigger( 'init:settingModel', this );\n\t\t\tnfRadio.channel( 'setting-name-' + this.get( 'name' ) ).trigger( 'init:settingModel', this );\n\t\t\tthis.on( 'change:error', this.maybePreventUI, this );\n\n\t\t\t/*\n\t\t\t * If we have an objectType set on our collection, then we're creating a model for the generic settings collection.\n\t\t\t * If we're using merge tags in this setting\n\t\t\t */\n\t\t\tif( 'undefined' == typeof this.collection ) return;\n\n\t\t\tif ( this.get( 'use_merge_tags' ) && 'undefined' != typeof this.collection.options.objectType ) {\n\t\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'update:fieldKey', this.updateKey );\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * When a field key is updated, send out a radio message requesting that this setting be checked for the old key.\n\t\t * We want to send the message on the objectType channel.\n\t\t * This means that if this setting is for fields, it will trigger on the fields channel, actions, etc.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Backbone.Model \tkeyModel data model representing the field for which the key just changed\n\t\t * @return void\n\t\t */\n\t\tupdateKey: function( keyModel ) {\n\t\t\tnfRadio.channel( 'app' ).trigger( 'fire:updateFieldKey', keyModel, this );\n\t\t},\n\n\t\tmaybePreventUI: function() {\n\t\t\tif ( this.get( 'error' ) ) {\n\t\t\t\tnfRadio.channel( 'drawer' ).request( 'prevent:close', 'setting-' + this.get( 'name' ) + '-error' );\n\t\t\t\tnfRadio.channel( 'app' ).request( 'prevent:changeDomain', 'setting-' + this.get( 'name' ) + '-error' );\t\t\t\t\n\t\t\t} else {\n\t\t\t\tnfRadio.channel( 'drawer' ).request( 'enable:close', 'setting-' + this.get( 'name' ) + '-error' );\n\t\t\t\tnfRadio.channel( 'app' ).request( 'enable:changeDomain', 'setting-' + this.get( 'name' ) + '-error' );\n\t\t\t}\n\t\t}\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Collections of settings for each field type.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/settingCollection',['models/app/settingModel'], function( settingModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: settingModel,\n\n\t\tinitialize: function( models, options ) {\n\t\t\tthis.options = options || {};\n\t\t}\n\t} );\n\treturn collection;\n} );\n","/**\n * Model that represents our type settings groups.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/settingGroupModel',[ 'models/app/settingCollection' ], function( SettingCollection ) {\n\tvar model = Backbone.Model.extend( {\n\t\tdefaults: {\n\t\t\tdisplay: false\n\t\t},\n\n\t\tinitialize: function( options ) {\n\t\t\tif ( false == this.get( 'settings' ) instanceof Backbone.Collection ) {\n\t\t\t\tthis.set( 'settings', new SettingCollection( this.get( 'settings' ) ) );\n\t\t\t}\n\t\t}\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Collection of our type settings groups.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/settingGroupCollection',['models/app/settingGroupModel'], function( settingGroupModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: settingGroupModel\n\t} );\n\treturn collection;\n} );\n","/**\n * Model for our field type\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/typeModel',[ 'models/app/settingGroupCollection' ], function( SettingGroupCollection ) {\n\tvar model = Backbone.Model.extend( {\n\t\tinitialize: function() {\n\t\t\tif ( false === this.get( 'settingGroups' ) instanceof Backbone.Collection ) {\n\t\t\t\tthis.set( 'settingGroups', new SettingGroupCollection( this.get( 'settingGroups' ) ) );\n\t\t\t}\n\t\t\t\n\t\t\tnfRadio.channel( 'fields' ).trigger( 'init:typeModel', this );\n\t\t}\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Collection that holds our field type models. \n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/typeCollection',['models/app/typeModel'], function( typeModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: typeModel,\n\t\ttype: false,\n\n\t\tinitialize: function( models, options ) {\n\t\t\t_.each( options, function( option, key ) {\n\t\t\t\tthis[ key ] = option;\n\t\t\t}, this );\n\t\t}\n\t} );\n\treturn collection;\n} );\n","/**\n * Add action drawer.\n *\n * TODO: make dynamic\n * \n * @package Ninja Forms builder\n * @subpackage Actions\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/actions/drawer/addAction',['views/actions/drawer/typeCollection', 'models/app/typeCollection'], function( actionTypeCollectionView, actionTypeCollection ) {\n\n\tvar view = Marionette.LayoutView.extend( {\n\t\ttemplate: '#tmpl-nf-drawer-content-add-action',\n\n\t\tregions: {\n\t\t\tprimary: '#nf-drawer-primary',\n\t\t\tcore: '#nf-drawer-primary-core',\n\n\t\t\tmanagement: '#nf-drawer-secondary-management',\n\t\t\tpayments: '#nf-drawer-secondary-payments',\n\t\t\tautomation: '#nf-drawer-secondary-automation',\n\t\t\tmarketing: '#nf-drawer-secondary-marketing',\n\t\t\tcrms: '#nf-drawer-secondary-crms',\n\t\t\tnotifications: '#nf-drawer-secondary-notifications',\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'filter:actionTypes', this.filteractionTypes );\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'clear:filter', this.removeactionTypeFilter );\n\t\t\n\t\t\tthis.installedActions = nfRadio.channel( 'actions' ).request( 'get:installedActions' );\n\t\t\tthis.updateInstalledActionGroups();\n\n\t\t\tthis.availableActions = nfRadio.channel( 'actions' ).request( 'get:availableActions' );\n\t\t\tthis.updateAvailableActionGroups();\n\t\t},\n\n\t\tonShow: function() {\n\t\t\tthis.primary.show( new actionTypeCollectionView( { collection: this.primaryCollection } ) );\n\t\t\tthis.core.show( new actionTypeCollectionView( { collection: this.coreCollection } ) );\n\n\t\t\tthis.payments.show( new actionTypeCollectionView( { collection: this.paymentsCollection } ) );\n\t\t\tthis.marketing.show( new actionTypeCollectionView( { collection: this.marketingCollection } ) );\n\t\t\tthis.management.show( new actionTypeCollectionView( { collection: this.managementCollection } ) );\n\t\t\tthis.crms.show( new actionTypeCollectionView( { collection: this.crmCollection } ) );\n\t\t\tthis.notifications.show( new actionTypeCollectionView( { collection: this.notificationsCollection } ) );\n\t\t\tthis.automation.show( new actionTypeCollectionView( { collection: this.automationCollection } ) );\t\t\n\t\t},\n\n\t\tgetEl: function() {\n\t\t\treturn jQuery( this.el ).parent();\n\t\t},\n\n\t\tfilteractionTypes: function( filteredInstalled, filteredAvailable ) {\n\t\t\tthis.installedActions = filteredInstalled;\n\t\t\tthis.updateInstalledActionGroups();\n\t\t\tthis.primary.reset().show( new actionTypeCollectionView( { collection: this.primaryCollection } ) );\n\t\t\tthis.core.reset().show( new actionTypeCollectionView( { collection: this.coreCollection } ) );\n\n\t\t\tthis.availableActions = filteredAvailable;\n\t\t\tthis.updateAvailableActionGroups();\n\t\t\tthis.payments.reset().show( new actionTypeCollectionView( { collection: this.paymentsCollection } ) );\n\t\t\tthis.marketing.reset().show( new actionTypeCollectionView( { collection: this.marketingCollection } ) );\n\t\t\tthis.management.reset().show( new actionTypeCollectionView( { collection: this.managementCollection } ) );\n\t\t\tthis.crms.reset().show( new actionTypeCollectionView( { collection: this.crmCollection } ) );\n\t\t\tthis.notifications.reset().show( new actionTypeCollectionView( { collection: this.notificationsCollection } ) );\n\t\t\tthis.automation.reset().show( new actionTypeCollectionView( { collection: this.automationCollection } ) );\t\n\t\t\t\n\t\t},\n\n\t\tremoveactionTypeFilter: function () {\n\t\t\tthis.installedActions = nfRadio.channel( 'actions' ).request( 'get:installedActions' );\n\t\t\tthis.updateInstalledActionGroups();\n\t\t\tthis.primary.show( new actionTypeCollectionView( { collection: this.primaryCollection } ) );\n\t\t\tthis.core.show( new actionTypeCollectionView( { collection: this.coreCollection } ) );\n\n\t\t\tthis.availableActions = nfRadio.channel( 'actions' ).request( 'get:availableActions' );\n\t\t\tthis.updateAvailableActionGroups();\n\t\t\tthis.payments.show( new actionTypeCollectionView( { collection: this.paymentsCollection } ) );\n\t\t\tthis.marketing.show( new actionTypeCollectionView( { collection: this.marketingCollection } ) );\n\t\t\tthis.management.show( new actionTypeCollectionView( { collection: this.managementCollection } ) );\n\t\t\tthis.crms.show( new actionTypeCollectionView( { collection: this.crmCollection } ) );\n\t\t\tthis.notifications.show( new actionTypeCollectionView( { collection: this.notificationsCollection } ) );\n\t\t\tthis.automation.show( new actionTypeCollectionView( { collection: this.automationCollection } ) );\n\t\t},\n\n\t\tupdateInstalledActionGroups: function() {\n\t\t\tthis.primaryCollection = new actionTypeCollection(\n\t\t\t\tthis.installedActions.where({group: ''}),\n\t\t\t\t{\n\t\t\t\t\tslug: 'installed',\n\t\t\t\t\tnicename: 'Installed Add-on Actions'\n\t\t\t\t} \n\t\t\t);\n\t\t\tthis.primaryCollection.comparator = 'nicename';\n\t\t\tthis.primaryCollection.sort();\n\n\t\t\tthis.coreCollection = new actionTypeCollection(\n\t\t\t\tthis.installedActions.where({group: 'core'}),\n\t\t\t\t{\n\t\t\t\t\tslug: 'core',\n\t\t\t\t\tnicename: 'Core Actions'\n\t\t\t\t} \n\t\t\t);\n\t\t},\n\n\t\tupdateAvailableActionGroups: function() {\n\t\t\tthis.paymentsCollection = new actionTypeCollection(\n\t\t\t\tthis.availableActions.where({group: 'payments'}),\n\t\t\t\t{\n\t\t\t\t\tslug: 'payments',\n\t\t\t\t\tnicename: 'Accept Payments & Donations'\n\t\t\t\t} \n\t\t\t);\n\n\t\t\tthis.marketingCollection = new actionTypeCollection(\n\t\t\t\tthis.availableActions.where({group: 'marketing'}),\n\t\t\t\t{\n\t\t\t\t\tslug: 'marketing',\n\t\t\t\t\tnicename: 'Email Marketing'\n\t\t\t\t} \n\t\t\t);\n\n\t\t\tthis.managementCollection = new actionTypeCollection(\n\t\t\t\tthis.availableActions.where({group: 'management'}),\n\t\t\t\t{\n\t\t\t\t\tslug: 'management',\n\t\t\t\t\tnicename: 'User & Submission Management'\n\t\t\t\t} \n\t\t\t);\n\n\t\t\tthis.crmCollection = new actionTypeCollection(\n\t\t\t\tthis.availableActions.where({group: 'crms'}),\n\t\t\t\t{\n\t\t\t\t\tslug: 'crms',\n\t\t\t\t\tnicename: 'CRMs'\n\t\t\t\t} \n\t\t\t);\n\n\t\t\tthis.notificationsCollection = new actionTypeCollection(\n\t\t\t\tthis.availableActions.where({group: 'notifications'}),\n\t\t\t\t{\n\t\t\t\t\tslug: 'notifications',\n\t\t\t\t\tnicename: 'Notifications & Workflow'\n\t\t\t\t} \n\t\t\t);\n\n\t\t\tthis.automationCollection = new actionTypeCollection(\n\t\t\t\tthis.availableActions.where({group: 'automation'}),\n\t\t\t\t{\n\t\t\t\t\tslug: 'automation',\n\t\t\t\t\tnicename: 'Automation'\n\t\t\t\t} \n\t\t\t);\n\t\t}\n\n\t} );\n\n\treturn view;\n} );\n","/**\n * Individual change item.\n *\n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/drawer/contentViewChangesItem',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-drawer-content-view-changes-item',\n\n\t\tinitialize: function() {\n\t\t\tthis.model.on( 'change:disabled', this.render, this );\n\t\t},\n\n\t\tonBeforeDestroy: function() {\n\t\t\tthis.model.off( 'change:disabled', this.render );\n\t\t},\n\n\t\t/**\n\t\t * When we render this element, remove the extra wrapping <div> that backbone creates.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tonRender: function() {\n\t\t\tthis.$el = this.$el.children();\n\t\t\tthis.$el.unwrap();\n\t\t\tthis.setElement( this.$el );\n\t\t},\n\n\t\tevents: {\n\t\t\t'click .undoSingle': 'undoSingle'\n\t\t},\n\n\t\tundoSingle: function( e ) {\n\t\t\tnfRadio.channel( 'drawer' ).trigger( 'click:undoSingle', this.model );\n\t\t}\n\t});\n\n\treturn view;\n} );\n","/**\n * Changes collection view.\n *\n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/drawer/contentViewChanges',['views/app/drawer/contentViewChangesItem'], function( viewChangesItem ) {\n\tvar view = Marionette.CollectionView.extend( {\n\t\ttagName: 'table',\n        className: 'nf-changes',\n\t\tchildView: viewChangesItem\n\t} );\n\n\treturn view;\n} );\n\n","/**\n * Handles clicks on the 'view changes' button in the header.\n * \n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/drawer/headerViewChanges',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-drawer-header-view-changes',\n\n\t\tevents: {\n\t\t\t'click .undoChanges': 'clickUndoChanges'\n\t\t},\n\n\t\tclickUndoChanges: function( e ) {\n\t\t\tnfRadio.channel( 'drawer' ).trigger( 'click:undoChanges' );\n\t\t}\n\t});\n\n\treturn view;\n} );\n","/**\n * Error view used for settings.\n *\n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/drawer/settingError',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-edit-setting-error'\n\t});\n\n\treturn view;\n} );\n","define( 'views/app/drawer/itemSetting',['views/app/drawer/mergeTagsContent', 'views/app/drawer/settingError'], function( mergeTagsContentView, settingErrorView ) {\n\tvar view = Marionette.LayoutView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-edit-setting-wrap',\n\n\t\tregions: {\n\t\t\terror: '.nf-setting-error'\n\t\t},\n\n\t\tinitialize: function( data ) {\n\t\t\tthis.dataModel = data.dataModel;\n\t\t\t/*\n\t\t\t * Send out a request on the setting-type-{type} channel asking if we should render on dataModel change.\n\t\t\t * Defaults to false.\n\t\t\t * This lets specific settings, like RTEs, say that they don't want to be re-rendered when their data model changes.\n\t\t\t */\n\t\t\tvar renderOnChange = ( 'undefined' == typeof nfRadio.channel( 'setting-type-' + this.model.get( 'type' ) ).request( 'renderOnChange' ) ) ? false : nfRadio.channel( 'setting-type-' + this.model.get( 'type' ) ).request( 'renderOnChange' );\n\t\t\t\n\t\t\tif ( renderOnChange ) {\n\t\t\t\tthis.dataModel.on( 'change:' + this.model.get( 'name' ), this.render, this );\n\t\t\t}\n\n\t\t\tthis.model.on( 'change:error', this.renderError, this );\n\t\t\tthis.model.on( 'change:warning', this.renderWarning, this );\n\n\t\t\tvar deps = this.model.get( 'deps' );\n\t\t\tif ( deps ) {\n\t\t\t\t// If we don't have a 'settings' property, this is a legacy depdency setup.\n\t\t\t\tif ( 'undefined' == typeof deps.settings ) {\n\t\t\t\t\tdeps.settings = [];\n\t\t\t\t\t_.each(deps, function(dep, name){\n\t\t\t\t\t\tif( 'settings' !== name ) {\n\t\t\t\t\t\t\tdeps.settings.push( { name: name, value: dep } );\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tdeps.match = 'all';\n\t\t\t\t}\n\n\t\t\t\tfor (var i = deps.settings.length - 1; i >= 0; i--) {\n\t\t\t\t\tlet name = deps.settings[i].name;\n\t\t\t\t\tthis.dataModel.on( 'change:' + name, this.render, this );\n\t\t\t\t}\n\t\t\t}\n\n            /**\n\t\t\t * For settings that require a remote refresh\n\t\t\t *   add an \"update\"/refresh icon to the label.\n             */\n            var remote = this.model.get( 'remote' );\n\t\t\tif( remote ) {\n                if( 'undefined' != typeof remote.refresh || remote.refresh ) {\n\t\t\t\t\tvar labelText, updateIcon, updateLink, labelWrapper;\n\n                    labelText = document.createTextNode( this.model.get('label') );\n\n                    updateIcon = document.createElement( 'span' );\n                    updateIcon.classList.add( 'dashicons', 'dashicons-update' );\n\n                    updateLink = document.createElement( 'a' );\n                    updateLink.classList.add( 'extra' );\n                    updateLink.appendChild( updateIcon );\n\n                    // Wrap the label text and icon/link in a parent element.\n                    labelWrapper = document.createElement( 'span' );\n                    labelWrapper.appendChild( labelText );\n                    labelWrapper.appendChild( updateLink );\n\n                    // The model expects a string value.\n                    this.model.set('label', labelWrapper.innerHTML );\n                }\n\n\t\t\t\tnfRadio.channel( 'setting' ).trigger( 'remote', this.model, this.dataModel, this );\n\t\t\t\tthis.model.on( 'rerender', this.render, this );\n\t\t\t}\n\n\t\t\t/*\n\t\t\t * When our drawer opens, send out a radio message on our setting type channel.\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'opened', this.drawerOpened );\n\n\t\t\t/*\n\t\t\t * When our drawer closes, send out a radio message on our setting type channel.\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'closed', this.drawerClosed );\n\t\t},\n\n\t\tonBeforeDestroy: function() {\n\t\t\tthis.dataModel.off( 'change:' + this.model.get( 'name' ), this.render );\n\t\t\tthis.model.off( 'change:error', this.renderError );\n\n\t\t\tvar deps = this.model.get( 'deps' );\n\t\t\tif ( deps ) {\n\t\t\t\tfor (var i = deps.settings.length - 1; i >= 0; i--) {\n\t\t\t\t\tlet name = deps.settings[i].name;\n\t\t\t\t\tthis.dataModel.off( 'change:' + name, this.render );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif( this.model.get( 'remote' ) ) {\n\t\t\t\tthis.model.off( 'rerender', this.render, this );\n\t\t\t}\n\n\t\t\t/*\n\t\t\t * Send out a radio message.\n\t\t\t */\n\t\t\tnfRadio.channel( 'setting-' + this.model.get( 'name' ) ).trigger( 'destroy:setting', this.model, this.dataModel, this );\n\t\t\tnfRadio.channel( 'setting-type-' + this.model.get( 'type' ) ).trigger( 'destroy:setting', this.model, this.dataModel, this );\n\t\t\n\t\t\t/*\n\t\t\t * Unescape any HTML being saved if we are a textbox.\n\t\t\t */\n\t\t\tif ( 'textbox' == this.model.get( 'type' ) ) {\n\t\t\t\tvar setting = this.model.get( 'name' );\n\t\t\t\tvar value = this.dataModel.get( setting );\n\t\t\t\tthis.dataModel.set( setting, _.unescape( value ), { silent: true } );\n\t\t\t}\n\n\t\t},\n\n\t\tonBeforeRender: function() {\n\t\t\t/*\n\t\t\t * We want to escape any HTML being output if we are a textbox.\n\t\t\t */\n\t\t\tif ( 'textbox' == this.model.get( 'type' ) ) {\n\t\t\t\tvar setting = this.model.get( 'name' );\n\t\t\t\tvar value = this.dataModel.get( setting );\n\t\t\t\tthis.dataModel.set( setting, _.escape( value ), { silent: true } );\n\t\t\t}\n\t\t\t\n\t\t\tnfRadio.channel( 'app' ).trigger( 'before:renderSetting', this.model, this.dataModel );\n\t\t\tnfRadio.channel( 'setting-type-' + this.model.get( 'type' ) ).trigger( 'before:renderSetting', this.model, this.dataModel, this );\n\t\t\tnfRadio.channel( 'setting-' + this.model.get( 'name' ) ).trigger( 'before:renderSetting', this.model, this.dataModel, this );\n\t\t},\n\n\t\tonRender: function() {\n\t\t\tthis.mergeTagsContentView = false;\n\t\t\tvar that = this;\n\n\t\t\t/*\n\t\t\t * Send out a radio message.\n\t\t\t */\n\t\t\tnfRadio.channel( 'setting-' + this.model.get( 'name' ) ).trigger( 'render:setting', this.model, this.dataModel, this );\n\t\t\tnfRadio.channel( 'setting-type-' + this.model.get( 'type' ) ).trigger( 'render:setting', this.model, this.dataModel, this );\n\n\t\t\tjQuery( this.el ).find( '.nf-help' ).each(function() {\n\t\t\t\tvar content = jQuery(this).next('.nf-help-text');\n\t\t\t\tjQuery( this ).jBox( 'Tooltip', {\n\t\t\t\t\tcontent: content,\n\t\t\t\t\tmaxWidth: 200,\n\t\t\t\t\ttheme: 'TooltipBorder',\n\t\t\t\t\ttrigger: 'click',\n\t\t\t\t\tcloseOnClick: true\n\t\t\t\t})\n\t\t    });\n\t\t\t\n\t\t    if ( this.model.get( 'use_merge_tags' ) ) {\n\t\t    \tnfRadio.channel( 'mergeTags' ).request( 'init', this );\n\t\t    }\n\n\t\t\t/*\n\t\t\t * Apply Setting Field Masks\n\t\t\t */\n\t\t\tvar mask = this.model.get( 'mask' );\n\n\t\t\tif( typeof mask != \"undefined\" ){\n\n\t\t\t\tvar input = jQuery( this.$el ).find( 'input' );\n\t\t\t\tjQuery( input ).attr( 'contentEditable', true );\n\t\t\t\tswitch( mask.type ){\n\t\t\t\t\tcase 'numeric':\n\t\t\t\t\t\tvar autoNumericOptions = {\n\t\t\t\t\t\t\tdigitGroupSeparator: nfi18n.thousands_sep,\n\t\t\t\t\t\t\tdecimalCharacter: nfi18n.decimal_point\n\t\t\t\t\t\t};\n\t\t\t\t\t\tnew AutoNumeric( input[0], autoNumericOptions );\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase 'currency':\n\t\t\t\t\t\tvar autoNumericOptions = {\n\t\t\t\t\t\t\tdigitGroupSeparator: nfi18n.thousands_sep,\n\t\t\t\t\t\t\tdecimalCharacter: nfi18n.decimal_point,\n\t\t\t\t\t\t\tcurrencySymbol: nfi18n.currencySymbol\n\t\t\t\t\t\t};\n\t\t\t\t\t\tnew AutoNumeric( input[0], autoNumericOptions );\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase 'custom':\n\t\t\t\t\t\tif( mask.format ) input.mask( mask.format );\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tdefault:\n\t\t\t\t\t\t// TODO: Error Logging.\n\t\t\t\t\t\tconsole.log( 'Notice: Mask type of \"' + mask.type + '\" is not supported.' );\n\t\t\t\t}\n\t\t\t}\n\t\t\t\n\t\t\tthis.renderError();\n\t\t},\n\n\t\tonShow: function() {\t\t\n\t\t\t/*\n\t\t\t * Send out a radio message.\n\t\t\t */\n\t\t\tnfRadio.channel( 'setting-' + this.model.get( 'name' ) ).trigger( 'show:setting', this.model, this.dataModel, this );\n\t\t\tnfRadio.channel( 'setting-type-' + this.model.get( 'type' ) ).trigger( 'show:setting', this.model, this.dataModel, this );\n\t\t},\n\n\t\tonAttach: function() {\t\n\t\t\t/*\n\t\t\t * Send out a radio message.\n\t\t\t */\n\t\t\tnfRadio.channel( 'setting-' + this.model.get( 'name' ) ).trigger( 'attach:setting', this.model, this.dataModel, this );\n\t\t\tnfRadio.channel( 'setting-type-' + this.model.get( 'type' ) ).trigger( 'attach:setting', this.model, this.dataModel, this );\n\t\t},\n\n\t\trenderError: function() {\n\t\t\tif ( this.model.get( 'error' ) ) {\n\t\t\t\tjQuery( this.el ).find( '.nf-setting' ).addClass( 'nf-error' );\n\t\t\t\tthis.error.show( new settingErrorView( { model: this.model } ) );\n\t\t\t} else {\n\t\t\t\tjQuery( this.el ).find( '.nf-setting' ).removeClass( 'nf-error' );\n\t\t\t\tthis.error.empty();\n\t\t\t}\n\t\t},\n\n        renderWarning: function() {\n            const errorRegion = this.getRegion('error');\n            if (errorRegion && errorRegion.$el && errorRegion.$el.length > 0) {\n                if ( this.model.get( 'warning' ) ) {\n                    jQuery( this.el ).find( '.nf-setting' ).addClass( 'nf-warning' );\n                    this.error.show( new settingErrorView( { model: this.model } ) );\n                } else {\n                    jQuery( this.el ).find( '.nf-setting' ).removeClass( 'nf-warning' );\n                    this.error.empty();\n                    errorRegion.empty();\n                }\n            }\n        },\n\n\t\ttemplateHelpers: function () {\n\t\t\tvar that = this;\n\t    \treturn {\n\n\t    \t\trenderVisible: function() {\n\n\t\t\t\t\tif(!nfAdmin.devMode){\n\t\t\t\t\t\tif('Action' == that.dataModel.get('objectType') && 'email' == that.dataModel.get('type')){\n\t\t\t\t\t\t\tif('cc' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t\tif('bcc' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t\tif('from_name' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t\tif('from_address' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t\tif('email_format' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t}\n\t\t\t\t\t\t\n\t\t\t\t\t\tif('Action' == that.dataModel.get('objectType') && 'save' == that.dataModel.get('type')){\n\t\t\t\t\t\t\tif('submitter_email' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif('label_pos' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\tif('input_limit' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\tif('input_limit_type' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\tif('input_limit_msg' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t\n\t\t\t\t\t\tif('disable_input' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\tif('disable_browser_autocomplete' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\tif('mask' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\tif('custom_mask' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\tif('custom_name_attribute' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t// if('personally_identifiable' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t\n\t\t\t\t\t\t// \"administration\" settings\n\t\t\t\t\t\tif('key' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\tif('admin_label' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\tif('num_sort' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\tif('user_state' == this.name) return 'style=\"display:none;\"';\n\n\t\t\t\t\t\t\n\t\t\t\t\t\tif('checkbox' == that.dataModel.get('type')){\n\t\t\t\t\t\t\tif('checked_value' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t\tif('unchecked_value' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif('starrating' == that.dataModel.get('type')){\n\t\t\t\t\t\t\tif('default' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// @TODO: This isn't actually working.\n\t\t\t\t\t\t// 'multi_size' is the correct type of datamodel.\n\t\t\t\t\t\tif('listmultiselect' == that.dataModel.get('type')){\n\t\t\t\t\t\t\tif('box_size' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif('date' == that.dataModel.get('type')){\n\t\t\t\t\t\t\tif('year_range_start' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t\tif('year_range_end' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn nfRadio.channel( 'settings' ).request( 'check:deps', this, that );\n\t    \t\t},\n\n\t    \t\trenderSetting: function(){\n\t    \t\t\tif ( 'undefined' != typeof that.dataModel.get( this.name ) ) {\n\t    \t\t\t\tthis.value = that.dataModel.get( this.name );\n\t    \t\t\t} else if ( 'undefined' == typeof this.value ) {\n\t    \t\t\t\tthis.value = '';\n\t    \t\t\t}\n\t    \t\t\tvar setting = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-edit-setting-' + this.type );\n\t\t\t\t\treturn setting( this );\n\t\t\t\t},\n\n\t\t\t\trenderLabelClasses: function() {\n\t\t\t\t\tvar classes = '';\n\t\t\t\t\tif ( this.use_merge_tags ) {\n\t\t\t\t\t\tclasses += ' has-merge-tags';\n\t\t\t\t\t}\n\t\t\t\t\tif ( 'rte' == this.type ) {\n\t\t\t\t\t\tclasses += ' rte';\n\t\t\t\t\t}\n\n\t\t\t\t\treturn classes;\n\t\t\t\t},\n\n\t\t\t\trenderClasses: function() {\n\t\t\t\t\tvar classes = 'nf-setting ';\n\t\t\t\t\tif ( 'undefined' != typeof this.width ) {\n\t\t\t\t\t\tclasses += 'nf-' + this.width;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tclasses += ' nf-one-half';\n\t\t\t\t\t}\n\n\t\t\t\t\tif ( this.error ) {\n\t\t\t\t\t\tclasses += ' nf-error';\n\t\t\t\t\t}\n\n\t\t\t\t\treturn classes;\n\t\t\t\t},\n\n\t\t\t\trenderTooltip: function() {\n\t\t\t\t\tif ( ! this.help ) return '';\n\t\t\t\t\tvar helpText, helpTextContainer, helpIcon, helpIconLink, helpTextWrapper;\n\n\t\t\t\t\thelpText = document.createElement( 'div' );\n\t\t\t\t\thelpText.innerHTML = this.help;\n\t\t\t\t\t\n\t\t\t\t\thelpTextContainer = document.createElement( 'div' );\n\t\t\t\t\thelpTextContainer.classList.add( 'nf-help-text' );\n\t\t\t\t\thelpTextContainer.appendChild( helpText );\n\n\t\t\t\t\thelpIcon = document.createElement( 'span' );\n\t\t\t\t\thelpIcon.classList.add( 'dashicons', 'dashicons-admin-comments' );\n                    helpIconLink = document.createElement( 'a' );\n                    helpIconLink.classList.add( 'nf-help' );\n                    helpIconLink.setAttribute( 'href', '#' );\n                    helpIconLink.setAttribute( 'tabindex', '-1' );\n                    helpIconLink.appendChild( helpIcon );\n\n                    helpTextWrapper = document.createElement( 'span' );\n                    helpTextWrapper.appendChild( helpIconLink );\n                    helpTextWrapper.appendChild( helpTextContainer );\n\n                    // The template expects a string value.\n\t\t\t\t\treturn helpTextWrapper.innerHTML;\n\t\t\t\t},\n\n\t\t\t    /*\n\t\t\t     * Render a select element with only the email fields on the\n\t\t\t      * form\n\t\t\t     */\n\t\t\t    renderEmailFieldOptions: function() {\n\t\t\t\t    var fields = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\n\t\t\t\t    initialOption = document.createElement( 'option' );\n\t\t\t\t    initialOption.value = '';\n\t\t\t\t    initialOption.label = '--';\n\t\t\t\t    initialOption.innerHTML = '--';\n\n\t\t\t\t    var select_value = '';\n\t\t\t\t    var select = document.createElement( 'select' );\n\t\t\t\t    select.classList.add( 'setting' );\n\t\t\t\t    select.setAttribute( 'data-id', 'my_seledt' );\n\t\t\t\t    select.appendChild( initialOption );\n\n\t\t\t\t    var index = 0;\n\t\t\t\t    var that = this;\n\t\t\t\t    fields.each( function( field ) {\n\t\t\t\t\t    // Check for the field type in our lookup array and...\n\t\t\t\t\t    if( 'email' != field.get( 'type' ) ) {\n\t\t\t\t\t\t    // Return if the type is in our lookup array.\n\t\t\t\t\t\t    return '';\n\t\t\t\t\t    }\n\n\t\t\t\t\t    var option = document.createElement( 'option' );\n\n\t\t\t\t\t    option.value = field.get( 'key' );\n\t\t\t\t\t    option.innerHTML = field.get( 'label' );\n\t\t\t\t\t    option.label = field.get( 'label' );\n\t\t\t\t\t    \n\t\t\t\t\t    if( that.value === field.get( 'key' ) ) {\n\t\t\t\t\t\t    option.setAttribute( 'selected', 'selected' );\n\t\t\t\t\t    }\n\t\t\t\t\t    select.appendChild( option );\n\t\t\t\t\t    index = index + 1;\n\t\t\t\t    });\n\n\t\t\t\t    label = document.createElement( 'label' );\n\t\t\t\t    label.classList.add( 'nf-select' );\n\n\t\t\t\t    label.appendChild( select );\n\n\t\t\t\t    // Select Lists need an empty '<div></div>' for styling purposes.\n\t\t\t\t    emptyContainer = document.createElement( 'div' );\n\t\t\t\t    label.appendChild( emptyContainer );\n\n\t\t\t\t    // The template requires a string.\n\t\t\t\t    return label.innerHTML;\n\t\t\t    },\n\n\t\t\t\trenderMergeTags: function() {\n\t\t\t\t\tif ( this.use_merge_tags && ! this.hide_merge_tags ) {\n\t\t\t\t\t\treturn '<span class=\"dashicons dashicons-list-view merge-tags\"></span>';\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn '';\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t    /**\n\t\t\t     * Renders min and/or max attributes for the number input\n\t\t\t     *\n\t\t\t     * @returns {string}\n\t\t\t     */\n\t\t\t    renderMinMax: function() {\n\t\t\t\t\tvar minMaxStr = '';\n\t\t\t\t\t// if we have a min value set, then output it\n\t\t\t\t\tif( 'undefined' != typeof this.min_val && null != this.min_val && jQuery.isNumeric( this.min_val ) ) {\n\t\t\t\t\t\tminMaxStr = minMaxStr + \"min='\" + this.min_val + \"'\";\n\t\t\t\t\t}\n\n\t\t\t\t\t// if we have a max value set, then output it\n\t\t\t\t    if( 'undefined' != typeof this.max_val && '' != this.max_val && jQuery.isNumeric( this.max_val ) ) {\n\t\t\t\t\t    minMaxStr = minMaxStr + \" max='\" + this.max_val + \"'\";\n\t\t\t\t    }\n\n\t\t\t\t    // if we have a step size set, then output it\n\t\t\t\t    if( 'undefined' != typeof this.step && '' != this.step && jQuery.isNumeric( this.step ) ) {\n\t\t\t\t\t    minMaxStr = minMaxStr + \" step='\" + this.step + \"'\";\n\t\t\t\t    }\n\n\t\t\t\t    return minMaxStr;\n\t\t\t    },\n\n\t\t\t    /**\n\t\t\t     * Returns a string to let the user know the min and/or max\n\t\t\t     * value for the field\n\t\t\t     *\n\t\t\t     * @returns {string}\n\t\t\t     */\n\t\t\t    renderMinMaxHelper: function() {\n\t\t\t\t    var minMaxHelperStr = '';\n\t\t\t\t    // if we have a min value output it to the helper text\n\t\t\t\t    if( 'undefined' != typeof this.min_val && null != this.min_val && jQuery.isNumeric( this.min_val ) ) {\n\t\t\t\t    \t// empty string? then add '('\n\t\t\t\t    \tif( 0 == minMaxHelperStr.length ) {\n\t\t\t\t    \t\tminMaxHelperStr = \"(\";\n\t\t\t\t\t    }\n\t\t\t\t\t    minMaxHelperStr = minMaxHelperStr +  nfi18n.minVal + \": \" + this.min_val;\n\t\t\t\t    }\n\n\t\t\t\t    // if we have a max value output it to the helper text\n\t\t\t\t    if( 'undefined' != typeof this.max_val && '' != this.max_val && jQuery.isNumeric( this.max_val ) ) {\n\t\t\t\t\t    // empty string? then add '('\n\t\t\t\t\t    if( 0 == minMaxHelperStr.length ) {\n\t\t\t\t\t\t    minMaxHelperStr = \"(\";\n\t\t\t\t\t    } else {\n\t\t\t\t\t    \t// else, we know we have a min so add a comma\n\t\t\t\t\t    \tminMaxHelperStr = minMaxHelperStr + \", \";\n\t\t\t\t\t    }\n\t\t\t\t\t    minMaxHelperStr = minMaxHelperStr + nfi18n.maxVal + \": \" + this.max_val;\n\t\t\t\t    }\n\n\t\t\t\t    // if not an empty string, then add ')'\n\t\t\t\t    if( 0 < minMaxHelperStr.length ) {\n\t\t\t\t\t    minMaxHelperStr = minMaxHelperStr + \")\";\n\t\t\t\t    }\n\n\t\t\t\t    return minMaxHelperStr;\n\t\t\t\t},\n\t\t\t}\n\t\t},\n\n\t\tevents: {\n\t\t\t'change .setting': 'changeSetting',\n\t\t\t'keyup .setting': 'keyUpSetting',\n\t\t\t'click .setting': 'clickSetting',\n\t\t\t'click .extra': 'clickExtra'\n\t\t},\n\n\t\tchangeSetting: function( e ) {\n\n\t\t\tnfRadio.channel( this.model.get( 'type' ) ).request( 'validate:updateSetting', e, this.model, this.dataModel );\n\t\t\t\n\t\t\tnfRadio.channel( 'app' ).trigger( 'change:setting', e, this.model, this.dataModel );\n\t\t},\n\n\t\tkeyUpSetting: function( e ) {\n\t\t\tnfRadio.channel( 'app' ).trigger( 'keyup:setting', e, this.model, this.dataModel );\n\t\t\tnfRadio.channel( 'setting-' + this.model.get( 'name' ) ).trigger( 'keyup:setting', e, this.model, this.dataModel );\n\t\t},\n\n\t\tclickSetting: function( e ) {\n\t\t\tnfRadio.channel( 'app' ).trigger( 'click:setting', e, this.model, this.dataModel );\n\t\t\tnfRadio.channel( 'setting-type-' + this.model.get( 'type' ) ).trigger( 'click:setting', e, this.model, this.dataModel,