is.addAction, this );\n\t\t},\n\n\t\t/**\n\t\t * Add an action to our collection. If silent is passed as true, no events will trigger.\n\t\t * \n\t\t * @since 3.0\n\t\t * @param Object \tdata \taction data to insert\n\t\t * @param bool \t\tsilent \tprevent events from firing as a result of adding\t \t\n\t\t */\n\t\taddAction: function( type ) {\n\n\t\t\tvar data = {\n\t\t\t\tid: nfRadio.channel( 'actions' ).request( 'get:tmpID' ),\n\t\t\t\ttype: type.get( 'id' ),\n\t\t\t\tlabel: type.get( 'settingDefaults').label || type.get( 'nicename' )\n\t\t\t}\n\n\t\t\tvar newModel = nfRadio.channel( 'actions' ).request( 'add', data );\n\n\t\t\tvar label = {\n\t\t\t\tobject: 'Action',\n\t\t\t\tlabel: newModel.get( 'label' ),\n\t\t\t\tchange: 'Added',\n\t\t\t\tdashicon: 'plus-alt'\n\t\t\t};\n\n\t\t\tvar data = {\n\t\t\t\tcollection: nfRadio.channel( 'actions' ).request( 'get:collection' )\n\t\t\t}\n\n\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'addObject', newModel, null, label, data );\n\t\t\tnfRadio.channel( 'app' ).trigger( 'click:edit', {}, newModel );\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles the logic for our action type draggables.\n * \n * @package Ninja Forms builder\n * @subpackage Actions - New Action Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/actions/typeDrag',[], function( ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Listen to our action type draggables and run the appropriate function.\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addAction' ), 'startDrag:type', this.startDrag );\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addAction' ), 'stopDrag:type', this.stopDrag );\n\t\t\t/*\n\t\t\t * Respond to requests for our helper clone.\n\t\t\t * This is used by other parts of the application to modify what the user is dragging in real-time.\n\t\t\t */ \n\t\t\tnfRadio.channel( 'drawer-addAction' ).reply( 'get:typeHelperClone', this.getCurrentDraggableHelperClone, this );\n\t\t},\n\n\t\t/**\n\t\t * When we start dragging:\n\t\t * get our drawer element\n\t\t * set its overflow property to visible !important -> forces the type drag element to be on at the top of the z-index.\n\t\t * get our main element\n\t\t * est its overflow propery to visible !important -> forces the type drag element to be on top of the z-index.\n\t\t * set our dragging helper clone\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  object context \tThis function is going to be called from a draggable. Context is the \"this\" reference to the draggable.\n\t\t * @param  object ui      \tObject sent by jQuery UI draggable.\n\t\t * @return void\n\t\t */\n\t\tstartDrag: function( context, ui ) {\n\t\t\tthis.drawerEl = nfRadio.channel( 'app' ).request( 'get:drawerEl' );\n\t\t\tthis.mainEl = nfRadio.channel( 'app' ).request( 'get:mainEl' );\n\t\t\tjQuery( this.drawerEl )[0].style.setProperty( 'overflow', 'visible', 'important' );\n\t\t\t// jQuery( this.mainEl )[0].style.setProperty( 'overflow', 'visible', 'important' );\n\n\t\t\tthis.draggableHelperClone = jQuery( ui.helper ).clone();\n\n\t\t},\n\n\t\t/**\n\t\t * When we stop dragging, reset our overflow property to hidden !important.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  object context \tThis function is going to be called from a draggable. Context is the \"this\" reference to the draggable.\n\t\t * @param  object ui      \tObject sent by jQuery UI draggable.\n\t\t * @return {[type]}         [description]\n\t\t */\n\t\tstopDrag: function( context, ui ) {\n\t\t\tjQuery( this.drawerEl )[0].style.setProperty( 'overflow', 'hidden', 'important' );\n\t\t\t// jQuery( this.mainEl )[0].style.setProperty( 'overflow', 'hidden', 'important' );\n\t\t},\n\n\t\tgetCurrentDraggableHelperClone: function() {\n\t\t\treturn this.draggableHelperClone;\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles the logic for our action type droppable.\n * \n * @package Ninja Forms builder\n * @subpackage Actions - New Action Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/actions/droppable',[], function( ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t/*\n\t\t\t * Respond to requests for our helper clone.\n\t\t\t * This is used by other parts of the application to modify what the user is dragging in real-time.\n\t\t\t */ \n\t\t\tnfRadio.channel( 'app' ).reply( 'drop:actionType', this.dropActionType, this );\n\t\t},\n\n\t\tdropActionType: function( e, ui ) {\n\t\t\tvar type_slug = jQuery( ui.helper ).data( 'type' );\n\t\t\tvar type = nfRadio.channel( 'actions' ).request( 'get:type', type_slug );\n\t\t\tnfRadio.channel( 'actions' ).request( 'add:actionType', type );\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Model for our action type\n * \n * @package Ninja Forms builder\n * @subpackage Actions\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/actions/typeModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Collection that holds our action type models. \n * \n * @package Ninja Forms builder\n * @subpackage Actions\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/actions/typeCollection',['models/actions/typeModel'], function( actionTypeModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: actionTypeModel,\n\t} );\n\treturn collection;\n} );\n","/**\n * Filters our action type collection.\n * \n * @package Ninja Forms builder\n * @subpackage Actions - New Action Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/actions/filterTypes',['models/actions/typeCollection'], function( typeCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Listen to our change filter event.\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addAction' ), 'change:filter', this.filterActionTypes );\n\t\t},\n\n\t\t/**\n\t\t * Filter our action types in the add new action drawer\n\t\t * \n\t\t * Takes a search string and finds any action types that match either the name or alias.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  string\t search \tstring being searched for\n\t\t * @param  object \t e      \tKeyup event\n\t\t * @return void\n\t\t */\n\t\tfilterActionTypes: function( search, e ) {\n\n\t\t\t// Make sure that we aren't dealing with an empty string.\n\t\t\tif ( '' != String(  search ).trim() ) {\n\n        \t\tvar filteredInstalled = [];\n        \t\t/**\n        \t\t * Call the function that actually filters our collection,\n        \t\t * and then loop through our collection, adding each model to our filteredInstalled array.\n        \t\t */\n\t\t\t\tvar installedActions = nfRadio.channel( 'actions' ).request( 'get:installedActions' );\n        \t\t_.each( this.filterCollection( search, installedActions ), function( model ) {\n        \t\t\tfilteredInstalled.push( model );\n        \t\t} );\n\n        \t\tvar filteredAvailable = [];\n        \t\tvar availableActions = nfRadio.channel( 'actions' ).request( 'get:availableActions' );\n        \t\t_.each( this.filterCollection( search, availableActions ), function( model ) {\n        \t\t\tfilteredAvailable.push( model );\n        \t\t} );\n\n        \t\t// Create a new Action Type Section collection with the filtered array.\n        \t\tvar newInstalled = new typeCollection( filteredInstalled );\n        \t\tnewInstalled.slug = 'installed';\n        \t\tnewInstalled.nicename = 'Installed';\n\n        \t\tvar newAvailable = new typeCollection( filteredAvailable );\n        \t\tnewAvailable.slug = 'available';\n\t\t\t\tnewAvailable.nicename = 'Available';\n\n        \t\t// Request that our action types filter be applied, passing the collection we created above.\n        \t\tnfRadio.channel( 'drawer' ).trigger( 'filter:actionTypes', newInstalled, newAvailable );\n        \t\t// If we've pressed the 'enter' key, add the action to staging and clear the filter.\n        \t\tif ( e.addObject ) {\n        \t\t\tif ( 0 < newInstalled.length ) {\n        \t\t\t\tnfRadio.channel( 'actions' ).request( 'add:actionType', newInstalled.models[0] );\n        \t\t\t\tnfRadio.channel( 'drawer' ).request( 'clear:filter' );\n        \t\t\t}\n        \t\t}\n        \t} else {\n        \t\t// Clear our filter if the search text is empty.\n        \t\tnfRadio.channel( 'drawer' ).trigger( 'clear:filter' );\n        \t}\n        },\n\n        /**\n         * Search our action type collection for the search string.\n         * \n         * @since  3.0\n         * @param  string\t search \tst