 optionModel = setting.collection.get( { cid: cid } );\n\t\t\t\tvar oldPos = optionModel.get( 'order' );\n\t\t\t\toptionModel.set( 'order', index );\n\t\t\t\tvar newPos = index;\n\n\t\t\t\tdata.objModels.push( {\n\t\t\t\t\tmodel: optionModel,\n\t\t\t\t\tattr: 'order',\n\t\t\t\t\tbefore: oldPos,\n\t\t\t\t\tafter: newPos\n\t\t\t\t} );\n\t\t\t} );\n\t\t\t\n\t\t\tsetting.collection.sort( { silent: true } );\n\t\t\t\n\t\t\tvar image = {\n\t\t\t\tobject: setting.dataModel.get( 'objectType' ),\n\t\t\t\timage: setting.dataModel.get( 'image' ),\n\t\t\t\tchange: 'Option ' + dragModel.get( 'image' ) + ' re-ordered from ' + dragModel._previousAttributes.order + ' to ' + dragModel.get( 'order' ),\n\t\t\t\tdashicon: 'sort'\n\t\t\t};\n\n\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'sortListOptions', dragModel, null, image, data );\n\t\t\tthis.triggerDataModel( dragModel, setting.dataModel );\n\t\t\tnfRadio.channel( 'image-option-repeater' ).trigger( 'sort:option', dragModel, setting );\n\t\t\tnfRadio.channel( 'image-option-repeater-' + setting.model.get( 'name' ) ).trigger( 'sort:option', dragModel, setting );\n\t\t},\n\n\t\t/**\n\t\t * When we stop sorting our list options, reset our item opacity.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object ui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\tstopOptionSortable: function( ui ) {\n\t\t\tjQuery( ui.item ).css( 'opacity', '' );\n\t\t},\n\n\t\t/**\n\t\t * When we start sorting our list options, remove containing divs and set our item opacity to 0.5\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Objects ui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\tstartOptionSortable: function( ui ) {\n\t\t\tjQuery( ui.placeholder ).find( 'div' ).remove();\n\t\t\tjQuery( ui.item ).css( 'opacity', '0.5' ).show();\n\t\t},\n\n\t\t/**\n\t\t * Convert settings from an array/object to a collection/model\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Backbone.Model dataModel\n\t\t * @param  Backbone.Model settingModel\n\t\t * @return void\n\t\t */\n\t\tconvertSettings: function( dataModel, settingModel ) {\n\t\t\t/*\n\t\t\t * Our options are stored in our database as objects, not collections.\n\t\t\t * Before we attempt to render them, we need to convert them to a collection if they aren't already one.\n\t\t\t */ \n\t\t\tvar optionCollection = dataModel.get( settingModel.get( 'name' ) );\n\n\t\t\tif ( false == optionCollection instanceof Backbone.Collection ) {\n\t\t\t\toptionCollection = new listOptionCollection( [], { settingModel: settingModel } );\n\t\t\t\toptionCollection.add( dataModel.get( settingModel.get( 'name' ) ) );\n\t\t\t\tdataModel.set( settingModel.get( 'name' ), optionCollection, { silent: true } );\n\t\t\t}\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles adding and removing the active class from a field currently being edited.\n * \n * @package Ninja Forms builder\n * @subpackage Fields - Edit Field Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/editActive',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Respond to requests to remove the active class from all our fields.\n\t\t\tnfRadio.channel( 'fields' ).reply( 'clear:editActive', this.clearEditActive, this );\n\t\t\t// Listen for the closing drawer so that we can remove all of our active classes.\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-editSettings' ), 'before:closeDrawer', this.clearEditActive );\n\t\t},\n\n\t\t/**\n\t\t * Loops through our fields collection and sets editActive to false.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n        clearEditActive: function() {\n            var fieldCollection = nfRadio.channel( 'fields' ).request( 'get:collection' );\n            _.each( fieldCollection.models, function( field ) {\n\t\t\t\tfield.set( 'editActive', false );\n            } );\n        }\n\t});\n\n\treturn controller;\n} );\n\n","/**\n * Fetches settings models so that we can get setting information\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/fieldSettings',['models/app/settingCollection'], function( settingCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.collection = new settingCollection( fieldSettings, { objectType: 'fields' } );\n\n\t\t\t// Responds to requests for settings models.\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:settingModel', this.getSettingModel, this );\n\t\t\t\n\t\t\t// Responds to requests for our collection.\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:settingCollection', this.getSettingCollection, this );\n\t\t},\n\n\t\tgetSettingModel: function( name ) {\n\t\t\treturn this.collection.findWhere( { name: name } );\n\t\t},\n\n\t\tgetSettingCollection: function() {\n\t\t\treturn this.collection;\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Listens to our app channel to add the individual Credit Card Fields.\n *\n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/fieldCreditCard',[], function() {\n    var controller = Marionette.Object.extend( {\n        initialize: function() {\n          this.listenTo( nfRadio.channel( 'fields' ), 'after:addField', this.dropCreditCardField );\n        },\n\n        dropCreditCardField: function( fieldModel ) {\n\n            if( 'creditcard' == fieldModel.get( 'type' ) ) {\n\n                var order = fieldModel.get( 'order' );\n\n                nfRadio.channel( 'fields' ).request( 'delete', fieldModel );\n\n                _.each( [ 'creditcardfullname', 'creditcardnumber', 'creditcardcvc', 'creditcardexpiration', 'creditcardzip'], function( type ) {\n\n                    var fieldType = nfRadio.channel( 'fields' ).request( 'get:type', type );\n\n                    var newField = {\n                        id: nfRadio.channel( 'fields' ).request( 'get:tmpID' ),\n                        type: type,\n                        label: fieldType.get( 'nicename' ),\n                        order: order\n                    };\n\n                    nfRadio.channel( 'fields' ).request( 'add', newField );\n                });\n            }\n\n        },\n\n        stageCreditCardField: function( model ) {\n\n            if( 'creditcard' == model.get( 'slug' ) ) {\n\n                nfRadio.channel( 'fields' ).request( 'remove:stagedField', '', model );\n\n                _.each( [ 'creditcardfullname', 'creditcardnumber', 'creditcardcvc', 'creditcardexpiration', 'creditcardzip'], function( type ) {\n                    nfRadio.channel('fields').request('add:stagedField', type );\n                });\n            }\n        }\n\n    });\n\n    return controller;\n} );\n","/**\n * Listens to our app channel to add the individual List Fields.\n *\n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/fieldList',[ 'models/app/optionRepeaterCollection' ], function( ListOptionCollection ) {\n    var controller = Marionette.Object.extend( {\n        initialize: function() {\n            this.listenTo( nfRadio.channel( 'option-repeater-option-label' ), 'update:option', this.updateOptionLabel );\n            this.listenTo( nfRadio.channel( 'option-repeater-option-value' ), 'update:option', this.updateOptionValue );\n            \n            /*\n             * When we init our model, convert our options from an array of objects to a collection of models.\n             */\n            this.listenTo( nfRadio.channel( 'fields-list' ), 'init:fieldModel', this.convertOptions );\n        },\n\n        updateOptionLabel: function( e, model, dataModel, settingModel, optionView ) {\n\n            if( 'list' != _.findWhere( fieldTypeData, { id: dataModel.get( 'type' ) } ).parentType ) return;\n\n            if( model.get( 'manual_value' ) ) return;\n\n            value = jQuery.slugify( model.get( 'label' ), { separator: '-' } );\n\n            model.set( 'value', value );\n            model.trigger( 'change', model );\n\n            // Set focus on value input\n            jQuery( optionView.el ).find( '[data-id=\"value\"]' ).focus().select();\n        },\n\n        updateOptionValue: function( e, model, dataModel, settingModel, optionView ) {\n            if ( 'Field' == dataModel.get( 'objectType' ) ) {\n                var newVal = model.get( 'value' );\n                // Sanitize any unwanted special characters.\n                // TODO: This assumes English is the standard language.\n                //       We might want to allow other language characters through this check later.\n                var pattern = /[^0-9a-zA-Z _@.-]/g;\n                newVal = newVal.replace( pattern, '' );\n                model.set( 'value', newVal );\n                // Re-render the value.\n                optionView.render();\n            }\n            \n            var findWhere = _.findWhere( fieldTypeData, { id: dataModel.get( 'type' ) } );\n            if( 'undefined' == typeof findWhere ) return;\n            if( 'list' != findWhere.parentType ) return;\n\n            model.set( 'manual_value', true );\n            \n            // Set focus on calc input\n            jQuery( optionView.el ).find( '[data-id=\"calc\"]' ).focus().select();\n        },\n\n        convertOptions: function( fieldModel ) {\n            /*\n             * Our options are stored in our database as objects, not collections.\n             * Before we attempt to render them, we need to convert them to a collection if they aren't already one.\n             */ \n            var options = fieldModel.get( 'options' );\n\n            var settingModel = nfRadio.channel( 'fields' ).request( 'get:settingModel', 'options' );\n\n            if ( false == options instanceof Backbone.Collection ) {\n                options = new ListOptionCollection( [], { settingModel: settingModel } );\n                options.add( fieldModel.get( 'options' ) );\n                fieldModel.set( 'options', options, { silent: true } );\n            }\n        }\n\n    });\n\n    return controller;\n} );\n","/**\n * Listens to our app channel to add the individual Credit Card Fields.\n *\n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/fieldPassword',[], function() {\n    var controller = Marionette.Object.extend( {\n        initialize: function() {\n            this.listenTo( nfRadio.channel( 'fields' ), 'after:addField', this.addField );\n        },\n\n        addField: function( model ) {\n\n            if( 'password' == model.get( 'type' ) ) {\n\n                var order = model.get( 'order' );\n\n                var confirm = this.insertField( 'passwordconfirm', order + 1 );\n\n                confirm.set( 'confirm_field', model.get( 'key' ) );\n            }\n        },\n\n        insertField: function( type, order ) {\n            var fieldType = nfRadio.channel( 'fields' ).request( 'get:type', type );\n\n            var newField = {\n                id: nfRadio.channel( 'fields' ).request( 'get:tmpID' ),\n                type: type,\n                label: fieldType.get( 'nicename' ),\n                order: order\n            };\n\n            return nfRadio.channel('fields').request('add', newField );\n        }\n    });\n\n    return controller;\n} );\n","/**\n * Listens to our app channel for settings views being rendered.\n *\n * If we're rendering a product_assignment setting, add our products to the data model.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/fieldQuantity',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Listen for messages that are fired before a setting view is rendered.\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'before:renderSetting', this.beforeRenderSetting );\n\t\t},\n\n\t\tbeforeRenderSetting: function( settingModel, dataModel, view ) {\n\t\t\tif ( 'product_assignment' == settingModel.get( 'name' ) ) {\n\t\t\t\tvar productFields = this.getProductFields( settingModel );\n\t\t\t\tsettingModel.set( 'options', productFields );\n\t\t\t}\n\t\t},\n\n\t\tgetProductFields: function( settingModel ) {\n\t\t\tvar productFields = [ settingModel.get( 'select_product' ) ];\n\t\t\t// Update our dataModel with all of our product fields.\n\t\t\tvar fields = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\t\t\t_.each( fields.models, function( field ) {\n\t\t\t\tif ( 'product' == field.get( 'type' ) ) {\n\t\t\t\t\tproductFields.push( { label: field.get( 'label' ), value: field.get( 'id' ) } );\n\t\t\t\t}\n\t\t\t} );\n\t\t\treturn productFields;\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Listens to our app channel for settings views being rendered.\n *\n * If we're rendering a product_assignment setting, add our products to the data model.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/fieldShipping',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'setting-shipping_options' ), 'render:setting', this.addMask );\n\t\t\tthis.listenTo( nfRadio.channel( 'setting-shipping_options-option' ), 'render:setting', this.addMask );\n\t\t},\n\n\t\taddMask: function( settingModel, dataModel, view ) {\n\t\t\tjQuery( view.el ).find( '[data-id=\"value\"]' ).each( function() {\n\t\t\t\tvar autoNumericOptions = {\n\t\t\t\t\tdigitGroupSeparator: nfi18n.thousands_sep,\n\t\t\t\t\tdecimalCharacter: nfi18n.decimal_point,\n\t\t\t\t\tcurrencySymbol: nfi18n.currencySymbol\n\t\t\t\t};\n\t\t\t\tnew AutoNumeric( this, autoNumericOptions );\n\t\t\t} );\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * When we add a new field, update its key.\n *\n * When we change the key, update any refs to the key.\n *\n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/key',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// When we add a field, update its key.\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'add:field', this.newFieldKey );\n\n\t\t\t// When we edit a label, update our key.\n\t\t\tthis.listenTo( nfRadio.channel( 'fieldSetting-label' ), 'update:setting', this.updateLabel );\n\n\t\t\t// When we edit a key, check for places that key might be used.\n\t\t\tthis.listenTo( nfRadio.channel( 'fieldSetting-key' ), 'update:setting', this.updateKey );\n\n\t\t\t// When we type inside the admin key field, we need to save our manual_key setting.\n\t\t\tthis.listenTo( nfRadio.channel( 'setting-key' ), 'keyup:setting', this.keyUp );\n\t\t},\n\n\t\t/**\n\t\t * Add a key to our new field model.\n\t\t *\n\t\t * @since 3.0\n\t\t * @param backbone.model model new field model\n\t\t * @return void\n\t\t */\n\t\tnewFieldKey: function( model ) {\n\t\t\tvar d = new Date();\n\t\t\tvar n = d.valueOf();\n\t\t\tvar key = this.slugify( model.get( 'type' ) + '_' + n );\n\n\t\t\tmodel.set( 'key', key, { silent: true } );\n\n\t\t\tif( 'undefined' == model.get( 'manual_key' ) ) {\n\t\t\t\tmodel.set('manual_key', false, {silent: true});\n\t\t\t}\n\t\t},\n\n\t\tupdateLabel: function( model ) {\n\n\t\t\t/*\n\t\t\t * If we haven't entered a key manually, update our key when our label changes.\n\t\t\t */\n\t\t\tif ( ! model.get( 'manual_key' ) && 0 != String(model.get( 'label' )).trim().length ) {\n\t\t\t\t/*\n\t\t\t\t * When we're editing settings, we expect the edits to fire one at a time.\n\t\t\t\t * Since we're calling this in the middle of our label update, anything that inquires about what has changed after we set our key will see both label and key.\n\t\t\t\t * We need to remove the label from our model.changed property so that all that has changed is the key.\n\t\t\t\t *\n\t\t\t\t */\n\t\t\t\tdelete model.changed.label;\n\t\t\t\tvar d = new Date();\n\t\t\t\tvar n = d.valueOf();\n\t\t\t\tvar key = this.slugify( model.get( 'label' ) + '_' + n );\n                // If our slug didn't setup correctly...\n                // Force a valid entry.\n                if ( -1 == key.indexOf( '_' ) ) key = 'field_' + key;\n\t\t\t\tmodel.set( 'key', key );\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * When a field key is updated, find any merge tags using the key and update them.\n\t\t *\n\t\t * @since  3.0\n\t\t * @param  backbone.model model field model\n\t\t * @return void\n\t\t */\n\t\tupdateKey: function( dataModel ) {\n\t\t\tvar key = dataModel.get( 'key' );\n\t\t\tthis.settingModel = nfRadio.channel( 'fields' ).request( 'get:settingModel', 'key' );\n\t\t\tthis.setError( key, dataModel );\n\t\t},\n\n\t\tkeyUp: function( e, settingModel, dataModel ) {\n\t\t\tdataModel.set( 'manual_key', true );\n\t\t\tthis.settingModel = settingModel;\n\t\t\tvar key = jQuery( e.target ).val();\n\t\t\tthis.setError( key, dataModel );\n\t\t},\n\n\t\tsetError: function( key, dataModel ) {\n\t\t\tvar error = false;\n\t\t\tif ( '' == String(key).trim() ) {\n\t\t\t\terror = 'Field keys can\\'t be empty. Please enter a key.';\n\t\t\t} else if ( key != key.toLowerCase() ) {\n\t\t\t\terror = 'Field keys must be lowercase.';\n\t\t\t} else if ( key != key.replace( ' ', '_' ) ) {\n\t\t\t\terror = 'Field keys must cannot use spaces. Separate with \"_\" instead.';\n\t\t\t} else if ( '_' == key.slice( -1 ) ) {\n\t\t\t\terror = 'Field keys cannot end with a \"_\"';\n\t\t\t} else if ( key != this.slugify( key ) ) {\n\t\t\t\terror = 'Invalid Format.';\n\t\t\t} else if ( key != this.keyExists( key, dataModel ) ) {\n\t\t\t\terror = 'Field keys must be unique. Please enter another key.'\n\t\t\t}\n\n\t\t\tif ( error ) {\n\t\t\t\tthis.settingModel.set( 'error', error );\n\t\t\t} else {\n\t\t\t\tnfRadio.channel( 'app' ).trigger( 'update:fieldKey', dataModel );\n\t\t\t\tthis.settingModel.set( 'error', false );\n\t\t\t}\n\t\t},\n\n\t\tkeyExists: function( key, dataModel ) {\n\t\t\tvar newKey = this.slugify( key );\n\t\t\tif ( 0 != newKey.length ) {\n\t\t\t\tkey = newKey;\n\t\t\t}\n\t\t\tvar fieldCollection = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\t\t\tvar x = 1;\n\t\t\tvar testKey = key;\n\t\t\t_.each( fieldCollection.models, function( field ) {\n\t\t\t\tif ( dataModel != field && testKey == field.get( 'key' ) ) {\n\t\t\t\t\ttestKey = key + '_' + x;\n\t\t\t\t\tx++;\n\t\t\t\t}\n\t\t\t} );\n\n\t\t\tkey = testKey;\n\n\t\t\treturn key;\n\t\t},\n\n\t\tslugify: function( string ){\n\t\t\treturn jQuery.slugify( string, { separator: '_' } )\n\t\t}\n\t});\n\n\treturn controller;\n} );\n\n","/**\n * Creates notices for our fields domain.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/notices',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'add:stagedField', this.addStagedField );\n\t\t},\n\n\t\taddStagedField: function( model ) {\n\t\t\tnfRadio.channel( 'notices' ).request( 'add', 'addStagedField', model.get( 'nicename' ) + ' added to staging' );\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles mobile-specific JS for our fields domain.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/mobile',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Listen for the start of our sorting.\n\t\t\t// this.listenTo( nfRadio.channel( 'app' ), 'render:fieldsSortable', this.initWiggle );\n\t\t\t// Listen for when we start sorting.\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'sortable:start', this.startWiggle );\n\t\t\t// Listen for when we stop sorting.\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'sortable:stop', this.stopWiggle );\n\t\t},\n\n\t\tinitWiggle: function( view ) {\n\t\t\tif ( nfRadio.channel( 'app' ).request( 'is:mobile' ) ) {\n\t\t\t\tjQuery( view.el ).find( '.nf-field-wrap' ).on( 'taphold', function() {\n\t\t\t\t\tjQuery( this ).ClassyWiggle( 'start', { degrees: ['.65', '1', '.65', '0', '-.65', '-1', '-.65', '0'], delay: 50 } );\n\t\t\t\t} );\n\t\t\t}\n\t\t},\n\n\t\tstartWiggle: function( ui ) {\n\t\t\tif ( nfRadio.channel( 'app' ).request( 'is:mobile' ) ) {\n\t\t\t\tjQuery( ui.item ).removeClass( 'ui-sortable-helper' ).ClassyWiggle( 'stop' );\n\t\t\t\tjQuery( ui.helper ).css( 'opacity', '0.75' ).ClassyWiggle( 'start', { degrees: ['.5', '1', '.5', '0', '-.5', '-1', '-.5', '0'] } );\n\t\t\t}\n\t\t},\n\n\t\tstopWiggle: function( ui ) {\n\t\t\tif ( nfRadio.channel( 'app' ).request( 'is:mobile' ) ) {\n\t\t\t\tjQuery( ui.helper ).ClassyWiggle( 'stop' );\n\t\t\t\tjQuery( ui.item ).removeClass( 'ui-sortable-helper drag-selected' );\n\t\t\t}\n\t\t}\n\t});\n\n\treturn controller;\n} );\n\n","/**\n * If we add a saved field to our form and then update it, set the \"saved\" flag to false.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/savedFields',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tignoreAttributes: [\n\t\t\t'editActive',\n\t\t\t'order',\n\t\t\t'saved',\n\t\t\t'jBox'\n\t\t],\n\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'update:setting', this.updateField );\n\t\t\t// Listen to clicks on our add saved field button.\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'click:addSavedField', this.clickAddSavedField, this );\n\t\t},\n\n\t\tupdateField: function( dataModel ) {\n\t\t\tif ( dataModel.get( 'saved' ) ) {\n\t\t\t\t\n\t\t\t\tvar modified = false;\n\t\t\t\tvar changedAttributes = _.keys( dataModel.changedAttributes() );\n\t\t\t\tvar that = this;\n\t\t\t\t_.each( changedAttributes, function( changed ) {\n\t\t\t\t\tif ( -1 == that.ignoreAttributes.indexOf( changed ) ) {\n\t\t\t\t\t\tmodified = true;\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t\t\n\t\t\t\tif ( modified ) {\n\t\t\t\t\tdataModel.set( 'saved', false );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tclickAddSavedField: function( e, dataModel ) {\n\t\t\tvar modelClone = nfRadio.channel( 'app' ).request( 'clone:modelDeep', dataModel );\n\n\t\t\tvar fieldData = modelClone.attributes;\n\t\t\tfieldData.saved = true;\n\n\t\t\tdelete fieldData.jBox;\n\t\t\tdelete fieldData.editActive;\n\t\t\tdelete fieldData.created_at;\n\t\t\tdelete fieldData.order;\n\t\t\tdelete fieldData.id;\n\t\t\tdelete fieldData.formID;\n\t\t\tdelete fieldData.parent_id;\n\t\t\t\n\t\t\tvar type = nfRadio.channel( 'fields' ).request( 'get:type', fieldData.type );\n\t\t\tvar newType = _.clone( type.attributes );\n\n\t\t\tvar nicename = _.escape(jQuery( e.target ).parent().parent().find( 'input' ).val());\n\t\t\tconsole.log( nicename );\n\t\t\tnewType.nicename = nicename;\n\t\t\tfieldData.label = nicename;\n\t\t\tfieldData.nicename = nicename;\n\t\t\tdataModel.set( 'addSavedLoading', true );\n\t\t\tvar newTypeDefaults = JSON.stringify( fieldData );\n\n\t\t\tjQuery.post( ajaxurl, { action: 'nf_create_saved_field', field: newTypeDefaults, security: nfAdmin.ajaxNonce }, function( response ) {\n\t\t\t\tresponse = JSON.parse( response );\n\t\t\t\tnewType.id = response.data.id;\n\t\t\t\tnewType.nicename = nicename;\n\t\t\t\tnewType.settingDefaults = fieldData;\n\n\t\t\t\tvar typeCollection = nfRadio.channel( 'fields' ).request( 'get:typeCollection' );\n\t\t\t\tvar newModel = typeCollection.add( newType );\n\n\t\t\t\tvar typeSections = nfRadio.channel( 'fields' ).request( 'get:typeSections' );\n\t\t\t\ttypeSections.get( 'saved' ).get( 'fieldTypes' ).push( newType.id );\n\n\t\t\t\t// dataModel.set( 'type', response.data.id );\n\t\t\t\tdataModel.set( 'addSavedLoading', false );\n\t\t\t\tdataModel.unset( 'addSavedLoading', { silent: true } );\n\t\t\t\tdataModel.get( 'jBox' ).close();\n\t\t\t\t// dataModel.set( 'saved', true );\n\n\t\t\t\tnfRadio.channel( 'notices' ).request( 'add', 'addSaved', 'Saved Field Added' );\n\t\t\t} );\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Listens to our app channel for settings views being rendered.\n *\n * If we're rendering a datepicker setting, add our datepicker.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/fieldDatepicker',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'setting-type-datepicker' ), 'render:setting', this.addDatepicker );\n\t\t},\n\n\t\taddDatepicker: function( settingModel, dataModel, view ) {\n\t\t\t//Switch to flatpickr from pikaday\n\t\t\tlet el = jQuery( view.el ).fi