              type: 'toggle',\n                    label: group.label,\n                    width: 'full',\n                });\n            });\n            this.set( 'settings', settings );\n        },\n\n    });\n\n    return controller;\n} );\n\n","/**\n * Listens to field deletion, removing any merge tags that reference the field.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2017 WP Ninjas\n * @since 3.1.7\n */\ndefine( 'controllers/actions/deleteFieldListener',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t/*\n\t\t\t * When we init an action model, register a listener for field deletion.\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'actions' ), 'init:actionModel', this.registerListener );\n\t\t},\n\n\t\tregisterListener: function( actionModel ) {\n\t\t\tactionModel.listenTo( nfRadio.channel( 'fields' ), 'delete:field', this.maybeUpdateSettings );\n\t\t},\n\n\t\tmaybeUpdateSettings: function( fieldModel ) {\n\t\t\tvar newObject, filteredCollection,\n\t\t\t\tfieldMergeTag = '{field:' + fieldModel.get( 'key' ) + '}';\n\t\t\t\n\t\t\t/*\n\t\t\t * Loop through our action attributes to see if the field mergetag exists in our action.\n\t\t\t *\n\t\t\t * If it does:\n\t\t\t * \t- Replace the field mergetag in strings with ''.\n\t\t\t * \t- Remove any items with the field merge tag if they are in an array.\n\t\t\t */\n\t\t\t_.each( this.attributes, function( attr, key ) {\n\t\t\t\tif ( _.isString( attr ) ) {\n\t\t\t\t\t// If our attribute is a string, replace any instances of the field merge tag with an empty string.\n\t\t\t\t\tthis.set( key, attr.replace( fieldMergeTag, '' ) );\n\t\t\t\t} else if ( _.isArray( attr ) ) {\n\t\t\t\t\t// If our attribute is an array, search the contents for field merge tag and remove items that match.\n\t\t\t\t\t_.each( attr, function( val, index ) {\n\t\t\t\t\t\tif ( _.isString( val ) ) {\n\t\t\t\t\t\t\t// If val is a string, search it for the field mergetag.\n\t\t\t\t\t\t\tconsole.log( 'string replace' );\n\t\t\t\t\t\t} else if ( _.isArray( val ) ) {\n\t\t\t\t\t\t\t// If val is an array, search it for the field mergetag.\n\t\t\t\t\t\t\tconsole.log( 'array search' );\n\t\t\t\t\t\t} else if ( _.isObject( val ) ) {\n\t\t\t\t\t\t\t// If val is a object, search it for the field mergetag.\n\t\t\t\t\t\t\tnewObject = _.mapObject( val, function( value, key ) {\n\t\t\t\t\t\t\t\tif ( _.isString( value ) ) {\n\t\t\t\t\t\t\t\t\tif ( -1 != value.indexOf( fieldMergeTag ) ) {\n\t\t\t\t\t\t\t\t\t\tattr.splice( index, 1 );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t};\n\n\t\t\t\t\t\t\t\treturn value;\n\t\t\t\t\t\t\t} );\n\n\t\t\t\t\t\t\tthis.set( key, attr );\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this );\n\t\t\t\t} else if ( attr instanceof Backbone.Collection ) {\n\t\t\t\t\t// This is a Backbone Collection, so we need to loop through the models and remove any that have an attribute containing the field merge tag.\n\t\t\t\t\tvar filteredCollection = attr.filter( function ( model ) {\n\t\t\t\t\t\t// Make sure that EVERY model attribute does NOT reference the field merge tag.\n\t\t\t\t\t    return _.every( model.attributes, function( val ) {\n\t\t\t\t\t    \t/*\n\t\t\t\t\t    \t * Currently only handles items that are one-level deep.\n\t\t\t\t\t    \t * TODO: Add support for further nesting of values.\n\t\t\t\t\t    \t */\n\t\t\t\t\t    \tif ( _.isString( val ) ) {\n\t\t\t\t\t    \t\tif ( -1 != val.indexOf( fieldMergeTag ) ) {\n\t\t\t\t\t    \t\t\treturn false;\n\t\t\t\t\t    \t\t}\n\t\t\t\t\t    \t}\n\t\t\t\t\t    \treturn true;\n\t\t\t\t\t