ilterCollection: function( search, collection ) {\n        \tsearch = search.toLowerCase();\n        \t/*\n        \t * Backbone collections have a 'filter' method that loops through every model,\n        \t * waiting for you to return true or false. If you return true, the model is kept.\n        \t * If you return false, it's removed from the filtered result.\n        \t */\n\t\t\tvar filtered = collection.filter( function( model ) {\n\t\t\t\tvar found = false;\n\t\t\t\t\n\t\t\t\t// If we match either the ID or nicename, return true.\n\t\t\t\tif ( model.get( 'id' ).toLowerCase().indexOf( search ) != -1 ) {\n\t\t\t\t\tfound = true;\n\t\t\t\t} else if ( model.get( 'nicename' ).toLowerCase().indexOf( search ) != -1 ) {\n\t\t\t\t\tfound = true;\n\t\t\t\t}\n\n\t\t\t\t/*\n\t\t\t\t * TODO: Hashtag searching. Doesn't really do anything atm.\n\t\t\t\t */\n\t\t\t\tif ( model.get( 'tags' ) && 0 == search.indexOf( '#' ) ) {\n\t\t\t\t\t_.each( model.get( 'tags' ), function( tag ) {\n\t\t\t\t\t\tif ( search.replace( '#', '' ).length > 1 ) {\n\t\t\t\t\t\t\tif ( tag.toLowerCase().indexOf( search.replace( '#', '' ) ) != -1 ) {\n\t\t\t\t\t\t\t\tfound = true;\n\t\t\t\t\t\t\t}\t\t\t\t\t\t\t\n\t\t\t\t\t\t}\n\t\t\t\t\t} );\n\t\t\t\t}\n\n\t\t\t\t// If we match any of the aliases, return true.\n\t\t\t\tif ( model.get( 'alias' ) ) {\n\t\t\t\t\t_.each( model.get( 'alias' ), function( alias ) {\n\t\t\t\t\t\tif ( alias.toLowerCase().indexOf( search ) != -1 ) {\n\t\t\t\t\t\t\tfound = true;\n\t\t\t\t\t\t}\n\t\t\t\t\t} );\n\t\t\t\t}\n\n\t\t\t\treturn found;\n\t\t\t} );\n\n\t\t\t// Return our filtered collection.\n\t\t\treturn filtered;\n        }\n\t});\n\n\treturn controller;\n} );\n","/**\n * @package Ninja Forms builder\n * @subpackage Actions - New Action Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/actions/newsletterList',[], function( ) {\n    var controller = Marionette.Object.extend( {\n        initialize: function() {\n            this.listenTo( nfRadio.channel( 'setting-newsletter_list' ),             'show:setting',      this.defaultFields );\n            this.listenTo( nfRadio.channel( 'setting-type-newsletter_list' ),        'click:extra',       this.clickListUpdate );\n            this.listenTo( nfRadio.channel( 'actionSetting-newsletter_list' ),       'update:setting',    this.maybeRenderFields );\n            this.listenTo( nfRadio.channel( 'actionSetting-newsletter_list' ),       'update:setting',    this.maybeRenderGroups );\n            this.listenTo( nfRadio.channel( 'setting-name-newsletter_list_fields' ), 'init:settingModel', this.registerFieldsListener );\n            this.listenTo( nfRadio.channel( 'setting-name-newsletter_list_groups' ), 'init:settingModel', this.registerGroupsListener );\n        },\n\n        defaultFields: function( settingModel, dataModel ) {\n            this.maybeRenderFields( dataModel, settingModel );\n            this.maybeRenderGroups( dataModel, settingModel );\n        },\n\n        registerFieldsListener: function ( model ) {\n            model.listenTo( nfRadio.channel( 'newsletter_list_fields' ), 'update:fieldMapping', this.updateFieldMapping, model );\n        },\n\n        registerGroupsListener: function ( model ) {\n            model.listenTo( nfRadio.channel( 'newsletter_list_groups' ), 'update:interestGroups', this.updateInterestGroups, model );\n        },\n\n        clickListUpdate: function( e, settingModel, dataModel, settingView ) {\n\n            var data = {\n                action: 'nf_' + dataModel.attributes.type + '_get_lists',\n                security: nfAdmin.ajaxNonce\n            };\n\n            var that = this;\n            jQuery( e.srcElement ).addClass( 'spin' );\n            jQuery.post( ajaxurl, data, function( response ){\n                var response = JSON.parse( response );\n                that.updateLists( settingModel, response.lists, settingView, dataModel );\n                dataModel.set( 'newsletter_list', response.lists[0].value, { settingModel: settingModel } );\n            }).always( function() {\n                jQuery( e.srcElement ).removeClass( 'spin' );\n            });\n        },\n\n        updateLists: function( settingModel, lists, settingView, dataModel ) {\n            settingModel.set( 'options', lists );\n            settingView.render();\n        },\n\n        maybeRenderFields: function( dataModel, settingModel ) {\n\n            if( 'undefined' == typeof settingModel ) return;\n\n            var selectedList = dataModel.get( 'newsletter_list' );\n            var lists = settingModel.get( 'options' );\n            _.each( lists, function( list ) {\n                if ( selectedList == list.value ) {\n                    nfRadio.channel( 'newsletter_list_fields').trigger( 'update:fieldMapping', list.fields );\n                }\n            } );\n\n            dataModel.set( 'newsletter_list_fields', 0 );\n        },\n\n        maybeRenderGroups: function( dataModel, settingModel ) {\n            if( 'undefined' == typeof settingModel ) return;\n\n            var selectedList = dataModel.get( 'newsletter_list' );\n            var lists = settingModel.get( 'options' );\n            _.each( lists, function( list ) {\n                if ( selectedList == list.value ) {\n                    nfRadio.channel( 'newsletter_list_groups').trigger( 'update:interestGroups', list.groups );\n                }\n            } );\n\n            dataModel.set( 'newsletter_list_fields', 0 );\n        },\n\n        updateFieldMapping: function( fields ) {\n           var settings = this.get( 'settings' );\n            settings.reset();\n            _.each( fields, function( field ){\n\n                settings.add({\n                    name: field.value,\n                    type: 'textbox',\n                    label: field.label,\n                    width: 'full',\n                    use_merge_tags: { exclude: [ 'user', 'post', 'system', 'querystrings' ] }\n                });\n            });\n            this.set( 'settings', settings );\n        },\n\n        updateInterestGroups: function( groups ) {\n            var settings = this.get( 'settings' );\n            settings.reset();\n            _.each( groups, function( group