{ label: fieldModel.get( 'label' ), value: '{field:' + fieldModel.get( 'key' ) + '}' } );\n\t\t\t\t}\n\t\t\t}\n\t\t\t\n\t\t\t/*\n\t\t\t * Update our fields options.\n\t\t\t */\n\t\t\tsettingModel.set( 'options', fields );\n\t\t\t\n\t\t},\n\n\t\tgetFields: function( settingModel ) {\n\t\t\tvar returnFields = [ settingModel.get( 'default_options' ) ];\n\t\t\t// Update our dataModel with all of our product fields.\n\t\t\tvar fields = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\t\t\tvar allowed = [\n\t\t\t\t'number',\n\t\t\t\t'checkbox',\n\t\t\t\t'total', // Deprecated\n\t\t\t\t'listcheckbox',\n\t\t\t\t'listimage',\n\t\t\t\t'listmultiselect',\n\t\t\t\t'listradio',\n\t\t\t\t'listselect'\n\t\t\t];\n\t\t\t_.each( fields.models, function( field ) {\n\t\t\t\tif ( allowed.includes( field.get( 'type' ) ) ) {\n\t\t\t\t\treturnFields.push( { label: field.get( 'label' ), value: '{field:' + field.get( 'key' ) + '}' } );\n\t\t\t\t}\n\t\t\t} );\n\n\t\t\treturnFields = _.sortBy( returnFields, function( field ) { return field.label } );\n\n\t\t\treturn returnFields;\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Listens to our app channel for settings views being rendered.\n *\n * If we're rendering a collect payment setting, add our calculations to the data model.\n *\n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2017 WP Ninjas\n * @since 3.1.7\n */\ndefine( 'controllers/actions/collectPaymentCalculations',[], function() {\n    var controller = Marionette.Object.extend( {\n        initialize: function() {\n            // Listen for messages that are fired before a setting view is rendered.\n            this.listenTo( nfRadio.channel( 'app' ), 'before:renderSetting', this.beforeRenderSetting );\n        },\n\n        beforeRenderSetting: function( settingModel, dataModel, view ) {\n            if ( 'calc' == settingModel.get( 'total_type' ) ) {\n                var calcModels = nfRadio.channel( 'app' ).request( 'get:formModel' );\n                var calcs = this.getCalcs( calcModels, settingModel );\n\n                settingModel.set( 'options', calcs );\n            }\n        },\n\n        getCalcs: function( calcModels, settingModel ) {\n            var returnCalcs = [ settingModel.get( 'default_options' ) ];\n\n            // Update our dataModel with all of our product fields.\n            var calcs = calcModels.get( 'settings' ).get( 'calculations' );\n\n            _.each( calcs.models, function( calc ) {\n                returnCalcs.push( { label: calc.get( 'name' ), value: '{calc:' + calc.get( 'name' ) + '}' } );\n            } );\n\n            returnCalcs = _.sortBy( returnCalcs, function( calc ) { return calc.label } );\n\n            return returnCalcs;\n        }\n\n    });\n\n    return controller;\n} );\n","/**\n * Listens to our app channel for settings views being rendered.\n *\n * If we haven't set a total_type, then set the total_type to fixed.\n *\n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2017 WP Ninjas\n * @since 3.1.7\n */\ndefine( 'controllers/actions/collectPaymentFixed',[], function() {\n    var controller = Marionette.Object.extend( {\n        initialize: function() {\n            // Listen for messages that are fired before a setting view is rendered.\n            this.listenTo( nfRadio.channel( 'app' ), 'before:renderSetting', this.beforeRenderSetting );\n        },\n\n        beforeRenderSetting: function( settingModel, dataModel, view ) {\n\n            if ( 'payment_total_type' != settingModel.get( 'name' ) || _.isEmpty( dataModel.get( 'payment_total' ) ) ) return false;\n\n            /*\n             * If we don't have a payment total type and we have a payment total, set our total type to the appropriate total type.\n             */\n            if ( ( 'undefined' == dataModel.get( 'payment_total_type' ) || _.isEmpty( dataModel.get( 'payment_total_type' ) ) ) ) {\n                /*\n                 * If payment_total is a field merge tag, set payment_total_type to \"field\"\n                 */\n\n                if ( -1 != dataModel.get( 'payment_total' ).indexOf( '{field' ) ) {\n                    dataModel.set( 'payment_total_type', 'field' );\n                } else if ( -1 != dataModel.get( 'payment_total' ).indexOf( '{calc' ) ) {\n                    dataModel.set( 'payment_total_type', 'calc' );\n                } else {\n                    dataModel.set( 'payment_total_type', 'fixed' );\n                }   \n            }\n        },\n\n    });\n\n    return controller;\n} );\n","/**\n * When we init a collect payment action, listen for calc changes\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2017 WP Ninjas\n * @since 3.1.7\n */\ndefine( 'controllers/actions/collectPayment',[], function( settingCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t/*\n\t\t\t * When we init a collect payment action model, register a listener for calc changes.\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'actions-collectpayment' ), 'init:actionModel', this.initCollectPayment );\n\t\t\t\n\t\t\t/*\n\t\t\t * Before we render our total field, we may want to update its value.\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'before:renderSetting', this.maybeClearTotal );\n\t\t},\n\n\t\t/**\n\t\t * When a collect payment action is init'd, register a listener for calc changes and update our data appropriately.\n\t\t * @since  3.1.7\n\t\t * @param  {backbone.model} actionModel \n\t\t * @return {void}\n\t\t */\n\t\tinitCollectPayment: function( actionModel )  {\n\t\t\tactionModel.listenTo( nfRadio.channel( 'calcs' ), 'update:calcName', this.maybeUpdateTotal );\n        },\n\n\t\t//TODO: Add in an error that will not allow drawer to close until total type and total value is selected.\n\t\tmaybeError: function(){},\n\n\t\tmaybeUpdateTotal: function( optionModel, oldName ) {\n\t\t\t/*\n\t\t\t * We have changed a calculation. Make sure that 'calc' is our payment total type.\n\t\t\t */\n\t\t\tif ( 'calc' != this.get( 'payment_total_type' ) ) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\t\n\t\t\t/*\n\t\t\t * Check our payment_total setting for the old merge tag and replace it with the new one.\n\t\t\t */\n\t\t\tvar newVal = this.get( 'payment_total' ).replace( '{calc:' + oldName + '}', '{calc:' + optionModel.get( 'name' ) + '}' );\n\t\t\tthis.set( 'payment_total', newVal );\n\t\t},\n\n\t\tmaybeClearTotal: function( settingModel, dataModel, view ) {\n            /*\n             * If our payment_total is a merge tag, clear it when we select the \"fixed\" option.\n             */\n            if ( 'fixed' == dataModel.get( 'payment_total_type' ) ) {\n                if ( -1 != dataModel.get( 'payment_total' ).indexOf( '{field' ) || -1 != dataModel.get( 'payment_total' ).indexOf( '{calc' ) ) {\n                    dataModel.set( 'payment_total', '' );\n                }\n            }\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * When we init a save action, listen for form changes\n *\n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2017 WP Ninjas\n * @since 3.1.7\n */\ndefine( 'controllers/actions/save',[], function( settingCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'actions-save' ), 'init:actionModel', this.initSave );\n\t\t},\n\n\t\t/**\n\t\t * Set listeners up to listen for add/delete fields for Save action\n\t\t */\n\t\tinitSave: function( actionModel ) {\n\n\t\t\tthis.model = actionModel;\n\n\t\t\t/*\n\t\t\t * When we init a save action model, register a listener for new\n\t\t\t  * fields\n\t\t\t */\n\t\t\tthis.listenTo( Backbone.Radio.channel( 'fields' ), 'add:field',\n\t\t\t\tthis.checkFieldAdded );\n\n\t\t\t/*\n\t\t\t * When we init a save action model, register a listener for deleted\n\t\t\t  * fields\n\t\t\t */\n\t\t\tthis.listenTo( Backbone.Radio.channel( 'fields' ), 'delete:field',\n\t\t\t\tthis.checkFieldDeleted );\n\t\t},\n\n\t\t/**\n\t\t * When a save action is init'd, check to see if a new field added\n\t\t * is an email and decide if it needs to be the 'submitter_email'\n\t\t * for privacy regulation functionality\n\t\t *\n\t\t * @param  {backbone.model} actionModel\n\t\t * @return {void}\n\t\t */\n\t\tcheckFieldAdded: function( newFieldModel ) {\n\t\t\tif( 'email' == newFieldModel.get( 'type' ) ) {\n\t\t\t\tvar submitter_email = this.model.get('submitter_email');\n\n\t\t\t\tif( '' === submitter_email ) {\n\t\t\t\t\tthis.model.set( 'submitter_email', newFieldModel.get( 'key' ) );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * When a save action is init'd, check to see if a field that has been\n\t\t * deleted is an email and rearrance the submitter email setting\n\t\t * for privacy regulation functionality\n\t\t *\n\t\t * @param  {backbone.model} actionModel\n\t\t * @return {void}\n\t\t */\n\t\tcheckFieldDeleted: function( fieldModel ) {\n\t\t\tvar submitter_email = this.model.get( 'submitter_email' );\n\t\t\t\n\t\t\tif( submitter_email == fieldModel.get( 'key' ) ) {\n\t\t\t\tthis.model.set( 'submitter_email', '' );\n\t\t\t}\n\t\t},\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Creates and stores a collection of form setting types. This includes all of the settings shown when editing a field.\n *\n * Loops over our preloaded data and adds that to our form setting type collection\n *\n * Also responds to requests for data about form setting types\n *\n * @package Ninja Forms builder\n * @subpackage Advanced\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/advanced/types',[\n\t\t'models/app/typeCollection'\n\t],\n\tfunction(\n\t\tTypeCollection\n\t) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Create our field type collection\n\t\t\tthis.collection = new TypeCollection( formSettingTypeData );\n\n\t\t\t// Respond to requests to get field type, collection, settings, and sections\n\t\t\tnfRadio.channel( 'settings' ).reply( 'get:type', this.getType, this );\n\t\t\tnfRadio.channel( 'settings' ).reply( 'get:typeCollection', this.getCollection, this );\n\t\t},\n\n\t\t/**\n\t\t * Return a field type by id\n\t\t *\n\t\t * @since  3.0\n\t\t * @param  string \t\t\tid \tfield type\n\t\t * @return backbone.model    \tfield type model\n\t\t */\n\t\tgetType: function( id ) {\n\t\t\treturn this.collection.get( id );\n        },\n\n        /**\n         * Return the installed action type collection\n         *\n         * @since  3.0\n         * @return backbone.collection    \tfield type collection\n         */\n\t\tgetCollection: function() {\n        \treturn this.collection;\n        }\n\t});\n\n\treturn controller;\n} );\n\n","/**\n * Model that represents our form settings.\n * \n * @package Ninja Forms builder\n * @subpackage Form Settings\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/advanced/settingsModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\t\tdefaults: {\n\t\t\tobjectType: 'Form Setting',\n\t\t\teditActive: false\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\t// Listen for model attribute changes\n\t\t\tthis.bind( 'change', this.changeSetting, this );\n\t\t\t/*\n\t\t\t * Check to see if we have any setting defaults to set.\n\t\t\t */\n\t\t\tvar formSettings = nfRadio.channel( 'settings' ).request( 'get:collection' );\n\t\t\t_.each( formSettings.models, function( settingModel ) {\n\t\t\t\tif ( 'undefined' == typeof this.get( settingModel.get( 'name' ) ) ) {\n\t\t\t\t\tthis.set( settingModel.get( 'name' ), settingModel.get( 'value' ), { silent: true } );\n\t\t\t\t}\n\t\t\t\tnfRadio.channel( settingModel.get( 'type' ) ).trigger( 'init:dataModel', this, settingModel );\n\t\t\t}, this );\n\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'fire:updateFieldKey', this.updateFieldKey );\n\t\t},\n\n\t\t/**\n\t\t * When we change the model attributes, fire an event saying we've changed something.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tchangeSetting: function( model, options) {\n\t\t\tnfRadio.channel( 'app' ).trigger( 'update:setting', this, options.settingModel );\n\t\t},\n\n\t\tupdateFieldKey: function( keyModel, settingModel ) {\n\t\t\tnfRadio.channel( 'app' ).trigger( 'replace:fieldKey', this, keyModel, settingModel );\n\t\t}\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Handles interactions with our form settings collection.\n * \n * @package Ninja Forms builder\n * @subpackage Advanced\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/advanced/data',['models/advanced/settingsModel'], function( settingsModel ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Load our action collection from our localized form data\n\t\t\tthis.model = new settingsModel( preloadedFormData.settings );\n\n\t\t\tnfRadio.channel( 'settings' ).reply( 'get:settings', this.getSettings, this );\n\t\t\tnfRadio.channel( 'settings' ).reply( 'get:setting', this.getSetting, this );\n\t\t\tnfRadio.channel( 'settings' ).reply( 'update:setting', this.updateSetting, this );\n\t\t},\n\n\t\tgetSettings: function() {\n\t\t\treturn this.model;\n\t\t},\n\n\t\tupdateSetting: function( name, value, silent ) {\n\t\t\tsilent = silent || false;\n\t\t\tthis.model.set( name, value, { silent: silent } );\n\t\t},\n\n\t\tgetSetting: function( name ) {\n\t\t\treturn this.model.get( name );\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Fetches settings models so that we can get setting information\n * \n * @package Ninja Forms builder\n * @subpackage Advanced\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/advanced/formSettings',['models/app/settingCollection'], function( settingCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.collection = new settingCollection( formSettings, { objectType: 'settings' } );\n\t\t\t\t\t\n\t\t\t// Responds to requests for settings models.\n\t\t\tnfRadio.channel( 'settings' ).reply( 'get:settingModel', this.getSettingModel, this );\n\n\t\t\t// Responds to requests for our setting collection\n\t\t\tnfRadio.channel( 'settings' ).reply( 'get:collection', this.getSettingCollection, this );\n\t\t},\n\n\t\tgetSettingModel: function( name ) {\n\t\t\treturn this.collection.findWhere( { name: name } );\n\t\t},\n\n\t\tgetSettingCollection: function() {\n\t\t\treturn this.collection;\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles adding and removing the active class from form settings currently being edited.\n * \n * @package Ninja Forms builder\n * @subpackage Advanced\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/advanced/editActive',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Respond to requests t