type-datepicker' ).reply('get:options', () => { return dataModel.attributes });\n\t\t\t// Allow fields to add settings to the datepicker.\n\t\t\tlet filteredDatePickerSettings = nfRadio.channel( 'setting-type-datepicker' ).request( 'filter:settings', datePickerSettings, settingModel, el );\n\t\t\tif ( 'undefined' != typeof filteredDatePickerSettings ) {\n\t\t\t\tdatePickerSettings = filteredDatePickerSettings;\n\t\t\t}\n\n\t\t\tvar dateObject = flatpickr( el, datePickerSettings );\n\n\t\t\tnfRadio.channel( 'setting-type-datepicker' ).trigger( 'loadComplete', dateObject, settingModel, dataModel, view );\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Listens to our app channel for settings views being rendered.\n *\n * If we're rendering a product_assignment setting, add our products to the data model.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/fieldDisplayCalc',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Listen for messages that are fired before a setting view is rendered.\n\t\t\tthis.listenTo( nfRadio.channel( 'setting-calc_var' ), 'before:renderSetting', this.beforeRenderSetting );\n\t\t},\n\n\t\tbeforeRenderSetting: function( settingModel, dataModel, view ) {\n\t\t\t// console.log( 'render!' );\n\t\t},\n\n\t\tgetProductFields: function( settingModel ) {\n\t\t\tvar productFields = [ settingModel.get( 'select_product' ) ];\n\t\t\t// Update our dataModel with all of our product fields.\n\t\t\tvar fields = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\t\t\t_.each( fields.models, function( field ) {\n\t\t\t\tif ( 'product' == field.get( 'type' ) ) {\n\t\t\t\t\tproductFields.push( { label: field.get( 'label' ), value: field.get( 'id' ) } );\n\t\t\t\t}\n\t\t\t} );\n\t\t\treturn productFields;\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles specifics for our repeater field types.\n *\n */\ndefine( 'controllers/fields/fieldRepeater',[ 'models/fields/fieldCollection' ], function( fieldCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\n\t\tinitialize: function() {\n\t\t\t// Listen for repeater field models.\n\t\t\tthis.listenTo( nfRadio.channel( 'fields-repeater' ), 'init:fieldModel', this.setupCollection, this );\n\n\t\t\tnfRadio.channel( 'fields-repeater' ).reply( 'add:childField', this.addChildField, this );\n\t\t\tnfRadio.channel( 'fields-repeater' ).reply( 'receive:fields', this.receiveFields, this );\n\t\t\tnfRadio.channel( 'fields-repeater' ).reply( 'get:childField', this.getChildField, this );\n\t\t\tnfRadio.channel( 'fields-repeater' ).reply( 'process:stagedField', this.processStagedFields, this );\n\t\t\tnfRadio.channel( 'fields-repeater' ).reply( 'sort:repeaterField', this.sortRepeaterField, this );\n\t\t\tnfRadio.channel( 'fields-repeater' ).reply( 'over:repeaterField', this.overRepeaterField, this );\n\t\t\tnfRadio.channel( 'fields-repeater' ).reply( 'out:repeaterField', this.outRepeaterField, this );\n\t\t\tnfRadio.channel( 'fields-repeater' ).reply( 'stop:repeaterField', this.stopRepeaterField, this );\n\t\t\tnfRadio.channel( 'fields-repeater' ).reply( 'start:repeaterField', this.startRepeaterField, this );\n\t\t\tnfRadio.channel( 'fields-repeater' ).reply( 'update:repeaterField', this.updateRepeaterField, this );\n\t\t},\n\n\t\t/**\n\t\t * When we save repeater fields, their 'fields' content will be saved as an array of objects.\n\t\t * When a repeater field model is created, we need to hyrdate the 'fields' settings and turn it into a Backbone Collection.\n\t\t * \n\t\t * @since  version\n\t\t * @param  {[type]} fieldModel [description]\n\t\t * @return {[type]}            [description]\n\t\t */\n\t\tsetupCollection: function( fieldModel ) {\n\t\t\t// The fields var will be an array of field model data.\n\t\t\tlet fields = fieldModel.get( 'fields' );\n\n\t\t\t// Only turn it into a collection if we haven't already.\n\t\t\tif ( false === fields instanceof Backbone.Collection ) {\n\t\t\t\tlet collection =  new fieldCollection( fields );\n\t\t\t\tfieldModel.set( 'fields', collection );\n\n\t\t\t\t//Allows to loop through Repeater fields to reset correct state\n\t\t\t\tcollection.listenTo( nfRadio.channel( 'fields-repeater' ), 'clearEditActive', this.clearEditActive, collection );\n\t\t\t\tcollection.listenTo( nfRadio.channel( 'app' ), 'after:appStart', this.clearEditActive, collection );\n\t\t\t\t\n\t\t\t\t// Listen for radio messages that a field was deleted.\n\t\t\t\tcollection.listenTo( nfRadio.channel( 'fields' ), 'delete:field', this.maybeDeleteField, collection );\n\t\t\t}\t\n\t\t},\n\n\t\t/**\n\t\t * In order to delete items from within a repeater field without creating a new convention, we listen to radio messages for field deletion.\n\t\t * We just have to make sure that these fields weren't just added to our repeater field collection.\n\t\t * \n\t\t * @since  version\n\t\t * @param  {[type]} fieldModel [description]\n\t\t * @return {[type]}            [description]\n\t\t */\n\t\tmaybeDeleteField: function( fieldModel ) {\n\t\t\t// Make sure that we didn't just add this field to our repeater.\n\t\t\tif ( ! fieldModel.get( 'droppedInRepeater' ) ) {\n\t\t\t\tthis.remove( fieldModel );\n\t\t\t}\n\t\t\t// We're done dropping now.\n\t\t\tfieldModel.set( 'droppedInRepeater', false );\n\t\t},\n\n\t\t/**\n\t\t * Loops through our fields collection and sets editActive to false.\n\t\t * \n\t\t * @param  {[type]} fieldModel field that was clicked\n\t\t * @return void\n\t\t */\n        clearEditActive: function( model ) {\n            _.each( this.models, function( field ) {\n\t\t\t\tif( model.cid !== field.cid ){\n\t\t\t\t\tfield.set( 'editActive', true );\n\t\t\t\t\tfield.set( 'editActive', false );\n\t\t\t\t}\n            } );\n\t\t},\n\n\n\t\t/**\n\t\t * Receive fields in the repeater field sortable zone\n\t\t * \n\t\t */\n\t\treceiveFields: function( ui, that, e ) {\n\n\t\t\tif( jQuery( ui.item ).hasClass( 'nf-stage' ) ) {\n\t\t\t\tthis.processStagedFields( ui, that, e );\n\t\t\t} else {\n\t\t\t\tthis.addChildField(ui, that, e);\n\t\t\t}\n\n\t\t},\t\n\t\t\n\t\t/**\n\t\t * Add a field in the repeater fields collection\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\taddChildField: function( ui, that, e ) {\n\n\t\t\tlet type = typeof ui.item !== \"undefined\" ? jQuery( ui.item ).data( 'id' ) : ui.get('slug'),\n\t\t\tdroppedFieldModel = nfRadio.channel( 'fields' ).request( 'get:field', type ),\n\t\t\tcollection = that.repeaterFieldModel.get( 'fields' ),\n\t\t\tfieldModel;\n\t\t\t\n\t\t\t\n\t\t\t//Don't process another repeater field\n\t\t\tif(type === \"repeater\") return;\n\t\t\t\n\t\t\t//If a field Model exists and comes from the builder get the field Type and delete Field Model from main collection\n\t\t\tif(droppedFieldModel != null){\n\t\t\t\t//Reset type based on the model\n\t\t\t\ttype = droppedFieldModel.attributes.type;\n\t\t\t\t// Remove the field from the main field collection.\n\t\t\t\tnfRadio.channel( 'app' ).trigger( 'click:delete', e, droppedFieldModel );\n\t\t\t}\n\n\t\t\t// Get our field type model\n\t\t\tfieldModel = nfRadio.channel( 'fields' ).request( 'get:type', type );\n\n\t\t\t// Get our tmp ID\n\t\t\tlet elId = nfRadio.channel( 'fields' ).request( 'get:tmpID' ) != null ? nfRadio.channel( 'fields' ).request( 'get:tmpID' ) : \"tmp\";\n\t\t\t//Add field to collection\n\t\t\tnewField = collection.add(  { id: elId , label: fieldModel.get( 'nicename' ), type: type, repeaterField: true} );\n\n\t\t\t//Sort fields\n\t\t\tlet sortableEl = nfRadio.channel( 'fields-repeater' ).request( 'get:sortableEl' );\n\t\t\tif(! jQuery(sortableEl).hasClass('ui-sortable')){\n\t\t\t\tnfRadio.channel( 'fields-repeater' ).request( 'init:sortable' );\n\t\t\t}\n\t\t\tlet sortableElArray = jQuery( sortableEl ).sortable( 'toArray' );\n\t\t\t_.each( sortableElArray, function( element, index ) {\n\t\t\t\tif(false === element.length > 0){\n\t\t\t\t\tsortableElArray[index] = elId;\n\t\t\t\t} else if (element === elId) {\n\t\t\t\t\tsortableElArray.splice( index, 1);\n\t\t\t\t}\n\t\t\t});\n\t\t\tnfRadio.channel( 'fields-repeater' ).request( 'sort:repeaterField', sortableElArray);\n\n\t\t\t// Add our field addition to our change log.\n\t\t\tvar label = {\n\t\t\t\tobject: 'Field',\n\t\t\t\tlabel: newField.get( 'label' ),\n\t\t\t\tchange: 'Added',\n\t\t\t\tdashicon: 'plus-alt'\n\t\t\t};\n\n\t\t\tvar data = {\n\t\t\t\tcollection: collection\n\t\t\t}\n\t\t\t\n\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'addObject', newField, null, label, data );\n\n\t\t\t\n\t\t\tif( typeof elId !== \"undefined\" && typeof ui.helper !== \"undefined\" ){\n\t\t\t\t/*\n\t\t\t\t* Update our helper id to the tmpID.\n\t\t\t\t* We do this so that when we sort, we have the proper ID.\n\t\t\t\t*/ \n\t\t\t\tjQuery( ui.helper ).prop( 'id', elId );\n\t\t\t\t//Sort fields in repeater\n\t\t\t\tnfRadio.channel( 'app' ).request( 'stop:fieldsSortable', ui );\n\t\t\t\t// Remove the helper. Gets rid of a weird type artifact.\n\t\t\t\tjQuery( ui.helper ).remove();\n\t\t\t\t// Trigger a drop field type event.\n\t\t\t\tnfRadio.channel( 'fields' ).trigger( 'drop:fieldType', type, elId );\n\t\t\t}\n\n\t\t\treturn elId;\n\n\t\t},\n\n\t\t/**\n\t\t * Get a field from a repeater field collection\n\t\t * \n\t\t * @return fieldModel\n\t\t */\n\t\tgetChildField: function( childFieldID, parentFieldModel, newID ) {\n\n\t\t\tif( typeof childFieldID === \"undefined\") return;\n\t\t\t//Prepare retuned variable\n\t\t\tlet childFieldModel;\n\t\t\t//Allow to retrieve parentFieldModel by the newID that contains the parent Field ID ( USed to update a field ID after saving the form )\n\t\t\tif( parentFieldModel == null && typeof newID !== \"undefined\" ){\n\t\t\t\tconst parentID = newID.split('.')[0];\n\t\t\t\tparentFieldModel = nfRadio.channel( 'fields' ).request( 'get:field', parentID );\n\t\t\t}\n\t\t\t\n\t\t\t//Check we have the Repeater Field Model\n\t\t\tif( parentFieldModel ) {\n\t\t\t\t//Get the fields collection in the repeater Field model\n\t\t\t\tlet repeaterFieldsCollection = parentFieldModel.get( 'fields' );\n\t\t\t\t//Get the Child Field Model\n\t\t\t\tchildFieldModel = repeaterFieldsCollection.get( childFieldID );\n\t\t\t}\n\t\t\t\n\t\t\treturn childFieldModel;\n\t\t},\n\n\t\t/**\n\t\t * Add Staged fields to repeater fieldset\n\t\t * \n\t\t * @paran object event dropped\n\t\t * @param object ui dropped element\n\t\t */\n\t\tprocessStagedFields( ui, that, e) {\n\n\t\t\t// Make sure that our staged fields are sorted properly.\t\n\t\t\tnfRadio.channel( 'fields' ).request( 'sort:staging' );\n\t\t\t// Grab our staged fields.\n\t\t\tvar stagedFields = nfRadio.channel( 'fields' ).request( 'get:staging' );\n\n\t\t\t// Get our current field order.\n\t\t\tvar sortableEl = nfRadio.channel( 'fields-repeater' ).request( 'get:sortableEl' );\n\n\t\t\tlet order = [];\n\t\t\tif ( jQuery( sortableEl ).hasClass( 'repeater' ) ) { // Sortable isn't empty\n\t\t\t\t// If we're dealing with a sortable that isn't empty, get the order.\n\t\t\t\torder = jQuery( sortableEl ).sortable( 'toArray' );\n\t\t\t} else { // Sortable is empty\n\t\t\t\t// Sortable is empty, all we care about is our staged field draggable.\n\t\t\t\torder = ['nf-staged-fields-drag'];\n\t\t\t}    \n\t\t\t\n\t\t\t// Get the index of our droped element.\n\t\t\tlet insertedAt = order.indexOf( 'nf-staged-fields-drag' );\n\n\t\t\t// Loop through each staged fields model and insert a field.\n\t\t\t_.each( stagedFields.models, function( field, index ) {\n\t\t\t\t// Add our field.\n\t\t\t\tvar tmpID = nfRadio.channel( 'fields-repeater' ).request( 'add:childField', field, that, e );\n\t\t\t\t// Add this newly created field to our order array.\n\t\t\t\torder.splice( insertedAt + index, 0, tmpID );\n\t\t\t\t\n\t\t\t} );\n\n\t\t\t// Remove our dropped element from our order array.\n\t\t\tinsertedAt = order.indexOf( 'nf-staged-fields-drag' );\n\t\t\torder.splice( insertedAt, 1 );\n\n\t\t\t// Sort our fields\n\t\t\tnfRadio.channel( 'fields' ).request( 'sort:fields', order );\n\t\t\t// Clear our staging\n\t\t\tnfRadio.channel( 'fields' ).request( 'clear:staging' );\n\t\t\t// Remove our helper. Fixes a weird artifact.\n\t\t\tjQuery( ui.helper ).remove();\n\n\t\t},\n\n\t\t/**\n\t\t * Sort the fields in a repeater Field\n\t\t * \n\t\t * @param  Array \torder optional order array like: [field-1, field-4, field-2]\n\t\t * @return void\n\t\t */\n\t\tsortRepeaterField: function( order, ui, updateDB ) {\n\t\t\t// Add the field to this repeatable collection.\n\t\t\tlet collection = nfRadio.channel( 'fields-repeater' ).request( 'get:repeaterFieldsCollection' );\n\n\t\t\tif ( null == updateDB ) {\n\t\t\t\tupdateDB = true;\n\t\t\t}\n\t\t\t// Get our sortable element\n\t\t\tvar sortableEl = nfRadio.channel( 'fields-repeater' ).request( 'get:sortableEl' );\n\t\t\tif ( jQuery( sortableEl ).hasClass( 'ui-sortable' ) ) { // Make sure that sortable is enabled\n\t\t\t\t// JS ternerary for setting our order\n\t\t\t\tvar order = order || jQuery( sortableEl ).sortable( 'toArray' );\n\t\t\t\t// Loop through all of our fields and update their order value\n\t\t\t\t_.each( collection.models, function( field ) {\n\t\t\t\t\t// Get our current position.\n\t\t\t\t\tvar oldPos = field.get( 'order' );\n\t\t\t\t\tvar id = field.get( 'id' );\n\t\t\t\t\tif ( jQuery.isNumeric( id ) ) {\n\t\t\t\t\t\tvar search = 'field-' + id;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tvar search = id;\n\t\t\t\t\t}\n\t\t\t\t\t\n\t\t\t\t\t// Get the index of our field inside our order array\n\t\t\t\t\tvar newPos = order.indexOf( search ) + 1;\n\t\t\t\t\tfield.set( 'order', newPos );\n\t\t\t\t} );\n\n\t\t\t\tcollection.sort();\n\t\t\t\t\n\t\t\t\tif ( updateDB ) {\n\t\t\t\t\t// Set our 'clean' status to false so that we get a notice to publish changes\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'update:setting', 'clean', false );\n\t\t\t\t\t// Update our preview\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'update:db' );\t\t\t\t\t\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * When the user drags a field type or staging over our sortable, we need to modify the helper.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \tui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\toverRepeaterField: function( ui ) {\n\t\t\tif( jQuery( ui.item ).hasClass( 'nf-field-type-draggable' ) ) { // Field Type\n\t\t\t\t// String type\n\t\t\t\tvar type = jQuery( ui.helper ).data( 'id' );\n\t\t\t\t// Get our field type model.\n\t\t\t\tvar fieldType = nfRadio.channel( 'fields' ).request( 'get:type', type );\n\t\t\t\t// Get our field type nicename.\n\t\t\t\tvar label = fieldType.get( 'nicename' );\n\t\t\t\t// Get our sortable element.\n\t\t\t\tvar sortableEl = nfRadio.channel( 'fields-repeater' ).request( 'get:sortableEl' );\n\n\t\t\t\t// Set our currentHelper to an object var so that we can access it later.\n\t\t\t\tthis.currentHelper = ui.helper;\n\n\t\t\t} else if ( jQuery( ui.item ).hasClass( 'nf-stage' ) ) { // Staging\n\t\t\t\t// Get our sortable, and if it's initialized add our hover class.\n\t\t\t\tvar sortableEl = nfRadio.channel( 'fields-repeater' ).request( 'get:sortableEl' );\n\t\t\t\tif ( jQuery( sortableEl ).hasClass( 'ui-sortable' ) ) {\n\t\t\t\t\tjQuery( sortableEl ).addClass( 'nf-droppable-hover' );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * When the user moves a draggable outside of the sortable, we need to change the helper.\n\t\t * This returns the item to its pre-over state.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \tui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\toutRepeaterField: function( ui ) {\n\t\t\tif( jQuery( ui.item ).hasClass( 'nf-field-type-draggable' ) ) { // Field Type\n\t\t\t\t/*\n\t\t\t\t * Get our helper clone.\n\t\t\t\t * This will let us access the previous label and classes of our helper.\n\t\t\t\t */ \n\t\t\t\tvar helperClone = nfRadio.channel( 'drawer-addField' ).request( 'get:typeHelperClone' );\n\t\t\t\t// Set our helper label, remove our sortable class, and add the type class back to the type draggable.\n\t\t\t\tjQuery( this.currentHelper ).html( jQuery( helperClone ).html() );\n\t\t\t\tjQuery( this.currentHelper ).removeClass( 'nf-field-wrap' ).addClass( 'nf-field-type-button' ).css( { 'width': '', 'height': '' } );\n\t\t\t\t// Get our sortable and if it has been intialized, remove the droppable hover class.\n\t\t\t\tvar sortableEl = nfRadio.channel( 'fields-repeater' ).request( 'get:sortableEl' );\n\t\t\t\tif ( jQuery( sortableEl ).hasClass( 'ui-sortable' ) ) {\n\t\t\t\t\tjQuery( sortableEl ).removeClass( 'nf-droppable-hover' );\n\t\t\t\t}\n\t\t\t} else if ( jQuery( ui.item ).hasClass( 'nf-stage' ) ) { // Staging\n\t\t\t\t// If we've initialized our sortable, remove the droppable hover class.\n\t\t\t\tvar sortableEl = nfRadio.channel( 'fields-repeater' ).request( 'get:sortableEl' );\n\t\t\t\tif ( jQuery( sortableEl ).hasClass( 'ui-sortable' ) ) {\n\t\t\t\t\tjQuery( sortableEl ).removeClass( 'nf-droppable-hover' );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * When we stop dragging in the sortable:\n\t\t * remove our opacity setting\n\t\t * remove our ui helper\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \tui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\tstopRepeaterField: function( ui ) {\n\t\t\tjQuery( ui.item ).css( 'opacity', '' );\n\t\t\tjQuery( ui.helper ).remove();\n\t\t\t//nfRadio.channel( 'fields' ).trigger( 'sortable:stop', ui );\n\t\t},\n\n\t\t/**\n\t\t * When we start dragging in the sortable:\n\t\t * add an opacity setting of 0.5\n\t\t * show our item (jQuery hides the original item by default)\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \tui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\tstartRepeaterField: function( ui ) {\n\t\t\t// If we aren't dragging an item in from types or staging, update our change log.\n\t\t\tif( ! jQuery( ui.item ).hasClass( 'nf-field-type-draggable' ) && ! jQuery( ui.item ).hasClass( 'nf-stage' ) ) { \n\t\t\t\t\n\t\t\t\t// Maintain origional visibility during drag/sort.\n\t\t\t\tjQuery( ui.item ).show();\n\n\t\t\t\t// Determine helper based on builder/layout type.\n\t\t\t\tif(jQuery(ui.item).hasClass('nf-field-wrap')){\n\t\t\t\t\tvar newHelper = jQuery(ui.item).clone();\n\t\t\t\t} else if(jQuery(ui.item).parent().hasClass('layouts-cell')) {\n\t\t\t\t\tvar newHelper = $parentHelper.clone();\n\t\t\t\t} else {\n\t\t\t\t\tvar newHelper = jQuery(ui.item).clone();\n\t\t\t\t}\n\n\t\t\t\t// Remove unecessary item controls from helper.\n\t\t\t\tnewHelper.find('.nf-item-controls').remove();\n\n\t\t\t\t// Update helper with clone's content.\n\t\t\t\tjQuery( ui.helper ).html( newHelper.html() );\n\n\t\t\t\tjQuery( ui.helper ).css( 'opacity', '0.5' );\n\t\t\t\t\n\t\t\t\t// Add de-emphasize origional.\n\t\t\t\tjQuery( ui.item ).css( 'opacity', '0.25' );\n\t\t\t}\n\t\t\t//nfRadio.channel( 'fields' ).trigger( 'sortable:start', ui );\n\t\t},\n\n\t\t/**\n\t\t * Sort our fields when we change the order.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \tui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\tupdateRepeaterField: function( ui, sortable ) {\n\n\t\t\tnfRadio.channel( 'fields-repeater' ).request( 'sort:repeaterField' );\n\n\t\t\t// If we aren't dragging an item in from types or staging, update our change log.\n\t\t\tif( ! jQuery( ui.item ).hasClass( 'nf-field-type-draggable' ) && ! jQuery( ui.item ).hasClass( 'nf-stage' ) ) { \n\n\t\t\t\tvar fieldCollection = nfRadio.channel( 'fields-repeater' ).request( 'get:repeaterFieldsCollection' );\n\t\t\t\tvar dragFieldID = jQuery( ui.item ).prop( 'id' ).replace( 'field-', '' );\n\t\t\t\tvar dragModel = fieldCollection.get( dragFieldID );\n\n\t\t\t\t// Add our change event to the change tracker.\n\t\t\t\tvar data = { fields: [] };\n\t\t\t\t_.each( fieldCollection.models, function( field ) {\n\t\t\t\t\tvar oldPos = field._previousAttributes.order;\n\t\t\t\t\tvar newPos = field.get( 'order' );\n\t\t\t\t\t\n\t\t\t\t\tdata.fields.push( {\n\t\t\t\t\t\tmodel: field,\n\t\t\t\t\t\tattr: 'order',\n\t\t\t\t\t\tbefore: oldPos,\n\t\t\t\t\t\tafter: newPos\n\t\t\t\t\t} );\n\n\t\t\t\t} );\n\n\t\t\t\tvar label = {\n\t\t\t\t\tobject: 'Field',\n\t\t\t\t\tlabel: dragModel.get( 'label' ),\n\t\t\t\t\tchange: 'Re-ordered from ' + dragModel._previousAttributes.order + ' to ' + dragModel.get( 'order' ),\n\t\t\t\t\tdashicon: 'sort'\n\t\t\t\t};\n\n\t\t\t\t//nfRadio.channel( 'changes' ).request( 'register:change', 'sortFields', dragModel, null, label, data );\n\t\t\t}\n\n\t\t},\n\n\t});\n\n\t\n\t\n\treturn controller;\n} );\n","/**\n * Creates and stores a collection of action types. This includes all of the settings shown when editing a field.\n *\n * Loops over our preloaded data and adds that to our action type collection\n *\n * Also responds to requests for data about action types\n *\n * @package Ninja Forms builder\n * @subpackage Actions\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/actions/types',[ 'models/app/typeCollection' ], function( TypeCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\n\t\t\t/*\n\t\t\t * Instantiate \"installed\" actions collection.\n\t\t\t */\n\t\t\tthis.installedActions = new TypeCollection(\n\t\t\t\t_.filter( actionTypeData, function( type ) {\n\t\t\t\t\treturn type.section == 'installed';\n\t\t\t\t\t} \n\t\t\t\t),\n\t\t\t\t{\n\t\t\t\t\tslug: 'installed',\n\t\t\t\t\tnicename: nfi18n.installed\n\t\t\t\t} \n\t\t\t);\n\n\t\t\tthis.availableActions = new TypeCollection(\n\t\t\t\t_.filter( actionTypeData, function( type ) {\n\t\t\t\t\treturn type.section == 'available';\n\t\t\t\t\t} \n\t\t\t\t),\n\t\t\t\t{\n\t\t\t\t\tslug: 'available',\n\t\t\t\t\tnicename: nfi18n.available\n\t\t\t\t}\n\t\t\t);\n\n\t\t\t// Respond to requests to get field type, collection, settings, and sections\n\t\t\tnfRadio.channel( 'actions' ).reply( 'get:type', this.getType, this );\n\t\t\tnfRadio.channel( 'actions' ).reply( 'get:installedActions', this.getInstalledActions, this );\n\t\t\tnfRadio.channel( 'actions' ).reply( 'get:availableActions', this.getAvailableActions, this );\n\t\t},\n\n\t\t/**\n\t\t * Return a field type by id\n\t\t *\n\t\t * @since  3.0\n\t\t * @param  string \t\t\tid \tfield type\n\t\t * @return backbone.model    \tfield type model\n\t\t */\n\t\tgetType: function( id ) {\n\t\t\t// Search our installed actions first\n\t\t\tvar type = this.installedActions.get( id );\n\t\t\tif ( ! type ) {\n\t\t\t\ttype = this.availableActions.get( id );\n\t\t\t}\n        \treturn type;\n        },\n\n        /**\n         * Return the installed action type collection\n         *\n         * @since  3.0\n         * @return backbone.collection    \tfield type collection\n         */\n\t\tgetInstalledActions: function() {\n        \treturn this.installedActions;\n        },\n\n        /**\n         * Return the available action type collection\n         *\n         * @since  3.0\n         * @return backbone.collection    \tfield type collection\n         */\n\t\tgetAvailableActions: function() {\n        \treturn this.availableActions;\n        },\n\n        /**\n         * Add a field type to our staging area when the field type button is clicked.\n         *\n         * @since 3.0\n         * @param Object e event\n         * @return void\n         */\n        addStagedField: function( e ) {\n        \tvar type = jQuery( e.target ).data( 'id' );\n        \tnfRadio.channel( 'fields' ).request( 'add:stagedField', type );\n        },\n\n        /**\n         * Return our field type settings sections\n         *\n         * @since  3.0\n         * @return backbone.collection field type settings sections\n         */\n        getTypeSections: function() {\n            return this.fieldTypeSections;\n        }\n\t});\n\n\treturn controller;\n} );\n\n","/**\n * Model that represents our form action.\n * \n * @package Ninja Forms builder\n * @subpackage Actions\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/actions/actionModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\t\tdefaults: {\n\t\t\tobjectType: 'Action',\n\t\t\tobjectDomain: 'actions',\n\t\t\teditActive: false\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\t// Listen for model attribute changes\n\t\t\tthis.on( 'change', this.changeSetting, this );\n\n\t\t\t// Get our parent field type.\n\t\t\tvar actionType = nfRadio.channel( 'actions' ).request( 'get:type', this.get( 'type' ) );\n\n\t\t\tif( 'undefined' == typeof actionType ) return;\n\n\t\t\t// Loop through our action type \"settingDefaults\" and add any default settings.\n\t\t\tvar that = this;\n\t\t\t_.each( actionType.get( 'settingDefaults' ), function( val, key ) {\n\t\t\t\tif ( ! that.get( key ) ) {\n\t\t\t\t\tthat.set( key, val, { silent: true } );\n\t\t\t\t}\n\t\t\t} );\n\t\t\t\n\t\t\t/*\n\t\t\t * Trigger an init event on three channels:\n\t\t\t * \n\t\t\t * actions\n\t\t\t * action-type\n\t\t\t *\n\t\t\t * This lets specific field types modify model attributes before anything uses them.\n\t\t\t */ \n\t\t\tnfRadio.channel( 'actions' ).trigger( 'init:actionModel', this );\n\t\t\tnfRadio.channel( 'actions-' + this.get( 'type' ) ).trigger( 'init:actionModel', this );\n\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'fire:updateFieldKey', this.updateFieldKey );\n\t\t},\n\n\t\t/**\n\t\t * When we change the model attributes, fire an event saying we've changed something.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tchangeSetting: function( model, options ) {\n            nfRadio.channel( 'actionSetting-' + _.keys( this.changedAttributes() )[0] ).trigger( 'update:setting', this, options.settingModel ) ;\n\t\t\tnfRadio.channel( 'actions').trigger( 'update:setting', this, options.settingModel );\n            nfRadio.channel( 'app' ).trigger( 'update:setting', this, options.settingModel );\n\t\t},\n\n\t\tupdateFieldKey: function( keyModel, settingModel ) {\n\t\t\tnfRadio.channel( 'app' ).trigger( 'replace:fieldKey', this, keyModel, settingModel );\n\t\t}\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Collection that holds our action models. \n * This is the actual action data created by the user.\n *\n * We listen to the add and remove events so that we can push the new id to either the new action or removed action property.\n * \n * @package Ninja Forms builder\n * @subpackage Actions\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/actions/actionCollection',['models/actions/actionModel'], function( actionModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: actionModel,\n\t\tcomparator: 'order',\n\t\ttmpNum: 1,\n\n\t\tinitialize: function() {\n\t\t\tthis.on( 'add', this.addAction, this );\n\t\t\tthis.on( 'remove', this.removeAction, this );\n\t\t\tthis.newIDs = [];\n\t\t},\n\n\t\t/**\n\t\t * When we add a field, push the id onto our new action property.\n\t\t * This lets us tell the server that this is a new field to be added rather than a field to be updated.\n\t\t * \n\t\t * @since 3.0\n\t\t * @param void\n\t\t */\n\t\taddAction: function( model ) {\n\t\t\tthis.newIDs.push( model.get( 'id' ) );\n\t\t},\n\n\t\t/**\n\t\t * When we remove a field, push the id onto our removed action property.\n\t\t * \n\t\t * @since 3.0\n\t\t * @param void\n\t\t */\n\t\tremoveAction: function( model ) {\n\t\t\tthis.removedIDs[ model.get( 'id' ) ] = model.get( 'id' );\n\t\t}\n\t} );\n\treturn collection;\n} );\n","/**\n * Handles interactions with our actions collection.\n * \n * @package Ninja Forms builder\n * @subpackage Actions\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/actions/data',['models/actions/actionCollection', 'models/actions/actionModel'], function( actionCollection, actionModel ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Load our action collection from our localized form data\n\t\t\tthis.collection = new actionCollection( preloadedFormData.actions );\n\t\t\tthis.collection.tmpNum = 1;\n\n\t\t\tif ( 0 != this.collection.models.length ) {\n\t\t\t\tvar that = this;\n\t\t\t\t_.each( this.collection.models, function( action ) {\n\t\t\t\t\tif ( ! jQuery.isNumeric( action.get( 'id' ) ) ) {\n\t\t\t\t\t\tthat.collection.tmpNum++;\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\t\t\t// Set our removedIDs to an empty object. This will be populated when a action is removed so that we can add it to our 'deleted_actions' object.\n\t\t\tthis.collection.removedIDs = {};\n\n\t\t\t// Respond to requests for data about actions and to update/change/delete actions from our collection.\n\t\t\tnfRadio.channel( 'actions' ).reply( 'get:collection', this.getCollection, this );\n\t\t\tnfRadio.channel( 'actions' ).reply( 'get:action', this.getAction, this );\n\t\t\tnfRadio.channel( 'actions' ).reply( 'get:tmpID', this.getTmpID, this );\n\n\t\t\tnfRadio.channel( 'actions' ).reply( 'add', this.addAction, this );\n\t\t\tnfRadio.channel( 'actions' ).reply( 'delete', this.deleteAction, this );\n\t\t},\n\n\t\tgetCollection: function() {\n\t\t\treturn this.collection;\n\t\t},\n\n\t\tgetAction: function( id ) {\n\t\t\treturn this.collection.get( id );\n\t\t},\n\n\t\t/**\n\t\t * Add a action to our collection. If silent is passed as true, no events will trigger.\n\t\t * \n\t\t * @since 3.0\n\t\t * @param Object \tdata \taction data to insert\n\t\t * @param bool \t\tsilent \tprevent events from firing as a result of adding\t \t\n\t\t */\n\t\taddAction: function( data, silent ) {\n\t\t\tsilent = silent || false;\n\n\t\t\tif ( false === data instanceof Backbone.Model ) {\n\t\t\t\tvar model = new actionModel( data );\n\t\t\t} else {\n\t\t\t\tvar model = data;\n\t\t\t}\n\n\t\t\tthis.collection.add( model, { silent: silent } );\n\t\t\t// Set our 'clean' status to false so that we get a notice to publish changes\n\t\t\tnfRadio.channel( 'app' ).request( 'update:setting', 'clean', false );\n\n\t\t\treturn model;\n\t\t},\n\n\t\t/**\n\t\t * Delete a action from our collection.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  backbone.model \tmodel \taction model to be deleted\n\t\t * @return void\n\t\t */\n\t\tdeleteAction: function( model ) {\n\t\t\tthis.collection.remove( model );\n\t\t\t// Set our 'clean' status to false so that we get a notice to publish changes\n\t\t\tnfRadio.channel( 'app' ).request( 'update:setting', 'clean', false );\n\t\t\tnfRadio.channel( 'app' ).request( 'update:db' );\n\n\t\t},\n\n\n\t\t/**\n\t\t * Return a new tmp id for our actions.\n\t\t * Gets the action collection length, adds 1, then returns that prepended with 'tmp-'.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return string\n\t\t */\n\t\tgetTmpID: function() {\n\t\t\tvar tmpNum = this.collection.tmpNum;\n\t\t\tthis.collection.tmpNum++;\n\t\t\treturn 'tmp-' + tmpNum;\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Fetches settings models so that we can get setting information\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/actions/actionSettings',['models/app/settingCollection'], function( settingCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.collection = new settingCollection( actionSettings, { objectType: 'actions' } );\n\n\t\t\t// Responds to requests for settings models.\n\t\t\tnfRadio.channel( 'actions' ).reply( 'get:settingModel', this.getSettingModel, this );\n\t\t},\n\n\t\tgetSettingModel: function( name ) {\n\t\t\treturn this.collection.findWhere( { name: name } );\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles adding and removing the active class from a action currently being edited.\n * \n * @package Ninja Forms builder\n * @subpackage Actions - Edit Action Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/actions/editActive',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Respond to requests to remove the active class from all our actions.\n\t\t\tnfRadio.channel( 'actions' ).reply( 'clear:editActive', this.clearEditActive, this );\n\t\t\t// Listen for the closing drawer so that we can remove all of our active classes.\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-editSettings' ), 'before:closeDrawer', this.clearEditActive );\n\t\t},\n\n\t\t/**\n\t\t * Loops through our actions collection and sets editActive to false.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n        clearEditActive: function() {\n            var actionCollection = nfRadio.channel( 'actions' ).request( 'get:collection' );\n            _.each( actionCollection.models, function( action ) {\n\t\t\t\taction.set( 'editActive', false );\n            } );\n        }\n\t});\n\n\treturn controller;\n} );\n\n","/**\n * @package Ninja Forms builder\n * @subpackage Actions - Action Settings Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/actions/emailFromSetting',[], function( ) {\n    var controller = Marionette.Object.extend( {\n        initialize: function() {\n            this.listenTo( nfRadio.channel( 'actionSetting-from_address' ), 'update:setting', this.updateFromAddress );\n        },\n\n        updateFromAddress: function( dataModel, settingModel ) {\n            if( 'undefined' == typeof settingModel ) return;\n\n            var value = String( dataModel.get( 'from_address' ) ).trim();\n\n            if( '{wp:admin_email}' == value ) {\n                return settingModel.set( 'warning', false );\n            }\n\n            if( value && ( ! this.isValidEmail( value ) ) || nfAdmin.home_url_host != value.replace(/.*@/, \"\") ){\n                return settingModel.set( 'warning', nfi18n.errorInvalidEmailFromAddress );\n            }\n\n            return settingModel.set( 'warning', false );\n        },\n\n        isValidEma