dynamically created based on the list of form fields.\n *\n * Note: Field references in the dynamic setting names are based on field keys, which may change.\n * Unlike regular field key tracking, a new setting needs to be created with the same value as the previous.\n *\n * @package Ninja Forms builder\n * @subpackage Action Settings\n * @copyright (c) 2016 WP Ninjas\n * @author Kyle B. Johnson\n * @since 3.0\n */\ndefine( 'controllers/app/settingFieldList',['views/app/drawer/typeSettingFieldset','models/app/settingCollection'], function( fieldsetView, settingCollection ) {\n    return Marionette.Object.extend( {\n\n        /**\n         * A reference list of Field List setting models.\n         */\n        fieldListSettings: [],\n\n        initialize: function() {\n            this.listenTo( nfRadio.channel( 'field-list' ),       'init:settingModel',    this.registerFieldListSettings  );\n            this.listenTo( nfRadio.channel( 'fields' ),           'update:setting',       this.updateFieldListSettingKeys );\n                           nfRadio.channel( 'field-list' ).reply( 'get:settingChildView', this.getSettingChildView, this  );\n        },\n\n        /**\n         * Build a reference list of Field List setting models for later reference.\n         *\n         * @param settingModel\n         */\n        registerFieldListSettings: function( settingModel ){\n            this.fieldListSettings.push( settingModel.get( 'name' ) );\n        },\n\n        /**\n         * Field List settings contain field keys in the setting names.\n         * When a field key changes, so too must the Field List setting name.\n         *\n         * @param fieldModel\n         */\n        updateFieldListSettingKeys: function( fieldModel ){\n\n            // We are only interested in field key changes.\n            if( 'undefined' == typeof fieldModel.changed.key ) return;\n\n            var oldKey = fieldModel._previousAttributes.key;\n            var newKey = fieldModel.changed.key;\n\n            /*\n             * This is an absolute (functional) mess of nesting. I apologize to my future self, or Kenny.\n             *\n             * Each setting of each action model must be checked against each registered Field List setting.\n             */\n            var that = this;\n            _.each( Backbone.Radio.channel( 'actions' ).request( 'get:collection' ).models, function( actionModel ) {\n                _.each( actionModel.attributes, function( value, setting ) {\n                    var lastChanged = ''; // Used to avoid resetting the change with a duplicate call.\n                    _.each( that.fieldListSettings, function( prefix ) {\n                        if( setting != prefix + '-' + oldKey || lastChanged == oldKey ) return;\n                        var oldValue = actionModel.get( prefix + '-' + oldKey );\n                        actionModel.set( prefix + '-' + newKey, oldValue );\n                        actionModel.set( prefix + '-' + oldKey, 0 );\n                        lastChanged = oldKey;\n                    });\n                });\n            });\n        },\n\n        /**\n         * Set the view for Field List sub-settings, just like the Fieldset setting.\n         *\n         * @param settingModel\n         * @returns {*}\n         */\n        getSettingChildView: function( settingModel ) {\n\n            /**\n             * Dynamically build field-list settings as needed for the view.\n             */\n\n            // Filter fields based on the field_types setting property.\n            var fields = _.filter( nfRadio.channel( 'fields' ).request( 'get:collection' ).models, function( field ) {\n                return _.contains( settingModel.get( 'field_types' ), field.get( 'type' ) );\n            });\n\n            // Map fields into setting definitions.\n            var settings = _.map( fields, function( field ) {\n                return {\n                    name: settingModel.get( 'name' ) + '-' + field.get( 'key' ),\n                    type: 'toggle',\n                    label: field.get( 'label' ),\n                    width: 'full'\n                };\n            });\n\n            settingModel.set( 'settings', new settingCollection( settings ) );\n\n            // return the child view.\n            return fieldsetView;\n        },\n\n    });\n} );\n\n","/**\n * Li