       var fieldCollection = nfRadio.channel( 'fields' ).request( 'get:collection' );\n            // Stores the keys of unwanted fields.\n            var fieldsToRemove = [];\n            // Declare blacklisted field types.\n            var blacklist = ['product', 'quantity', 'total', 'shipping', 'date'];\n            // Remove them from the merge tag selection box.\n            _.each( fieldCollection.models, function( model ) {\n                if ( -1 != blacklist.indexOf( model.get('type') ) ) {\n                    fieldsToRemove.push( '{field:' + model.get( 'key' ) + '}' );\n                }\n            });\n            return fieldsToRemove;\n        }\n    });\n\n    return view;\n} );\n","/**\n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/drawer/mergeTagGroup',[], function() {\n    var view = Marionette.ItemView.extend({\n        tagName: 'li',\n        template: '#tmpl-nf-merge-tag-box-section',\n        events: {\n            \"click\": \"onClick\"\n        },\n\n        initialize: function () {\n            this.listenTo( nfRadio.channel( 'merge-tags' ), 'after:filtersearch', this.updateActive );\n        },\n\n        onClick: function(){\n          this.updateTags();\n        },\n\n        updateTags: function() {\n            nfRadio.channel( 'merge-tags' ).request( 'update:taglist', this.model.get( 'id' ) );\n        },\n\n        updateActive: function( section ) {\n            this.$el.removeClass( 'active' );\n\n            if ( section == this.model.get( 'id' ) ) {\n                this.$el.addClass( 'active' );\n            }\n        },\n\n        setActive: function(){\n            this.$el.addClass( 'active' );\n            this.$el.siblings().removeClass( 'active' );\n        },\n\n    });\n\n    return view;\n} );\n","/**\n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/drawer/mergeTagGroupList',[ 'views/app/drawer/mergeTagGroup' ], function( mergeTagGroupView ) {\n    var view = Marionette.CollectionView.extend({\n        tagName: 'ul',\n        childView: mergeTagGroupView,\n\n        initialize: function(){\n            this.listenTo( nfRadio.channel( 'merge-tags' ), 'open', this.render, this );\n        },\n\n        // TODO: Update filter when a new tag is added. ie Calculations.\n        filter: function( child, index, collection ){\n            return 0 < child.get( 'tags' ).length;\n        },\n    });\n\n    return view;\n} );\n","/**\n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/drawer/mergeTagFilter',[], function() {\n    var view = Marionette.ItemView.extend({\n        template: '#tmpl-nf-merge-tag-box-filter',\n        events: {\n            \"keyup input\": \"updateFilter\",\n        },\n        updateFilter: function( event ) {\n\n            if( /* ENTER */ 13 == event.keyCode ){ // Copied from Keyup Callback.\n                // Get top listed merge tag.\n                var firstFilteredTag = jQuery( '#merge-tags-box .merge-tag-list ul li span' ).first().data( 'tag' );\n\n                nfRadio.channel( 'mergeTags' ).request( 'insert:tag', firstFilteredTag );\n\n                // COPIED FROM BELOW\n                jQuery( '#merge-tags-box' ).css( 'display', 'none' );\n                jQuery( '#merge-tags-box' ).removeClass();\n                jQuery( '.merge-tag-focus' ).removeClass( 'merge-tag-focus' );\n                jQuery( '.merge-tag-focus-overlay' ).removeClass( 'merge-tag-focus-overlay' );\n                return;\n            }\n            var value = this.$el.find( 'input' ).val();\n            nfRadio.channel( 'merge-tags' ).request( 'filtersearch', value );\n        }\n    });\n\n    return view;\n} );\n","/**\n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/drawer/mergeTagBox',[], function() {\n    var view = Marionette.LayoutView.extend({\n        el: '#merge-tags-box',\n        template: \"#tmpl-nf-merge-tag-box\",\n\n        regions: {\n            filter:   '.merge-tag-filter',\n            sections: '.merge-tag-sections',\n            tags:     '.merge-tag-list'\n        },\n    });\n\n    return view;\n} );\n","/**\n * @package Ninja Forms builder\n * @subpackage Merge Tag Box\n * @copyright (c) 2017 WP Ninjas\n * @since 3.1\n */\n\ndefine( 'controllers/app/mergeTagBox',[\n    'models/app/mergeTagModel',\n    'models/app/mergeTagLookupCollection',\n    'views/app/drawer/mergeTag',\n    'views/app/drawer/mergeTagList',\n    'views/app/drawer/mergeTagGroup',\n    'views/app/drawer/mergeTagGroupList',\n    'views/app/drawer/mergeTagFilter',\n    'views/app/drawer/mergeTagBox'\n], function(\n    MergeTagModel,\n    MergeTagLookupCollection,\n    MergeTagView,\n    MergeTagListView,\n    MergeTagGroupView,\n    MergeTagGroupListView,\n    MergeTagFilterView,\n    MergeTagBoxLayout\n) {\n    var controller = Marionette.Object.extend( {\n\n        caret: 0, // Track the caret position of the current setting's input.\n        old: '', // THe old merge tag that will be replaced.\n\n        initialize: function(){\n\n            this.listenTo( nfRadio.channel( 'drawer' ), 'render:settingGroup', function(){\n                jQuery( '.merge-tags' ).off( 'click' );\n                jQuery( '.merge-tags' ).on( 'click', this.mergeTagsButtonClick );\n            });\n\n            this.listenTo( nfRadio.channel( 'app' ), 'after:appStart', this.afterAppStart );\n            this.listenTo( nfRadio.channel( 'app' ), 'before:renderSetting', this.beforeRenderSetting );\n            this.listenTo( nfRadio.channel( 'drawer' ), 'before:close', this.beforeDrawerClose );\n\n            var that = this;\n            nfRadio.channel( 'mergeTags' ).reply( 'set:caret', function( position ){\n               that.caret = position;\n            });\n            nfRadio.channel( 'mergeTags' ).reply( 'get:caret', function(){\n                return that.caret;\n            });\n\n            var that = this;\n            nfRadio.channel( 'mergeTags' ).reply( 'set:old', function( value ){\n                that.old = value;\n            });\n            nfRadio.channel( 'mergeTags' ).reply( 'get:old', function(){\n                return that.old;\n            });\n\n            nfRadio.channel( 'mergeTags' ).reply( 'insert:tag', this.insertTag.bind( this ) );\n\n            /** OPTION REPEATER */\n            this.listenTo( nfRadio.channel( 'option-repeater' ), 'add:option', function( model ){\n                var selector = '#' + model.cid + ' .has-merge-tags input.setting';\n                jQuery( selector ).on( 'focus', function( event ){\n                   that.focusCallback( event, selector, 'option-repeater' );\n                });\n                jQuery( selector ).on( 'keyup', function( event ){\n                    that.keyupCallback( event, selector, 'option-repeater' );\n                });\n                jQuery( selector ).siblings( '.nf-list-options .merge-tags' ).off( 'click' );\n                jQuery( selector ).siblings( '.nf-list-options .merge-tags' ).on( 'click', this.mergeTagsButtonClick );\n            } );\n            this.listenTo( nfRadio.channel( 'drawer' ), 'opened', function(){\n                jQuery( '.nf-list-options .merge-tags' ).off( 'click' );\n                jQuery( '.nf-list-options .merge-tags' ).on( 'click', this.mergeTagsButtonClick );\n            } );\n\n            /* CALCULATIONS */\n            this.listenTo( nfRadio.channel( 'setting-calculations-option' ), 'render:setting', this.renderSetting );\n            // this.listenTo( nfRadio.channel( 'setting-calculations-option' ), 'render:setting', function( settingModel, dataModel, view ){\n            //     view.$el.find( '.merge-tags' ).on( 'click', this.mergeTagsButtonClick );\n            // } );\n            this.listenTo( nfRadio.channel( 'drawer' ), 'opened', function(){\n                jQuery( '.nf-list-options.calculations .merge-tags' ).off( 'click' );\n                jQuery( '.nf-list-options.calculations .merge-tags' ).on( 'click', this.mergeTagsButtonClick );\n            } );\n\n            /* SUMMERNOTE */\n            this.listenTo( nfRadio.channel( 'summernote' ), 'focus', function( e, selector ) {\n                that.focusCallback( false, selector, 'rte' );\n            } );\n            this.listenTo( nfRadio.channel( 'summernote' ), 'keydown', function( e, selector ){\n                jQuery( selector ).closest( '.nf-setting' ).find( '.setting' ).summernote( 'saveRange' );\n            } );\n            this.listenTo( nfRadio.channel( 'summernote' ), 'keyup', function( e, selector ){\n                that.keyupCallback( e, selector, 'rte' );\n            } );\n\n            // When an RTE setting is shown, make sure merge tags are hooked up.\n            this.listenTo( nfRadio.channel( 'setting-type-rte' ), 'render:setting', function(){\n                jQuery( '.note-editor .merge-tags' ).off( 'click' );\n                jQuery( '.note-editor .merge-tags' ).on( 'click', this.mergeTagsButtonClick );\n            } );\n\n            this.listenTo( nfRadio.channel( 'drawer' ), 'opened', function(){\n                jQuery( '.note-editor .merge-tags' ).off( 'click' );\n                jQuery( '.note-editor .merge-tags' ).on( 'click', this.mergeTagsButtonClick );\n            } );\n\n            jQuery( document ).on( 'keyup', function( event ){\n                if( 27 == event.keyCode ){\n                    nfRadio.channel( 'mergeTags' ).request( 'insert:tag', '' );\n                    // Copied from KeyupCallback.\n                    jQuery( '#merge-tags-box' ).css( 'display', 'none' );\n                    nfRadio.channel( 'drawer' ).request( 'enable:close' );\n                    jQuery( '#merge-tags-box' ).removeClass();\n                    jQuery( '.merge-tag-focus' ).blur();\n                    jQuery( '.merge-tag-focus' ).removeClass( 'merge-tag-focus' );\n                    jQuery( '.merge-tag-focus-overlay' ).removeClass( 'merge-tag-focus-overlay' );\n                }\n            });\n\n            /**\n             * Listen to the Field Changes (add, delete, update) and update the Merge Tags.\n             */\n            this.listenTo( Backbone.Radio.channel( 'fields' ), 'add:field',    this.afterAppStart );\n            this.listenTo( Backbone.Radio.channel( 'fields' ), 'delete:field', this.afterAppStart );\n            this.listenTo( Backbone.Radio.channel( 'fieldSetting-key' ), 'update:setting', this.afterAppStart );\n\n            /** ... and Calc updates. */\n            this.listenTo( Backbone.Radio.channel( 'calcs' ), 'update:calc', this.afterAppStart );\n\n            this.listenTo( Backbone.Radio.channel( 'app' ), 'change:currentDomain', this.afterAppStart );\n        },\n\n        afterAppStart: function() {\n\n            var currentDomain = Backbone.Radio.channel( 'app' ).request( 'get:currentDomain' );\n\n            var mergeTagCollection = nfRadio.channel( 'mergeTags' ).request( 'get:collection' );\n            var mergeTags = [];\n            mergeTagCollection.each( function( section ){\n\n                section.get( 'tags' ).each( function( tag ){\n\n                    if( 'fields' == currentDomain.get( 'id' ) && '{submission:sequence}' == tag.get( 'tag' ) ) return;\n\n                    mergeTags.push({\n                        label: tag.get( 'label' ),\n                        tag:   tag.get( 'tag' ),\n                        section: section.get( 'id' )\n                    });\n                });\n            });\n            var layout = new MergeTagBoxLayout();\n            layout.render();\n            var tagCollection = new MergeTagLookupCollection( mergeTags );\n            var mergeTagListView = new MergeTagListView({\n                collection: tagCollection\n            });\n            var mergeTagGroupListView = new MergeTagGroupListView({\n                collection: mergeTagCollection\n            });\n\n            layout.getRegion('tags').show(mergeTagListView);\n            layout.getRegion('sections').show(mergeTagGroupListView);\n            layout.getRegion('filter').show(new MergeTagFilterView);\n        },\n\n        beforeRenderSetting: function( settingModel, dataModel ){\n            if( 'undefined' == typeof settingModel.get( 'use_merge_tags' ) ) return;\n            if( ! settingModel.get( 'use_merge_tags' ) ) return;\n            var name = settingModel.get( 'name' );\n            this.listenTo( nfRadio.channel( 'setting-' + name ), 'render:setting', this.renderSetting );\n        },\n\n        renderSetting: function( settingModel, dataModel, view ){\n\n            view.$el.find( '.merge-tags' ).off( 'click' );\n            view.$el.find( '.merge-tags' ).on( 'click', this.mergeTagsButtonClick );\n\n            if( 0 == jQuery( '#merge-tags-box' ).length ) this.afterAppStart();\n\n            // Track Scrolling.\n            jQuery( '#nf-drawer' ).on( 'scroll', function(){\n               // COPIED AND MODIFIED FROM FOCUS\n                if( 0 == jQuery( '.merge-tag-focus' ).length ) return;\n\n                var rteEditor = jQuery( '.merge-tag-focus' ).closest( '.nf-setting' ).find( '.note-editor' );\n                if( 0 != rteEditor.length ){\n                    var posY = rteEditor.offset().top - jQuery(window).scrollTop();\n                    var height = rteEditor.outerHeight();\n                } else {\n                    var posY = jQuery('.merge-tag-focus').offset().top - jQuery(window).scrollTop();\n                    var height = jQuery('.merge-tag-focus').outerHeight();\n                }\n\n\t            // Find out if merge tag box will go below bottom of the page.\n\t            var tagBoxY = posY + height;\n\t            var windowHeight = window.innerHeight;\n\t            var tagBoxHeight = jQuery( '#merge-tags-box' ).outerHeight();\n\n\t            // If merge tag box will render below the bottom of the page,\n\t            // change it to render above the field\n\n\t            if ( ( tagBoxY + tagBoxHeight ) > windowHeight ) {\n                    tagBoxY = posY - tagBoxHeight;\n                }\n\n                if ( 0 > tagBoxY ) {\n                    tagBoxY = posY;\n                }\n\n                jQuery( '#merge-tags-box' ).css( 'top', tagBoxY );\n\n                var boxHeight = jQuery( '#merge-tags-box' ).outerHeight();\n                jQuery( '#nf-drawer' ).css( 'padding-bottom', boxHeight + 'px' );\n\n                var repeaterRow = jQuery( '.merge-tag-focus' ).closest( '.nf-list-options-tbody' );\n                if( 0 != repeaterRow.length ){\n                    var left = repeaterRow.offset().left - jQuery(window).scrollLeft();\n                    jQuery( '#merge-tags-box' ).css( 'left', left );\n                } else {\n                    var posX = jQuery( '.merge-tag-focus' ).closest( '.nf-settings' ).offset().left - jQuery(window).scrollLeft();\n                    jQuery( '#merge-tags-box' ).css( 'left', posX );\n                    jQuery( '#merge-tags-box' ).css( 'width', jQuery( '.merge-tag-focus' ).closest( '.nf-settings' ).width() );\n                }\n            });\n\n            // On input focus, move the Merge Tag Box into position.\n            jQuery( view.el ).find( '.setting' ).on( 'focus', this.focusCallback );\n\n            // TODO: Maybe move to view events.\n            // On input keyup, maybe show Merge Tag Box.\n            jQuery( view.el ).find( '.setting' ).on( 'keyup', this.keyupCallback );\n        },\n\n        // TODO: Maybe move to view class.\n        beforeDrawerClose: function(){\n            jQuery( '#merge-tags-box' ).css( 'display', 'none' );\n            nfRadio.channel( 'drawer' ).request( 'enable:close' );\n            // jQuery( 'body' ).append( jQuery( '#merge-tags-box' ) );\n        },\n\n        insertTag: function( tag ) {\n\n            var $input = jQuery( '.merge-tag-focus' );\n\n            if( 0 != $input.closest( '.nf-setting' ).first().find( '.note-editable' ).length ){\n                $input = $input.closest( '.nf-setting' ).first().find( '.note-editable' );\n            }\n\n            if( 1 < $input.length ){ $input = $input.first(); }\n\n            if( $input.hasClass( 'note-editable' ) ){\n                var str = $input.closest( '.nf-setting' ).find( '.setting' ).summernote( 'code' );\n            } else {\n                var str = $input.val();\n            }\n\n            var find = nfRadio.channel( 'mergeTags' ).request( 'get:old' );\n            var replace = tag;\n            var caretPos = nfRadio.channel( 'mergeTags' ).request( 'get:caret' );\n\n            var patt = /{([a-zA-Z0-9]|:|_||-})*/g;\n\n            // Loop through matches to find insert/replace index range.\n            // Reference: http://codepen.io/kjohnson/pen/36c3a782644dfff40fe3c1f05f8739d9?editors=0012\n            while (match = patt.exec(str)) {\n                if (find != match[0]) continue; // This isn't the match you are looking for...\n                var string = str.slice(0, match.index) + replace + str.slice(patt.lastIndex); // Fancy replace for the specifc match, using the index/position.\n\n                if( $input.hasClass( 'note-editable' ) ){\n                    $input.closest( '.nf-setting' ).find( '.setting' ).summernote( 'code', string );\n\n                    // Reposition the caret. http://stackoverflow.com/a/6249440 TODO: Determine the appropriate childNode.\n                    var el = $input;\n                    var childNode = null; // Default to first childNode.\n                    _.each( el[0].childNodes, function( node, index ){\n                        if( childNode ) return;\n                        if( ! node.nodeValue && ! node.innerHTML ) return;\n                        if( node.nodeValue ) {\n                            var value = node.nodeValue;\n                        } else if( node.innerHTML ){\n                            var value = node.innerHTML;\n                        }\n\n                        if( -1 == value.indexOf(replace) ) return; // Replace not found in this node.\n\n                        value = value.replace( /&nbsp;/g, ' ' );\n                        var position = value.indexOf(replace) + find.length;\n\n                        /*\n                         * If no caretPos, determine based on the node. ie Merge Tag Button context.\n                         * Note: We can't just check for '{', because they could just be inserting the first tag.\n                         */\n                        if( -1 == caretPos ){\n                            caretPos = value.indexOf( replace ) + 1;\n                        }\n\n                        if (caretPos == position) childNode = el[0].childNodes[index];\n                    });\n                    if( ! childNode ) childNode = el[0].childNodes[0];\n                    var offset = caretPos - find.length + replace.length;\n                    var range = document.createRange();\n                    var sel = window.getSelection();\n                    if( 0 != childNode.childNodes.length ) {\n                        try{\n                           range.setStart(childNode.childNodes[0], offset); \n                        } catch( err ) {\n                            console.log( childNode );\n                            console.log( 'error' );\n                        }\n                        \n                    } else {\n                        try {\n                            range.setStart(childNode, offset);\n                        } catch( err ) {\n                            console.log( 'error' );\n                        }\n                        \n                    }\n                    range.collapse(true);\n                    sel.removeAllRanges();\n                    sel.addRange(range);\n\n\n                } else {\n                    $input.val(string); // Update input value with parsed string.\n                    $input.change(); // Trigger a change event after inserting the merge tag so that it saves to the model.\n                    $input.caret(caretPos - find.length + replace.length); // Update Carept Position.\n                }\n\n            }\n\n            jQuery( '#merge-tags-box' ).css( 'display', 'none' );\n            nfRadio.channel( 'drawer' ).request( 'enable:close' );\n            $input.removeClass( 'merge-tag-focus' );\n            $input.closest( '.merge-tag-focus-overlay' ).removeClass( 'merge-tag-focus-overlay' );\n        },\n\n        mergeTagsButtonClick: function( e ){\n            var $this = jQuery( this );\n\n            if ($this.hasClass('open-media-manager')) {\n                return;\n            }\n\n            if( $this.siblings().hasClass( 'merge-tag-focus' ) ){\n                nfRadio.channel( 'mergeTags' ).request( 'insert:tag', '' );\n                jQuery( '#merge-tags-box' ).css( 'display', 'none' );\n                nfRadio.channel( 'drawer' ).request( 'enable:close' );\n                jQuery( '.merge-tag-focus' ).removeClass( 'merge-tag-focus' );\n                jQuery( '.merge-tag-focus-overlay' ).removeClass( 'merge-tag-focus-overlay' );\n                return;\n            }\n\n            if( 0 !== $this.closest( '.nf-setting, .nf-table-row' ).find( '.note-tools' ).length ){\n                var $inputSetting = $this.closest( '.note-editor' ).siblings( '.setting' ).first();\n                $this.closest( '.nf-setting' ).find( '.setting' ).summernote( 'insertText', '{' );\n                // Since we haven't determined the caretPos, set to -1 as a flag to determine later.\n                nfRadio.channel('mergeTags').request( 'set:caret', -1 );\n            } else {\n                var $inputSetting = $this.siblings( '.setting' ).first();\n                var text = $inputSetting.val() || '';\n                $inputSetting.val( text + '{' ).change();\n                nfRadio.channel('mergeTags').request('set:caret', text.length + 1 );\n            }\n\n            if( $this.parent().hasClass( 'note-tools' ) ){\n                // $this.closest( '.nf-setting' ).find( '.setting' ).summernote( 'insertText', '{' );\n            }\n\n            nfRadio.channel('mergeTags').request('set:old', '{' );\n\n            $inputSetting.addClass( 'merge-tag-focus' );\n\n            // Disable browser autocomplete.\n            var autocomplete = $this.attr( 'autocomplete' );\n            $this.attr( 'autocomplete', 'off' );\n            $this.data( 'autocomplete', autocomplete );\n\n            var $overlayElement = $this.closest( '.nf-setting, .nf-table-row' );\n            if( 0 != $overlayElement.find( '.note-editor' ).length ){\n                $overlayElement.find('.note-editor' ).addClass('merge-tag-focus-overlay');\n            } else {\n                $overlayElement.addClass('merge-tag-focus-overlay');\n            }\n\n            /**\n             * TODO: This is a wonky work around for removing Product and Quantity fields from calculation merge tags.\n             * The merge tag system doesn't currently respect \"exclude\" merge tag settings.\n             *\n             * If 'eq' is the textarea next to the merge tag icon, then we're in a calculation setting.\n             */\n            if ( 'eq' == jQuery( e.target ).prev( 'textarea' ).data( 'id' ) ) {\n                var calc = true;\n            } else {\n                var calc = false;\n            }\n\n            // Request that our merge tag box update its tag list, passing whether or not we're in a calculation setting.\n            nfRadio.channel( 'merge-tags' ).request( 'update:taglist', 'fields', calc );\n            \n            jQuery( '#merge-tags-box' ).css( 'display', 'block' );\n            nfRadio.channel( 'drawer' ).request( 'prevent:close' );\n\n            jQuery( '.merge-tag-focus-overlay' ).off( 'click' );\n            jQuery( '.merge-tag-focus-overlay' ).on( 'click', function( e ) {\n                if ( jQuery( e.target ).hasClass( 'note-editor' ) ) {\n                    nfRadio.channel( 'mergeTags' ).request( 'insert:tag', '' );\n                    jQuery( '#merge-tags-box' ).css( 'display', 'none' );\n                    nfRadio.channel( 'drawer' ).request( 'enable:close' );\n                    jQuery( '#merge-tags-box' ).removeClass();\n                    jQuery( '.merge-tag-focus' ).removeClass( 'merge-tag-focus' );\n                    jQuery( '.merge-tag-focus-overlay' ).removeClass( 'merge-tag-focus-overlay' );\n                }\n            } );\n\n            setTimeout(function(){\n                jQuery( '#merge-tags-box' ).find( '.merge-tag-filter' ).find( 'input' ).focus();\n            }, 500 );\n        },\n\n        focusCallback: function( e, target, type ){\n\n            var type = type || 'setting';\n            var $this = ( 'undefined' == typeof target ) ? jQuery( this ) : jQuery( target );\n\n            jQuery( '.merge-tag-focus' ).each(function(index, el){\n                if( this == el ) return;\n                el.removeClass( 'merge-tag-focus' );\n            });\n\n            if( 'rte' == type ) {\n                var posY = $this.closest( '.nf-setting' ).find( '.note-editor' ).offset().top - jQuery(window).scrollTop();\n                var height = $this.closest( '.nf-setting' ).find( '.note-editor' ).outerHeight();\n            } else {\n                var posY = $this.offset().top - jQuery(window).scrollTop();\n                var height = $this.outerHeight();\n            }\n\n            // Find out if merge tag box will go below bottom of the page.\n\t        var tagBoxY = posY + height;\n\t        var windowHeight = window.innerHeight;\n\t        var tagBoxHeight = jQuery( '#merge-tags-box' ).outerHeight();\n\n\t        // If merge tag box will render below the bottom of the page,\n            // change it to render above the field\n\n\t        if ( ( tagBoxY + tagBoxHeight ) > windowHeight ) {\n\t\t        tagBoxY = posY - tagBoxHeight;\n\t        }\n\n            if ( 0 > tagBoxY ) {\n                tagBoxY = posY;\n            }\n\n            jQuery( '#merge-tags-box' ).css( 'top', tagBoxY );\n\n            var repeaterRow = $this.closest( '.nf-list-options-tbody' );\n            if( 0 != repeaterRow.length ) {\n                var left = repeaterRow.offset().left - jQuery(window).scrollLeft();\n                jQuery( '#merge-tags-box' ).css( 'left', left );\n            } else if( 'rte' == type ) {\n                var posX = $this.closest( '.nf-setting' ).find( '.note-editor' ).offset().left - jQuery(window).scrollLeft();\n                jQuery( '#merge-tags-box' ).css( 'left', posX );\n                jQuery( '#merge-tags-box' ).css( 'width', $this.closest( '.nf-setting' ).find( '.note-editor' ).width() );\n            }\n            else\n            {\n                var posX = jQuery( this ).closest( '.nf-settings' ).offset().left - jQuery(window).scrollLeft();\n                jQuery( '#merge-tags-box' ).css( 'left', posX );\n                jQuery( '#merge-tags-box' ).css( 'width', $this.closest( '.nf-settings' ).width() );\n            }\n\n            var dataID = jQuery( this ).data( 'id' );\n            if( dataID && 'eq' != dataID ) return;\n\n            // var offset = jQuery( view.el ).find( '.setting' ).parent().outerHeight();\n            // jQuery( view.el ).find( '.setting' ).parent().append( jQuery( '#merge-tags-box' ) );\n            // jQuery( '#merge-tags-box' ).css( 'top', offset );\n        },\n\n        keyupCallback: function( event, target, type ){\n            var type = type || 'setting';\n\n            if( /* ENTER */ 13 == event.keyCode ){\n\n                // Get top listed merge tag.\n                var firstFilteredTag = jQuery( '#merge-tags-box .merge-tag-list ul li span' ).first().data( 'tag' );\n\n                nfRadio.channel( 'mergeTags' ).request( 'insert:tag', firstFilteredTag );\n\n                // COPIED FROM BELOW\n                jQuery( '#merge-tags-box' ).css( 'display', 'none' );\n                nfRadio.channel( 'drawer' ).request( 'enable:close' );\n                jQuery( '#merge-tags-box' ).removeClass();\n                jQuery( '.merge-tag-focus' ).removeClass( 'merge-tag-focus' );\n                jQuery( '.merge-tag-focus-overlay' ).removeClass( 'merge-tag-focus-overlay' );\n\n                return;\n            }\n\n            // Get the value.\n            // var value = jQuery( summernote ).summernote( 'code' );\n            // Update the value.\n            // jQuery( summernote ).closest( '.nf-setting' ).find( '.note-editable' ).html( value );\n\n            if( 'undefined' != typeof target ) {\n                var $this = jQuery(target);\n            } else {\n                var $this = jQuery( this );\n            }\n\n            // TODO: Disable Browser Autocomplete\n            // $this.attr()\n\n\n            var dataID = jQuery( this ).data( 'id' );\n            if( dataID && 'eq' == dataID ) return;\n\n            // Store the current caret position.\n            if( 'rte' == type ){\n                var range = $this.summernote('createRange');\n                if( range ) {\n                    var caretPos = range.so; // or .eo?\n                } else {\n                    var caretPos = 0;\n                }\n                $this.closest( '.nf-setting' ).find( '.setting' ).summernote( 'saveRange' );\n            } else {\n                var caretPos = $this.caret();\n            }\n            nfRadio.channel( 'mergeTags' ).request( 'set:caret', caretPos );\n\n            // Find merge tags.\n            if( 'rte' == type ) {\n                var mergetags = $this.summernote( 'code' ).match(new RegExp(/{([a-zA-Z0-9]|:|_|-|})*/g));\n            } else {\n                var mergetags = $this.val().match(new RegExp(/{([a-zA-Z0-9]|:|_|-|})*/g));\n            }\n\n            // Filter out closed merge tags.\n            mergetags = _.filter(mergetags, function(mergetag) {\n                return -1 == mergetag.indexOf( '}' ); // Filter out \"closed\" merge tags.\n            });\n\n            // If an open merge tag is found, show the Merge Tag Box, else hide.\n            if( 0 !== mergetags.length ) {\n\n                nfRadio.channel( 'mergeTags' ).request( 'set:old', mergetags[0] );\n                \n                jQuery('#merge-tags-box').css( 'display', 'block' );\n                nfRadio.channel( 'drawer' ).request( 'prevent:close' );\n                $this.addClass('merge-tag-focus');\n\n                var boxHeight = jQuery( '#merge-tags-box' ).outerHeight();\n                jQuery( '#nf-drawer' ).css( 'padding-bottom', boxHeight + 'px' );\n\n                // Disable browser autocomplete.\n                var autocomplete = $this.attr( 'autocomplete' );\n                $this.attr( 'autocomplete', 'off' );\n                $this.data( 'autocomplete', autocomplete );\n\n                var $overlayElement = $this.closest( '.nf-setting, .nf-table-row' );\n                if( 0 != $overlayElement.find( '.note-editor' ).length ){\n                    $overlayElement.find('.note-editor' ).addClass('merge-tag-focus-overlay');\n                } else {\n                    $overlayElement.addClass('merge-tag-focus-overlay');\n                }\n\n                $overlayElement.off( 'click' );\n                $overlayElement.on( 'click', function( event ){\n                    var elementClasses = jQuery( event.target ).attr( 'class' ) || [];\n                    if( -1 !== elementClasses.indexOf( 'merge-tag-focus-overlay' ) ){\n                        nfRadio.channel( 'mergeTags' ).request( 'insert:tag', '' );\n                        jQuery( '#merge-tags-box' ).css( 'display', 'none' );\n                        nfRadio.channel( 'drawer' ).request( 'enable:close' );\n                        jQuery( '#merge-tags-box' ).removeClass();\n                        jQuery( '.merge-tag-focus' ).removeClass( 'merge-tag-focus' );\n                        jQuery( '.merge-tag-focus-overlay' ).removeClass( 'merge-tag-focus-overlay' );\n                    }\n                });\n\n                var value = mergetags[0].replace( '{', '' );\n            } else {\n                jQuery( '#merge-tags-box' ).css( 'display', 'none' );\n                nfRadio.channel( 'drawer' ).request( 'enable:close' );\n                jQuery( '#merge-tags-box' ).removeClass();\n                jQuery( '.merge-tag-focus' ).removeClass( 'merge-tag-focus' );\n                jQuery( '.merge-tag-focus-overlay' ).removeClass( 'merge-tag-focus-overlay' );\n            }\n        }\n\n    } );\n\n    return controller;\n} );\n\n","/**\n * Listens to our app channel for settings views being rendered.\n *\n * If we're about to render a setting model that's a select and has 'fields' as the 'fill' setting, add all our field models to its options.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/itemSettingFill',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Listen for messages that are fired before a setting view is rendered.\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'before:renderSetting', this.beforeRenderSetting );\n\t\t},\n\n\t\tbeforeRenderSetting: function( settingModel, dataModel ) {\n\t\t\tif ( 'fields' == settingModel.get( 'fill' ) ) {\n\t\t\t\t\n\t\t\t}\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Modify the user's browser history when they click on a domain\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/confirmPublish',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'click:confirmPublish', this.confirmPublish );\n\t\t},\n\n\t\tconfirmPublish: function() {\n\t\t\tvar formModel = nfRadio.channel( 'app' ).request( 'get:formModel' );\n\t\t\t// Check to see if we need to add a submit button.\n\t\t\tif ( 1 == formModel.get( 'settings' ).get( 'add_submit' ) ) {\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'add', { type: 'submit', label: 'Submit', order: 9999 } );\n\t\t\t}\n\t\t\tformModel.set( 'show_publish_options', false );\n\t\t\tnfRadio.channel( 'app' ).request( 'update:db', 'publish' );\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles actions related to settings that utilise the Rich Text Editor\n *\n * @package Ninja Forms builder\n * @subpackage App - Settings Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/rte',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// We don't want the RTE setting to re-render when the value changes.\n\t\t\tnfRadio.channel( 'setting-type-rte' ).reply( 'renderOnChange', function(){ return false } );\n\n\t\t\tthis.listenTo( nfRadio.channel( 'rte' ), 'init:settingModel', this.initSettingModel );\n\n\t\t\t// When an RTE setting is shown, re-render RTE.\n\t\t\tthis.listenTo( nfRadio.channel( 'setting-type-rte' ), 'render:setting', this.renderSetting );\n\n\t\t\t// When an RTE setting view is destroyed, remove our RTE.\n\t\t\tthis.listenTo( nfRadio.channel( 'setting-type-rte' ), 'destroy:setting', this.destroySetting );\n\n\t\t\t// When an element within the RTE is clicked, check to see if we should insert a link.\n\t\t\tthis.listenTo( nfRadio.channel( 'setting-type-rte' ), 'click:extra', this.clickExtra );\n\n\t\t\t// Instantiates the variable that holds the media library frame.\n\t\t\tthis.meta_image_frame;\n\n\t\t\tjQuery.summernote.options.icons = {\n\t\t        'align': 'dashicons dashicons-editor-alignleft',\n\t\t        'alignCenter': 'dashicons dashicons-editor-aligncenter',\n\t\t        'alignJustify': 'dashicons dashicons-editor-justify',\n\t\t        'alignLeft': 'dashicons dashicons-editor-alignleft',\n\t\t        'alignRight': 'dashicons dashicons-editor-alignright',\n\t\t        'indent': 'dashicons dashicons-editor-indent',\n\t\t        'outdent': 'dashicons dashicons-editor-outdent',\n\t\t        // 'arrowsAlt': 'dashicons fa-arrows-alt',\n\t\t        'bold': 'dashicons dashicons-editor-bold',\n\t\t        'caret': 'dashicons dashicons-arrow-down',\n\t\t        // 'circle': 'dashicons fa-circle',\n\t\t        'close': 'dashicons dashicons-dismiss',\n\t\t        'code': 'dashicons dashicons-editor-code',\n\t\t        'eraser': 'dashicons dashicons-editor-removeformatting',\n\t\t        // 'font': 'dashicons fa-font',\n\t\t        // 'frame': 'dashicons fa-frame',\n\t\t        'italic': 'dashicons dashicons-editor-italic',\n\t\t        'link': 'dashicons dashicons-admin-links',\n\t\t        'unlink': 'dashicons dashicons-editor-unlink',\n\t\t        'magic': 'dashicons dashicons-editor-paragraph',\n\t\t        // 'menuCheck': 'dashicons fa-check',\n\t\t        'minus': 'dashicons dashicons-minus',\n\t\t        'orderedlist': 'dashicons dashicons-editor-ol',\n\t\t        // 'pencil': 'dashicons fa-pencil',\n\t\t        // 'picture': 'dashicons fa-picture-o',\n\t\t        // 'question': 'dashicons fa-question',\n\t\t        'redo': 'dashicons dashicons-redo',\n\t\t        'square': 'dashicons fa-square',\n\t\t        // 'strikethrough': 'dashicons fa-strikethrough',\n\t\t        // 'subscript': 'dashicons fa-subscript',\n\t\t        // 'superscript': 'dashicons fa-superscript',\n\t\t        'table': 'dashicons dashicons-editor-table',\n\t\t        // 'textHeight': 'dashicons fa-text-height',\n\t\t        // 'trash': 'dashicons fa-trash',\n\t\t        'underline': 'dashicons dashicons-editor-underline',\n\t\t        'undo': 'dashicons dashicons-undo',\n\t\t        'unorderedlist': 'dashicons dashicons-editor-ul',\n\t\t        // 'video': 'dashicons fa-youtube-play'\n\t\t      }\n\n\t\t      this.currentContext = {};\n\t\t},\n\n\t\tinitSettingModel: function( settingModel ) {\n\t\t\tsettingModel.set( 'hide_merge_tags', true );\n\t\t},\n\n\t\tinitRTE: function( settingModel, dataModel, settingView ) {\n\t\t\t/*\n\t\t\t * Custom Button for links\n\t\t\t */\n\t\t\tvar that = this;\n\t\t\t// var linkButton = this.linkButton();\n\t\t\tconst linkButton = function( context ) {\n\t\t\t\treturn that.linkButton( context );\n\t\t\t},\n\t\t\tmediaButton = function( context ) {\n\t\t\t\treturn that.mediaButton( context );\n\t\t\t},\n\t\t\tmergeTags = function() {\n\t\t\t\treturn that.mergeTags();\n\t\t\t};\n\n\t\t\tvar toolbar = [\n\t\t\t\t[ 'paragraphStyle', ['style'] ],\n\t\t\t\t[ 'fontStyle', [ 'bold', 'italic', 'underline','clear' ] ],\n\t\t\t\t[ 'lists', [ 'ul', 'ol' ] ],\n\t\t\t    [ 'paragraph', [ 'paragraph' ] ],\n\t\t\t    [ 'customGroup', [ 'linkButton', 'unlink' ] ],\n\t\t\t    [ 'table', [ 'table' ] ],\n\t\t\t    [ 'actions', [ 'undo', 'redo' ] ],\n\t\t\t    [ 'tools', [ 'mediaButton', 'mergeTags', 'codeview' ] ]\n\t\t\t];\n\n\t\t\tjQuery( settingView.el ).find( 'div.setting' ).summernote( {\n\t\t\t\ttoolbar: toolbar,\n\t\t\t\tbuttons: {\n\t\t\t\t\tlinkButton: linkButton,\n\t\t\t\t\tmergeTags: mergeTags,\n\t\t\t\t\tmediaButton: mediaButton\n\t\t\t\t},\n\t\t\t\theight: 150,   //set editable area's height\n\t\t\t\tcodemirror: { // codemirror options\n\t\t\t\t    theme: 'monokai',\n\t\t\t\t    lineNumbers: true,\n                    lineWrapping: true,\n\t\t\t\t    callbacks: {\n\t\t\t\t    \tonBlur: function( editor ) {\n\t\t\t\t    \t\tvar value = editor.getValue();\n\t\t\t\t    \t\tthat.updateDataModel( settingModel, dataModel, value );\n\t\t\t\t    \t}\n\t\t\t\t    }\n\t\t\t\t},\n\t\t\t\tprettifyHtml: true,\n\t\t\t\tcallbacks: {\n\t\t\t\t\tonBlur: function( e, context ) {\n\t\t\t\t\t\tvar value = jQuery( this ).summernote( 'code' );\n\t\t\t\t\t\tthat.updateDataModel( settingModel, dataModel, value );\n                        nfRadio.channel( 'summernote' ).trigger( 'blur', settingModel, dataModel, value );\n\t\t\t\t\t},\n                    onFocus: function( e, context ) {\n                        nfRadio.channel( 'summernote' ).trigger( 'focus', e, this, context );\n                    },\n                    onKeydown: function( e, context ) {\n                        nfRadio.channel( 'summernote' ).trigger( 'keydown', e, this, context );\n                    },\n                    onKeyup: function( e, context ) {\n                        nfRadio.channel( 'summernote' ).trigger( 'keyup', e, this, context );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tupdateDataModel: function( settingModel, dataModel, value ) {\n\t\t\tvar name = settingModel.get( 'name' );\n\t\t\tvar before = dataModel.get( name );\n\t\t\tvar after = value;\n\n\t\t\tvar changes = {\n\t\t\t\tattr: name,\n\t\t\t\tbefore: before,\n\t\t\t\tafter: after\n\t\t\t}\n\n\t\t\tvar label = {\n\t\t\t\tobject: dataModel.get( 'objectType' ),\n\t\t\t\tlabel: dataModel.get( 'label' ),\n\t\t\t\tchange: 'Changed ' + settingModel.get( 'label' ) + ' from ' + before + ' to ' + after\n\t\t\t};\n\n\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'changeSetting', dataModel, changes, label );\n\n\t\t\tdataModel.set( settingModel.get( 'name' ), after );\n\t\t},\n\n\t\trenderSetting: function( settingModel, dataModel, settingView ) {\n\t\t\tthis.initRTE( settingModel, dataModel,settingView );\n\t\t\tvar linkMenu = jQuery( settingView.el ).find( '.link-button' ).next( '.dropdown-menu' ).find( 'button' );\n\t\t\tlinkMenu.replaceWith(function () {\n\t\t\t    return jQuery( '<div/>', {\n\t\t\t        class: jQuery( linkMenu ).attr( 'class' ),\n\t\t\t        html: this.innerHTML\n\t\t\t    } );\n\t\t\t} );\n\t\t},\n\n\t\tdestroySetting: function( settingModel, dataModel, settingView ) {\n\t\t\tthis.removeRTE( settingModel, dataModel, settingView );\n\t\t},\n\n\t\tremoveRTE: function( settingModel, dataModel, settingView ) {\n\t\t\tjQuery( settingView.el ).find( 'div.setting' ).summernote( 'destroy' );\n\t\t},\n\n\t\tdrawerOpened: function( settingModel, dataModel, settingView ) {\n\t\t\tthis.initRTE( settingModel, dataModel, settingView );\n\t\t},\n\n\t\tlinkButton: function( context ) {\n\t\t\tvar that = this;\n\t\t\tvar ui = jQuery.summernote.ui;\n\t\t\tvar linkButton = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-rte-link-button' );\n\t\t\tvar linkDropdown = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-rte-link-dropdown' );\n\t\t\treturn ui.buttonGroup([\n\t\t\t\tui.button({\n\t            className: 'dropdown-toggle link-button',\n\t            contents: linkButton({}),\n\t            tooltip: 'Insert Link',\n\t            click: function( e ) {\n\t            \tthat.clickLinkButton( e, context );\n\t            },\n\t            data: {\n\t              toggle: 'dropdown'\n\t            }\n\t          }),\n\t\t\t\tui.dropdown([\n\t            ui.buttonGroup({\n\t              children: [\n\t                ui.button({\n\t                  contents: linkDropdown({}),\n\t                  tooltip: ''\n\t                }),\n\t              ]\n\t            })\n\t          ])\n\t\t\t]).render();\n\t\t},\n\n\t\tmergeTags: function( context ) {\n\t\t\tvar ui = jQuery.summernote.ui;\n\t\t\tvar mergeTagsButton = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-rte-merge-tags-button' );\n\t\t\treturn ui.button({\n\t\t\t\tclassName: 'dropdown-toggle merge-tags',\n\t\t\t\tcontents: mergeTagsButton({}),\n\t\t\t\ttooltip: 'Merge Tags'\n\t\t\t}).render();\n\t\t},\n\n\t\tmediaButton: function( context ) {\n\t\t\tvar that = this;\n\t\t\tvar ui = jQuery.summernote.ui;\n\t\t\tvar mediaButton = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-rte-media-button' );\n\t\t\treturn ui.button({\n\t            className: 'dropdown-toggle',\n\t            contents: mediaButton({}),\n\t            tooltip: 'Insert Media',\n\t            click: function( e ) {\n\t            \tthat.openMediaManager( e, context );\n\t            }\n\t          }).render();\n\t\t},\n\n\t\topenMediaManager: function( e, context ) {\n\t\t\tcontext.invoke( 'editor.createRange' );\n\t\t\tcontext.invoke( 'editor.saveRange' );\n\t\t\tthis.currentContext = context;\n\t\t\t\n\t\t\t// If the frame already exists, re-open it.\n\t\t\tif ( this.meta_image_frame ) {\n\t\t\t\tthis.meta_image_frame.open();\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Sets up the media library frame\n\t\t\tthis.meta_image_frame = wp.media.frames.meta_image_frame = wp.media({\n\t\t\t\ttitle: 'Select a file',\n\t\t\t\tbutton: { text:  'insert' }\n\t\t\t});\n\n\t\t\tvar that = this;\n\n\t\t\t// Runs when an image is selected.\n\t\t\tthis.meta_image_frame.on('select', function(){\n\n\t\t\t\t// Grabs the attachment selection and creates a JSON representation of the model.\n\t\t\t\tvar media_attachment = that.meta_image_frame.state().get('selection').first().toJSON();\n\t\t\t\tthat.insertMedia( media_attachment, context );\n\t\t\t});\n\n\t\t\t// Opens the media library frame.\n\t\t\tthis.meta_image_frame.open();\n\t\t},\n\n\t\tclickLinkButton: function ( e, context ) {\n\t\t\tvar range = context.invoke( 'editor.createRange' );\n\t\t\tcontext.invoke( 'editor.saveRange' );\n\t\t\tvar text = range.toString()\n\t\t\tthis.currentContext = context;\n\n\t\t\tjQuery( e.target ).closest( '.note-customGroup > .note-btn-group' ).on ('hide.bs.dropdown', function ( e ) {\n\t\t\t\treturn false;\n\t\t\t});\n\n\t\t\tjQuery( e.target ).closest( '.note-customGroup > .note-btn-group' ).on ('shown.bs.dropdown', function ( e ) {\n\t\t\t\tjQuery( e.target ).parent().parent().find( '.link-text' ).val( text );\n\t\t\t\tjQuery( e.target ).parent().parent().find( '.link-url' ).focus();\n\t\t\t});\n\t\t},\n\n\t\tclickExtra: function( e, settingModel, dataModel, settingView ) {\n\t\t\tvar textEl = jQuery( e.target ).parent().find( '.link-text' );\n\t\t\tvar urlEl = jQuery( e.target ).parent().find( '.link-url' );\n\t\t\tvar isNewWindowEl = jQuery( e.target ).parent().find( '.link-new-window' );\n\t\t\tthis.currentContext.invoke( 'editor.restoreRange' );\n\t\t\tif ( jQuery( e.target ).hasClass( 'insert-link' ) ) {\n\t\t\t\tvar text = textEl.val();\n\t\t\t\tvar url = urlEl.val();\n\t\t\t\tvar isNewWindow = ( isNewWindowEl.prop( 'checked' ) ) ? true: false;\n\t\t\t\tif ( 0 != text.length && 0 != url.length ) {\n\t\t\t\t\tthis.currentContext.invoke( 'editor.createLink', { text:text, url: url, isNewWindow: isNewWindow } );\n\t\t\t\t}\n\t\t\t}\n\t\t\ttextEl.val( '' );\n\t\t\turlEl.val( '' );\n\t\t\tisNewWindowEl.prop( 'checked', false );\n\t\t\tjQuery( e.target ).closest( 'div.note-btn-group.open' ).removeClass( 'open' );\n\t\t},\n\n\t\tinsertMedia: function( media, context ) {\n\t\t\tthis.currentContext.invoke( 'editor.restoreRange' );\n\t\t\tif ( 'image' == media.type ) {\n\t\t\t\tthis.currentContext.invoke( 'editor.insertImage', media.url );\n\t\t\t} else {\n\t\t\t\tthis.currentContext.invoke( 'editor.createLink', {\n\t\t\t\t\ttext: media.title || media.filename,\n\t\t\t\t\turl: media.url\n\t\t\t\t} );\n\t\t\t}\n\n\t\t}\n\t});\n\n\treturn controller;\n} );\n\n","/**\n * Listens to our app channel for settings views being rendered.\n *\n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/settingFieldSelect',[], function() {\n    var controller = Marionette.Object.extend( {\n\n        initialize: function() {\n\n            // Bind field key listener to field-select setting type.\n            this.listenTo( nfRadio.channel( 'field-select' ), 'init:settingModel', this.trackKeyChanges );\n\n            // The first time settingModel and the dataModel meet.\n            this.listenTo( nfRadio.channel( 'setting-type-field-select' ), 'before:renderSetting', this.beforeRender );\n\n            // Add setting change listener only in drawers with a field-select setting.\n            this.listenTo( nfRadio.channel( 'field-select' ), 'init:settingModel', function() {\n                this.listenTo( nfRadio.channel( 'app' ), 'change:setting', this.maybeSwitchToFieldsDomain );\n            });\n\n            this.listenTo( nfRadio.channel( 'app' ), 'change:currentDomain', this.autoOpenDrawer );\n\n            this.listenTo( nfRadio.channel( 'drawer' ), 'opened', this.filterDrawerContents );\n            this.listenTo( nfRadio.channel( 'drawer' ), 'closed', this.SwitchToFieldsDomain );\n        },\n\n        trackKeyChanges: function( settingModel ) {\n            settingModel.listenTo( nfRadio.channel( 'app' ), 'update:fieldKey', settingModel.updateKey );\n\n            // Update selected field if the selected field's key changes.\n            this.listenTo( nfRadio.channel( 'app' ), 'replace:fieldKey', this.updateFieldMap );\n        },\n\n        updateFieldMap: function( dataModel, keyModel, settingModel ) {\n\n            var oldKey = keyModel._previousAttributes[ 'key' ];\n            var newKey = keyModel.get( 'key' );\n\n            if( 'field-select' == settingModel.get( 'type' ) && dataModel.get( settingModel.get( 'name' ) ) == oldKey ) {\n\n                dataModel.set( settingModel.get( 'name' ), newKey );\n            }\n        },\n\n        beforeRender: function( settingModel, dataModel ) {\n\n            var fieldCollection = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\n            var fieldTypes = settingModel.get( 'field_types' );\n\n            var options = [\n                {\n                    label: '--',\n                    value: 0\n                }\n            ];\n            _.each( fieldCollection.models, function( field ){\n\n                if( dataModel.cid == field.cid ) return;\n\n                if( 'undefined' != typeof fieldTypes && 0 != fieldTypes.length && ! _.contains( fieldTypes, field.get( 'type' ) ) ) return;\n\n                var fieldFilter = settingModel.get( 'field_filter' );\n                if( fieldFilter && 'undefined' != typeof fieldFilter[ field.get( 'type' ) ] ) {\n                    var bail = false;\n                    _.each( fieldFilter[ field.get( 'type' ) ], function( value, setting ){\n                        console.log( value + \":\" + field.get( setting )  );\n                        if( value != field.get( setting ) ) bail = true;\n                    } );\n                    if( bail ) return;\n                }\n\n                var value = field.get( 'key' );\n                switch ( settingModel.get( 'field_value_format' ) ) {\n                    case 'key':\n                        value = field.get( 'key' );\n                        break;\n                    case 'merge_tag':\n                    default:\n                        value = '{field:' + field.get( 'key' ) + '}';\n                }\n\n                options.push({\n                    label: field.get( 'label' ),\n                    value: value\n                });\n            });\n\n            if( 'undefined' != typeof fieldTypes && 0 != fieldTypes.length ) {\n                _.each( fieldTypes, function( fieldType ){\n\n                    var fieldTypeModel = nfRadio.channel( 'fields' ).request( 'get:type', fieldType );\n\n                    options.push({\n                        label: '-- Add ' + fieldTypeModel.get( 'nicename' ) + ' Field',\n                        value: 'addField:' + fieldType,\n                    });\n                } );\n            }\n\n            settingModel.set( 'options', options );\n        },\n\n        maybeSwitchToFieldsDomain: function( e, model, dataModel ) {\n\n            if( 'field-select' != model.get( 'type' ) ) return;\n\n            var name = model.get( 'name' );\n            var value = dataModel.get( name );\n\n            if( ! value ) return;\n\n            var rubble = value.split( ':' );\n\n            if( 'addField' != rubble[0] ) return;\n\n            this.openDrawer = 'addField';\n            this.filterDrawer = rubble[1];\n\n            dataModel.set( name, '' );\n\n            this.switchDomain = true;\n            nfRadio.channel( 'app' ).request( 'close:drawer' );\n        },\n\n        SwitchToFieldsDomain: function() {\n            if( this.switchDomain ) {\n                var fieldDomainModel = nfRadio.channel( 'app' ).request( 'get:domainModel', 'fields' );\n                nfRadio.channel('app').request('change:currentDomain', null, fieldDomainModel);\n                this.switchDomain = null;\n            }\n        },\n\n        autoOpenDrawer: function() {\n            if( this.openDrawer ) {\n                nfRadio.channel( 'app' ).request( 'open:drawer', this.openDrawer );\n                this.openDrawer = null;\n            }\n        },\n\n        filterDrawerContents: function() {\n            if( this.filterDrawer ) {\n                nfRadio.channel('drawer-addField').trigger('change:filter', this.filterDrawer);\n                this.filterDrawer = null;\n            }\n        }\n    });\n\n    return controller;\n} );\n","/**\n * The Field List setting is a container of settings (like the Fieldset setting), in which its 