ja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/settingHTML',[], function() {\n    var controller = Marionette.Object.extend( {\n        initialize: function() {\n\n            // The first time settingModel and the dataModel meet.\n            this.listenTo( nfRadio.channel( 'setting-type-html' ), 'before:renderSetting', this.init );\n        },\n\n        init: function( settingModel, dataModel ) {\n\n            if( 'undefined' == settingModel.get( 'mirror' ) ) return;\n\n            // Listen to a setting change inside of the dataModel.\n            dataModel.on( 'change:' + settingModel.get( 'mirror' ), this.update, settingModel );\n        },\n\n        update: function( dataModel, changedSettingValue ) {\n\n            // Mirror the default value setting value.\n            dataModel.set( this.get( 'name' ), changedSettingValue );\n        }\n    });\n\n    return controller;\n} );\n","/**\n * Listens to our app channel for settings views being rendered.\n *\n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/settingColor',[], function() {\n    var controller = Marionette.Object.extend( {\n        initialize: function() {\n            // We don't want to re-render this setting type when the data changes.\n            nfRadio.channel( 'setting-type-color' ).reply( 'renderOnChange', this.setRenderFalse );\n            // We want to close any color pickers before we close our styling tab or drawer.\n            this.listenTo( nfRadio.channel( 'setting-type-color' ), 'destroy:setting', this.closeColorPickers );\n\n            // The first time settingModel and the dataModel meet.\n            this.listenTo( nfRadio.channel( 'setting-type-color' ), 'render:setting', this.initColorPicker );\n        },\n\n        initColorPicker: function( settingModel, dataModel, view ) {\n\n            var name = settingModel.get( 'name' );\n            var el = jQuery( view.el ).find( 'input' );\n\n            jQuery( el ).wpColorPicker( {\n                change: function( event, ui ){\n                    nfRadio.channel( 'app' ).request( 'change:setting', event, settingModel, dataModel, ui.color.toString() );\n                }\n            } );\n        },\n\n        setRenderFalse: function() {\n            return false;\n        },\n\n        closeColorPickers: function( settingModel, dataModel, view ) {\n            jQuery( view.el ).find( '.wp-color-picker' ).wpColorPicker( 'close' );\n        }\n    });\n\n    return controller;\n} );\n","/**\n * Listens to our app channel for the app to start.\n *\n * If the form is a new form, then highlight the Add New submenu item.\n * Otherwise, append an Edit Form submenu for context.\n *\n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2016 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/changeMenu',[], function() {\n    var controller = Marionette.Object.extend({\n\n        editFormText: '',\n\n        initialize: function () {\n            this.editFormText = nfAdmin.editFormText || 'Edit Form';\n            this.listenTo(nfRadio.channel('app'), 'after:appStart', this.changeMenu);\n            this.listenTo( nfRadio.channel( 'app' ), 'response:updateDB', this.formPublish );\n        },\n\n        changeMenu: function () {\n            var form = nfRadio.channel( 'app' ).request( 'get:formModel' );\n\n            if ( this.isNewForm( form.id ) ) {\n                this.highlightAddNew();\n            } else {\n                this.appendEditForm();\n            }\n        },\n\n        isNewForm: function( form_id ) {\n            return isNaN( form_id );\n        },\n\n        highlightAddNew: function() {\n            jQuery( '.wp-submenu li' ).removeClass( 'current' );\n            jQuery( 'a[href=\"admin.php?page=ninja-forms&form_id=new\"]' ).parent().addClass( 'current' );\n        },\n\n        /**\n         * Append 'Edit Form'\n         * When editing a form, add an 'Edit Form' submenu item to\n         *   the WordPress Admin Dashboard menu, specifically under\n         *   the Ninja Forms Menu Item and after the 'Add New' item.\n         */\n        appendEditForm: function() {\n            // Singleton check. Only add this menu item one time.\n            if ( jQuery( 'li a:contains(\"' + this.editFormText + '\")' ).length > 0 ) return;\n\n            var editFormLinkText, editFormLink, editFormListItem;\n\n            // Create the 'Edit Form' submenu item.\n            editFormLinkText = document.createTextNode(this.editFormText);\n            editFormLink = document.createElement(\"a\");\n            editFormLink.appendChild(editFormLinkText);\n\n            editFormListItem = document.createElement(\"li\");\n            editFormListItem.appendChild(editFormLink);\n            editFormListItem.classList.add(\"current\");\n\n            // Remove the `current` class from any existing list items.\n            jQuery( '.wp-submenu li' ).removeClass( 'current' );\n\n            // Insert the 'Edit Form' item after the 'Add New' item;\n            jQuery( 'a[href=\"admin.php?page=ninja-forms#new-form\"]' ).parent().after( editFormListItem );\n        },\n\n        formPublish: function( response ) {\n            if ( 'publish' !== response.action ) return false;\n            this.changeMenu();\n        }\n    });\n\n    return controller;\n});\n\n","/**\n * When we click on a domain link, close the mobile menu.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/mobile',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Listen for clicks on our app menu.\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'click:menu', this.closeMobileMenu );\n\t\t},\n\n\t\tcloseMobileMenu: function() {\n\t\t\tvar builderEl = nfRadio.channel( 'app' ).request( 'get:builderEl' );\n\t\t\tjQuery( builderEl ).removeClass( 'nf-menu-expand' );\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Add a jBox notice to the screen.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/notices',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tnfRadio.channel( 'notices' ).reply( 'add', this.addNotice, this );\n\t\t\tnfRadio.channel( 'notices' ).reply( 'close', this.closeNotice, this );\n\t\t\tthis.notices = {};\n\t\t},\n\n\t\taddNotice: function( key, msg, options ) {\n\n\t\t\tvar appDefaults = {\n\t\t\t\tcontent: msg,\n\t\t\t\tcolor: 'green',\n\t\t\t\tzIndex:10000000,\n\t\t\t\tconstructOnInit: true,\n\t\t\t\tstack: true,\n\t\t\t\tanimation: {\n\t\t\t\t\topen: 'flip',\n\t\t\t\t\tclose: 'flip'\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tvar mobileDefaults = {\n\t\t\t\tposition: {\n\t\t\t\t\tx: 'center',\n\t\t\t\t\ty: 'top'\n\t\t\t\t},\n\t\t\t\tanimation: {\n\t\t\t\t\topen:'slide:top',\n\t\t\t\t\tclose:'slide:left'\n\t\t\t\t},\n\t\t\t\tautoClose: 2000,\n\t\t\t\toffset: {\n\t\t\t\t\tx: 0,\n\t\t\t\t\ty: 55\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tvar desktopDefaults = {\n\t\t\t\tattributes: {\n\t\t\t\t\tx: 'left',\n\t\t\t\t\ty: 'bottom'\n\t\t\t\t},\n\t\t\t\tautoClose: 4000\n\t\t\t};\n\n\t\t\tif ( nfRadio.channel( 'app' ).request( 'is:mobile' ) ) {\n\t\t\t\tvar defaults = mobileDefaults;\t\n\t\t\t} else {\n\t\t\t\tvar defaults = desktopDefaults;\n\t\t\t}\n\t\t\tdefaults = jQuery.extend( defaults, appDefaults );\n\n\t\t\tvar options = jQuery.extend( defaults, options );\n\t\t\t// console.log( options );\n\t\t\tthis.notices[ key ] = new jBox( 'Notice', options );\n\t\t},\n\n\t\tcloseNotice: function( key ) {\n\t\t\tif ( 'undefined' != typeof this.notices[ key ] ) {\n\t\t\t\tthis.notices[ key ].close();\n\t\t\t}\n\t\t},\n\n\t\topenNotice: function( key ) {\n\t\t\tif ( 'undefined' != typeof this.notices[ key ] ) {\n\t\t\t\tthis.notices[ key ].open();\n\t\t\t}\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Prompt the user to save if they attempt to leave the page with unsaved changes.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2016 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/unloadCheck',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tjQuery( window ).bind( 'beforeunload', this.maybePrompt );\n\t\t},\n\n\t\tmaybePrompt: function( model ) {\n\t\t\t// If our app is clean, don't show a warning.\n\t\t\tif ( ! nfRadio.channel( 'app' ).request( 'get:setting', 'clean' ) ) {\n\t\t\t\treturn 'You have unsaved changes.';\n\t\t\t}\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Before we save data to the database (on preview update or publish), we check to see if we have anyone\n * that wants to update the 'formContent' form setting. This setting is used on the front-end to allow\n * for custom display of form fields. i.e. layout rows.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/formContentFilters',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t/*\n\t\t\t * Init our formContent view filter array.\n\t\t\t */\n\t\t\tthis.viewFilters = [];\n\t\t\tthis.saveFilters = [];\n\t\t\tthis.loadFilters = [];\n\n\t\t\t/*\n\t\t     * Listen for requests to add formContent filters.\n\t\t\t */\n\n\t\t\tnfRadio.channel( 'formContent' ).reply( 'add:viewFilter', this.addViewFilter, this );\n\t\t\tnfRadio.channel( 'formContent' ).reply( 'add:saveFilter', this.addSaveFilter, this );\n\t\t\tnfRadio.channel( 'formContent' ).reply( 'add:loadFilter', this.addLoadFilter, this );\n\n\t\t\t/*\n\t\t\t * Listen for requests to get our formContent filters.\n\t\t\t */\n\t\t\tnfRadio.channel( 'formContent' ).reply( 'get:viewFilters', this.getViewFilters, this );\n\t\t\tnfRadio.channel( 'formContent' ).reply( 'get:saveFilters', this.getSaveFilters, this );\n\t\t\tnfRadio.channel( 'formContent' ).reply( 'get:loadFilters', this.getLoadFilters, this );\n\t\t\t\n\t\t\t/*\n\t\t\t * -- DEPRECATED RADIO REPLIES --\n\t\t\t * \n\t\t\t * The 'fieldContents' channel has been deprecated as of 3.0 (it was present in the RC) in favour of 'formContent'.\n\t\t\t * Listen for requests to add new fieldContent filters.\n\t\t\t * \n\t\t\t * TODO: These radio listeners on the 'fieldContents' channels are here for backwards compatibility and should be removed eventually.\n\t\t\t */\n\n\t\t\tnfRadio.channel( 'fieldContents' ).reply( 'add:viewFilter', this.addViewFilter, this );\n\t\t\tnfRadio.channel( 'fieldContents' ).reply( 'add:saveFilter', this.addSaveFilter, this );\n\t\t\tnfRadio.channel( 'fieldContents' ).reply( 'add:loadFilter', this.addLoadFilter, this );\n\n\t\t\t/*\n\t\t\t * Listen for requests to get our fieldContent filters.\n\t\t\t */\n\t\t\tnfRadio.channel( 'fieldContents' ).reply( 'get:viewFilters', this.getViewFilters, this );\n\t\t\tnfRadio.channel( 'fieldContents' ).reply( 'get:saveFilters', this.getSaveFilters, this );\n\t\t\tnfRadio.channel( 'fieldContents' ).reply( 'get:loadFilters', this.getLoadFilters, this );\n\t\t\n\t\t\t/*\n\t\t\t * -- END DEPRECATED --\n\t\t\t */\n\t\t},\n\n\t\taddViewFilter: function( callback, priority ) {\n\t\t\tthis.viewFilters[ priority ] = callback;\n\t\t},\n\n\t\tgetViewFilters: function() {\n\t\t\treturn this.viewFilters;\n\t\t},\n\n\t\taddSaveFilter: function( callback, priority ) {\n\t\t\tthis.saveFilters[ priority ] = callback;\n\t\t},\n\n\t\tgetSaveFilters: function() {\n\t\t\treturn this.saveFilters;\n\t\t},\n\n\t\taddLoadFilter: function( callback, priority ) {\n\t\t\tthis.loadFilters[ priority ] = callback;\n\t\t},\n\n\t\tgetLoadFilters: function() {\n\t\t\treturn this.loadFilters;\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles filters for our main content gutter views.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/formContentGutterFilters',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t/*\n\t\t\t * Init our gutter view filter array.\n\t\t\t */\n\t\t\tthis.leftFilters = [];\n\t\t\tthis.rightFilters = [];\n\t\t\t/*\n\t\t     * Listen for requests to add gutter filters.\n\t\t\t */\n\t\t\tnfRadio.channel( 'formContentGutters' ).reply( 'add:leftFilter', this.addLeftFilter, this );\n\t\t\tnfRadio.channel( 'formContentGutters' ).reply( 'add:rightFilter', this.addRightFilter, this );\n\n\t\t\t/*\n\t\t\t * Listen for requests to get our content gutter filters.\n\t\t\t */\n\t\t\tnfRadio.channel( 'formContentGutters' ).reply( 'get:leftFilters', this.getLeftFilters, this );\n\t\t\tnfRadio.channel( 'formContentGutters' ).reply( 'get:rightFilters', this.getRightFilters, this );\n\t\t},\n\n\t\taddLeftFilter: function( callback, priority ) {\n\t\t\tthis.leftFilters[ priority ] = callback;\n\t\t},\n\n\t\taddRightFilter: function( callback, priority ) {\n\t\t\tthis.rightFilters[ priority ] = callback;\n\t\t},\n\n\t\tgetLeftFilters: function() {\n\t\t\treturn this.leftFilters;\n\t\t},\n\n\t\tgetRightFilters: function() {\n\t\t\treturn this.rightFilters;\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Returns a clone of a backbone collection with all the models' attributes looped through so that collections contained within are propely cloned.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/cloneCollectionDeep',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tnfRadio.channel( 'app' ).reply( 'clone:collectionDeep', this.cloneCollectionDeep, this );\n\t\t},\n\n\t\tcloneCollectionDeep: function( collection ) {\n\t\t\tvar models = [];\n\t\t\t// Loop through every model in our collection, clone it, and add it to our model array\n\t\t\t_.each( collection.models, function( model ) {\n\t\t\t\tvar newModel = nfRadio.channel( 'app' ).request( 'clone:modelDeep', model );\n\t\t\t\tmodels.push( newModel );\n\t\t\t} );\n\t\t\t// Create a new instance of our collection\n\t\t\treturn new collection.constructor( models, collection.options );\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Tracks which keys have been pressed.\n * Currently only used by fields to see if they should duplicate or delete on click.\n * (Shift + D + click = delete) (Shift + C + click = duplicate)\n * \n * @package Ninja Forms builder\n * @subpackage Fields - Edit Field Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/trackKeyDown',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tkeys: [],\n\n\t\tinitialize: function() {\n\t\t\tvar that = this;\n\t\t\t/*\n\t\t\t * Track keydowns and store the keys pressed.\n\t\t\t */\n\t\t\t\n\t\t\tjQuery( document ).on( 'keydown', function( e ) {\n\t\t\t\tthat.keyDown( e, that );\n\t\t\t} );\n\n\t\t\tjQuery( document ).on( 'keyup', function( e ) {\n\t\t\t\tthat.keyUp( e, that );\n\t\t\t} );\n\n\t\t\t/*\n\t\t\t * Get the keys currently being pressed, if any\n\t\t\t */\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:keydown', this.getKeyDown, this );\n\t\t},\n\n\t\tkeyDown: function( e, context ) {\n\t\t\t/*\n\t\t\t * Add our keycode to our keys array.\n\t\t\t */\n\t\t\tcontext.keys[ e.keyCode ] = e.keyCode;\n\t\t},\n\n\t\tkeyUp: function( e, context ) {\n\t\t\t/*\n\t\t\t * Remove our keycode from our keys array.\n\t\t\t */\n\t\t\tif ( -1 != context.keys.indexOf( e.keyCode ) ) {\n\t\t\t\tdelete context.keys[ e.keyCode ];\n\t\t\t}\n\t\t},\n\n\t\tgetKeyDown: function() {\n\t\t\treturn this.keys;\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Initialize the perfectscroll jQuery plugin\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/perfectScroll',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tmovedPos: false,\n\n\t\tinitialize: function() {\n\t\t\t/*\n\t\t\t * When we init the main view, init our perfectscroll\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'main' ), 'show:main', this.initPerfectScroll );\n\n\t\t\t/*\n\t\t\t * When our drawer opens and closes, change the position of our scroll rail.\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'opened', this.moveRail );\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'before:closeDrawer', this.resetRail );\n\t\t},\n\n\t\tinitPerfectScroll: function( view ) {\n\t\t\tif ( ! nfRadio.channel( 'app' ).request( 'is:mobile' ) ) {\n\t\t\t\tjQuery( view.el ).parent().perfectScrollbar( {\n\t\t\t\t\tsuppressScrollX: true\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tjQuery( 'head' ).append( '<style id=\"ps-scrollbar-css\" type=\"text/css\"></style>' );\n\t\t},\n\n\t\tmoveRail: function() {\n\t\t\tvar drawerEl = nfRadio.channel( 'app' ).request( 'get:drawerEl' );\n\t\t\tvar movedPos = jQuery( drawerEl ).outerWidth();\n\n\t\t\tjQuery( '#ps-scrollbar-css' ).text( '.ps-scrollbar-moved { right: ' + movedPos + 'px !important; } ' );\n\t\t\tjQuery( '#nf-main .ps-scrollbar-y-rail' ).addClass( 'ps-scrollbar-moved ' );\n\t\t\t\n\t\t},\n\n\t\tresetRail: function() {\n\t\t\tjQuery( '.ps-scrollbar-y-rail' ).removeClass( 'ps-scrollbar-moved ' );\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Returns a new setting group collection.\n * Used to settings drawers for custom data models (i.e. not fields, actions, or advanced)\n * \n * @package Ninja Forms builder\n * @subpackage App - Edit Settings Drawer\n * @copyright (c) 2016 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/getNewSettingGroupCollection',[ 'models/app/settingGroupCollection' ], function( SettingGroupCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Respond to requests for a new setting group collection\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:settingGroupCollectionDefinition', this.getNewSettingGroupCollection, this );\n\t\t},\n\n\t\t/**\n\t\t * Return a new instance of the setting group collection.\n\t\t *\n\t\t * @since  3.0\n\t\t * @return backbone.collection\n\t\t */\n\t\tgetNewSettingGroupCollection: function() {\n\t\t\treturn SettingGroupCollection;\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n *\n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2017 WP Ninjas\n * @since 3.0.30\n */\ndefine( 'controllers/app/settingMedia',[], function() {\n    var controller = Marionette.Object.extend( {\n        initialize: function() {\n            // When the media button is clicked, open the media manager.\n            this.listenTo( nfRadio.channel( 'setting-type-media' ), 'click:extra', this.clickExtra );\n        },\n\n        clickExtra: function( e, settingModel, dataModel, settingView ) {\n            var textEl = jQuery( e.target ).parent().find( '.setting' );\n\n            if ( jQuery( e.target ).hasClass( 'open-media-manager' ) ) {\n                // If the frame already exists, re-open it.\n                if ( this.meta_image_frame ) {\n                    this.meta_image_frame.open();\n                    return;\n                }\n\n                // Sets up the media library frame\n                this.meta_image_frame = wp.media.frames.meta_image_frame = wp.media({\n                    title: 'Select a file',\n                    button: { text:  'insert' }\n                });\n\n                var that = this;\n\n                // Runs when an image is selected.\n                this.meta_image_frame.on('select', function(){\n                    // Grabs the attachment selection and creates a JSON representation of the model.\n                    var media_attachment = that.meta_image_frame.state().get('selection').first().toJSON();\n                    textEl.val( media_attachment.url ).change();\n                });\n\n                // Opens the media library frame.\n                this.meta_image_frame.open();\n            }\n        },\n    });\n\n    return controller;\n} );\n","/**\n * Handles changing our public link when we request a new one or when it's set improperly.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2019 WP Ninjas\n * @since UPDATE_VERSION_ON_MERGE\n */\ndefine( 'controllers/app/publicLink',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'after:appStart', this.validatePublicLink, this );\n            nfRadio.channel( 'app' ).reply( 'generate:publicLinkKey', this.newPublicLinkKey, this );\n        },\n        \n        newPublicLinkKey: function() {\n            var formSettingsDataModel = nfRadio.channel( 'settings' ).request( 'get:settings' );\n            var public_link_key = nfRadio.channel('app').request('get:formModel').get('id');\n            for (var i = 0; i < 4; i++) {\n                var char = Math.random().toString(36).slice(-1);\n                public_link_key += char;\n            };\n            // Apply the public link key to form settings\n            formSettingsDataModel.set('public_link_key', public_link_key);\n            return public_link_key;\n        },\n\n        validatePublicLink: function() {\n            var formID = nfRadio.channel('app').request('get:formModel').get('id');\n            var formSettingsDataModel = nfRadio.channel( 'settings' ).request( 'get:settings' );\n            if ( 'undefined' === typeof formSettingsDataModel.get('public_link_key') ) return false;\n            if ( 0 === formSettingsDataModel.get( 'public_link_key' ).indexOf( formID ) ) return false;\n            var public_link_key = this.newPublicLinkKey();\n            var publicLink = nfAdmin.publicLinkStructure.replace('[FORM_ID]', public_link_key);\n            formSettingsDataModel.set('public_link', publicLink);\n        }\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Model that represents our field type section on the add new field drawer.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/fields/typeSectionModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\t\tdefaults: {\n\t\t\tclasses: ''\n\t\t}\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Collection that holds our field models.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/fields/typeSectionCollection',['models/fields/typeSectionModel'], function( typeSectionModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: typeSectionModel\n\t} );\n\treturn collection;\n} );\n","/**\n * Creates and stores a collection of field types. This includes all of the settings shown when editing a field.\n *\n * 1) Create our settings sections config\n * 2) Loops over our preloaded data and adds that to our field type collection\n *\n * Also responds to requests for data about field types\n *\n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/types',[\n\t\t'models/app/typeCollection',\n\t\t'models/fields/typeSectionCollection'\n\t],\n\tfunction(\n\t\tTypeCollection,\n\t\tSectionCollection\n\t) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Config for our settings sections\n\t\t\tthis.sections = new SectionCollection( fieldTypeSections );\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'init:typeModel', this.registerSection );\n\n\t\t\t// Create our field type collection\n\t\t\tthis.collection = new TypeCollection( fieldTypeData, { type: 'fields' } );\n\n\t\t\t// Respond to requests to get field type, collection, settings, and sections\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:type', this.getFieldType, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:typeCollection', this.getTypeCollection, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:typeSections', this.getTypeSections, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:savedFields', this.getSavedFields, this );\n\n\t\t\t// Listen to clicks on field types\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'click:fieldType', this.addField );\n\t\t},\n\n\t\tregisterSection: function( typeModel ) {\n\t\t\tif ( 'fields' != typeModel.collection.type || ! typeModel.get( 'section' ) ) return;\n\n\t\t\tthis.sections.get( typeModel.get( 'section' ) ).get( 'fieldTypes' ).push( typeModel.get( 'id' ) );\n\t\t},\n\n\t\t/**\n\t\t * Return a field type by id\n\t\t *\n\t\t * @since  3.0\n\t\t * @param  string \t\t\tid \tfield type\n\t\t * @return backbone.model    \tfield type model\n\t\t */\n\t\tgetFieldType: function( id ) {\n        \treturn this.collection.get( id );\n        },\n\n        /**\n         * Return the entire field type collection\n         *\n         * @since  3.0\n         * @param  string \t\t\t\tid \t[description]\n         * @return backbone.collection    \tfield type collection\n         */\n\t\tgetTypeCollection: function( id ) {\n        \treturn this.collection;\n        },\n\n        /**\n         * Add a field type to our fields sortable when the field type button is clicked.\n         *\n         * @since 3.0\n         * @param Object e event\n         * @return void\n         */\n        addField: function( e ) {\n\t\t\tvar type = jQuery( e.target ).data( 'id' );\n\n\t\t\tif( e.shiftKey ){\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'add:stagedField', type );\n\t\t\t\treturn;\n\t\t\t}\n\n        \tvar fieldModel = nfRadio.channel( 'fields' ).request( 'add', {\n\t\t\t\ttype: type,\n\n\t\t\t\tlabel: nfRadio.channel( 'fields' ).request( 'get:type', type ).get( 'nicename' )\n\t\t\t});\n\n\t\t\tconsole.log( fieldModel );\n\n\t\t\tvar label = {\n\t\t\t\tobject: 'Field',\n\t\t\t\tlabel: fieldModel.get( 'label' ),\n\t\t\t\tchange: 'Added',\n\t\t\t\tdashicon: 'plus-alt'\n\t\t\t};\n\n\t\t\tvar data = {\n\t\t\t\tcollection: nfRadio.channel( 'fields' ).request( 'get:collection' )\n\t\t\t}\n\n\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'addObject', fieldModel, null, label, data );\n\n\t\t\t// Re-Draw the Field Collection\n\t\t\tnfRadio.channel( 'fields' ).request( 'redraw:collection' );\n        },\n\n        /**\n         * Return our field type settings sections\n         *\n         * @since  3.0\n         * @return backbone.collection field type settings sections\n         */\n        getTypeSections: function() {\n            return this.sections;\n        },\n\n        /**\n         * Return our saved fields\n         *\n         * @since  3.0\n         * @return backbone.collection\n         */\n        getSavedFields: function() {\n        \tthis.sections.get( 'saved' );\n        }\n\t});\n\n\treturn controller;\n} );\n\n","/**\n * Handles the logic for our field type draggables.\n * \n * @package Ninja Forms builder\n * @subpackage Fields - New Field Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/fieldTypeDrag',[], function( ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Listen to our field type draggables and run the appropriate function.\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'startDrag:type', this.startDrag );\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'stopDrag:type', this.stopDrag );\n\t\t\t/*\n\t\t\t * Respond to requests for our helper clone.\n\t\t\t * This is used by other parts of the application to modify what the user is dragging in real-time.\n\t\t\t */ \n\t\t\tnfRadio.channel( 'drawer-addField' ).reply( 'get:typeHelperClone', this.getCurrentDraggableHelperClone, this );\n\t\t},\n\n\t\t/**\n\t\t * When we start dragging:\n\t\t * get our drawer element\n\t\t * set its overflow property to visible !important -> forces the type drag element to be on at the top of the z-index.\n\t\t * get our main element\n\t\t * est its overflow propery to visible !important -> forces the type drag element to be on top of the z-index.\n\t\t * set our dragging helper clone\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  object context \tThis function is going to be called from a draggable. Context is the \"this\" reference to the draggable.\n\t\t * @param  object ui      \tObject sent by jQuery UI draggable.\n\t\t * @return void\n\t\t */\n\t\tstartDrag: function( context, ui ) {\n\t\t\tthis.drawerEl = nfRadio.channel( 'app' ).request( 'get:drawerEl' );\n\t\t\tthis.mainEl = nfRadio.channel( 'app' ).request( 'get:mainEl' );\n\t\t\tjQuery( this.drawerEl )[0].style.setProperty( 'overflow', 'visible', 'important' );\n\n\t\t\tthis.draggableHelperClone = jQuery( ui.helper ).clone();\n\n\t\t},\n\n\t\t/**\n\t\t * When we stop dragging, reset our overflow property to hidden !important.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  object context \tThis function is going to be called from a draggable. Context is the \"this\" reference to the draggable.\n\t\t * @param  object ui      \tObject sent by jQuery UI draggable.\n\t\t * @return {[type]}         [description]\n\t\t */\n\t\tstopDrag: function( context, ui ) {\n\t\t\tjQuery( this.drawerEl )[0].style.setProperty( 'overflow', 'hidden', 'important' );\n\t\t},\n\n\t\tgetCurrentDraggableHelperClone: function() {\n\t\t\treturn this.draggableHelperClone;\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles the dragging of our field staging area\n * \n * @package Ninja Forms builder\n * @subpackage Fields - New Field Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/stagingDrag',[], function( ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Listen for the start and stop of our field staging dragging\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'startDrag:fieldStaging', this.startDrag );\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'stopDrag:fieldStaging', this.stopDrag );\n\t\t},\n\n\t\t/**\n\t\t * When the user starts dragging the staging area, we have to:\n\t\t * set the overflow property of the drawer to visible !important. If we don't, the button goes underneath the main section.\n\t\t * set the overflow proerty of the main to visible !important. If we don't, the dragged element goes underneath the drawer.\n\t\t * replace our helper with the stacked \"x fields\" template.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object\t context jQuery UI Draggable\n\t\t * @param  Object\t ui      jQuery UI element\n\t\t * @return void\n\t\t */\n\t\tstartDrag: function( context, ui ) {\n\t\t\tthis.drawerEl = nfRadio.channel( 'app' ).request( 'get:drawerEl' );\n\t\t\tthis.mainEl = nfRadio.channel( 'app' ).request( 'get:mainEl' );\n\t\t\tjQuery( this.drawerEl )[0].style.setProperty( 'overflow', 'visible', 'important' );\n\t\t\t// jQuery( this.mainEl )[0].style.setProperty( 'overflow', 'visible', 'important' );\n\n\t\t\tvar stagedFields = nfRadio.channel( 'fields' ).request( 'get:staging' );\n\t\t\tvar html = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-staged-fields-drag' );\n\t\t\tjQuery( ui.helper ).html( html( { num: stagedFields.models.length } ) );\n\t\t\tjQuery( ui.helper ).prop( 'id', 'nf-staged-fields-drag' );\n\t\t\tjQuery( ui.item ).css( 'opacity', '0.7' );\n\t\t},\n\n\t\t/**\n\t\t * When we stop dragging the staging area, we have to set the overflow property to hidden !important\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object\t context jQuery UI Draggable\n\t\t * @param  Object\t ui      jQuery UI element\n\t\t * @return void\n\t\t */\n\t\tstopDrag: function( context, ui ) {\n\t\t\tjQuery( this.drawerEl )[0].style.setProperty( 'overflow', 'hidden', 'important' );\n\t\t\t// jQuery( this.mainEl )[0].style.setProperty( 'overflow', 'hidden', 'important' );\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles most things related to our staging area:\n * 1) Creates a collection\n * 2) Listens for requests to CRUD items from the collection\n * 3) Adds our staged fields to the fields sortable when the drawer is closed\n * \n * @package Ninja Forms builder\n * @subpackage Fields - New Field Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/staging',['models/fields/stagingCollection'], function( stagingCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Create our staged fields collection\n\t\t\tthis.collection = new stagingCollection();\n\t\t\t// Respond to requests related to our staging area.\n\t\t    nfRadio.channel( 'fields' ).reply( 'add:stagedField', this.addStagedField, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'remove:stagedField', this.removeStagedField, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:staging', this.getStagingCollection, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'sort:staging', this.sortStagedFields, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'clear:staging', this.clearStagedFields, this );\n\t\t\t// Listen to our remove staged field click event.\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'click:removeStagedField', this.removeStagedField );\n\t\t\t// Listen to our event that fires just before a drawer is closed.\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'before:closeDrawer', this.beforeCloseDrawer );\n\t\t},\n\n\t\tgetStagingCollection: function() {\n\t\t\treturn this.collection;\n\t\t},\n\n\t\t/**\n\t\t * Add a field to our staging area\n\t\t * \n\t\t * @since 3.0\n\t\t * @param string type Type of field we're adding\n\t\t * @return tmpID\n\t\t */\n\t\taddStagedField: function( type, silent ) {\n\t\t\tvar silent = silent || false;\n\t\t\t// Get our type model from the string.\n\t\t\tvar fieldType = nfRadio.channel( 'fields' ).request( 'get:type', type );\n\t\t\t// If this isn't an installed field, don't add it.\n\t\t\tif('undefined' !== typeof fieldType.get('modal_content')) return false;\n\t\t\t// Our tmp ID is a string with the time appended to make it unique.\n\t\t\tvar tmpID = 'nf-staged-field-' + jQuery.now();\n\t\t\t// Object that will be added to our staging collection.\n\t\t\tvar data = {\n\t\t\t\tid: tmpID,\n\t\t\t\t// i.e. firstname, textbox, etc.\n\t\t\t\tslug: fieldType.get( 'type' ),\n\t\t\t\t// i.e. First Name, Textbox, etc.\n\t\t\t\tnicename: fieldType.get( 'nicename' ),\n\t\t\t\t// i.e. calendar, envelope, etc.\n\t\t\t\ticon: fieldType.get( 'icon' )\n\t\t\t}\n\t\t\t// \n\t\t\tvar model = this.collection.add( data );\n\n\t\t\tif( ! silent ) nfRadio.channel( 'fields').trigger( 'add:stagedField', model );\n\n\t\t\treturn tmpID;\n\t\t},\n\n\t\t/**\n\t\t * Remove a field from staging\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \t\t\te     \tEvent\n\t\t * @param  Backbone.model \tmodel \tstaged field model to remove\n\t\t * @return void\n\t\t */\n\t\tremoveStagedField: function( e, model ) {\n\t\t\tthis.collection.remove( model );\n\t\t\tnfRadio.channel( 'fields' ).trigger( 'remove:stagedField', model );\n\t\t},\n\n\t\t/**\n\t\t * Adds our staged fields to the main fields sortable before the drawer is closed.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tbeforeCloseDrawer: function() {\n\t\t\tif ( 0 != this.collection.models.length ) { // Make sure that we have models\n\t\t\t\t// Get our field collection.\n\t\t\t\tvar fieldCollection = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\n\t\t\t\tvar fields = [];\n\t\t\t\t// Loop through our staging collection\n\t\t\t\t_.each( this.collection.models, function( model ) {\n\t\t\t\t\t// Get a tmp ID for our new field.\n\t\t\t\t\tvar tmpID = nfRadio.channel( 'fields' ).request( 'get:tmpID' );\n\t\t\t\t\t// Create an object that can be added as a model.\n\t\t\t\t\tvar tmpField = { id: tmpID, label: model.get( 'nicename' ), type: model.get( 'slug' ) };\n\t\t\t\t\t// Add our new field.\n\t\t\t\t\tvar newModel = nfRadio.channel( 'fields' ).request( 'add',  tmpField, false );\n\t\t\t\t\t// Add our field addition to our change log.\n\t\t\t\t\tvar label = {\n\t\t\t\t\t\tobject: 'Field',\n\t\t\t\t\t\tlabel: newModel.get( 'label' ),\n\t\t\t\t\t\tchange: 'Added',\n\t\t\t\t\t\tdashicon: 'plus-alt'\n\t\t\t\t\t};\n\t\t\t\t\tvar data = {\n\t\t\t\t\t\tcollection: fieldCollection\n\t\t\t\t\t}\n\t\t\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'addObject', newModel, null, label, data );\n\t\t\t\n\t\t\t\t} );\n\t\t\t\t// Trigger a reset on our field collection so that our view re-renders\n\t\t\t\tfieldCollection.trigger( 'reset', fieldCollection );\n\t\t\t\t// Empty the staging collection\n\t\t\t\tthis.collection.reset();\n\t\t\t}\n\t\t\t// Sort our fields.\n\t\t\tnfRadio.channel( 'fields' ).request( 'sort:fields', null, null, false );\n\t\t},\n\n\t\t/**\n\t\t * Sort our staging area by the 'order' attribute.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tsortStagedFields: function() {\n\t\t\t// Get our staged fields sortable.\n\t\t\tvar sortableEl = nfRadio.channel( 'app' ).request( 'get:stagedFieldsEl' );\n\t\t\t// Get the current order using jQuery sortable. Will be an array of IDs: [tmp-blah, tmp-blah]\n\t\t\tvar order = jQuery( sortableEl ).sortable( 'toArray' );\n\t\t\t// Loop through our models\n\t\t\t_.each( this.collection.models, function( field ) {\n\t\t\t\t// Search our order array for this field.\n\t\t\t\tvar search = field.get( 'id' );\n\t\t\t\tvar pos = order.indexOf( search );\n\t\t\t\t// Update our staged field model with the new order.\n\t\t\t\tfield.set( 'order', pos );\n\t\t\t} );\n\t\t\t// Sort our staging collection.\n\t\t\tthis.collection.sort();\n\t\t},\n\n\t\tclearStagedFields: function() {\n\t\t\tthis.collection.reset();\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles actions related to our staged fields sortable.\n * \n * @package Ninja Forms builder\n * @subpackage Fields - New Field Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/stagingSortable',['models/fields/stagingCollection'], function( stagingCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Listen to our field type draggables\n\t\t\t// this.listenTo( nfRadio.channel( 'drawer-addField' ), 'startDrag:type', this.addActiveClass );\n\t\t\t// this.listenTo( nfRadio.channel( 'drawer-addField' ), 'stopDrag:type', this.removeActiveClass );\n\t\t\t// Listen to our sortable events\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'receive:stagedFields', this.receiveStagedFields );\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'over:stagedFields', this.overStagedFields );\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'out:stagedFields', this.outStagedFields );\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'start:stagedFields', this.startStagedFields );\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'stop:stagedFields', this.stopStagedFields );\n\t\t},\n\n\t\t/**\n\t\t * Change our dropped field type helper so that it matches the other items in our sortable.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \tui jQuery UI item\n\t\t * @return void\n\t\t */\n\t\treceiveStagedFields: function( ui ) {\n\t\t\tif( jQuery( ui.item ).hasClass( 'nf-field-type-draggable' ) ) {\n\t\t\t\tvar type = jQuery( ui.item ).data( 'id' );\n\t\t\t\tvar tmpID = nfRadio.channel( 'fields' ).request( 'add:stagedField', type );\n\t\t\t\tjQuery( ui.helper ).prop( 'id', tmpID );\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'sort:staging' );\n\t\t\t\tjQuery( ui.helper ).remove();\n\t\t\t\tnfRadio.channel( 'drawer-addField' ).trigger( 'drop:fieldType', type );\t\t\t\t\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Add an active class to our sortable when a field type item is dragged\n\t\t * \n\t\t * @since 3.0\n\t\t */\n\t\taddActiveClass: function() {\n\t\t\tvar stagedFieldsEl = nfRadio.channel( 'app' ).request( 'get:stagedFieldsEl' );\n\t\t\tjQuery( stagedFieldsEl ).addClass( 'nf-droppable-active' );\n\t\t},\n\n\t\t/**\n\t\t * Remove the active class from our sortable when the field type item is dropped.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tremoveActiveClass: function() {\n\t\t\tvar stagedFieldsEl = nfRadio.channel( 'app' ).request( 'get:stagedFieldsEl' );\n\t\t\tjQuery( stagedFieldsEl ).removeClass( 'nf-droppable-active' );\n\t\t},\n\n\t\t/**\n\t\t * When the field type item is dragged over our sortable, we change the helper to match the sortable items.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \te  event\n\t\t * @param  Object \tui jQuery UI Element\n\t\t * @return void\n\t\t */\n\t\toverStagedFields: function( e, ui ) {\n\t\t\tif( jQuery( ui.item ).hasClass( 'nf-field-type-draggable' ) ) {\n\t\t\t\tvar type = jQuery( ui.item ).data( 'id' );\n\t\t\t\tvar fieldType = nfRadio.channel( 'fields' ).request( 'get:type', type );\n\t\t\t\tvar nicename = fieldType.get( 'nicename' );\n\t\t\t\tthis.currentHelper = ui.helper \n\t\t\t\tjQuery( ui.helper ).html( nicename + '<span class=\"dashicons dashicons-dismiss\"></span>' );\n\t\t\t\tjQuery( ui.helper ).removeClass( 'nf-field-type-button' ).addClass( 'nf-item-dock' ).css( { 'opacity': '0.8', 'width': '', 'height': '' } );\n\t\t\t\tvar sortableEl = nfRadio.channel( 'app' ).request( 'get:stagedFieldsEl' );\n\t\t\t\tif ( jQuery( sortableEl ).hasClass( 'ui-sortable' ) ) {\n\t\t\t\t\tjQuery( sortableEl ).addClass( 'nf-droppable-hover' );\n\t\t\t\t}\n\t\t\t}\n\t\t\t\n\t\t},\n\n\t\t/**\n\t\t * When a field type item is moved away from our sortable, we change the helper to its previous appearance\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \tui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\toutStagedFields: function( ui ) {\n\t\t\tif( jQuery( ui.item ).hasClass( 'nf-field-type-draggable' ) ) {\n\t\t\t\tvar helperClone = nfRadio.channel( 'drawer-addField' ).request( 'get:typeHelperClone' );\t\n\t\t\t\tjQuery( this.currentHelper ).html( jQuery( helperClone ).html() );\n\t\t\t\tjQuery( this.currentHelper ).removeClass( 'nf-item-dock' ).addClass( 'nf-field-type-button' );\n\t\t\t\tvar sortableEl = nfRadio.channel( 'app' ).request( 'get:stagedFieldsEl' );\n\t\t\t\tif ( jQuery( sortableEl ).hasClass( 'ui-sortable' ) ) {\n\t\t\t\t\tjQuery( sortableEl ).removeClass( 'nf-droppable-hover' );\n\t\t\t\t}\n\t\t\t}\t\t\n\t\t},\n\n\t\t/**\n\t\t * When a user starts to drag a sortable item, we need to set a few properties on the item and the helper.\n\t\t * These keep the original item in place while dragging and changes the opacity of the helper.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object\t ui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\tstartStagedFields: function( ui ) {\n\t\t\tjQuery( ui.item ).show();\n\t\t\tjQuery( ui.item ).css( { 'display': 'inline', 'opacity': '0.7' } );\n\t\t\tjQuery( ui.helper ).css( 'opacity', '0.5' );\n\t\t},\n\n\t\t/**\n\t\t * When we stop dragging a sortable item, remove our opacity setting and remove the helper item.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object\t ui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\tstopStagedFields: function( ui ) {\n\t\t\tjQuery( ui.item ).css( 'opacity', '' );\n\t\t\tjQuery( ui.helper ).remove();\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Filters our field type collection.\n * \n * @package Ninja Forms builder\n * @subpackage Fields - New Field Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/filterTypes',['models/fields/typeSectionCollection'], function( fieldTypeSectionCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Define default values to be hidden from filtering.\n\t\t\tthis.hiddenFields = [\n\t\t\t\t'product',\n\t\t\t\t'quantity',\n\t\t\t\t'shipping',\n\t\t\t\t'total',\n\t\t\t\t'button'\n\t\t\t];\n\t\t\t// Listen for requests to hide fields.\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'add:hiddenFields', this.addHiddenFieldTypes );\n\t\t\t// Listen to our change filter event.\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'change:filter', this.filterFieldTypes );\n\t\t\t// Poll for additional fields to hide from the filter.\n\t\t\tnfRadio.channel( 'app' ).trigger( 'request:hiddenFields', this );\n\t\t},\n\n\t\t/**\n\t\t * Filter our field types in the add new field drawer\n\t\t * \n\t\t * Takes a search string and finds any field types that match either the name or alias.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  string\t search \tstring being searched for\n\t\t * @param  object \t e      \tKeyup event\n\t\t * @return void\n\t\t */\n\t\tfilterFieldTypes: function( search, e ) {\n\t\t\t// Make sure that we aren't dealing with an empty string.\n\t\t\tif ( '' != String(search).trim() ) {\n        \t\tvar filtered = [];\n        \t\t/**\n        \t\t * Call the function that actually filters our collection,\n        \t\t * and then loop through our collection, adding each model to our filtered array.\n        \t\t */\n        \t\t_.each( this.filterCollection( search ), function( model ) {\n        \t\t\tfiltered.push( model.get( 'id' ) );\n        \t\t} );\n\n        \t\t// Create a new Field Type Section collection with the filtered array.\n        \t\tvar filteredSectionCollection = new fieldTypeSectionCollection( [\n\t\t\t\t{ \n\t\t\t\t\tid: 'filtered',\n\t\t\t\t\tnicename: 'Filtered Fields',\n\t\t\t\t\tfieldTypes: filtered\n\t\t\t\t}\n\t\t\t\t] );\n\n                // Search our results of hidden fields.\n                for ( var i = filteredSectionCollection.models[ 0 ].get( 'fieldTypes' ).length -1; i >= 0; i-- ) {\n                    var target = this.hiddenFields.indexOf( filteredSectionCollection.models[ 0 ].get( 'fieldTypes' )[ i ] );\n                    // If we find any...\n                    if ( -1 < target ) {\n                        // Remove them from the collection.\n                        filteredSectionCollection.models[ 0 ].get( 'fieldTypes' ).splice( i, 1 );\n                    }\n                }\n\n        \t\t// Request that our field types filter be applied, passing the collection we created above.\n        \t\tnfRadio.channel( 'drawer' ).trigger( 'filter:fieldTypes', filteredSectionCollection );\n        \t\t// If we've pressed the 'enter' key, add the field to staging and clear the filter.\n        \t\tif ( 'undefined' != typeof e && e.addObject ) {\n        \t\t\tif ( 0 < filtered.length ) {\n        \t\t\t\tnfRadio.channel( 'fields' ).request( 'add:stagedField', filtered[0] );\n        \t\t\t\tnfRadio.channel( 'drawer' ).request( 'clear:filter' );\n        \t\t\t}\n        \t\t}\n        \t} else {\n        \t\t// Clear our filter if the search text is empty.\n        \t\tnfRadio.channel( 'drawer' ).trigger( 'clear:filter' );\n        \t}\n        },\n\n\t\t/**\n\t\t * Add requested fields to be hidden from the filter.\n\t\t * \n\t\t * @param array  fields  the list of fields to be hidden from the filter\n\t\t * @return false or void\n\t\t */\n\t\taddHiddenFieldTypes: function( fields ) {\n\t\t\tvar that = this;\n\t\t\t// Ensure we have an array.\n\t\t\tif( fields.constructor !== Array ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\t_.each( fields, function( field ){\n\t\t\t\tif( ! that.hiddenFields.includes( field ) ) {\n\t\t\t\t\tthat.hiddenFields.push( field );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n        /**\n         * Search our field type collection for the search string.\n         * \n         * @since  3.0\n         * @param  string\t search \tstring being searched for\n         * @return backbone.collection\n         */\n        filterCollection: function( search ) {\n        \tsearch = search.toLowerCase();\n        \t// Get our list of field types\n        \tvar collection = nfRadio.channel( 'fields' ).request( 'get:typeCollection' );\n        \t/*\n        \t * Backbone collections have a 'filter' method that loops through every model,\n        \t * waiting for you to return true or false. If you return true, the model is kept.\n        \t * If you return false, it's removed from the filtered result.\n        \t */\n\t\t\tvar filtered = collection.filter( function( model ) {\n\t\t\t\tvar found = false;\n\t\t\t\t\n\t\t\t\t// If we match either the ID or nicename, return true.\n\t\t\t\tif ( model.get( 'type' ).toLowerCase().indexOf( search ) != -1 ) {\n\t\t\t\t\tfound = true;\n\t\t\t\t} else if ( model.get( 'nicename' ).toLowerCase().indexOf( search ) != -1 ) {\n\t\t\t\t\tfound = true;\n\t\t\t\t}\n\n\t\t\t\t/*\n\t\t\t\t * TODO: Hashtag searching. Doesn't really do anything atm.\n\t\t\t\t */\n\t\t\t\tif ( model.get( 'tags' ) && 0 == search.indexOf( '#' ) ) {\n\t\t\t\t\t_.each( model.get( 'tags' ), function( tag ) {\n\t\t\t\t\t\tif ( search.replace( '#', '' ).length > 1 ) {\n\t\t\t\t\t\t\tif ( tag.toLowerCase().indexOf( search.replace( '#', '' ) ) != -1 ) {\n\t\t\t\t\t\t\t\tfound = true;\n\t\t\t\t\t\t\t}\t\t\t\t\t\t\t\n\t\t\t\t\t\t}\n\t\t\t\t\t} );\n\t\t\t\t}\n\n\t\t\t\t// If we match any of the aliases, return true.\n\t\t\t\tif ( model.get( 'alias' ) ) {\n\t\t\t\t\t_.each( model.get( 'alias' ), function( alias ) {\n\t\t\t\t\t\tif ( alias.toLowerCase().indexOf( search ) != -1 ) {\n\t\t\t\t\t\t\tfound = true;\n\t\t\t\t\t\t}\n\t\t\t\t\t} );\n\t\t\t\t}\n\n\t\t\t\treturn found;\n\t\t\t} );\n\t\t\t// Return our filtered collection.\n\t\t\treturn filtered;\n        }\n\t});\n\n\treturn controller;\n} );\n","define( 'views/fields/preview/element',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-field-input',\n\n\t\tinitialize: function() {\n\t\t\t\n\t\t\tvar type = this.model.get('type');\n\n\t\t\tthis.model.set('value', this.model.get('default'));\n\t\t\t\n\t\t\tif('date' == type && this.model.get('date_default')){\n\t\t\t\tvar format = this.model.get('date_format');\n\t\t\t\tif('default' == format || '' == format) format = this.convertDateFormat(nfAdmin.dateFormat);\n\t\t\t\tvar original = moment.locale();\n\t\t\t\tif( ! moment.locales().includes( 'ninja-forms' ) ) {\n\t\t\t\t\tmoment.defineLocale('ninja-forms', {\n\t\t\t\t\t\tmonths: nfi18n.months,\n\t\t\t\t\t\tmonthsShort: nfi18n.monthsShort,\n\t\t\t\t\t\tweekdays: nfi18n.weekdays,\n\t\t\t\t\t\tweekdaysShort: nfi18n.weekdaysShort,\n\t\t\t\t\t\tweekdaysMin: nfi18n.weekdaysMin\n\t\t\t\t\t} );\n\t\t\t\t}\n\t\t\t\tthis.model.set('value', moment().format(format) );\n\t\t\t\tmoment.locale(original);\n\t\t\t}\n\n\t\t\tif('phone' == type) type = 'tel';\n\t\t\tif('spam' == type) type = 'input';\n\t\t\t// if('date' == type) type = 'input';\n\t\t\tif('confirm' == type) type = 'input';\n\t\t\tif('password' == type) type = 'input';\n\t\t\tif('passwordconfirm' == type) type = 'input';\n\t\t\tif('quantity' == type) type = 'number';\n\t\t\tif('terms' == type) type = 'listcheckbox';\n\t\t\tif('liststate' == type) type = 'listselect';\n\t\t\tif('listcountry' == type) type = 'listselect';\n\t\t\tif('listmultiselect' == type) type = 'listselect';\n\t\t\tif('save' == type) type = 'submit';\n\n\t\t\t// If a builder-specific template exists for this type, use that.\n\t\t\tif ( 1 == jQuery( '#tmpl-nf-builder-field-' + type ).length ) {\n\t\t\t\tthis.template = '#tmpl-nf-builder-field-' + type;\n\t\t\t} else {\n\t\t\t\tthis.template = '#tmpl-nf-field-' + type;\n\t\t\t}\t\t\t\n\t\t},\n\n\t\tonRender: function() {\n\t\t\tif(this.model.get('container_class').includes('two-col-list')) {\n\t\t\t\tjQuery(this.el).find('> ul').css('display', 'grid');\n\t\t\t\tjQuery(this.el).find('> ul').css('grid-template-columns', 'repeat(2, 1fr)');\n\t\t\t}\n\t\t\tif(this.model.get('container_class').includes('three-col-list')) {\n\t\t\t\tjQuery(this.el).find('> ul').css('display', 'grid');\n\t\t\t\tjQuery(this.el).find('> ul').css('grid-template-columns', 'repeat(3, 1fr)');\n\t\t\t}\n\t\t\tif(this.model.get('container_class').includes('four-col-list')) {\n\t\t\t\tjQuery(this.el).find('> ul').css('display', 'grid');\n\t\t\t\tjQuery(this.el).find('> ul').css('grid-template-columns', 'repeat(4, 1fr)');\n\t\t\t}\n\t\t},\n        \n\t\ttemplateHelpers: function () {\n\t    \treturn {\n\t    \t\trenderClasses: function() {\n\t    \t\t\t// ...\n                },\n\t\t\t\tmaybeFilterHTML: function()  {\n\t\t\t\t\treturn typeof nfAdmin.filter_esc_status !== \"undefined\" ? nfAdmin.filter_esc_status : \"false\";\n\t\t\t\t},\n                renderPlaceholder: function() {\n                    if('undefined' == typeof this.placeholder) return;\n\t\t\t\t\treturn 'placeholder=\"' + String( _.escape( this.placeholder ) ).trim() + '\"';\n                },\n                maybeDisabled: function() {\n                    if('undefined' == typeof this.disable_input) return;\n                    if(!this.disable_input) return;\n                    return 'disabled=\"disabled\"';\n                },\n                maybeRequired: function() {\n\t\t\t\t\t// ...\n\t\t\t\t},\n\t\t\t\tmaybeInputLimit: function() {\n\t\t\t\t\t// ...\n\t\t\t\t},\n\t\t\t\tmaybeDisableAutocomplete: function() {\n\t\t\t\t\tif ( 1 == this.disable_browser_autocomplete ) {\n\t\t\t\t\t\treturn 'autocomplete=\"off\"';\n\t\t\t\t\t} else if ( this.custom_autocomplete && this.custom_autocomplete.trim() !== '' ) {\n\t\t\t\t\t\treturn 'autocomplete=\"' + this.custom_autocomplete.trim() + '\"';\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn 'autocomplete=\"on\"';\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tmaybeChecked: function() {\n\t\t\t\t\tif('checked' == this.default_value) return ' checked=\"checked\"';\n\t\t\t\t},\n\t\t\t\trenderOptions: function() {\n\t\t\t\t\tlet optionLabel;\n\t\t\t\t\tswitch(this.type) {\n\t\t\t\t\t\tcase 'terms':\n\n\t\t\t\t\t\t\tif( ! this.taxonomy ){\n\t\t\t\t\t\t\t\treturn '(No taxonomy selected)';\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tvar taxonomyTerms = fieldTypeData.find(function(typeData){\n\t\t\t\t\t\t\t\treturn 'terms' == typeData.id;\n\t\t\t\t\t\t\t}).settingGroups.find(function(settingGroup){\n\t\t\t\t\t\t\t\treturn 'primary' == settingGroup.id;\n\t\t\t\t\t\t\t}).settings.find(function(setting){\n\t\t\t\t\t\t\t\treturn 'taxonomy_terms' == setting.name;\n\t\t\t\t\t\t\t}).settings;\n\n\t\t\t\t\t\t\tvar attributes = Object.keys(this);\n\t\t\t\t\t\t\tvar enabledTaxonomyTerms = attributes.filter(function(attribute){\n\t\t\t\t\t\t\t\treturn 0 == attribute.indexOf('taxonomy_term_') && this[attribute];\n\t\t\t\t\t\t\t}.bind(this));\n\n\t\t\t\t\t\t\tif(0 == enabledTaxonomyTerms.length) {\n\t\t\t\t\t\t\t\treturn '(No available terms selected)';\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn enabledTaxonomyTerms.reduce(function(html, enabledTaxonomyTerm) {\n\t\t\t\t\t\t\t\tvar term = taxonomyTerms.find(function(terms){\n\t\t\t\t\t\t\t\t\treturn enabledTaxonomyTerm == terms.name;\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\tif( 'undefined' == typeof term ) return html;\n\t\t\t\t\t\t\t\treturn html += '<li><input type=\"checkbox\"><div>' + term.label  + '</div></li>';\n\t\t\t\t\t\t\t}.bind(this), '');\n\t\t\t\t\t\tcase 'liststate':\n\t\t\t\t\t\tcase 'listselect':\n\n\t\t\t\t\t\t\t// Check if there are any options.\n\t\t\t\t\t\t\tif(0 == this.options.models.length) return '';\n\n\t\t\t\t\t\t\t// Filter by :selected\" options.\n\t\t\t\t\t\t\tvar options = this.options.models.filter(function(option){\n\t\t\t\t\t\t\t\treturn option.get('selected');\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t// If no option set as \"selected\", then reset the previous filter.\n\t\t\t\t\t\t\tif(0 == options.length) options = this.options.models;\n\n\t\t\t\t\t\t\t// Set the first option to display in the field preview.\n\t\t\t\t\t\t\toptionLabel = (typeof nfAdmin.filter_esc_status !== \"undefined\" && nfAdmin.filter_esc_status === \"true\") ? _.escape(options[0].get('label')) : options[0].get('label'); \n\t\t\t\t\t\t\treturn '<option>' + optionLabel + '</option>';\n\t\t\t\t\t\tcase 'listmultiselect':\n\t\t\t\t\t\t\treturn this.options.models.reduce(function(html, option) {\n\t\t\t\t\t\t\t\toptionLabel = (typeof nfAdmin.filter_esc_status !== \"undefined\" && nfAdmin.filter_esc_status === \"true\") ? _.escape(option.get('label')) : option.get('label'); \n\t\t\t\t\t\t\t\tvar selected = (option.get('selected')) ? ' selected=\"selected\"' : '';\n\t\t\t\t\t\t\t\treturn html += '<option' + selected + '>' + optionLabel + '</option>';\n\t\t\t\t\t\t\t}, '');\n\t\t\t\t\t\tcase 'listcheckbox':\n\t\t\t\t\t\t\treturn this.options.models.reduce(function(html, option) {\n\t\t\t\t\t\t\t\toptionLabel = (typeof nfAdmin.filter_esc_status !== \"undefined\" && nfAdmin.filter_esc_status === \"true\") ? _.escape(option.get('label')) : option.get('label'); \n\t\t\t\t\t\t\t\tvar checked = (option.get('selected')) ? ' checked=\"checked\"' : '';\n\t\t\t\t\t\t\t\treturn html += '<li><input type=\"checkbox\"' + checked + '><div>' + optionLabel + '</div></li>';\n\t\t\t\t\t\t\t}, '');\n\t\t\t\t\t\tcase 'listradio':\n\t\t\t\t\t\t\tvar checked = false; // External flag to only select one radio item.\n\t\t\t\t\t\t\treturn this.options.models.reduce(function(html, option) {\n\t\t\t\t\t\t\t\toptionLabel = (typeof nfAdmin.filter_esc_status !== \"undefined\" && nfAdmin.filter_esc_status === \"true\") ? _.escape(option.get('label')) : option.get('label'); \n\t\t\t\t\t\t\t\tchecked = (option.get('selected') && !checked) ? ' checked=\"checked\"' : '';\n\t\t\t\t\t\t\t\treturn html += '<li><input type=\"radio\"' + checked + '><div>' + optionLabel   + '</div></li>';\n\t\t\t\t\t\t\t}, '');\n\t\t\t\t\t\tcase 'listcountry':\n\t\t\t\t\t\t\tvar defaultValue = this.default;\n\t\t\t\t\t\t\tvar defaultOption = fieldTypeData.find(function(data) {\n\t\t\t\t\t\t\t\treturn 'listcountry' == data.id;\n\t\t\t\t\t\t\t}).settingGroups.find(function(group){\n\t\t\t\t\t\t\t\treturn 'primary' == group.id;\n\t\t\t\t\t\t\t}).settings.find(function(setting){\n\t\t\t\t\t\t\t\treturn 'default' == setting.name;\n\t\t\t\t\t\t\t}).options.find(function(option) {\n\t\t\t\t\t\t\t\treturn defaultValue == option.value;\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\toptionLabel = ('undefined' !== typeof defaultOption ) ? defaultOption.label : '--';\n\t\t\t\t\t\t\toptionLabel = (typeof nfAdmin.filter_esc_status !== \"undefined\" && nfAdmin.filter_esc_status === \"true\") ? _.escape(optionLabel ) : optionLabel; \n\t\t\t\t\t\t\treturn '<option>' + optionLabel + '</option>';\n\t\t\t\t\t\tdefault:\n\t\t\t\t\t\t\treturn '';\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\trenderOtherAttributes: function() {\n\t\t\t\t\tvar attributes = [];\n\t\t\t\t\tif('listmultiselect' == this.type) {\n\t\t\t\t\t\tattributes.push('multiple');\n\n\t\t\t\t\t\tvar multi_size = this.multi_size || '5';\n\t\t\t\t\t\tattributes.push('size=\"' + multi_size + '\"');\n\t\t\t\t\t}\n\n\t\t\t\t\treturn attributes.join(' ');\n\t\t\t\t},\n\t\t\t\trenderProduct: function() {\n\t\t\t\t\t// ...\n\t\t\t\t},\n\t\t\t\trenderNumberDefault: function() {\n\t\t\t\t\treturn this.value;\n\t\t\t\t},\n\t\t\t\trenderCurrencyFormatting: function() {\n\t\t\t\t\t// ...\n\t\t\t\t},\n\t\t\t\trenderRatings: function() {\n\t\t\t\t\tvar ratingOutput = '';\n\t\t\t\t\tfor (var i = 0; i < this.number_of_stars; i++) {\n\t\t\t\t\t\tratingOutput += '<i class=\"fa fa-star\" aria-hidden=\"true\"></i>&nbsp;';\n\t\t\t\t\t  }\n\t\t\t\t\treturn ratingOutput;\n\t\t\t\t},\n\t\t\t\trenderHourOptions: function() {\n            html = '';\n            let hours = 12;\n\n            if ( 'undefined' != typeof this.hours_24 && 1 == this.hours_24 ) {\n                hours = 24;\n            }\n\n            for (var i = 0; i < hours; i++) {\n                let value = label = i;\n\n                if ( i < 10 ) {\n                    value = label = '0' + i;\n                }\n                html += '<option value=\"' + value + '\">' + label + '</option>';\n                i = i++;\n            }\n\n            return html;\n        },\n\n        renderMinuteOptions: function() {\n            var html = '';\n            let minute_increment = 5;\n\n            if ( 'undefined' != typeof this.minute_increment ) {\n                minute_increment = this.minute_increment;\n            }\n\n            let i = 0;\n\t\t\t\n            while( i.toString().length <= 2 && i < 60 ) {\n                let value = label = i;\n\n                if ( i < 10 ) {\n                    value = label = '0' + i;\n                }\n                html += '<option value=\"' + value + '\">' + label + '</option>';\n                i = i + minute_increment;\n            }\n\n            return html;\n        },\n\n        maybeRenderAMPM: function() {\n            if ( 'undefined' == typeof this.hours_24 || 1 == this.hours_24 ) {\n                return;\n            }\n\n            return '<div style=\"float:left;\"><select class=\"ampm\" style=\"float:left;\"><option value=\"am\">AM</option><option value=\"pm\">PM</option></select></div>'\n        },\n        \t\t\t\tmaybeRenderTime: function() {\n\t\t\t\t\tif ( 'time_only' == this.date_mode || 'date_and_time' == this.date_mode ) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\t\t\t\t\treturn false;\n\t\t\t\t},\n\n            }\n\t\t},\n\t\t\n        convertDateFormat: function( dateFormat ) {\n            // http://php.net/manual/en/function.date.php\n            // https://github.com/dbushell/Pikaday/blob/master/README.md#formatting\n            // Note: Be careful not to add overriding replacements. Order is important here.\n\n            /** Day */\n            dateFormat = dateFormat.replace( 'D', 'ddd' ); // @todo Ordering issue?\n            dateFormat = dateFormat.replace( 'd', 'DD' );\n            dateFormat = dateFormat.replace( 'l', 'dddd' );\n            dateFormat = dateFormat.replace( 'j', 'D' );\n            dateFormat = dateFormat.replace( 'N', '' ); // Not Supported\n            dateFormat = dateFormat.replace( 'S', '' ); // Not Supported\n            dateFormat = dateFormat.replace( 'w', 'd' );\n            dateFormat = dateFormat.replace( 'z', '' ); // Not Supported\n\n            /** Week */\n            dateFormat = dateFormat.replace( 'W', 'W' );\n\n            /** Month */\n            dateFormat = dateFormat.replace( 'M', 'MMM' ); // \"M\" before \"F\" or \"m\" to avoid overriding.\n            dateFormat = dateFormat.replace( 'F', 'MMMM' );\n            dateFormat = dateFormat.replace( 'm', 'MM' );\n            dateFormat = dateFormat.replace( 'n', 'M' );\n            dateFormat = dateFormat.replace( 't', '' );  // Not Supported\n\n            // Year\n            dateFormat = dateFormat.replace( 'L', '' ); // Not Supported\n            dateFormat = dateFormat.replace( 'o', 'YYYY' );\n            dateFormat = dateFormat.replace( 'Y', 'YYYY' );\n            dateFormat = dateFormat.replace( 'y', 'YY' );\n\n            // Time - Not supported\n            dateFormat = dateFormat.replace( 'a', '' );\n            dateFormat = dateFormat.replace( 'A', '' );\n            dateFormat = dateFormat.replace( 'B', '' );\n            dateFormat = dateFormat.replace( 'g', '' );\n            dateFormat = dateFormat.replace( 'G', '' );\n            dateFormat = dateFormat.replace( 'h', '' );\n            dateFormat = dateFormat.replace( 'H', '' );\n            dateFormat = dateFormat.replace( 'i', '' );\n            dateFormat = dateFormat.replace( 's', '' );\n            dateFormat = dateFormat.replace( 'u', '' );\n            dateFormat = dateFormat.replace( 'v', '' );\n\n            // Timezone - Not supported\n            dateFormat = dateFormat.replace( 'e', '' );\n            dateFormat = dateFormat.replace( 'I', '' );\n            dateFormat = dateFormat.replace( 'O', '' );\n            dateFormat = dateFormat.replace( 'P', '' );\n            dateFormat = dateFormat.replace( 'T', '' );\n            dateFormat = dateFormat.replace( 'Z', '' );\n\n            // Full Date/Time - Not Supported\n            dateFormat = dateFormat.replace( 'c', '' );\n            dateFormat = dateFormat.replace( 'r', '' );\n            dateFormat = dateFormat.replace( 'u', '' );\n\n            return dateFormat;\n        }\n\n\t});\n\n\treturn view;\n} );\n","/**\n * This is a copy of the 'views/fields/mainContentEmpty.js' file.\n * It is also the file that handles dropping new field types on our repeater field.\n * \n */\n\ndefine( 'views/fields/preview/repeaterElementEmpty',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-repeater-content-fields-empty',\n\n\t\tinitialize: function( data ) {\n\t\t\tthis.repeaterFieldModel = data.repeaterFieldModel;\n\t\t},\n\n\t\tonBeforeDestroy: function() {\n\t\t\tjQuery( this.el ).parent().removeClass( 'nf-fields-empty-droppable' ).droppable( 'destroy' );\n\t\t},\n\n\t\tonRender: function() {\n\t\t\tthis.$el = this.$el.children();\n\t\t\tthis.$el.unwrap();\n\t\t\tthis.setElement( this.$el );\n\t\t},\n\n\t\tonShow: function() {\n\t\t\tif ( jQuery( this.el ).parent().hasClass( 'ui-sortable' ) ) {\n\t\t\t\tjQuery( this.el ).parent().sortable( 'destroy' );\n\t\t\t}\n\t\t\tjQuery( this.el ).parent().addClass( 'nf-fields-empty-droppable' );\n\t\t\tlet that = this;\n\t\t\tjQuery( this.el ).parent().droppable( {\n\t\t\t\taccept: function( draggable ) {\n\t\t\t\t\tif ( jQuery( draggable ).hasClass( 'nf-stage' ) || jQuery( draggable ).hasClass( 'nf-field-type-button' ) ) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tactiveClass: 'nf-droppable-active',\n\t\t\t\thoverClass: 'nf-droppable-hover',\n\t\t\t\ttolerance: 'pointer',\n\n\t\t\t\tover: function( e, ui ) {\t\n\t\t\t\t\t\n\t\t\t\t\tui.item = ui.draggable;\n\t\t\t\t\tjQuery(ui.item).addClass(\"nf-over-repeater\");\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'over:fieldsSortable', ui );\n\t\t\t\t},\n\t\t\t\tout: function( e, ui ) {\n\t\t\t\t\n\t\t\t\t\tui.item = ui.draggable;\n\t\t\t\t\tjQuery(ui.item).removeClass(\"nf-over-repeater\");\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'out:fieldsSortable', ui );\n\t\t\t\t},\n\t\t\t\t/**\n\t\t\t\t * Handles the dropping of items into our EMPTY repeater field.\n\t\t\t\t * \n\t\t\t\t */\n\t\t\t\tdrop: function( e, ui ) {\n\t\t\t\t\tui.item = null != ui.item ? ui.item : ui.draggable;\n\t\t\t\t\tnfRadio.channel( 'fields-repeater' ).request( 'add:childField', ui, that, e );\n\t\t\t\t},\n\t\t\t} );\n\t\t}\n\t});\n\n\treturn view;\n} );\n","/**\n * Collection View that outputs our repeater field collection to the screen.\n */\ndefine( 'views/fields/preview/repeaterElementCollection',[ 'views/fields/preview/repeaterElementEmpty' ], function( emptyView ) {\n\tvar view = Marionette.CollectionView.extend( {\n\t\ttagName: 'div',\n\t\temptyView: emptyView,\n\n\t\tgetChildView: function() {\n\t\t\tlet view = nfRadio.channel( 'views' ).request( 'get:fieldItem' );\n\t\t\treturn view;\n\t\t},\n\n\t\tinitialize: function( data ) {\n\t\t\tthis.emptyViewOptions = {\n\t\t\t\trepeaterFieldModel: data.repeaterFieldModel,\n\t\t\t};\n\t\t\tthis.repeaterFieldModel = data.repeaterFieldModel;\n\n\t\t\tnfRadio.channel( 'fields-repeater' ).reply( 'init:sortable', this.initSortable, this );\n\t\t\tnfRadio.channel( 'fields-repeater' ).reply( 'get:sortableEl', this.getSortableEl, this );\n\t\t\tnfRadio.channel( 'fields-repeater' ).reply( 'get:repeaterFieldsCollection', this.getRepeaterFieldsCollection, this );\n\t\t},\n\n\t\tonRender: function() {\n\t\t\tif ( this.collection.models.length > 0 ) {\n\t\t\t\tjQuery( this.el ).addClass( 'nf-field-type-droppable' );\n\t\t\t\tvar that = this;\n\t\t\t\tthis.initSortable();\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * This sortable is a copy with modifications of the main field list sortable.\n\t\t * \n\t\t * @since  version\n\t\t * @return {[type]} [description]\n\t\t */\n\t\tinitSortable: function() {\n\t\t\t// If the sortable has already been instantiated, return early.\n\t\t\tif ( 'undefined' != typeof jQuery( this.el ).sortable( 'instance' ) ) return false;\n\n\t\t\tjQuery( this.el ).addClass( 'nf-field-type-droppable' ).addClass( 'nf-fields-sortable' );\n\n\t\t\tlet that = this;\n\t\t\tjQuery( this.el ).sortable( {\n\t\t\t\tcontainment: 'parent',\n\t\t\t\thelper: 'clone',\n\t\t\t\tcancel: '.nf-item-controls',\n\t\t\t\tplaceholder: 'nf-fields-sortable-placeholder',\n\t\t\t\topacity: 0.95,\n\t\t\t\tgrid: [ 5, 5 ],\n\t\t\t\tappendTo: '#nf-main',\n\t\t\t\tscrollSensitivity: 10,\n\t\t\t\t//connectWith would allow drag and drop between fields already in the builder and the repeatable fieldset ( this is currently an issue until we deal with existing data stored)\n\t\t\t\t//connectWith: '.nf-fields-sortable', \n\n\t\t\t\treceive: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'fields-repeater' ).request( 'receive:fields', ui, that, e );\n\t\t\t\t},\n\n\t\t\t\tover: function( e, ui ) {\n\t\t\t\t\tjQuery(ui.item).addClass(\"nf-over-repeater\");\n\t\t\t\t\tif ( ui.item.dropping ) return;\n\t\t\t\t\tnfRadio.channel( 'fields-repeater' ).request( 'over:repeaterField', ui, that, e );\n\t\t\t\t},\n\n\t\t\t\tout: function( e, ui ) {\n\t\t\t\t\tjQuery(ui.item).removeClass(\"nf-over-repeater\");\n\t\t\t\t\tif ( ui.item.dropping ) return;\n\t\t\t\t\tnfRadio.channel( 'fields-repeater' ).request( 'out:repeaterField', ui, that, e );\n\t\t\t\t},\n\n\t\t\t\tstart: function( e, ui ) {\n\t\t\t\t\tif ( ui.item.dropping ) return;\n\t\t\t\t\tnfRadio.channel( 'fields-repeater' ).request( 'start:repeaterField', ui, that, e );\n\t\t\t\t},\n\n\t\t\t\tremove: function( e, ui ) {\n\t\t\t\t\t// The field is removed from repeater Fields collection and a new one is created for main Fields collection from controllers/fields/sortable/js\n\t\t\t\t\tlet droppedFieldID = jQuery( ui.item ).data( 'id' );\n\t\t\t\t\tlet collection = that.repeaterFieldModel.get( 'fields' );\n\t\t\t\t\tlet droppedFieldModel = collection.get( droppedFieldID );\n\t\t\t\t\t\n\t\t\t\t\t// Remove the field from the repeater field collection making sure we alert the user the field data is being deleted\n\t\t\t\t\tnfRadio.channel( 'app' ).trigger( 'click:delete', e, droppedFieldModel );\n\t\t\t\t},\n\t\t\t\t\n\t\t\t\t// When we update the sort order of our repeater field children, run our sort function.\n\t\t\t\tupdate: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'fields-repeater' ).request( 'update:repeaterField', ui, that, e );\n\t\t\t\t},\n\n\t\t\t\tstop: function( e, ui ) {\n\t\t\t\t\tif ( ui.item.dropping ) return;\n\t\t\t\t\tnfRadio.channel( 'fields-repeater' ).request( 'stop:repeaterField', ui, that, e );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tdestroySortable: function() {\n\t\t\tjQuery( this.el ).sortable( 'destroy' );\n\t\t},\n\n\t\t/**\n\t\t * When we add our first child, we need to init the sortable.\n\t\t * \n\t\t * @since  version\n\t\t * @param  {[type]} childView [description]\n\t\t * @return {[type]}           [description]\n\t\t */\n\t\tonAddChild: function( childView ) {\n\t\t\tif ( nfRadio.channel( 'fields' ).request( 'get:adding' ) ) {\n\t\t\t\tchildView.$el.hide().show( 'clip' );\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'set:adding', false);\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Get Element holding child fields\n\t\t */\n\t\tgetSortableEl: function() {\n\t\t\treturn this.el;\n\t\t},\n\n\t\t/**\n\t\t * Getter for the repeater Fields collection\n\t\t */\n\t\tgetRepeaterFieldsCollection: function() {\n\t\t\treturn this.repeaterFieldModel.get( 'fields' );\n\t\t}\n\t\t\n\t} );\n\n\treturn view;\n} );\n\n","define( 'views/fields/preview/repeaterElementLayout',[ 'views/fields/preview/repeaterElementCollection' ], function( previewRepeaterElementCollectionView ) {\n\tvar view = Marionette.LayoutView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-field-repeater',\n\n\t\tregions: {\n\t\t\tfields: '.nf-repeater-fieldsets',\n\t\t},\n\n\t\tinitialize: function( data ) {\n\t\t\tthis.collection = data.collection;\n\t\t\tthis.model = data.model;\n\t\t},\n\n\t\tonRender: function() {\n\t\t\t// Populate the fields region with our collection view.\n\t\t\tthis.fields.show( new previewRepeaterElementCollectionView( { collection: this.collection, repeaterFieldModel: this.model } ) );\n\t\t},\n\n\t\ttemplateHelpers: function() {\n\t\t\treturn {\n\t\t\t\tmaybeFilterHTML: function()  {\n\t\t\t\t\treturn typeof nfAdmin.filter_esc_status !== \"undefined\" ? nfAdmin.filter_esc_status : \"false\";\n\t\t\t\t},\n\t\t\t\trenderDescText: function() {\n\t\t\t\t\t// ...\n\t\t\t\t},\n\t\t\t}\n\t\t},\n\t});\n\n\treturn view;\n} );\n","define( 'views/fields/preview/label',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-field-label',\n\n\t\tinitialize: function( data ) {\n\t\t\t// this.$el = jQuery( data.itemView.el ).find( '.nf-realistic-field--label' );\n\t\t},\n\n\t\tonRender: function() {\n\t\t\t// ...\n\t\t\t// console.log( jQuery( this.$el ) );\n\t\t},\n        \n\t\ttemplateHelpers: function () {\n\t    \treturn {\n\t    \t\trenderLabelClasses: function() {\n                    // ...\n                },\n\t\t\t\tmaybeFilterHTML: function()  {\n\t\t\t\t\treturn typeof nfAdmin.filter_esc_status !== \"undefined\" ? nfAdmin.filter_esc_status : \"false\";\n\t\t\t\t},\n                maybeRenderHelp: function() {\n                    // ...\n                }\n            }\n        }\n\n\t});\n\n\treturn view;\n} );\n","define( 'views/fields/fieldItem',['views/app/itemControls', 'views/fields/preview/element', 'views/fields/preview/repeaterElementLayout', 'views/fields/preview/label'], function( itemControlsView, previewElementView, previewRepeaterElementView, previewLabelView ) {\n\tvar view = Marionette.LayoutView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-main-content-field',\n\t\tdoingShortcut: false,\n\n\t\tregions: {\n\t\t\titemControls: '.nf-item-controls',\n\t\t\tpreviewLabel: '.nf-realistic-field--label',\n\t\t\tpreviewElement: '.nf-realistic-field--element',\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\tthis.model.on( 'change:editActive', this.render, this );\n\t\t\tthis.model.on( 'change:label', this.render, this );\n\t\t\tthis.model.on( 'change:required', this.render, this );\n\t\t\tthis.model.on( 'change:id', this.render, this );\n\t\t},\n\n\t\tonBeforeDestroy: function() {\n\t\t\tthis.model.off( 'change:editActive', this.render );\n\t\t\tthis.model.off( 'change:label', this.render );\n\t\t\tthis.model.off( 'change:required', this.render );\n\t\t\tthis.model.off( 'change:id', this.render );\n\t\t},\n\n\t\tonRender: function() {\n\t\t\tthis.$el = this.$el.children();\n\t\t\tthis.$el.unwrap();\n\t\t\tthis.setElement( this.$el );\n\n\t\t\tthis.itemControls.show( new itemControlsView( { model: this.model } ) );\n\t\t\tjQuery( this.el ).disableSelection();\n\n\t\t\tvar type = this.model.get('type');\n\t\t\tif('phone' == type) type = 'tel';\n\t\t\tif('spam' == type) type = 'input';\n\t\t\t// if('date' == type) type = 'input';\n\t\t\tif('confirm' == type) type = 'input';\n\t\t\tif('password' == type) type = 'input';\n\t\t\tif('passwordconfirm' == type) type = 'input';\n\t\t\tif('quantity' == type) type = 'number';\n\t\t\tif('terms' == type) type = 'listcheckbox';\n\t\t\tif('liststate' == type) type = 'listselect';\n\t\t\tif('listcountry' == type) type = 'listselect';\n\t\t\tif('listmultiselect' == type) type = 'listselect';\n\t\t\tif('save' == type) type = 'submit';\n\n\t\t\t// Only show preview / realisitic fields when not `html`, `hidden`, `note`, or `recaptcha`.\n\t\t\tvar previewFieldTypeBlacklist = ['html', 'hidden', 'note', 'recaptcha'];\n\t\t\tvar isFieldTypeTemplateAvailable = jQuery('#tmpl-nf-field-' + type).length;\n\t\t\tif(-1 == previewFieldTypeBlacklist.indexOf(this.model.get('type')) && isFieldTypeTemplateAvailable) {\n\t\t\t\t\n\t\t\t\t// If we have a repeater field, then we have to load a specific collection view.\n\t\t\t\tif ( 'repeater' == type ) {\n\t\t\t\t\tthis.previewElement.show( new previewRepeaterElementView( { collection: this.model.get( 'fields' ), model: this.model } ) );\n\t\t\t\t} else {\n\t\t\t\t\tthis.previewElement.show( new previewElementView( { model: this.model } ) );\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\t// Only show the preview label when not `submit`, or `hr`.\n\t\t\t\tvar showLabelFieldTypeBlacklist = ['submit', 'save', 'hr'];\n\t\t\t\tif(-1 == showLabelFieldTypeBlacklist.indexOf(this.model.get('type'))) {\n\t\t\t\t\tthis.previewLabel.show( new previewLabelView( { model: this.model, itemView: this } ) );\n\t\t\t\t}\n\n\t\t\t\tjQuery( this.el ).find('.nf-placeholder-label').hide();\n\t\t\t}\n\n\t\t\tif ( nfRadio.channel( 'app' ).request( 'is:mobile' ) ) {\n\t\t\t\tjQuery( this.el ).on( 'taphold', function( e, touch ) {\n\t\t\t\t\tif ( ! jQuery( e.target ).hasClass( 'nf-edit-settings' ) ) {\n\t\t\t\t\t\tjQuery( this ).addClass( 'ui-sortable-helper drag-selected' );\n\t\t\t\t\t\tjQuery( this ).ClassyWiggle( 'start', { degrees: ['.65', '1', '.65', '0', '-.65', '-1', '-.65', '0'], delay: 50 } );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tnfRadio.channel( 'fields-' + type ).trigger( 'render:itemView', this );\n\t\t},\n\n\t\ttemplateHelpers: function () {\n\t    \treturn {\n\t    \t\trenderClasses: function() {\n\t    \t\t\tvar classes = 'nf-field-wrap ' + this.type;\n\t    \t\t\tif ( this.editActive ) {\n\t    \t\t\t\tclasses += ' active';\n\t    \t\t\t}\n\t    \t\t\treturn classes;\n\t    \t\t},\n\t\t\t\tmaybeFilterHTML: function()  {\n\t\t\t\t\treturn typeof nfAdmin.filter_esc_status !== \"undefined\" ? nfAdmin.filter_esc_status : \"false\";\n\t\t\t\t},\n\t    \t\trenderRequired: function() {\n\t    \t\t\tif ( 1 == this.required ) {\n\t    \t\t\t\treturn '<span class=\"required\">*</span>';\n\t    \t\t\t} else {\n\t    \t\t\t\treturn '';\n\t    \t\t\t}\n\t    \t\t},\n\t    \t\tgetFieldID: function() {\n\t\t\t\t\tif ( jQuery.isNumeric( this.id ) ) {\n\t\t\t\t\t\treturn 'field-' + this.id;\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn this.id;\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\trenderIcon: function() {\n\t    \t\t\tvar type, icon;\n\n\t\t\t\t\ttype = nfRadio.channel( 'fields' ).request( 'get:type', this.type );\n\n\t\t\t\t\ticon = document.createElement( 'span' );\n\t\t\t\t\ticon.classList.add( 'fa', 'fa-' + type.get( 'icon' ) );\n\n\t\t\t\t\treturn icon.outerHTML;\n\t\t\t\t},\n\t\t\t\tlabelPosition: function() {\n\t\t\t\t\treturn this.label_pos;\n\t\t\t\t},\n\t\t\t\trenderDescriptionText: function() {\n\t\t\t\t\treturn typeof this.desc_text === \"undefined\" || this.desc_text === null ? \"\" : String(this.desc_text).trim();\n\t\t\t\t}\n\t\t\t};\n\t\t},\n\n\t\tevents: {\n\t\t\t'mouseover .nf-item-control': 'mouseoverItemControl',\n\t\t\t'mousedown': 'maybeShortcut',\n\t\t\t'click': 'maybeClickEdit',\n\t\t\t'singletap': 'maybeTapEdit',\n\t\t\t'swipeleft': 'swipeLeft',\n\t\t\t'swiperight': 'swipeRight',\n\t\t\t'tapend': 'tapend'\n\t\t},\n\n\t\tmaybeClickEdit: function( e ) {\n\t\t\tif ( this.doingShortcut ) {\n\t\t\t\tthis.doingShortcut = false;\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tif ( ( jQuery( e.target ).parent().hasClass( 'nf-fields-sortable' ) || jQuery( e.target ).parent().hasClass( 'nf-field-wrap' ) || jQuery( e.target ).hasClass( 'nf-field-wrap' ) ) && ! nfRadio.channel( 'app' ).request( 'is:mobile' ) ) {\n\t\t\t\tjQuery( ':focus' ).blur();\n\t\t\t\tnfRadio.channel( 'app' ).trigger( 'click:edit', e, this.model );\n\t\t\t}\n\t\t},\n\n\t\tmaybeShortcut: function( e ) {\n\t\t\tvar keys = nfRadio.channel( 'app' ).request( 'get:keydown' );\n\t\t\t/*\n\t\t\t * If the shift key isn't held down, return.\n\t\t\t */\n\t\t\tif ( -1 == keys.indexOf( 16 ) ) {\n\t\t\t\treturn true;\n\t\t\t}\n\t\t\t/*\n\t\t\t * If we are pressing D, delete this field.\n\t\t\t */\n\t\t\tif ( -1 != keys.indexOf( 68 ) ) {\n\t\t\t\tnfRadio.channel( 'app' ).trigger( 'click:delete', e, this.model );\n\t\t\t\tthis.doingShortcut = true;\n\t\t\t\treturn false;\n\t\t\t} else if ( -1 != keys.indexOf( 67 ) ) {\n\t\t\t\tthis.doingShortcut = true;\n\t\t\t\tnfRadio.channel( 'app' ).trigger( 'click:duplicate', e, this.model );\n\t\t\t\treturn false;\n\t\t\t}\n\t\t},\n\n\t\tmaybeTapEdit: function( e ) {\n\t\t\tif ( jQuery( e.target ).parent().hasClass( 'nf-fields-sortable' ) ) {\n\t\t\t\tnfRadio.channel( 'app' ).trigger( 'click:edit', e, this.model );\n\t\t\t}\n\t\t},\n\n\t\tswipeLeft: function( e, touch ) {\n\t\t\tjQuery( touch.startEvnt.target ).closest( 'div' ).find( '.nf-item-duplicate' ).show();\n\t\t\tjQuery( touch.startEvnt.target ).closest( 'div' ).find( '.nf-item-delete' ).show();\n\t\t},\n\n\t\tswipeRight: function( e, touch ) {\n\t\t\tjQuery( touch.startEvnt.target ).closest( 'div' ).find( '.nf-item-duplicate' ).hide();\n\t\t\tjQuery( touch.startEvnt.target ).closest( 'div' ).find( '.nf-item-delete' ).hide();\n\t\t},\n\n\t\ttapend: function( e, touch ) {\n\t\t\tjQuery( this.el ).ClassyWiggle( 'stop' );\n\t\t\tjQuery( this.el ).removeClass( 'ui-sortable-helper drag-selected' );\n\t\t},\n\n\t\tremove: function(){\n\t\t\tif ( nfRadio.channel( 'fields' ).request( 'get:removing' ) ) {\n\t\t\t\tthis.$el.hide( 'clip', function(){\n\t\t\t\t\tjQuery( this ).remove();\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\tthis.$el.remove();\n\t\t\t}\n\n\t\t\tnfRadio.channel( 'fields' ).request( 'set:removing', false );\n\t\t},\n\n\t\tmouseoverItemControl: function( e ) {\n\t\t\tjQuery( this.el ).find( '.nf-item-control' ).css( 'display', '' );\n\t\t}\n\n\t});\n\n\treturn view;\n} );\n","/**\n * Handles all the actions/functions related to our main field sortable.\n * All of the actual logic for our sortable is held here; the view just calls it using nfRadio.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/sortable',['models/fields/fieldModel', 'views/fields/fieldItem'], function(FieldModel, FieldItemView) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// When our field type buttons are dragged, we need to add or remove the active (blue) class.\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'startDrag:type', this.addActiveClass );\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'stopDrag:type', this.removeActiveClass );\n\t\t\t// When our field staging is dragged, we need to add or remove the active (blue) class.\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'startDrag:fieldStaging', this.addActiveClass );\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer-addField' ), 'stopDrag:fieldStaging', this.removeActiveClass );\n\t\t\t\n\t\t\t/*\n\t\t\t * Handles all the events fired by our sortable:\n\t\t\t * receive - dropped from type button or staging\n\t\t\t * over - dragging within or over the sortable\n\t\t\t * out - leaving the sortable\n\t\t\t * stop - stopped sorting/dragging\n\t\t\t * start - started sorting/dragging\n\t\t\t * update - stopped sorting/dragging and order has changed\n\t\t\t */\n\t\t\tnfRadio.channel( 'app' ).reply( 'receive:fieldsSortable', this.receiveFieldsSortable, this );\n\t\t\tnfRadio.channel( 'app' ).reply( 'over:fieldsSortable', this.overfieldsSortable, this );\n\t\t\tnfRadio.channel( 'app' ).reply( 'out:fieldsSortable', this.outFieldsSortable, this );\n\t\t\tnfRadio.channel( 'app' ).reply( 'stop:fieldsSortable', this.stopFieldsSortable, this );\n\t\t\tnfRadio.channel( 'app' ).reply( 'start:fieldsSortable', this.startFieldsSortable, this );\n\t\t\tnfRadio.channel( 'app' ).reply( 'update:fieldsSortable', this.updateFieldsSortable, this );\n\t\t\tnfRadio.channel( 'app' ).reply( 'receive:repeaterField', this.receiveRepeaterField, this );\n\t\t},\n\n\t\t/**\n\t\t * Add the active class to our sortable so that its border is blue.\n\t\t * \n\t\t * @since 3.0\n\t\t * @return void\n\t\t */\n\t\taddActiveClass: function() {\n\t\t\tvar sortableEl = nfRadio.channel( 'fields' ).request( 'get:sortableEl' );\n\t\t\tjQuery( sortableEl ).addClass( 'nf-droppable-active' );\t\n\t\t},\n\n\t\t/**\n\t\t * Remove the active class from our sortable\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tremoveActiveClass: function() {\n\t\t\tvar sortableEl = nfRadio.channel( 'fields' ).request( 'get:sortableEl' );\n\t\t\tjQuery( sortableEl ).removeClass( 'nf-droppable-active' );\n\t\t},\n\n\t\t/**\n\t\t * Fires when we drop a field type button or staging onto our sortable\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \tui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\treceiveFieldsSortable: function( ui ) {\n\t\t\t//Check for fields coming from a repeater field\n\t\t\tui = this.receiveRepeaterField(ui);\n\t\t\t/*\n\t\t\t * We have to do different things if we're dealing with a field type button or staging area.\n\t\t\t */ \n\t\t\tif( jQuery( ui.item ).hasClass( 'nf-field-type-draggable' ) ) { // Field Type Button\n\t\t\t\t// Get our type string\n\t\t\t\tvar type = jQuery( ui.item ).data( 'id' );\n\t\t\t\t// Add a field (returns the tmp ID )\n\t\t\t\tvar tmpID = this.addField( type, false );\n\t\t\t\t/*\n\t\t\t\t * Update our helper id to the tmpID.\n\t\t\t\t * We do this so that when we sort, we have the proper ID.\n\t\t\t\t */ \n\t\t\t\tjQuery( ui.helper ).prop( 'id', tmpID );\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'sort:fields' );\n\t\t\t\t// Remove the helper. Gets rid of a weird type artifact.\n\t\t\t\tjQuery( ui.helper ).remove();\n\t\t\t\t// Trigger a drop field type event.\n\t\t\t\tnfRadio.channel( 'fields' ).trigger( 'drop:fieldType', type, tmpID );\n\n\t\t\t} else if ( jQuery( ui.item ).hasClass( 'nf-stage' ) ) { // Staging\n\t\t\t\t// Later, we want to reference 'this' context, so we define it here.\n\t\t\t\tvar that = this;\n\t\t\t\t// Make sure that our staged fields are sorted properly.\t\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'sort:staging' );\n\t\t\t\t// Grab our staged fields.\n\t\t\t\tvar stagedFields = nfRadio.channel( 'fields' ).request( 'get:staging' );\n\t\t\t\t// Get our current field order.\n\t\t\t\tvar sortableEl = nfRadio.channel( 'fields' ).request( 'get:sortableEl' );\n\t\t\t\t\n\t\t\t\tif ( jQuery( sortableEl ).hasClass( 'ui-sortable' ) ) { // Sortable isn't empty\n\t\t\t\t\t// If we're dealing with a sortable that isn't empty, get the order.\n\t\t\t\t\tvar order = jQuery( sortableEl ).sortable( 'toArray' );\n\t\t\t\t} else { // Sortable is empty\n\t\t\t\t\t// Sortable is empty, all we care about is our staged field draggable.\n\t\t\t\t\tvar order = ['nf-staged-fields-drag'];\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\t// Get the index of our droped element.\n\t\t\t\tvar insertedAt = order.indexOf( 'nf-staged-fields-drag' );\n\n\t\t\t\t// Loop through each staged fields model and insert a field.\n\t\t\t\tvar tmpIDs = [];\n\t\t\t\t_.each( stagedFields.models, function( field, index ) {\n\t\t\t\t\t// Add our field.\n\t\t\t\t\tvar tmpID = that.addField( field.get( 'slug' ) );\n\t\t\t\t\t// Add this newly created field to our order array.\n\t\t\t\t\torder.splice( insertedAt + index, 0, tmpID );\n\t\t\t\t} );\n\n\t\t\t\t// Remove our dropped element from our order array.\n\t\t\t\tvar insertedAt = order.indexOf( 'nf-staged-fields-drag' );\n\t\t\t\torder.splice( insertedAt, 1 );\n\t\t\t\t// Sort our fields\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'sort:fields', order );\n\t\t\t\t// Clear our staging\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'clear:staging' );\n\t\t\t\t// Remove our helper. Fixes a weird artifact.\n\t\t\t\tjQuery( ui.helper ).remove();\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Add a field.\n\t\t * Builds the object necessary to add a field to the field model collection.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  string \ttype   field type\n\t\t * @param  boolean \tsilent add silently\n\t\t * @return string \ttmpID\n\t\t */\n\t\taddField: function( type, silent ) {\n\t\t\t// Default to false\n\t\t\tsilent = silent || false;\n\t\t\t// Get our field type model\n\t\t\tvar fieldType = nfRadio.channel( 'fields' ).request( 'get:type', type ); \n\t\t\t// Get our tmp ID\n\t\t\tvar tmpID = nfRadio.channel( 'fields' ).request( 'get:tmpID' );\n\t\t\t// Add our field\n\t\t\tvar newModel = nfRadio.channel( 'fields' ).request( 'add',  { id: tmpID, label: fieldType.get( 'nicename' ), type: type }, silent );\n\t\t\t// Add our field addition to our change log.\n\t\t\tvar label = {\n\t\t\t\tobject: 'Field',\n\t\t\t\tlabel: newModel.get( 'label' ),\n\t\t\t\tchange: 'Added',\n\t\t\t\tdashicon: 'plus-alt'\n\t\t\t};\n\n\t\t\tvar data = {\n\t\t\t\tcollection: nfRadio.channel( 'fields' ).request( 'get:collection' )\n\t\t\t}\n\n\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'addObject', newModel, null, label, data );\n\n\t\t\treturn tmpID;\n\t\t},\n\n\t\t/**\n\t\t * When the user drags a field type or staging over our sortable, we need to modify the helper.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \tui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\toverfieldsSortable: function( ui ) {\n\t\t\tif( jQuery( ui.item ).hasClass( 'nf-field-type-draggable' ) ) { // Field Type\n\t\t\t\t// String type\n\t\t\t\tvar type = jQuery( ui.helper ).data( 'id' );\n\t\t\t\t// Get our field type model.\n\t\t\t\tvar fieldType = nfRadio.channel( 'fields' ).request( 'get:type', type );\n\t\t\t\t// Get our field type nicename.\n\t\t\t\tvar label = fieldType.get( 'nicename' );\n\t\t\t\t// Get our sortable element.\n\t\t\t\tvar sortableEl = nfRadio.channel( 'fields' ).request( 'get:sortableEl' );\n\t\t\t\t// Get our fieldwidth.\n\t\t\t\tvar fieldWidth = jQuery( sortableEl ).width();\n\t\t\t\t// Set our currentHelper to an object var so that we can access it later.\n\t\t\t\tthis.currentHelper = ui.helper;\n\n\t\t\t\t// Render a fieldItemView using a mock fieldModel.\n\t\t\t\tvar fieldModel = new FieldModel({ label: fieldType.get( 'nicename' ), type: type });\n\t\t\t\tvar fieldItemView = new FieldItemView({model:fieldModel});\n\t\t\t\tvar renderedFieldItemView = fieldItemView.render();\n\t\t\t\tvar fieldTypeEl = renderedFieldItemView.$el[0];\n\t\t\t\tjQuery( ui.helper ).html( fieldTypeEl.outerHTML );\n\n\t\t\t} else if ( jQuery( ui.item ).hasClass( 'nf-stage' ) ) { // Staging\n\t\t\t\t// Get our sortable, and if it's initialized add our hover class.\n\t\t\t\tvar sortableEl = nfRadio.channel( 'fields' ).request( 'get:sortableEl' );\n\t\t\t\tif ( jQuery( sortableEl ).hasClass( 'ui-sortable' ) ) {\n\t\t\t\t\tjQuery( sortableEl ).addClass( 'nf-droppable-hover' );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * When the user moves a draggable outside of the sortable, we need to change the helper.\n\t\t * This returns the item to its pre-over state.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \tui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\toutFieldsSortable: function( ui ) {\n\t\t\tif( jQuery( ui.item ).hasClass( 'nf-field-type-draggable' ) ) { // Field Type\n\t\t\t\t/*\n\t\t\t\t * Get our helper clone.\n\t\t\t\t * This will let us access the previous label and classes of our helper.\n\t\t\t\t */ \n\t\t\t\tvar helperClone = nfRadio.channel( 'drawer-addField' ).request( 'get:typeHelperClone' );\n\t\t\t\t// Set our helper label, remove our sortable class, and add the type class back to the type draggable.\n\t\t\t\tjQuery( this.currentHelper ).html( jQuery( helperClone ).html() );\n\t\t\t\tjQuery( this.currentHelper ).removeClass( 'nf-field-wrap' ).addClass( 'nf-field-type-button' ).css( { 'width': '', 'height': '' } );\n\t\t\t\t// Get our sortable and if it has been intialized, remove the droppable hover class.\n\t\t\t\tvar sortableEl = nfRadio.channel( 'fields' ).request( 'get:sortableEl' );\n\t\t\t\tif ( jQuery( sortableEl ).hasClass( 'ui-sortable' ) ) {\n\t\t\t\t\tjQuery( sortableEl ).removeClass( 'nf-droppable-hover' );\n\t\t\t\t}\n\t\t\t} else if ( jQuery( ui.item ).hasClass( 'nf-stage' ) ) { // Staging\n\t\t\t\t// If we've initialized our sortable, remove the droppable hover class.\n\t\t\t\tvar sortableEl = nfRadio.channel( 'fields' ).request( 'get:sortableEl' );\n\t\t\t\tif ( jQuery( sortableEl ).hasClass( 'ui-sortable' ) ) {\n\t\t\t\t\tjQuery( sortableEl ).removeClass( 'nf-droppable-hover' );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * When we stop dragging in the sortable:\n\t\t * remove our opacity setting\n\t\t * remove our ui helper\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \tui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\tstopFieldsSortable: function( ui ) {\n\t\t\tjQuery( ui.item ).css( 'opacity', '' );\n\t\t\tjQuery( ui.helper ).remove();\n\t\t\tnfRadio.channel( 'fields' ).trigger( 'sortable:stop', ui );\n\t\t},\n\n\t\t/**\n\t\t * When we start dragging in the sortable:\n\t\t * add an opacity setting of 0.5\n\t\t * show our item (jQuery hides the original item by default)\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \tui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\tstartFieldsSortable: function( ui ) {\n\t\t\t// If we aren't dragging an item in from types or staging, update our change log.\n\t\t\tif( ! jQuery( ui.item ).hasClass( 'nf-field-type-draggable' ) && ! jQuery( ui.item ).hasClass( 'nf-stage' ) ) { \n\t\t\t\t\n\t\t\t\t// Maintain origional visibility during drag/sort.\n\t\t\t\tjQuery( ui.item ).show();\n\n\t\t\t\t// Determine helper based on builder/layout type.\n\t\t\t\tif(jQuery(ui.item).hasClass('nf-field-wrap')){\n\t\t\t\t\tvar newHelper = jQuery(ui.item).clone();\n\t\t\t\t} else if(jQuery(ui.item).parent().hasClass('layouts-cell')) {\n\t\t\t\t\tvar newHelper = $parentHelper.clone();\n\t\t\t\t} else {\n\t\t\t\t\tvar newHelper = jQuery(ui.item).clone();\n\t\t\t\t}\n\n\t\t\t\t// Remove unecessary item controls from helper.\n\t\t\t\tnewHelper.find('.nf-item-controls').remove();\n\n\t\t\t\t// Update helper with clone's content.\n\t\t\t\tjQuery( ui.helper ).html( newHelper.html() );\n\n\t\t\t\tjQuery( ui.helper ).css( 'opacity', '0.5' );\n\t\t\t\t\n\t\t\t\t// Add de-emphasize origional.\n\t\t\t\tjQuery( ui.item ).css( 'opacity', '0.25' );\n\t\t\t}\n\t\t\tnfRadio.channel( 'fields' ).trigger( 'sortable:start', ui );\n\t\t},\n\n\t\t/**\n\t\t * Sort our fields when we change the order.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \tui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\tupdateFieldsSortable: function( ui, sortable ) {\n\t\t\t\n\t\t\tnfRadio.channel( 'fields' ).request( 'sort:fields' );\n\n\t\t\t// If we aren't dragging an item in from types or staging, update our change log.\n\t\t\tif( ! jQuery( ui.item ).hasClass( 'nf-field-type-draggable' ) && ! jQuery( ui.item ).hasClass( 'nf-stage' ) ) { \n\n\t\t\t\tvar fieldCollection = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\t\t\t\tvar dragFieldID = jQuery( ui.item ).prop( 'id' ).replace( 'field-', '' );\n\t\t\t\tvar dragModel = fieldCollection.get( dragFieldID );\n\n\t\t\t\t// Add our change event to the change tracker.\n\t\t\t\tvar data = { fields: [] };\n\t\t\t\t_.each( fieldCollection.models, function( field ) {\n\t\t\t\t\tvar oldPos = field._previousAttributes.order;\n\t\t\t\t\tvar newPos = field.get( 'order' );\n\t\t\t\t\t\n\t\t\t\t\tdata.fields.push( {\n\t\t\t\t\t\tmodel: field,\n\t\t\t\t\t\tattr: 'order',\n\t\t\t\t\t\tbefore: oldPos,\n\t\t\t\t\t\tafter: newPos\n\t\t\t\t\t} );\n\n\t\t\t\t} );\n\n\t\t\t\tvar label = {\n\t\t\t\t\tobject: 'Field',\n\t\t\t\t\tlabel: dragModel.get( 'label' ),\n\t\t\t\t\tchange: 'Re-ordered from ' + dragModel._previousAttributes.order + ' to ' + dragModel.get( 'order' ),\n\t\t\t\t\tdashicon: 'sort'\n\t\t\t\t};\n\n\t\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'sortFields', dragModel, null, label, data );\n\t\t\t}\n\n\t\t},\n\n\t\treceiveRepeaterField: function( ui ){\n\t\t\t//If the field was already saved as a Repeater child field we'll delete it and create a new one for the main collection\n\t\t\tif( String( jQuery( ui.item ).data('id') ).indexOf('.') !== -1){\n\t\t\t\tjQuery( ui.item ).removeClass('nf-field-wrap');\n\t\t\t\tlet type = jQuery( ui.item ).attr('class');\n\t\t\t\tjQuery( ui.item ).data('id', type);\n\t\t\t\tjQuery( ui.item ).addClass('nf-field-type-draggable');\n\t\t\t}\n\n\t\t\treturn ui;\n\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles interactions with our field collection.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/fields/data',['models/fields/fieldCollection', 'models/fields/fieldModel'], function( fieldCollection, fieldModel ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tadding: false,\n\t\tremoving: false,\n\t\t\n\t\tinitialize: function() {\n\t\t\t// Load our field collection from our localized form data\n\t\t\tthis.collection = new fieldCollection( preloadedFormData.fields );\n\t\t\t// Set our removedIDs to an empty object. This will be populated when a field is removed so that we can add it to our 'deleted_fields' object.\n\t\t\tthis.collection.removedIDs = {};\n\n\t\t\t// Respond to requests for data about fields and to update/change/delete fields from our collection.\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:collection', this.getFieldCollection, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:field', this.getField, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'redraw:collection', this.redrawFieldCollection, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:tmpID', this.getTmpFieldID, this );\n\n\t\t\tnfRadio.channel( 'fields' ).reply( 'add', this.addField, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'delete', this.deleteField, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'sort:fields', this.sortFields, this );\n\n\t\t\t/*\n\t\t\t * Respond to requests to set our 'adding' and 'removing' state. This state is used to track whether or not\n\t\t\t * we should run animations in our fields collection.\n\t\t\t */\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:adding', this.getAdding, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'set:adding', this.setAdding, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:removing', this.getRemoving, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'set:removing', this.setRemoving, this );\n\t\t},\n\n\t\tgetFieldCollection: function() {\n\t\t\treturn this.collection;\n\t\t},\n\n\t\tredrawFieldCollection: function() {\n\t\t\tthis.collection.trigger( 'reset', this.collection );\n\t\t},\n\n\t\tgetField: function( id ) {\n\t\t\tif ( this.collection.findWhere( { key: id } ) ) {\n\t\t\t\t/*\n\t\t\t\t * First we check to see if a key matches what we were sent.\n\t\t\t\t */\t\t\t\t\n\t\t\t\treturn this.collection.findWhere( { key: id } );\n\t\t\t} else {\n\t\t\t\t/*\n\t\t\t\t * If it doesn't, we try to return an ID that matches.\n\t\t\t\t */\n\t\t\t\treturn this.collection.get( id );\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Add a field to our collection. If silent is passed as true, no events will trigger.\n\t\t * \n\t\t * @since 3.0\n\t\t * @param Object \tdata \t\t\tfield data to insert\n\t\t * @param bool \t\tsilent \t\t\tprevent events from firing as a result of adding\n\t\t * @param bool  \trenderTrigger\tshould this cause the view to re-render?\n\t\t * @param string  \taction\t\t\taction context - are we performing a higher level action? i.e. duplicate\n\t\t */\n\t\taddField: function( data, silent, renderTrigger, action ) {\n\n\t\t\t/*\n\t\t\t * Set our fields 'adding' value to true. This enables our add field animation.\n\t\t\t */\n\t\t\tnfRadio.channel( 'fields' ).request( 'set:adding', true );\n\n\t\t\tsilent = silent || false;\n\t\t\taction = action || '';\n\t\t\trenderTrigger = ( 'undefined' == typeof renderTrigger ) ? true : renderTrigger;\n\n\t\t\tif ( false === data instanceof Backbone.Model ) {\n\t\t\t\tif ( 'undefined' == typeof ( data.id ) ) {\n\t\t\t\t\tdata.id = this.getTmpFieldID();\n\t\t\t\t}\n\t\t\t\tvar model = new fieldModel( data );\n\t\t\t} else {\n\t\t\t\tvar model = data;\n\t\t\t}\n\n\t\t\t/*\n\t\t\t * TODO: Add an nfRadio message filter for the model variable.\n\t\t\t * Currently, we manually replace for saved fields; this should be moved to a separate controller.\n\t\t\t * \n\t\t\t * If we're adding a saved field, make sure that we set the type to the parentType.\n\t\t\t */\n\n\t\t\tif ( jQuery.isNumeric( model.get( 'type' ) ) ) {\n\t\t\t\tvar savedType = nfRadio.channel( 'fields' ).request( 'get:type', model.get( 'type' ) );\n\t\t\t\tmodel.set( 'type', savedType.get( 'parentType' ) );\n\t\t\t}\n\n\t\t\tvar newModel = this.collection.add( model, { silent: silent } );\n\t\t\t\n\t\t\t// Set our 'clean' status to false so that we get a notice to publish changes\n\t\t\tnfRadio.channel( 'app' ).request( 'update:setting', 'clean', false );\n\t\t\tnfRadio.channel( 'fields' ).trigger( 'add:field', model );\n\t\t\tif ( renderTrigger ) {\n\t\t\t\tnfRadio.channel( 'fields' ).trigger( 'render:newField', newModel, action );\n\t\t\t}\n\t\t\tif( 'duplicate' == action ){\n                nfRadio.channel( 'fields' ).trigger( 'render:duplicateField', newModel, action );\n\t\t\t}\n\t\t\tnfRadio.channel( 'fields' ).trigger( 'after:addField', model );\n\t\t\t\n\t\t\treturn model;\n\t\t},\n\n\t\t/**\n\t\t * Update a field setting by ID\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  int \t\tid    field id\n\t\t * @param  string \tname  setting name\n\t\t * @param  mixed \tvalue setting value\n\t\t * @return void\n\t\t */\n\t\tupdateFieldSetting: function( id, name, value ) {\n\t\t\tvar fieldModel = this.collection.get( id );\n\t\t\tfieldModel.set( name, value );\n\t\t},\n\n\t\t/**\n\t\t * Get our fields sortable EL\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Array \torder optional order array like: [field-1, field-4, field-2]\n\t\t * @return void\n\t\t */\n\t\tsortFields: function( order, ui, updateDB ) {\n\t\t\tif ( null == updateDB ) {\n\t\t\t\tupdateDB = true;\n\t\t\t}\n\t\t\t// Get our sortable element\n\t\t\tvar sortableEl = nfRadio.channel( 'fields' ).request( 'get:sortableEl' );\n\t\t\tif ( jQuery( sortableEl ).hasClass( 'ui-sortable' ) ) { // Make sure that sortable is enabled\n\t\t\t\t// JS ternerary for setting our order\n\t\t\t\tvar order = order || jQuery( sortableEl ).sortable( 'toArray' );\n\n\t\t\t\t// Loop through all of our fields and update their order value\n\t\t\t\t_.each( this.collection.models, function( field ) {\n\t\t\t\t\t// Get our current position.\n\t\t\t\t\tvar oldPos = field.get( 'order' );\n\t\t\t\t\tvar id = field.get( 'id' );\n\t\t\t\t\tif ( jQuery.isNumeric( id ) ) {\n\t\t\t\t\t\tvar search = 'field-' + id;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tvar search = id;\n\t\t\t\t\t}\n\t\t\t\t\t\n\t\t\t\t\t// Get the index of our field inside our order array\n\t\t\t\t\tvar newPos = order.indexOf( search ) + 1;\n\t\t\t\t\tfield.set( 'order', newPos );\n\t\t\t\t} );\n\t\t\t\tthis.collection.sort();\n\n\t\t\t\tif ( updateDB ) {\n\t\t\t\t\t// Set our 'clean' status to false so that we get a notice to publish changes\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'update:setting', 'clean', false );\n\t\t\t\t\t// Update our preview\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'update:db' );\t\t\t\t\t\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Delete a field from our collection.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  backbone.model \tmodel \tfield model to be deleted\n\t\t * @return void\n\t\t */\n\t\tdeleteField: function( model ) {\n\t\t\tnfRadio.channel( 'fields' ).trigger( 'delete:field', model );\n\t\t\tthis.removing = true;\n\t\t\tthis.collection.remove( model );\n\n\t\t\t// Set our 'clean' status to false so that we get a notice to publish changes\n\t\t\tnfRadio.channel( 'app' ).request( 'update:setting', 'clean', false );\n\t\t\tnfRadio.channel( 'app' ).request( 'update:db' );\n\n\t\t},\n\n\t\t/**\n\t\t * Return a new tmp id for our fields.\n\t\t * Gets the field collection length, adds 1, then returns that prepended with 'tmp-'.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return string\n\t\t */\n\t\tgetTmpFieldID: function() {\n\t\t\tvar tmpNum = this.collection.tmpNum;\n\t\t\tthis.collection.tmpNum++;\n\t\t\treturn 'tmp-' + tmpNum;\n\t\t},\n\n\t\tgetAdding: function() {\n\t\t\treturn this.adding;\n\t\t},\n\n\t\tsetAdding: function( val ) {\n\t\t\tthis.adding = val;\n\t\t},\n\n\t\tgetRemoving: function() {\n\t\t\treturn this.removing;\n\t\t},\n\n\t\tsetRemoving: function( val ) {\n\t\t\tthis.removing = val;\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Model for our repeater option.\n * \n * @package Ninja App builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/optionRepeaterModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\t\tdefaults: {\n\t\t\terrors: {},\n            max_options: 0,\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\t// When we add errors to the option row, run a function.\n\t\t\tthis.on( 'change:errors', this.changeErrors, this );\n\t\t},\n\n\t\t/**\n\t\t * When we change the errors on our model, check to see if we should add or remove \n\t\t * the error from the setting that this option is a part of.\n\t\t *\n\t\t * Adding an error to the setting model simply disables the drawer and other\n\t\t * navigation. As long as we have one option with an error, it should be set to true.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tchangeErrors: function( model ) {\n\t\t\t/*\n\t\t\t * The errors attribute will be an object, so if we don't have any keys, it's empty.\n\t\t\t * If we have an empty object, check to see if we can remove the error from our setting model.\n\t\t\t */\n\n\t\t\tif ( 0 == _.size( model.get( 'errors' ) ) ) {\n\t\t\t\t/*\n\t\t\t\t * Loop through our collection to see if we have any other errors.\n\t\t\t\t */\n\t\t\t\tvar errorsFound = false;\n\t\t\t\t_.each( model.collection.models, function( opt ) {\n\t\t\t\t\tif ( 0 != _.size( opt.get( 'errors' ) ) ) {\n\t\t\t\t\t\terrorsFound = true;\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t\tif ( ! errorsFound ) {\n\t\t\t\t\tmodel.collection.settingModel.set( 'error', false );\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t/*\n\t\t\t\t * We have errors, so make sure that the setting model has an error set.\n\t\t\t\t */\n\t\t\t\tmodel.collection.settingModel.set( 'error', true );\n\t\t\t}\n\t\t}\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Model that represents our list options.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/optionRepeaterCollection',['models/app/optionRepeaterModel'], function( listOptionModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: listOptionModel,\n\t\tcomparator: function( model ){\n\t\t\treturn parseInt( model.get( 'order' ) );\n\t\t},\n\n\t\tinitialize: function( models, options ) {\n\t\t\t// Listen to the 'sort' event\n\t\t\tthis.on( 'sort', this.changeCollection, this );\n\t\t\t// Listen to the 'add' event\n\t\t\tthis.on( 'add', this.addOption, this );\n\t\t\tthis.settingModel = options.settingModel;\n\t\t},\n\n\t\tchangeCollection: function() {\n\t\t\t// Trigger a 'sort:options' event so that our field model can update\n\t\t\tnfRadio.channel( 'option-repeater' ).trigger( 'sort:options', this );\n\n\t\t\tif ('undefined' !== typeof this.settingModel ) {\n\t\t\t\tnfRadio.channel('option-repeater-' + this.settingModel.get('name')).trigger('sort:options', this);\n\t\t\t}\n\t\t},\n\n\t\taddOption: function( model, collection ) {\n\t\t\tmodel.set( 'settingModel', this.settingModel );\n\t\t}\n\t} );\n\treturn collection;\n} );\n","define( 'views/app/drawer/optionRepeaterError',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\tclassName: 'nf-error',\n\t\ttemplate: '#tmpl-nf-edit-setting-option-repeater-error',\n\n\t\ttemplateHelpers: function() {\n\t\t\tvar that = this;\n\t\t\treturn {\n\t\t\t\trenderErrors: function() {\n\t\t\t\t    if ( 'undefined' != typeof that.errors ) {\n    \t\t\t\t\treturn that.errors[ Object.keys( errors )[0] ];\n \t\t\t\t\t} else {\n \t\t\t\t\t\treturn '';\n \t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\n\treturn view;\n} );\n","define( 'views/app/drawer/optionRepeaterOption',['views/app/drawer/optionRepeaterError'], function( ErrorView ) {\n    var view = Marionette.LayoutView.extend({\n        tagName: 'div',\n        className: 'nf-table-row',\n        template: '#tmpl-nf-edit-setting-option-repeater-default-row',\n        id: function() {\n            return this.model.cid;\n        },\n\n        regions: {\n            error: '.nf-option-error'\n        },\n\n        initialize: function( data ) {\n            this.settingModel = data.settingModel;\n            this.dataModel = data.dataModel;\n            this.collection = data.collection;\n            this.columns = data.columns;\n            this.parentView = data.parentView;\n            this.model.on( 'change:errors', this.renderErrors, this );\n\n            // Removed because the re-render was breaking tag insertion for merge tags.\n            // this.model.on( 'change', this.render, this );\n\n            if ( 'undefined' != typeof this.settingModel.get( 'tmpl_row' ) ) {\n                this.template = '#' + this.settingModel.get( 'tmpl_row' );\n            }\n\n            this.hasErrors = false;\n        },\n\n        onBeforeDestroy: function() {    \n            this.model.off( 'change', this.render );\n            this.model.off( 'change:errors', this.renderErrors );\n        },\n\n        onBeforeRender: function() {\n            /*\n             * We want to escape any HTML being output for our label.\n             */\n            if ( this.model.get( 'label' ) ) {\n                var label = this.model.get( 'label' );\n                this.model.set( 'label', _.escape( label ), { silent: true } );\n            }\n            \n        },\n\n        onRender: function() {\n            nfRadio.channel( 'mergeTags' ).request( 'init', this );\n            /*\n             * Send out a radio message.\n             */\n            nfRadio.channel( 'setting-' + this.settingModel.get( 'name' ) + '-option' ).trigger( 'render:setting', this.model, this.dataModel, this );\n            /*\n             * We want to unescape any HTML being output for our label.\n             */\n            if ( this.model.get( 'label' ) ) {\n                var label = this.model.get( 'label' );\n                this.model.set( 'label', _.unescape( label ), { silent: true } );\n            }\n        },\n\n        onShow: function() {\n            if ( this.model.get( 'new' ) ) {\n                jQuery( this.el ).find( 'input:first' ).focus();\n                this.model.set( 'new', false );\n            }\n        },\n\n        events: {\n            'change .setting': 'changeOption',\n            'click .nf-delete': 'deleteOption',\n            'keyup': 'keyupOption'\n        },\n\n        changeOption: function( e ) {\n            nfRadio.channel( 'option-repeater' ).trigger( 'change:option', e, this.model, this.dataModel, this.settingModel, this );\n        },\n\n        deleteOption: function( e ) {\n            nfRadio.channel( 'option-repeater' ).trigger( 'click:deleteOption', this.model, this.collection, this.dataModel, this );\n        },\n\n        keyupOption: function( e ) {\n            this.maybeAddOption( e );\n            nfRadio.channel( 'option-repeater' ).trigger( 'keyup:option', e, this.model, this.dataModel, this.settingModel, this )\n            nfRadio.channel( 'option-repeater-' + this.settingModel.get( 'name' ) ).trigger( 'keyup:option', e, this.model, this.dataModel, this.settingModel, this )\n        },\n\n        maybeAddOption: function( e ) {\n            if ( 13 == e.keyCode && 'calculations' != this.settingModel.get( 'name' ) ) {\n                nfRadio.channel( 'option-repeater' ).trigger( 'click:addOption', this.collection, this.dataModel, this );\n                jQuery( this.parentView.children.findByIndex(this.parentView.children.length - 1).el ).find( '[data-id=\"label\"]' ).focus();\n            }\n        },\n\n        renderErrors: function() {\n            \n            // if ( jQuery.isEmptyObject( this.model.get( 'errors' ) ) ) {\n            //     return false;\n            // }\n\n            /*\n             * We don't want to redraw the entire row, which would remove focus from the eq textarea,\n             * so we add and remove error classes manually.\n             */\n            if ( 0 == Object.keys( this.model.get( 'errors' ) ) ) {\n                if ( this.hasErrors ) {\n                    this.error.empty();\n                    jQuery( this.el ).removeClass( 'nf-error' );\n                }\n            } else {\n                this.hasErrors = true;\n                this.error.show( new ErrorView( { model: this.model } ) );\n                jQuery( this.el ).addClass( 'nf-error' );\n            }\n        },\n\n        templateHelpers: function() {\n            var that = this;\n            return {\n                getColumns: function() {\n                    var columns = that.columns;\n                    if(!nfAdmin.devMode){\n                        delete columns.value;\n                    }\n                    return columns;\n                },\n                renderFieldSelect: function( dataID, value ){\n                    var initialOption, select, emptyContainer, label;\n\n                    var fields = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\n                    initialOption = document.createElement( 'option' );\n                    initialOption.value = '';\n                    initialOption.label = '--';\n                    initialOption.innerHTML = '--';\n\n                    select = document.createElement( 'select' );\n                    select.classList.add( 'setting' );\n                    select.setAttribute( 'data-id', dataID );\n                    select.appendChild( initialOption );\n\n                    fields.each( function( field ){\n                        var option = document.createElement( 'option' );\n                        if ( value == field.get( 'key' ) ) {\n                            option.setAttribute( 'selected', 'selected' );\n                        }\n                        option.value = field.get( 'key' );\n                        option.innerHTML = field.formatLabel();\n                        option.label = field.formatLabel();\n                        select.appendChild( option );\n                    });\n\n                    label = document.createElement( 'label' );\n                    label.classList.add( 'nf-select' );\n                    label.appendChild( select );\n\n                    // Select Lists need an empty '<div></div>' for styling purposes.\n                    emptyContainer = document.createElement( 'div' );\n                    emptyContainer.style.bottom = '6px';\n                    label.appendChild( emptyContainer );\n\n                    // The template requires a string.\n                    return label.innerHTML;\n                },\n                renderNonSaveFieldSelect: function( dataID, value ){\n                    var initialOption, select, emptyContainer, label;\n\n                    var fields = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\n                    initialOption = document.createElement( 'option' );\n                    initialOption.value = '';\n                    initialOption.label = '--';\n                    initialOption.innerHTML = '--';\n\n                    select = document.createElement( 'select' );\n                    select.classList.add( 'setting' );\n                    select.setAttribute( 'data-id', dataID );\n                    select.appendChild( initialOption );\n\n                    // Build a lookup table for fields we want to remove from our fields list.\n                    var removeFieldsLookup = [ 'html', 'submit', 'hr',\n                        'recaptcha', 'spam', 'creditcard', 'creditcardcvc',\n                        'creditcardexpiration', 'creditcardfullname',\n                        'creditcardnumber', 'creditcardzip' ];\n\n                    fields.each( function( field ){\n                        // Check for the field type in our lookup array and...\n                        if( jQuery.inArray( field.get( 'type' ), removeFieldsLookup ) !== -1 ) {\n                            // Return if the type is in our lookup array.\n                            return '';\n                        }\n\n                        var option = document.createElement( 'option' );\n                        if ( value == field.get( 'key' ) ) {\n                            option.setAttribute( 'selected', 'selected' );\n                        }\n                        option.value = field.get( 'key' );\n                        option.innerHTML = field.formatLabel();\n                        option.label = field.formatLabel();\n                        select.appendChild( option );\n                    });\n\n                    label = document.createElement( 'label' );\n                    label.classList.add( 'nf-select' );\n                    label.appendChild( select );\n\n                    // Select Lists need an empty '<div></div>' for styling purposes.\n                    emptyContainer = document.createElement( 'div' );\n                    emptyContainer.style.bottom = '6px';\n                    label.appendChild( emptyContainer );\n\n                    // The template requires a string.\n                    return label.innerHTML;\n                },\n                renderOptions: function( column, value ) {\n\n                    if( 'undefined' == typeof that.options.columns[ column ] ) return;\n\n                    var select = document.createElement( 'select' );\n                    \n                    _.each( that.options.columns[ column ].options, function( option ){\n                        var optionNode = document.createElement( 'option' );\n                        if ( value === option.value ) {\n                            optionNode.setAttribute( 'selected', 'selected' );\n                        }\n                        optionNode.setAttribute( 'value', option.value );\n                        optionNode.setAttribute( 'label', option.label );\n                        optionNode.innerText = option.label;\n                        select.appendChild( optionNode );\n                    });\n\n                    // The template only needs the options.\n                    return select.innerHTML;\n                }\n\n            }\n        }\n\n    });\n\n    return view;\n} );\n\n","define( 'views/app/drawer/optionRepeaterEmpty',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'tr',\n\t\ttemplate: '#tmpl-nf-edit-setting-option-repeater-empty'\n\t});\n\n\treturn view;\n} );\n","define( 'views/app/drawer/optionRepeaterComposite',['views/app/drawer/optionRepeaterOption', 'views/app/drawer/optionRepeaterEmpty', 'models/app/optionRepeaterCollection'], function( listOptionView, listEmptyView, listOptionCollection ) {\n\tvar view = Marionette.CompositeView.extend( {\n\t\ttemplate: '#tmpl-nf-edit-setting-option-repeater-wrap',\n\t\tchildView: listOptionView,\n\t\temptyView: listEmptyView,\n\t\treorderOnSort: false,\n\n\t\tinitialize: function( data ) {\n\n\t\t\t/*\n\t\t\t * Our options are stored in our database as objects, not collections.\n\t\t\t * Before we attempt to render them, we need to convert them to a collection if they aren't already one.\n\t\t\t */ \n\t\t\tvar optionCollection = data.dataModel.get( this.model.get( 'name' ) );\n\n\t\t\tif ( false == optionCollection instanceof Backbone.Collection ) {\n\t\t\t\toptionCollection = new listOptionCollection( [], { settingModel: this.model } );\n\t\t\t\toptionCollection.add( data.dataModel.get( this.model.get( 'name' ) ) );\n\t\t\t\tdata.dataModel.set( this.model.get( 'name' ), optionCollection, { silent: true } );\n\t\t\t}\n\n\t\t\tthis.collection = optionCollection;\n\t\t\tthis.dataModel = data.dataModel;\n\t\t\tthis.childViewOptions = { parentView: this, settingModel: this.model, collection: this.collection, dataModel: data.dataModel, columns: this.model.get( 'columns' ) };\n\n\t\t\tvar deps = this.model.get( 'deps' );\n\t\t\tif ( deps ) {\n\t\t\t\t// If we don't have a 'settings' property, this is a legacy depdency setup.\n\t\t\t\tif ( 'undefined' == typeof deps.settings ) {\n\t\t\t\t\tdeps.settings = [];\n\t\t\t\t\t_.each(deps, function(dep, name){\n\t\t\t\t\t\tif( 'settings' !== name ) {\n\t\t\t\t\t\t\tdeps.settings.push( { name: name, value: dep } );\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tdeps.match = 'all';\n\t\t\t\t}\n\n\t\t\t\tfor (var i = deps.settings.length - 1; i >= 0; i--) {\n\t\t\t\t\tlet name = deps.settings[i].name;\n\t\t\t\t\tthis.dataModel.on( 'change:' + name, this.render, this );\n\t\t\t\t}\n\t\t\t}\n            this.listenTo( nfRadio.channel( 'option-repeater' ), 'added:option', this.maybeHideNew );\n            this.listenTo( nfRadio.channel( 'option-repeater' ), 'removed:option', this.maybeHideNew );\n\t\t},\n\n\t\tonBeforeDestroy: function() {\n\t\t\tvar deps = this.model.get( 'deps' );\n\t\t\tif ( deps ) {\n\t\t\t\tfor (var i = deps.settings.length - 1; i >= 0; i--) {\n\t\t\t\t\tname = deps.settings[i].name;\n\t\t\t\t\tthis.dataModel.off( 'change:' + name, this.render );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tonRender: function() {\t\t\n\t\t\tvar that = this;\n\t\t\tjQuery( this.el ).find( '.nf-list-options-tbody' ).sortable( {\n\t\t\t\thandle: '.handle',\n\t\t\t\thelper: 'clone',\n\t\t\t\tplaceholder: 'nf-list-options-sortable-placeholder',\n\t\t\t\tforcePlaceholderSize: true,\n\t\t\t\topacity: 0.95,\n\t\t\t\ttolerance: 'pointer',\n\n\t\t\t\tstart: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'option-repeater' ).request( 'start:optionSortable', ui );\n\t\t\t\t},\n\n\t\t\t\tstop: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'option-repeater' ).request( 'stop:optionSortable', ui );\n\t\t\t\t},\n\n\t\t\t\tupdate: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'option-repeater' ).request( 'update:optionSortable', ui, this, that );\n\t\t\t\t}\n\t\t\t} );\n\n            that.setupTooltip();\n            that.maybeHideNew( that.collection );\n\n\t\t\t/*\n\t\t\t * Send out a radio message.\n\t\t\t */\n\t\t\tnfRadio.channel( 'setting-' + this.model.get( 'name' ) ).trigger( 'render:setting', this.model, this.dataModel, this );\n\t\t\n\t\t},\n\n\t\tonAttach: function() {\n            \n\t\t\tvar importLink = jQuery( this.el ).find( '.nf-open-import-tooltip' );\n\t\t\tvar jBox = jQuery( importLink ).jBox( 'Tooltip', {\n                title: '<h3>Please enter your options below:</h3>',\n                content: ( \"1\" == nfAdmin.devMode ? jQuery( this.el ).find( '.nf-dev-import-options' ) : jQuery( this.el ).find( '.nf-import-options' ) ),\n                trigger: 'click',\n                closeOnClick: 'body',\n                closeButton: 'box',\n                offset: { x: 20, y: 0 },\n                addClass: 'import-options',\n\n                onOpen: function() {\n                \tvar that = this;\n                \tsetTimeout( function() { jQuery( that.content ).find( 'textarea' ).focus(); }, 200 );\n                }\n            } );\n\n\t\t\tjQuery( this.el ).find( '.nf-import' ).on( 'click', { view: this, jBox: jBox }, this.clickImport );\n\n\t\t\t/*\n\t\t\t * Send out a radio message.\n\t\t\t */\n\t\t\tnfRadio.channel( 'setting-' + this.model.get( 'name' ) ).trigger( 'attach:setting', this.model, this.dataModel, this );\n\t\t\tnfRadio.channel( 'setting-type-' + this.model.get( 'type' ) ).trigger( 'attach:setting', this.model, this.dataModel, this );\n\t\t},\n        \n        /**\n         * Function to append jBox modals to each tooltip element in the option repeater.\n         */\n        setupTooltip: function() {\n            // For each .nf-help in the option repeater...\n            jQuery( this.el ).find( '.nf-list-options' ).find( '.nf-help' ).each(function() {\n                // Get the content.\n                var content = jQuery(this).next('.nf-help-text');\n                // Declare the modal.\n                jQuery( this ).jBox( 'Tooltip', {\n                    content: content,\n                    maxWidth: 200,\n                    theme: 'TooltipBorder',\n                    trigger: 'click',\n                    closeOnClick: true\n                })\n            });\n        },\n\n        templateHelpers: function () {\n            var that = this;\n\n            return {\n                renderHeaders: function() {\n                    // If this is a Field...\n                    // AND If the type includes 'list'...\n                    if ( 'Field' == that.dataModel.get( 'objectType' ) && -1 !== that.dataModel.get( 'type' ).indexOf( 'list' ) ) {\n                        // Declare help text.\n                        var helpText, helpTextContainer, helpIcon, helpIconLink, helpTextWrapper;\n\n                        helpText = document.createTextNode( nfi18n.valueChars );\n                        helpTextContainer = document.createElement( 'div' );\n                        helpTextContainer.classList.add( 'nf-help-text' );\n                        helpTextContainer.appendChild( helpText );\n\n                        helpIcon = document.createElement( 'span' );\n                        helpIcon.classList.add( 'dashicons', 'dashicons-admin-comments' );\n                        helpIconLink = document.createElement( 'a' );\n                        helpIconLink.classList.add( 'nf-help' );\n                        helpIconLink.setAttribute( 'href', '#' );\n                        helpIconLink.setAttribute( 'tabindex', '-1' );\n                        helpIconLink.appendChild( helpIcon );\n\n                        helpTextWrapper = document.createElement( 'span' );\n                        helpTextWrapper.appendChild( helpIconLink );\n                        helpTextWrapper.appendChild( helpTextContainer );\n\n                        // Append the help text to the 'value' header.\n                        if('undefined' !== typeof that.model.get('columns') ){\n                            if('undefined' !== typeof that.model.get('columns').value ){\n                                if ( -1 == that.model.get('columns').value.header.indexOf( helpTextWrapper.innerHTML ) ) {\n                                    that.model.get('columns').value.header += helpTextWrapper.innerHTML;\n                                }\n                            }\n                    \n                        }\n                    }\n                   \t// If this is a Field and If the type includes 'list'...\n\t\t\t\t\tif ( 'Field' == that.dataModel.get( 'objectType' ) && -1 !== that.dataModel.get( 'type' ).indexOf( 'list' ) ) {\n\t\t\t\t\t\t// Declare help text elements.\n\t\t\t\t\t\tlet helpTextContainer, helpIcon, helpIconLink, helpTextWrapper;\n\t\t\t\t\t\t\n\t\t\t\t\t\thelpTextContainer = document.createElement( 'div' );\n\t\t\t\t\t\thelpTextContainer.classList.add( 'nf-help-text' );\n\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\thelpIcon = document.createElement( 'span' );\n\t\t\t\t\t\thelpIcon.classList.add( 'dashicons', 'dashicons-admin-comments' );\n\t\t\t\t\t\thelpIconLink = document.createElement( 'a' );\n\t\t\t\t\t\thelpIconLink.classList.add( 'nf-help' );\n\t\t\t\t\t\thelpIconLink.setAttribute( 'href', '#' );\n\t\t\t\t\t\thelpIconLink.setAttribute( 'tabindex', '-1' );\n\t\t\t\t\t\thelpIconLink.appendChild( helpIcon );\n\t\t\t\t\t\thelpTextWrapper = document.createElement( 'span' );\n\t\t\t\t\t\thelpTextWrapper.appendChild( helpIconLink );\n\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t// Conditionals for setting a Value or CalcValue header\n\t\t\t\t\t\tconst isValue = 'undefined' !== typeof that.model.get('columns') && 'undefined' !== typeof that.model.get('columns').value;\n\t\t\t\t\t\tconst isCalc = 'undefined' !== typeof that.model.get('columns') && 'undefined' !== typeof that.model.get('columns').calc;\n\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t// Append the help text to the 'value' column\n\t\t\t\t\t\tif( isValue && -1 == that.model.get('columns').value.header.indexOf( helpTextWrapper.innerHTML ) ){\n\t\t\t\t\t\t\tconst helpText = document.createTextNode( nfi18n.valueChars );\n\t\t\t\t\t\t\thelpTextContainer.replaceChildren( helpText );\n\t\t\t\t\t\t\thelpTextWrapper.appendChild( helpTextContainer );\n\t\t\t\t\t\t\tthat.model.get('columns').value.header += helpTextWrapper.innerHTML;\n\t\t\t\t\t\t} \n\t\t\t\t\t\t// Append the help text to the 'calcValue' column\n\t\t\t\t\t\tif ( isCalc && -1 == that.model.get('columns').calc.header.indexOf( helpTextWrapper.innerHTML ) ) {\n\t\t\t\t\t\t\tconst helpText = document.createTextNode( nfi18n.calcValueChars );\n\t\t\t\t\t\t\thelpTextContainer.replaceChildren( helpText );\n\t\t\t\t\t\t\thelpTextWrapper.appendChild( helpTextContainer );\n\t\t\t\t\t\t\tthat.model.get('columns').calc.header += helpTextWrapper.innerHTML;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t    \t\t\tvar columns, beforeColumns, afterColumns;\n\n\t    \t\t\tbeforeColumns = document.createElement( 'div' );\n\n\t    \t\t\tcolumns = document.createElement( 'span' );\n\t    \t\t\tcolumns.appendChild( beforeColumns );\n\n\t\t\t\t\tif(!nfAdmin.devMode){\n\t\t\t\t\t\tdelete this.columns.value;\n\t\t\t\t\t}\n\n\t    \t\t\t_.each( this.columns, function( col ) {\n\t    \t\t\t\tvar headerText, headerContainer;\n\n\t    \t\t\t\t// Use a fragment to support HTML in the col.header property, ie Dashicons.\n                        headerText = document.createRange().createContextualFragment( col.header );\n\t    \t\t\t\theaderContainer = document.createElement( 'div' );\n\t    \t\t\t\theaderContainer.appendChild( headerText );\n\n\t    \t\t\t\tcolumns.appendChild( headerContainer );\n\t    \t\t\t} );\n\n                    afterColumns = document.createElement( 'div' );\n                    columns.appendChild( afterColumns );\n\n\t\t\t\t\treturn columns.innerHTML;\n\t\t\t\t},\n\n\t    \t\trenderSetting: function() {\n\t    \t\t\tvar setting = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-edit-setting-' + this.type );\n\t\t\t\t\treturn setting( this );\n\t\t\t\t},\n\n\t\t\t\trenderClasses: function() {\n\t\t\t\t\tvar classes = '';\n\t\t\t\t\tif ( 'undefined' != typeof this.width ) {\n\t\t\t\t\t\tclasses += this.width;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tclasses += ' one-half';\n\t\t\t\t\t}\n\n\t\t\t\t\tif ( this.error ) {\n\t\t\t\t\t\tclasses += ' nf-error';\n\t\t\t\t\t}\n\n\t\t\t\t\treturn classes;\n\t\t\t\t},\n\n\t\t\t\trenderVisible: function() {\n\t\t\t\t\treturn nfRadio.channel( 'settings' ).request( 'check:deps', this, that );\n\t    \t\t},\n\n\t\t\t\trenderError: function() {\n\t\t\t\t\tif ( this.error ) {\n\t\t\t\t\t\treturn this.error;\n\t\t\t\t\t}\n\t\t\t\t\treturn '';\n\t\t\t\t},\n\n\t\t\t\trenderFieldsetClasses: function() {\n\t\t\t\t\treturn that.model.get( 'name' );\n\t\t\t\t},\n\n\t\t\t\tcurrencySymbol: function() {\n\t\t\t\t\treturn nfRadio.channel( 'settings' ).request( 'get:setting', 'currency' ) || nfi18n.currency_symbol;\n\t\t\t\t}\n\t\t\t};\n\t\t},\n\n\t\tattachHtml: function( collectionView, childView ) {\n\t\t\tjQuery( collectionView.el ).find( '.nf-list-options-tbody' ).append( childView.el );\n\t\t\tnfRadio.channel( 'mergeTags' ).request( 'init', this );\n\t\t},\n\n\t\tevents: {\n\t\t\t'click .nf-add-new': 'clickAddOption',\n\t\t\t'click .extra': 'clickExtra'\n\t\t},\n        \n        maybeHideNew: function( collection ) {\n\t\t\tif( 'undefined' == typeof collection.settingModel ) return false;\n            var limit = collection.settingModel.get( 'max_options' );\n            if( 0 !== limit && collection.models.length >= ( limit ) ) {\n                jQuery(this.el).find('.nf-add-new').addClass('disabled');\n            } else {\n                jQuery(this.el).find('.nf-add-new').removeClass('disabled');\n            }\n        },\n\n\t\tclickAddOption: function( e ) {\n\t\t\tnfRadio.channel( 'option-repeater' ).trigger( 'click:addOption', this.collection, this.dataModel );\n\t\t\tjQuery( this.children.findByIndex(this.children.length - 1).el ).find( '[data-id=\"label\"]' ).focus();\n\t\t},\n\n\t\tclickExtra: function( e ) {\n\t\t\tnfRadio.channel( 'option-repeater' ).trigger( 'click:extra', e, this.collection, this.dataModel );\n\t\t\tnfRadio.channel( 'option-repeater-' + this.model.get( 'name' ) ).trigger( 'click:extra', e, this.model, this.collection, this.dataModel );\n\t\t},\n\n\t\tclickImport: function( e ) {\n\t\t\tvar textarea = jQuery( e.data.jBox.content ).find( 'textarea' );\n\t\t\tvar value = textarea.val().trimLeft().trimRight();\n\t\t\t/*\n\t\t\t * Return early if we have no strings.\n\t\t\t */\n\t\t\tif ( 0 == value.length ) {\n\t\t\t\te.data.jBox.close();\n\t\t\t\treturn false;\n\t\t\t}\t\t\t\n\t\t\t/*\n\t\t\t * Split our value based on new lines.\n\t\t\t */\n\n\t\t\tvar lines = value.split(/\\n/);\n\t\t\tif ( _.isArray( lines ) ) {\n\t\t\t\t/*\n\t\t\t\t * Loop over \n\t\t\t\t */\n\t\t\t\t_.each( lines, function( line ) {\n\t\t\t\t\tvar row = line.split( ',' );\n\t\t\t\t\tvar label = row[0];\n\t\t\t\t\tvar value = row[1] || jQuery.slugify( label, { separator: '-' } );\n\t\t\t\t\tvar calc = row[2] || '';\n\n\t\t\t\t\tlabel = label.trimLeft().trimRight();\n\t\t\t\t\tvalue = value.trimLeft().trimRight();\n\t\t\t\t\tcalc = calc.trimLeft().trimRight();\n\t\t\t\t\t/*\n\t\t\t\t\t * Add our row to the collection\n\t\t\t\t\t */\n\t\t\t\t\tvar model = e.data.view.collection.add( { label: row[0], value: value, calc: calc } );\n\t\t\t\t\t// Add our field addition to our change log.\n\t\t\t\t\tvar label = {\n\t\t\t\t\t\tobject: 'field',\n\t\t\t\t\t\tlabel: row[0],\n\t\t\t\t\t\tchange: 'Option Added',\n\t\t\t\t\t\tdashicon: 'plus-alt'\n\t\t\t\t\t};\n\n\t\t\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'addListOption', model, null, label );\n\t\t\t\t\tnfRadio.channel( 'option-repeater-' + e.data.view.model.get( 'name' ) ).trigger( 'add:option', model );\n\t\t\t\t\tnfRadio.channel( 'option-repeater' ).trigger( 'add:option', model );\n\t\t\t\t\tnfRadio.channel( 'app' ).trigger( 'update:setting', model );\n\t\t\t\t}, this );\n\t\t\t\t/*\n\t\t\t\t * Set our state to unclean so that the user can publish.\n\t\t\t\t */\n\t\t\t} else {\n\t\t\t\t/*\n\t\t\t\t * TODO: Error Handling Here\n\t\t\t\t */\n\t\t\t}\n\t\t\ttextarea.val( '' );\n\t\t\te.data.jBox.close();\n\t\t},\n\t} );\n\n\treturn view;\n} );\n\n","/**\n * Handles tasks associated with our option-repeater.\n * \n * Return our repeater child view.\n *\n * Also listens for changes to the options settings.\n * \n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/optionRepeater',['models/app/optionRepeaterModel', 'models/app/optionRepeaterCollection', 'views/app/drawer/optionRepeaterComposite'], function( listOptionModel, listOptionCollection, listCompositeView ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Respond to requests for the childView for list type fields.\n\t\t\tnfRadio.channel( 'option-repeater' ).reply( 'get:settingChildView', this.getSettingChildView, this );\n\t\t\t\n\t\t\t// Listen for changes to our list options.\n\t\t\tthis.listenTo( nfRadio.channel( 'option-repeater' ), 'change:option', this.changeOption );\n\t\t\tthis.listenTo( nfRadio.channel( 'option-repeater' ), 'click:addOption', this.addOption );\n\t\t\tthis.listenTo( nfRadio.channel( 'option-repeater' ), 'click:deleteOption', this.deleteOption );\n\n\t\t\t// Respond to requests related to our list options sortable.\n\t\t\tnfRadio.channel( 'option-repeater' ).reply( 'update:optionSortable', this.updateOptionSortable, this );\n\t\t\tnfRadio.channel( 'option-repeater' ).reply( 'stop:optionSortable', this.stopOptionSortable, this );\n\t\t\tnfRadio.channel( 'option-repeater' ).reply( 'start:optionSortable', this.startOptionSortable, this );\n\t\t\n\t\t\t/**\n\t\t\t * When we init our setting model, we need to convert our array/objects into collections/models\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'option-repeater' ), 'init:dataModel', this.convertSettings );\n\t\t},\n\n\t\t/**\n\t\t * Update an option value in our model.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object\t\t\te          event\n\t\t * @param  backbone.model \tmodel      option model\n\t\t * @param  backbone.model \tdataModel\n\t\t * @return void\n\t\t */\n\t\tchangeOption: function( e, model, dataModel, settingModel, optionView ) {\n\t\t\tvar name = jQuery( e.target ).data( 'id' );\n\t\t\tif ( 'selected' == name ) {\n\t\t\t\tif ( jQuery( e.target ).prop( 'checked' ) ) {\n\t\t\t\t\tvar value = 1;\n\t\t\t\t} else {\n\t\t\t\t\tvar value = 0;\n\t\t\t\t}\n\t\t\t} else if ('calc' == name) {\n\t\t\t\tvar value = Number(jQuery(e.target).val());\n\t\t\t\tif( isNaN(value) ) {\n\t\t\t\t\tvalue = 0;\n\t\t\t\t\tjQuery(e.target).val(0);\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tvar value = jQuery( e.target ).val();\n\t\t\t}\n\t\t\t\n\t\t\tvar before = model.get( name );\n\t\t\t\n\t\t\tmodel.set( name, value );\n\t\t\t// Trigger an update on our dataModel\n\t\t\tthis.triggerDataModel( model, dataModel );\n\n\t\t\tvar after = value;\n\t\t\t\n\t\t\tvar changes = {\n\t\t\t\tattr: name,\n\t\t\t\tbefore: before,\n\t\t\t\tafter: after\n\t\t\t}\n\n\t\t\tvar label = {\n\t\t\t\tobject: dataModel.get( 'objectType' ),\n\t\t\t\tlabel: dataModel.get( 'label' ),\n\t\t\t\tchange: 'Option ' + model.get( 'label' ) + ' ' + name + ' changed from ' + before + ' to ' + after\n\t\t\t};\n\n\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'changeSetting', model, changes, label );\n\t\t\tnfRadio.channel( 'option-repeater' ).trigger( 'update:option', model, dataModel, settingModel, optionView );\n\t\t\tnfRadio.channel( 'option-repeater-option-' + name  ).trigger( 'update:option', e, model, dataModel, settingModel, optionView );\n\t\t\tnfRadio.channel( 'option-repeater-' + settingModel.get( 'name' ) ).trigger( 'update:option', model, dataModel, settingModel, optionView );\n\t\t},\n\n\t\t/**\n\t\t * Add an option to our list\n\t\t * \n\t\t * @since 3.0\n\t\t * @param backbone.collection \tcollection \tlist option collection\n\t\t * @param backbone.model \t\tdataModel\n\t\t * @return void\n\t\t */\n\t\taddOption: function( collection, dataModel ) {\n\t\t\tvar modelData = {\n\t\t\t\torder: collection.length,\n\t\t\t\tnew: true,\n\t\t\t\toptions: {}\n\t\t\t};\n\t\t\t/**\n\t\t\t * If we don't actually have a 'settingModel' duplicated fields\n\t\t\t * can't add options until publish and the builder is reloaded.\n\t\t\t * If we ignore the code if we don't have settingsModel, then it\n\t\t\t * works.\n\t\t\t */\n\t\t\tif  ( 'undefined' !== typeof collection.settingModel ) {\n\t\t\t\tvar limit = collection.settingModel.get( 'max_options' );\n\t\t\t\tif ( 0 !== limit && collection.models.length >= limit ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\t_.each( collection.settingModel.get( 'columns' ), function ( col, key ) {\n\t\t\t\t\tmodelData[ key ] = col.default;\n\n\t\t\t\t\tif ( 'undefined' != typeof col.options ) {\n\t\t\t\t\t\tmodelData.options[ key ] = col.options;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t\tvar model = new listOptionModel( modelData );\n\t\t\tcollection.add( model );\n\n\t\t\t// Add our field addition to our change log.\n\t\t\tvar label = {\n\t\t\t\tobject: dataModel.get( 'objectType' ),\n\t\t\t\tlabel: dataModel.get( 'label' ),\n\t\t\t\tchange: 'Option Added',\n\t\t\t\tdashicon: 'plus-alt'\n\t\t\t};\n\n\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'addListOption', model, null, label );\n\n\t\t\tif ( 'undefined' !== typeof collection.settingModel ) {\n\t\t\t\tnfRadio.channel('option-repeater-' + collection.settingModel.get('name')).trigger('add:option', model);\n\t\t\t}\n\t\t\tnfRadio.channel( 'option-repeater' ).trigger( 'add:option', model );\n\t\t\tnfRadio.channel( 'option-repeater' ).trigger( 'added:option', collection );\n\t\t\tthis.triggerDataModel( model, dataModel );\n\t\t},\n\n\t\t/**\n\t\t * Delete an option from our list\n\t\t * \n\t\t * @since  3.0\n\t\t * @param backbone.model \t\tmodel       list option model\n\t\t * @param backbone.collection \tcollection \tlist option collection\n\t\t * @param backbone.model \t\tdataModel\n\t\t * @return void\n\t\t */\n\t\tdeleteOption: function( model, collection, dataModel ) {\n\t\t\tvar newModel = nfRadio.channel( 'app' ).request( 'clone:modelDeep', model );\n\n\t\t\t// Add our field deletion to our change log.\n\t\t\tvar label = {\n\t\t\t\tobject: dataModel.get( 'objectType' ),\n\t\t\t\tlabel: dataModel.get( 'label' ),\n\t\t\t\tchange: 'Option ' + newModel.get( 'label' ) + ' Removed',\n\t\t\t\tdashicon: 'dismiss'\n\t\t\t};\n\n\t\t\tvar data = {\n\t\t\t\tcollection: collection\n\t\t\t}\n\n\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'removeListOption', newModel, null, label, data );\n\t\t\t\n\t\t\tvar changeCollection = nfRadio.channel( 'changes' ).request( 'get:collection' );\n\t\t\tvar results = changeCollection.where( { model: model } );\n\n\t\t\t_.each( results, function( changeModel ) {\n\t\t\t\tif ( 'object' == typeof changeModel.get( 'data' ) ) {\n\t\t\t\t\t_.each( changeModel.get( 'data' ), function( dataModel ) {\n\t\t\t\t\t\tif ( dataModel.model == dataModel ) {\n\t\t\t\t\t\t\tdataModel.model = newModel;\n\t\t\t\t\t\t}\n\t\t\t\t\t} );\n\t\t\t\t}\n\t\t\t\tchangeModel.set( 'model', newModel );\n\t\t\t\tchangeModel.set( 'disabled', true );\n\t\t\t} );\n\n\t\t\tcollection.remove( model );\n\t\t\tnfRadio.channel( 'option-repeater' ).trigger( 'remove:option', model );\n\t\t\tnfRadio.channel( 'option-repeater' ).trigger( 'removed:option', collection );\n\t\t\tnfRadio.channel( 'option-repeater-' + collection.settingModel.get( 'name' ) ).trigger( 'remove:option', model );\n\t\t\tthis.triggerDataModel( model, dataModel );\n\t\t},\n\n\t\t/**\n\t\t * Creates an arbitrary value on our collection, then clones and updates that collection.\n\t\t * This forces a change event to be fired on the dataModel where the list option collection data is stored.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param backbone.collection \tcollection \tlist option collection\n\t\t * @param backbone.model \t\tdataModel\n\t\t * @return void\n\t\t */\n\t\ttriggerDataModel: function( model, dataModel ) {\n\t\t\tnfRadio.channel( 'app' ).trigger( 'update:setting', model );\t\n\t\t},\n\n\t\t/**\n\t\t * Return our list composite view to the setting collection view.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  backbone.model \tmodel \tsettings model\n\t\t * @return void\n\t\t */\n\t\tgetSettingChildView: function( model ) {\n\t\t\treturn listCompositeView;\n\t\t},\n\n\t\t/**\n\t\t * When we sort our list options, change the order in our option model and trigger a change.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object\t \t\tsortable \tjQuery UI element\n\t\t * @param  backbone.view \tsetting  \tSetting view\n\t\t * @return void\n\t\t */\n\t\tupdateOptionSortable: function( ui, sortable, setting ) {\n\t\t\tvar newOrder = jQuery( sortable ).sortable( 'toArray' );\n\t\t\tvar dragModel = setting.collection.get( { cid: jQuery( ui.item ).prop( 'id' ) } );\n\t\t\tvar data = {\n\t\t\t\tcollection: setting.collection,\n\t\t\t\tobjModels: []\n\t\t\t};\n\n\t\t\t_.each( newOrder, function( cid, index ) {\n\t\t\t\tvar optionModel = setting.collection.get( { cid: cid } );\n\t\t\t\tvar oldPos = optionModel.get( 'order' );\n\t\t\t\toptionModel.set( 'order', index );\n\t\t\t\tvar newPos = index;\n\n\t\t\t\tdata.objModels.push( {\n\t\t\t\t\tmodel: optionModel,\n\t\t\t\t\tattr: 'order',\n\t\t\t\t\tbefore: oldPos,\n\t\t\t\t\tafter: newPos\n\t\t\t\t} );\n\t\t\t} );\n\t\t\t\n\t\t\tsetting.collection.sort( { silent: true } );\n\t\t\t\n\t\t\tvar label = {\n\t\t\t\tobject: setting.dataModel.get( 'objectType' ),\n\t\t\t\tlabel: setting.dataModel.get( 'label' ),\n\t\t\t\tchange: 'Option ' + dragModel.get( 'label' ) + ' re-ordered from ' + dragModel._previousAttributes.order + ' to ' + dragModel.get( 'order' ),\n\t\t\t\tdashicon: 'sort'\n\t\t\t};\n\n\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'sortListOptions', dragModel, null, label, data );\n\t\t\tthis.triggerDataModel( dragModel, setting.dataModel );\n\t\t\tnfRadio.channel( 'option-repeater' ).trigger( 'sort:option', dragModel, setting );\n\t\t\tnfRadio.channel( 'option-repeater-' + setting.model.get( 'name' ) ).trigger( 'sort:option', dragModel, setting );\n\t\t},\n\n\t\t/**\n\t\t * When we stop sorting our list options, reset our item opacity.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object ui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\tstopOptionSortable: function( ui ) {\n\t\t\tjQuery( ui.item ).css( 'opacity', '' );\n\t\t},\n\n\t\t/**\n\t\t * When we start sorting our list options, remove containing divs and set our item opacity to 0.5\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Objects ui jQuery UI element\n\t\t * @return void\n\t\t */\n\t\tstartOptionSortable: function( ui ) {\n\t\t\tjQuery( ui.placeholder ).find( 'div' ).remove();\n\t\t\tjQuery( ui.item ).css( 'opacity', '0.5' ).show();\n\t\t},\n\n\t\t/**\n\t\t * Convert settings from an array/object to a collection/model\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Backbone.Model dataModel\n\t\t * @param  Backbone.Model settingModel\n\t\t * @return void\n\t\t */\n\t\tconvertSettings: function( dataModel, settingModel ) {\n\t\t\t/*\n\t\t\t * Our options are stored in our database as objects, not collections.\n\t\t\t * Before we attempt to render them, we need to convert them to a collection if they aren't already one.\n\t\t\t */ \n\t\t\tvar optionCollection = dataModel.get( settingModel.get( 'name' ) );\n\n\t\t\tif ( false == optionCollection instanceof Backbone.Collection ) {\n\t\t\t\toptionCollection = new listOptionCollection( [], { settingModel: settingModel } );\n\t\t\t\toptionCollection.add( dataModel.get( settingModel.get( 'name' ) ) );\n\t\t\t\tdataModel.set( settingModel.get( 'name' ), optionCollection, { silent: true } );\n\t\t\t}\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","define( 'views/app/drawer/imageOptionRepeaterOption',['views/app/drawer/optionRepeaterError'], function( ErrorView ) {\n    var view = Marionette.LayoutView.extend({\n        tagName: 'div',\n        className: 'nf-table-row',\n        template: '#tmpl-nf-edit-setting-image-option-repeater-default-row',\n        id: function() {\n            return this.model.cid;\n        },\n\n        regions: {\n            error: '.nf-option-error'\n        },\n\n        initialize: function( data ) {\n            this.settingModel = data.settingModel;\n            this.dataModel = data.dataModel;\n            this.collection = data.collection;\n            this.columns = data.columns;\n            this.parentView = data.parentView;\n            this.model.on( 'change:errors', this.renderErrors, this );\n\n            // Removed because the re-render was breaking tag insertion for merge tags.\n            // this.model.on( 'change', this.render, this );\n\n            if ( 'undefined' != typeof this.settingModel.get( 'tmpl_row' ) ) {\n                this.template = '#' + this.settingModel.get( 'tmpl_row' );\n            }\n\n            this.listenTo( nfRadio.channel( 'image-option-repeater' ), 'click:extra', this.clickExtra );\n\n            this.hasErrors = false;\n        },\n\n        onBeforeDestroy: function() {    \n            this.model.off( 'change', this.render );\n            this.model.off( 'change:errors', this.renderErrors );\n        },\n\n        onBeforeRender: function() {\n            /*\n             * We want to escape any HTML being output for our image.\n             */\n            if ( this.model.get( 'image' ) ) {\n                var image = this.model.get( 'image' );\n                this.model.set( 'image', _.escape( image ), { silent: true } );\n            }\n            \n        },\n\n        onRender: function() {\n            nfRadio.channel( 'mergeTags' ).request( 'init', this );\n            /*\n             * Send out a radio message.\n             */\n            nfRadio.channel( 'setting-' + this.settingModel.get( 'name' ) + '-option' ).trigger( 'render:setting', this.model, this.dataModel, this );\n            /*\n             * We want to unescape any HTML being output for our image.\n             */\n            if ( this.model.get( 'image' ) ) {\n                var image = this.model.get( 'image' );\n                this.model.set( 'image', _.unescape( image ), { silent: true } );\n            }\n        },\n\n        onShow: function() {\n            if ( this.model.get( 'new' ) ) {\n                jQuery( this.el ).find( 'input:first' ).focus();\n                this.model.set( 'new', false );\n            }\n        },\n\n        events: {\n            'change .setting': 'changeOption',\n            'click .nf-delete': 'deleteOption',\n            'keyup': 'keyupOption',\n            // 'click .open-media-manager': 'openMediaModal'\n        },\n\n        changeOption: function( e ) {\n            nfRadio.channel( 'image-option-repeater' ).trigger( 'change:option', e, this.model, this.dataModel, this.settingModel, this );\n        },\n\n        deleteOption: function( e ) {\n            nfRadio.channel( 'image-option-repeater' ).trigger( 'click:deleteOption', this.model, this.collection, this.dataModel, this );\n        },\n\n        keyupOption: function( e ) {\n            this.maybeAddOption( e );\n            nfRadio.channel( 'image-option-repeater' ).trigger( 'keyup:option', e, this.model, this.dataModel, this.settingModel, this )\n            nfRadio.channel( 'image-option-repeater-' + this.settingModel.get( 'name' ) ).trigger( 'keyup:option', e, this.model, this.dataModel, this.settingModel, this )\n        },\n\n        maybeAddOption: function( e ) {\n            if ( 13 == e.keyCode && 'calculations' != this.settingModel.get( 'name' ) ) {\n                nfRadio.channel( 'image-option-repeater' ).trigger( 'click:addOption', this.collection, this.dataModel, this );\n                jQuery( this.parentView.children.findByIndex(this.parentView.children.length - 1).el ).find( '[data-id=\"image\"]' ).focus();\n            }\n        },\n\n        clickExtra: function(e, settingModel, dataModel, settingView) {\n            \n            var textEl = jQuery(e.target).parent().find('.setting');\n            var optionContainerDiv = jQuery(e.target).parent().parent().parent();\n\n            var valueEl = jQuery(optionContainerDiv[0]).find('[data-id=\"value\"]');\n\n            var imageIdEl = jQuery(optionContainerDiv[0]).find('[data-id=\"image_id\"]');\n\n            var labelEl = jQuery(optionContainerDiv[0]).find('[data-id=\"label\"]');\n            \n            if ( jQuery( e.target ).hasClass( 'open-media-manager' )\n                && this.el.id === optionContainerDiv[0].id) {\n                // If the frame already exists, re-open it.\n                if ( this.meta_image_frame ) {\n                    this.meta_image_frame.open();\n                    return;\n                }\n\n                // Sets up the media library frame\n                this.meta_image_frame = wp.media.frames.meta_image_frame = wp.media({\n                    title: 'Select a file',\n                    button: { text:  'insert' }\n                });\n\n                var that = this;\n\n                // Runs when an image is selected.\n                this.meta_image_frame.on('select', function(){\n                    // Grabs the attachment selection and creates a JSON representation of the model.\n                    var media_attachment = that.meta_image_frame.state().get('selection').first().toJSON();\n                    \n                    textEl.val(media_attachment.url).change();\n                    valueEl.val(media_attachment.filename).change();\n                    labelEl.val(media_attachment.title).change();\n                    imageIdEl.val(media_attachment.id).change();\n                    var img_container = optionContainerDiv.find('.option-image-container');\n\n                    if(img_container) {\n                        $imgs = jQuery(img_container).find('img');\n                        if($imgs.length > 0) {\n                            jQuery($imgs[0]).attr('src', media_attachment.url);\n                        } else {\n                            var new_img = document.createElement('img');\n                            new_img.style=\"max-width:100px;display:inline-block;\";\n                            new_img.src = media_attachment.url;\n                            jQuery(img_container).append(new_img);\n                        }\n                    }\n                });\n\n                // Opens the media library frame.\n                this.meta_image_frame.open();\n            }\n        },\n\n        renderErrors: function() {\n            \n            // if ( jQuery.isEmptyObject( this.model.get( 'errors' ) ) ) {\n            //     return false;\n            // }\n\n            /*\n             * We don't want to redraw the entire row, which would remove focus from the eq textarea,\n             * so we add and remove error classes manually.\n             */\n            if ( 0 == Object.keys( this.model.get( 'errors' ) ) ) {\n                if ( this.hasErrors ) {\n                    this.error.empty();\n                    jQuery( this.el ).removeClass( 'nf-error' );\n                }\n            } else {\n                this.hasErrors = true;\n                this.error.show( new ErrorView( { model: this.model } ) );\n                jQuery( this.el ).addClass( 'nf-error' );\n            }\n        },\n\n        templateHelpers: function() {\n            var that = this;\n            return {\n                getColumns: function() {\n                    var columns = that.columns;\n                    if(!nfAdmin.devMode){\n                        delete columns.value;\n                    }\n                    return columns;\n                },\n                renderFieldSelect: function( dataID, value ){\n                    var initialOption, select, emptyContainer, image;\n\n                    var fields = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\n                    initialOption = document.createElement( 'option' );\n                    initialOption.value = '';\n                    initialOption.image = '';\n                    initialOption.innerHTML = '--';\n\n                    select = document.createElement( 'select' );\n                    select.classList.add( 'setting' );\n                    select.setAttribute( 'data-id', dataID );\n                    select.appendChild( initialOption );\n\n                    fields.each( function( field ){\n                        var option = document.createElement( 'option' );\n                        if ( value == field.get( 'key' ) ) {\n                            option.setAttribute( 'selected', 'selected' );\n                        }\n                        option.value = field.get( 'key' );\n                        option.innerHTML = field.formatLabel();\n                        option.image = field.formatLabel();\n                        select.appendChild( option );\n                    });\n\n                    image = document.createElement( 'image' );\n                    image.classList.add( 'nf-select' );\n                    image.appendChild( select );\n\n                    // Select Lists need an empty '<div></div>' for styling purposes.\n                    emptyContainer = document.createElement( 'div' );\n                    emptyContainer.style.bottom = '6px';\n                    image.appendChild( emptyContainer );\n\n                    // The template requires a string.\n                    return image.innerHTML;\n                },\n                renderNonSaveFieldSelect: function( dataID, value ){\n                    var initialOption, select, emptyContainer, image;\n\n                    var fields = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\n                    initialOption = document.createElement( 'option' );\n                    initialOption.value = '';\n                    initialOption.image = '';\n                    initialOption.innerHTML = '--';\n\n                    select = document.createElement( 'select' );\n                    select.classList.add( 'setting' );\n                    select.setAttribute( 'data-id', dataID );\n                    select.appendChild( initialOption );\n\n                    // Build a lookup table for fields we want to remove from our fields list.\n                    var removeFieldsLookup = [ 'html', 'submit', 'hr',\n                        'recaptcha', 'spam', 'creditcard', 'creditcardcvc',\n                        'creditcardexpiration', 'creditcardfullname',\n                        'creditcardnumber', 'creditcardzip' ];\n\n                    fields.each( function( field ){\n                        // Check for the field type in our lookup array and...\n                        if( jQuery.inArray( field.get( 'type' ), removeFieldsLookup ) !== -1 ) {\n                            // Return if the type is in our lookup array.\n                            return '';\n                        }\n\n                        var option = document.createElement( 'option' );\n                        if ( value == field.get( 'key' ) ) {\n                            option.setAttribute( 'selected', 'selected' );\n                        }\n                        option.value = field.get( 'key' );\n                        option.innerHTML = field.formatLabel();\n                        option.image = field.formatLabel();\n                        select.appendChild( option );\n                    });\n\n                    image = document.createElement( 'image' );\n                    image.classList.add( 'nf-select' );\n                    image.appendChild( select );\n\n                    // Select Lists need an empty '<div></div>' for styling purposes.\n                    emptyContainer = document.createElement( 'div' );\n                    emptyContainer.style.bottom = '6px';\n                    image.appendChild( emptyContainer );\n\n                    // The template requires a string.\n                    return image.innerHTML;\n                },\n                renderOptions: function( column, value ) {\n\n                    if( 'undefined' == typeof that.options.columns[ column ] ) return;\n\n                    var select = document.createElement( 'select' );\n                    \n                    _.each( that.options.columns[ column ].options, function( option ){\n                        var optionNode = document.createElement( 'option' );\n                        if ( value === option.value ) {\n                            optionNode.setAttribute( 'selected', 'selected' );\n                        }\n                        optionNode.setAttribute( 'value', option.value );\n                        optionNode.setAttribute( 'image_id', option.image_id);\n                        optionNode.setAttribute( 'image', option.image );\n                        optionNode.innerText = option.image;\n                        select.appendChild( optionNode );\n                    });\n\n                    // The template only needs the options.\n                    return select.innerHTML;\n                }\n\n            }\n        }\n\n    });\n\n    return view;\n} );\n\n","define( 'views/app/drawer/imageOptionRepeaterComposite',['views/app/drawer/imageOptionRepeaterOption', 'views/app/drawer/optionRepeaterEmpty', 'models/app/optionRepeaterCollection'], function( listOptionView, listEmptyView, listOptionCollection ) {\n\tvar view = Marionette.CompositeView.extend( {\n\t\ttemplate: '#tmpl-nf-edit-setting-image-option-repeater-wrap',\n\t\tchildView: listOptionView,\n\t\temptyView: listEmptyView,\n\t\treorderOnSort: false,\n\n\t\tinitialize: function( data ) {\n\n\t\t\t/*\n\t\t\t * Our options are stored in our database as objects, not collections.\n\t\t\t * Before we attempt to render them, we need to convert them to a collection if they aren't already one.\n\t\t\t */ \n\t\t\tvar optionCollection = data.dataModel.get( this.model.get( 'name' ) );\n\n\t\t\tif ( false == optionCollection instanceof Backbone.Collection ) {\n\t\t\t\toptionCollection = new listOptionCollection( [], { settingModel: this.model } );\n\t\t\t\toptionCollection.add( data.dataModel.get( this.model.get( 'name' ) ) );\n\t\t\t\tdata.dataModel.set( this.model.get( 'name' ), optionCollection, { silent: true } );\n\t\t\t}\n\n\t\t\tthis.collection = optionCollection;\n\t\t\tthis.dataModel = data.dataModel;\n\t\t\tthis.childViewOptions = { parentView: this, settingModel: this.model, collection: this.collection, dataModel: data.dataModel, columns: this.model.get( 'columns' ) };\n\n\t\t\tvar deps = this.model.get( 'deps' );\n\t\t\tif ( deps ) {\n\t\t\t\t// If we don't have a 'settings' property, this is a legacy depdency setup.\n\t\t\t\tif ( 'undefined' == typeof deps.settings ) {\n\t\t\t\t\tdeps.settings = [];\n\t\t\t\t\t_.each(deps, function(dep, name){\n\t\t\t\t\t\tif( 'settings' !== name ) {\n\t\t\t\t\t\t\tdeps.settings.push( { name: name, value: dep } );\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tdeps.match = 'all';\n\t\t\t\t}\n\n\t\t\t\tfor (var i = deps.settings.length - 1; i >= 0; i--) {\n\t\t\t\t\tlet name = deps.settings[i].name;\n\t\t\t\t\tthis.dataModel.on( 'change:' + name, this.render, this );\n\t\t\t\t}\n\t\t\t}\n            this.listenTo( nfRadio.channel( 'image-option-repeater' ), 'added:option', this.maybeHideNew );\n            this.listenTo( nfRadio.channel( 'image-option-repeater' ), 'removed:option', this.maybeHideNew );\n\t\t},\n\n\t\tonBeforeDestroy: function() {\n\t\t\tvar deps = this.model.get( 'deps' );\n\t\t\tif ( deps ) {\n\t\t\t\tfor (var i = deps.settings.length - 1; i >= 0; i--) {\n\t\t\t\t\tlet name = deps.settings[i].name;\n\t\t\t\t\tthis.dataModel.off( 'change:' + name, this.render );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tonRender: function() {\n\t\t\t// this.$el = this.$el.children();\n\t\t\t// this.$el.unwrap();\n\t\t\t// this.setElement( this.$el );\n\n\t\t\t// this.$el = this.$el.children();\n\t\t\t// this.$el.unwrap();\n\t\t\t// this.setElement( this.$el );\n\t\t\n\t\t\tvar that = this;\n\t\t\tjQuery( this.el ).find( '.nf-listimage-options-tbody' ).sortable( {\n\t\t\t\thandle: '.handle',\n\t\t\t\thelper: 'clone',\n\t\t\t\tplaceholder: 'nf-listimage-options-sortable-placeholder',\n\t\t\t\tforcePlaceholderSize: true,\n\t\t\t\topacity: 0.95,\n\t\t\t\ttolerance: 'pointer',\n\n\t\t\t\tstart: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'image-option-repeater' ).request( 'start:optionSortable', ui );\n\t\t\t\t},\n\n\t\t\t\tstop: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'image-option-repeater' ).request( 'stop:optionSortable', ui );\n\t\t\t\t},\n\n\t\t\t\tupdate: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'image-option-repeater' ).request( 'update:optionSortable', ui, this, that );\n\t\t\t\t}\n\t\t\t} );\n\n            that.setupTooltip();\n            that.maybeHideNew( that.collection );\n\n\t\t\t/*\n\t\t\t * Send out a radio message.\n\t\t\t */\n\t\t\tnfRadio.channel( 'setting-' + this.model.get( 'name' ) ).trigger( 'render:setting', this.model, this.dataModel, this );\n\t\t\n\t\t},\n\n\t\tonAttach: function() {\n\n\t\t},\n        \n        /**\n         * Function to append jBox modals to each tooltip element in the option repeater.\n         */\n        setupTooltip: function() {\n            // For each .nf-help in the option repeater...\n            jQuery( this.el ).find( '.nf-listimage-options' ).find( '.nf-help' ).each(function() {\n                // Get the content.\n                var content = jQuery(this).next('.nf-help-text');\n                // Declare the modal.\n                jQuery( this ).jBox( 'Tooltip', {\n                    content: content,\n                    maxWidth: 200,\n                    theme: 'TooltipBorder',\n                    trigger: 'click',\n                    closeOnClick: true\n                })\n            });\n        },\n\n\t\ttemplateHelpers: function () {\n\t\t\tvar that = this;\n\n\t    \treturn {\n\t    \t\trenderHeaders: function() {\n                    // If this is a Field...\n                    // AND If the type includes 'list'...\n                    if ( 'Field' == that.dataModel.get( 'objectType' ) && -1 !== that.dataModel.get( 'type' ).indexOf( 'list' ) ) {\n                        // Declare help text.\n                        var helpText, helpTextContainer, helpIcon, helpIconLink, helpTextWrapper;\n\n                        helpText = document.createTextNode( nfi18n.valueChars );\n                        helpTextContainer = document.createElement( 'div' );\n                        helpTextContainer.classList.add( 'nf-help-text' );\n                        helpTextContainer.appendChild( helpText );\n\n                        helpIcon = document.createElement( 'span' );\n                        helpIcon.classList.add( 'dashicons', 'dashicons-admin-comments' );\n                        helpIconLink = document.createElement( 'a' );\n                        helpIconLink.classList.add( 'nf-help' );\n                        helpIconLink.setAttribute( 'href', '#' );\n                        helpIconLink.setAttribute( 'tabindex', '-1' );\n                        helpIconLink.appendChild( helpIcon );\n\n                        helpTextWrapper = document.createElement( 'span' );\n                        helpTextWrapper.appendChild( helpIconLink );\n                        helpTextWrapper.appendChild( helpTextContainer );\n\n\t\t\t\t\t\t// Append the help text to the 'value' header.\n\t\t\t\t\t\tif('undefined' !== typeof that.model.get('columns') ){\n\t\t\t\t\t\t\tif('undefined' !== typeof that.model.get('columns').value ){\n\t\t\t\t\t\t\t\tif ( -1 == that.model.get('columns').value.header.indexOf( helpTextWrapper.innerHTML ) ) {\n\t\t\t\t\t\t\t\t\tthat.model.get('columns').value.header += helpTextWrapper.innerHTML;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n                    }\n\t\t\t\t\t// If this is a Field and If the type includes 'list'...\n\t\t\t\t\tif ( 'Field' == that.dataModel.get( 'objectType' ) && -1 !== that.dataModel.get( 'type' ).indexOf( 'list' ) ) {\n\t\t\t\t\t\t// Declare help text elements.\n\t\t\t\t\t\tlet helpTextContainer, helpIcon, helpIconLink, helpTextWrapper;\n\t\t\t\t\t\t\n\t\t\t\t\t\thelpTextContainer = document.createElement( 'div' );\n\t\t\t\t\t\thelpTextContainer.classList.add( 'nf-help-text' );\n\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\thelpIcon = document.createElement( 'span' );\n\t\t\t\t\t\thelpIcon.classList.add( 'dashicons', 'dashicons-admin-comments' );\n\t\t\t\t\t\thelpIconLink = document.createElement( 'a' );\n\t\t\t\t\t\thelpIconLink.classList.add( 'nf-help' );\n\t\t\t\t\t\thelpIconLink.setAttribute( 'href', '#' );\n\t\t\t\t\t\thelpIconLink.setAttribute( 'tabindex', '-1' );\n\t\t\t\t\t\thelpIconLink.appendChild( helpIcon );\n\t\t\t\t\t\thelpTextWrapper = document.createElement( 'span' );\n\t\t\t\t\t\thelpTextWrapper.appendChild( helpIconLink );\n\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t// Conditionals for setting a Value or CalcValue header\n\t\t\t\t\t\tconst isValue = 'undefined' !== typeof that.model.get('columns') && 'undefined' !== typeof that.model.get('columns').value;\n\t\t\t\t\t\tconst isCalc = 'undefined' !== typeof that.model.get('columns') && 'undefined' !== typeof that.model.get('columns').calc;\n\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t// Append the help text to the 'value' column\n\t\t\t\t\t\tif( isValue && -1 == that.model.get('columns').value.header.indexOf( helpTextWrapper.innerHTML ) ){\n\t\t\t\t\t\t\tconst helpText = document.createTextNode( nfi18n.valueChars );\n\t\t\t\t\t\t\thelpTextContainer.replaceChildren( helpText );\n\t\t\t\t\t\t\thelpTextWrapper.appendChild( helpTextContainer );\n\t\t\t\t\t\t\tthat.model.get('columns').value.header += helpTextWrapper.innerHTML;\n\t\t\t\t\t\t} \n\t\t\t\t\t\t// Append the help text to the 'calcValue' column\n\t\t\t\t\t\tif ( isCalc && -1 == that.model.get('columns').calc.header.indexOf( helpTextWrapper.innerHTML ) ) {\n\t\t\t\t\t\t\tconst helpText = document.createTextNode( nfi18n.calcValueChars );\n\t\t\t\t\t\t\thelpTextContainer.replaceChildren( helpText );\n\t\t\t\t\t\t\thelpTextWrapper.appendChild( helpTextContainer );\n\t\t\t\t\t\t\tthat.model.get('columns').calc.header += helpTextWrapper.innerHTML;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t    \t\t\tvar columns, beforeColumns, afterColumns;\n\n\t    \t\t\tbeforeColumns = document.createElement( 'div' );\n\n