injas\n * @since 3.0\n */\ndefine( 'views/app/drawer/headerNewForm',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-drawer-header-new-form'\n\t});\n\n\treturn view;\n} );\n","/**\n * Config file for our app drawers.\n *\n * this.collection represents all of our registered drawers.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/drawerConfig',[\n\t'models/app/drawerCollection',\n\t'views/fields/drawer/addField',\n\t'views/app/drawer/editSettings',\n\t'views/app/drawer/headerEditSettings',\n\t'views/actions/drawer/addAction',\n\t'views/app/drawer/contentViewChanges',\n\t'views/app/drawer/headerViewChanges',\n\t'views/app/drawer/contentPublicLink',\n\t'views/app/drawer/headerPublicLink',\n\t'views/app/drawer/contentNewForm',\n\t'views/app/drawer/headerNewForm'\n\t], function(\n\t\tdrawerCollection,\n\t\taddFieldView,\n\t\teditSettingsView,\n\t\teditSettingsHeaderView,\n\t\taddActionView,\n\t\tviewChangesView,\n\t\tviewChangesHeaderView,\n\t\tpublicLinkView,\n\t\tpublicLinkHeaderView,\t\t\n\t\tnewFormView,\n\t\tnewFormHeaderView,\n\t\tmobileItemControlsView\n\t) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\n\t\t\tthis.collection = new drawerCollection( [\n\t\t\t\t{\n\t\t\t\t\tid: 'addField',\n\n\t\t\t\t\tgetContentView: function( data ) {\n\t\t\t\t\t\treturn new addFieldView( data );\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\tid: 'addAction',\n\n\t\t\t\t\tgetContentView: function( data ) {\n\t\t\t\t\t\treturn new addActionView( data );\n\t\t\t\t\t}\n\t\t\t\t},\t\t\t\t\n\t\t\t\t{\n\t\t\t\t\tid: 'editSettings',\n\n\t\t\t\t\t/*\n\t\t\t\t\t * TODO: Add filtering when editing settings. For now, removing them from settings.\n\t\t\t\t\t */\n\t\t\t\t\tgetHeaderView: function( data ) {\n\t\t\t\t\t\t/*\n\t\t\t\t\t\t * Get a custom setting header view if one is set.\n\t\t\t\t\t\t * TODO: Currently, this only works for advanced settings.\n\t\t\t\t\t\t * This could be used to replace the need for a single config file.\n\t\t\t\t\t\t */\n\t\t\t\t\t\tif ( 'undefined' != typeof data.typeModel ) {\n\t\t\t\t\t\t\tvar view = nfRadio.channel( data.typeModel.get( 'id' ) ).request( 'get:drawerHeaderView' ) || editSettingsHeaderView;\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tvar view = editSettingsHeaderView;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn new view( data );\n\t\t\t\t\t},\n\n\t\t\t\t\tgetContentView: function( data ) {\n\t\t\t\t\t\treturn new editSettingsView( data );\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\tid: 'viewChanges',\n\n\t\t\t\t\t// getHeaderView() is defined by default, but we need to override it for the viewChanges drawer.\n\t\t\t\t\tgetHeaderView: function( data ) {\n\t\t\t\t\t\treturn new viewChangesHeaderView( data );\n\t\t\t\t\t},\n\n\t\t\t\t\tgetContentView: function( data ) {\n\t\t\t\t\t\treturn new viewChangesView( data );\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\tid: 'publicLink',\n\n\t\t\t\t\t// getHeaderView() is defined by default, but we need to override it for the publicLink drawer.\n\t\t\t\t\tgetHeaderView: function( data ) {\n\t\t\t\t\t\treturn new publicLinkHeaderView( data );\n\t\t\t\t\t},\n\n\t\t\t\t\tgetContentView: function( data ) {\n\t\t\t\t\t\treturn new publicLinkView( data );\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\tid: 'newForm',\n\n\t\t\t\t\t// getHeaderView() is defined by default, but we need to override it for the newForm drawer.\n\t\t\t\t\tgetHeaderView: function( data ) {\n\t\t\t\t\t\treturn new newFormHeaderView( data );\n\t\t\t\t\t},\n\n\t\t\t\t\tgetContentView: function( data ) {\n\t\t\t\t\t\treturn new newFormView( data );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t] );\n\n\t\t\t// Listen for requests for our drawer collection.\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:drawerCollection', this.getDrawerCollection, this );\n\t\t\t// Listen for requests for specific drawer models.\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:drawer', this.getDrawer, this );\n\t\t},\n\n\t\tgetDrawerCollection: function() {\n\t\t\treturn this.collection;\n\t\t},\n\n\t\tgetDrawer: function( id ) {\n\t\t\treturn this.collection.get( id );\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Default settings title view.\n * \n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/drawer/defaultSettingsTitle',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-drawer-content-edit-settings-title-default',\n\n\t\ttemplateHelpers: function () {\n\t    \treturn {\n\t    \t\trenderTypeNicename: function() {\n\t    \t\t\tvar currentDomain = nfRadio.channel( 'app' ).request( 'get:currentDomain' );\n\t\t\t\t\tvar domainID = currentDomain.get( 'id' );\n\t    \t\t\tvar type = nfRadio.channel( domainID ).request( 'get:type', this.type );\n\t    \t\t\tif ( 'undefined' != typeof type ) {\n\t    \t\t\t\treturn type.get( 'nicename' );\n\t    \t\t\t} else {\n\t    \t\t\t\treturn '';\n\t    \t\t\t}\n\t\t\t\t}\n\t\t\t};\n\t\t},\n\t});\n\n\treturn view;\n} );\n","/**\n * Action settings title view.\n * \n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2024 WP Ninjas\n * @since 3.8\n */\ndefine( 'views/actions/drawer/settingsTitle',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-drawer-content-edit-settings-title-actions',\n\n\t\ttemplateHelpers: function () {\n\t    \treturn {\n\t    \t\trenderTypeNicename: function() {\n\t    \t\t\tvar currentDomain = nfRadio.channel( 'app' ).request( 'get:currentDomain' );\n\t\t\t\t\tvar domainID = currentDomain.get( 'id' );\n\t    \t\t\tvar type = nfRadio.channel( domainID ).request( 'get:type', this.type );\n\t    \t\t\tif ( 'undefined' != typeof type ) {\n\t    \t\t\t\treturn type.get( 'nicename' );\n\t    \t\t\t} else {\n\t    \t\t\t\treturn '';\n\t    \t\t\t}\n\t\t\t\t},\n\n\t\t\t\trenderDocLink: function() {\n\t    \t\t\tvar currentDomain = nfRadio.channel( 'app' ).request( 'get:currentDomain' );\n\t\t\t\t\tvar domainID = currentDomain.get( 'id' );\n\t    \t\t\tvar type = nfRadio.channel( domainID ).request( 'get:type', this.type );\n\t\t\t\t\tvar response = '';\n\t    \t\t\tif ( 'undefined' != typeof type ) {\n\t\t\t\t\t\tif( 'undefined' != typeof type.get('docUrl') && '' != type.get('docUrl') ) {\n\t\t\t\t\t\t\tresponse = '<a class=\"nf-external-info\" href=\"' + type.get('docUrl') + '\" target=\"_blank\"></a>';\n\t\t\t\t\t\t}\n\t    \t\t\t}\n\t\t\t\t\treturn response;\n\t\t\t\t}\n\t\t\t};\n\t\t},\n\t});\n\n\treturn view;\n} );\n","/**\n * Calculations title view.\n * \n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2024 WP Ninjas\n * @since 3.8\n */\ndefine( 'views/advanced/drawer/calculationsTitle',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-drawer-content-edit-settings-title-calculations',\n\n\t\ttemplateHelpers: function () {\n\t    \treturn {\n\t\t\t\trenderDocLink: function() {\n\t    \t\t\tvar currentDomain = nfRadio.channel( 'app' ).request( 'get:currentDomain' );\n\t\t\t\t\tvar domainID = currentDomain.get( 'id' );\n\t    \t\t\tvar type = nfRadio.channel( domainID ).request( 'get:type', this.type );\n\t\t\t\t\treturn '<a class=\"nf-external-info\" href=\"https://ninjaforms.com/docs/calculations/\" target=\"_blank\"></a>';\n\t\t\t\t}\n\t\t\t};\n\t\t},\n\t});\n\n\treturn view;\n} );\n","/**\n * Empty view.\n *\n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/empty',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-empty'\n\t});\n\n\treturn view;\n} );\n","/**\n * Model for our individual domains.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/domainModel',[\n\t'views/app/drawer/defaultSettingsTitle',\n\t'views/actions/drawer/settingsTitle',\n\t'views/advanced/drawer/calculationsTitle',\n\t'views/app/empty'\n\t],\n\tfunction(\n\t\tDefaultSettingsTitleView,\n\t\tActionsSettingsTitleView,\n\t\tCalculationsTitleView,\n\t\tEmptyView\n\t) {\n\tvar model = Backbone.Model.extend( {\n\t\tdefaults: {\n\t\t\tdashicons: '',\n\t\t\tclasses: '',\n\t\t\tactive: false,\n\t\t\turl: '',\n\t\t\thotkeys: false,\n\t\t\tdisabled: false,\n\n\t\t\tgetSettingsTitleView: function( data ) {\n\t\t\t\tif ( 'actions' == data.model.get( 'objectDomain' ) ) {\n\t\t\t\t\treturn new ActionsSettingsTitleView( data );\n\t\t\t\t} else if ( 'calculations' == data.model.get( 'objectDomain' ) ) {\n\t\t\t\t\treturn new CalculationsTitleView( data );\n\t\t\t\t} else {\n\t\t\t\t\treturn new DefaultSettingsTitleView( data );\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tgetDefaultSettingsTitleView: function( data ) {\n\t\t\t\treturn new DefaultSettingsTitleView( data );\n\t\t\t},\n\n\t\t\tgetGutterLeftView: function( data ) {\n\t\t\t\t/*\n\t\t\t\t * Return empty view\n\t\t\t\t */\n\t\t\t\treturn new EmptyView();\n\t\t\t},\n\n\t\t\tgetGutterRightView: function( data ) {\n\t\t\t\t/* \n\t\t\t\t * Return empty view\n\t\t\t\t */\n\t\t\t\treturn new EmptyView();\n\t\t\t}\n\t\t}\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Holds all of our domain models.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/domainCollection',['models/app/domainModel'], function( domainModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: domainModel\n\t} );\n\treturn collection;\n} );\n","define( 'views/fields/subHeader',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-sub-header-fields'\n\t});\n\n\treturn view;\n} );\n","define( 'views/fields/mainContentFieldCollection',[], function() {\n\tvar view = Marionette.CollectionView.extend( {\n\t\ttagName: 'div',\n\t\treorderOnSort: true,\n\n\t\tgetChildView: function() {\n\t\t\treturn nfRadio.channel( 'views' ).request( 'get:fieldItem' );\n\t\t},\n\n\t\tgetEmptyView: function() {\n\t\t\treturn nfRadio.channel( 'views' ).request( 'get:mainContentEmpty' );\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:sortableEl', this.getSortableEl, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'init:sortable', this.initSortable, this );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'destroy:sortable', this.destroySortable, this );\n\t\t},\n\n\t\tonRender: function() {\n\t\t\tif ( this.collection.models.length > 0 ) {\n\t\t\t\tjQuery( this.el ).addClass( 'nf-field-type-droppable' ).addClass( 'nf-fields-sortable' );\n\t\t\t\tvar that = this;\n\t\t\t\t/* TODO: There's a bug with some Android phones and chrome. The fix below hasn't been implement.\n\n\t\t\t\t * Instantiate our sortable field list, but only if we aren't on a mobile device.\n\t\t\t\t *\n\t\t\t\t * On Android, our sortable list isn't scrollable if it's instantiated at render.\n\t\t\t\t * Instead, for mobile, we need to instantiate our sortable when the user tapholds and then\n\t\t\t\t * destroy it when the drag stops.\n\t\t\t\t */\n\t\t\t\t// if ( ! nfRadio.channel( 'app' ).request( 'is:mobile' ) ) {\n\t\t\t\t\tthis.initSortable();\n\t\t\t\t// }\n\t\t\t}\n\t\t\tnfRadio.channel( 'app' ).trigger( 'render:fieldsSortable', this );\n\t\t},\n\n\t\tgetSortableEl: function() {\n\t\t\treturn this.el;\n\t\t},\n\n\t\tinitSortable: function() {\n\t\t\tif ( nfRadio.channel( 'app' ).request( 'is:mobile' ) ) {\n\t\t\t\tvar tolerance = 'pointer';\n\t\t\t} else {\n\t\t\t\tvar tolerance = 'intersect';\n\t\t\t}\n\n\t\t\tjQuery( this.el ).sortable( {\n\t\t\t\tcontainment: 'parent',\n\t\t\t\thelper: 'clone',\n\t\t\t\tcancel: '.nf-item-controls',\n\t\t\t\tplaceholder: 'nf-fields-sortable-placeholder',\n\t\t\t\topacity: 0.95,\n\t\t\t\tgrid: [ 5, 5 ],\n\t\t\t\t// scroll: false,\n\t\t\t\tappendTo: '#nf-main',\n\t\t\t\tscrollSensitivity: 10,\n\t\t\t\t//connectWith would allow drag and drop between fields already in the builder and the repeatable fieldset ( this is currently an issue until we deal with existing data stored)\n\t\t\t\t//connectWith: '.nf-fields-sortable', \n\n\t\t\t\treceive: function( e, ui ) {\n\t\t\t\t\tif ( ui.item.dropping || jQuery(ui.item).hasClass(\"nf-over-repeater\") ) return;\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'receive:fieldsSortable', ui );\n\t\t\t\t},\n\n\t\t\t\tover: function( e, ui ) {\n\t\t\t\t\tif ( ui.item.dropping ) return;\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'over:fieldsSortable', ui );\n\t\t\t\t},\n\n\t\t\t\tout: function( e, ui ) {\n\t\t\t\t\tif ( ui.item.dropping ) return;\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'out:fieldsSortable', ui );\n\t\t\t\t},\n\n\t\t\t\tstart: function( e, ui ) {\n\t\t\t\t\tif ( ui.item.dropping ) return;\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'start:fieldsSortable', ui );\n\t\t\t\t},\n\n\t\t\t\tupdate: function( e, ui ) {\n\t\t\t\t\tif ( ui.item.dropping ) return;\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'update:fieldsSortable', ui, this );\n\t\t\t\t},\n\n\t\t\t\tstop: function( e, ui ) {\n\t\t\t\t\tif ( ui.item.dropping ) return;\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'stop:fieldsSortable', ui );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tdestroySortable: function() {\n\t\t\tjQuery( this.el ).sortable( 'destroy' );\n\t\t},\n\n\t\tonAddChild: function( childView ) {\n\t\t\tif ( nfRadio.channel( 'fields' ).request( 'get:adding' ) ) {\n\t\t\t\tchildView.$el.hide().show( 'clip' );\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'set:adding', false );\n\t\t\t}\n\t\t}\n\t\t\n\t} );\n\n\treturn view;\n} );\n\n","define( 'views/fields/drawer/addSavedField',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-add-saved-field',\n\n\t\tinitialize: function() {\n\t\t\tthis.model.on( 'change:addSavedLoading', this.renderAddButton, this );\n\t\t},\n\n\t\tonRender: function() {\n\t\t\tthis.renderAddButton();\n\t\t},\n\n\t\trenderAddButton: function() {\n\t\t\tif ( this.model.get( 'addSavedLoading' ) ) {\n\t\t\t\tvar button = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-add-saved-field-loading' );\n\t\t\t} else {\n\t\t\t\tvar button = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-add-saved-field-button' );\n\t\t\t}\n\t\t\tjQuery( this.el ).find( '.add-button' ).html( button( this ) );\n\t\t},\n\n\t\tonBeforeDestroy: function() {\n\t\t\tthis.model.off( 'change:addSavedLoading', this.render );\n\t\t},\n\n\t\tevents: {\n\t\t\t'click .nf-button': 'clickAddSavedField'\n\t\t},\n\n\t\tclickAddSavedField: function( e ) {\n\t\t\tnfRadio.channel( 'drawer' ).trigger( 'click:addSavedField', e, this.model );\n\t\t}\n\t});\n\n\treturn view;\n} );\n\n","/**\n * Fields settings title view.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/fields/drawer/settingsTitle',['views/fields/drawer/addSavedField'], function( addSavedFieldView ) {\n\tvar view = Marionette.LayoutView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-drawer-content-edit-settings-title-fields',\n\n\t\tinitialize: function() {\n\t\t\tthis.model.on( 'change:saved', this.render, this );\n\t\t\tthis.mo