ame = calc.replace( '}', '' ).replace( '{calc:', '' );\n\t\t\t\t\t// Get our optionModel from our calculations collection.\n\t\t\t\t\tvar targetCalc = calculations.findWhere( { name: name } );\n\t\t\t\t\tif ( name == optionModel.get( 'name' ) ) {\n\t\t\t\t\t\t// If we already have a calc with this name, set an error.\n\t\t\t\t\t\terrors.selfRef = 'A calculation can\\'t reference itself!';\n\t\t\t\t\t\terrorSelfRef = true;\n\t\t\t\t\t} else if ( targetCalc && targetCalc.get( 'order' ) > optionModel.get( 'order' ) ) {\n\t\t\t\t\t\t// If the calc is after this one, set an error. \n\t\t\t\t\t\terrorFutureCalc = true;\n\t\t\t\t\t\terrors.futureCalc = 'Can\\'t reference a future calculation!';\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\t// If we didn't find any self ref errors, remove the key.\n\t\t\tif ( ! errorSelfRef ) {\n\t\t\t\tdelete errors.selfRef;\n\t\t\t}\n\n\t\t\t// If we didn't find any future calc errors, remove the key.\n\t\t\tif ( ! errorFutureCalc ) {\n\t\t\t\tdelete errors.futureCalc;\n\t\t\t}\n\n\t\t\t// Set errors and trigger our optionModel change.\n\t\t\toptionModel.set( 'errors', errors );\n\t\t\toptionModel.trigger( 'change:errors', optionModel );\n\n\t\t},\n\n        /**\n         * Ceck to see if a dec is an integer value.\n         * \n         * @since 3.1\n         * @param string            dec         our decimal value\n         * @param backbone.model    optionModel\n         * @return void\n         */\n        checkDec: function( dec, optionModel ) {\n            // If dec isn't defined, bail...\n            if( 'undefined' === typeof(dec) ) return false;\n\t\t\t// Get our current errors, if any.\n\t\t\tvar errors = optionModel.get( 'errors' );\n            /**\n             * We're looking for one error:\n             * - dec is not a non-negative integer.\n             */\n            var errorNonIntDec = false;\n            \n            // Get our target value and see if it matches what we got.\n            var checked = Math.abs( parseInt( String(dec).trim() ) );\n            if ( String(dec).trim() !== '' && checked.toString() !== String(dec).trim() ) {\n                errorNonIntDec = true;\n                errors.nonIntDec = 'Decimals must be a non-negative integer!';\n            }\n            \n            // If our dec value is a non-negative integer.\n            if ( ! errorNonIntDec ) {\n                delete errors.nonIntDec;\n            }\n            \n\t\t\t// Set errors and trigger our optionModel change.\n\t\t\toptionModel.set( 'errors', errors );\n\t\t\toptionModel.trigger( 'change:errors', optionModel );\n            \n        },\n        \n\t\tcheckAllCalcs: function( collection ) {\n\t\t\tvar that = this;\n\t\t\tcollection.models.map( function( opt ) {\n\t\t\t\tthat.checkName( opt.get( 'name' ), opt );\n\t\t\t\tthat.checkEQ( opt.get( 'eq' ), opt );\n                that.checkDec( opt.get( 'dec' ), opt );\n\t\t\t} );\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n\n","/**\n * Loads all of our controllers using Require JS.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine(\n\t'controllers/loadControllers',[\n\t\t/*\n\t\t * Application controllers\n\t\t */\n\t\t'controllers/app/remote',\n\t\t'controllers/app/drawer',\n\t\t'controllers/app/drawerConfig',\n\t\t'controllers/app/domainConfig',\n\t\t'controllers/app/data',\t\t\n\t\t'controllers/app/drawerToggleSettingGroup',\n\t\t'controllers/app/updateDB',\n\t\t'controllers/app/formData',\n\t\t'controllers/app/previewLink',\n\t\t'controllers/app/menuButtons',\n\t\t'controllers/app/trackChanges',\n\t\t'controllers/app/undoChanges',\n\t\t'controllers/app/publishResponse',\n\t\t'controllers/app/changeDomain',\n\t\t'controllers/app/pushstate',\n\t\t'controllers/app/hotkeys',\n\t\t'controllers/app/cleanState',\n\t\t'controllers/app/coreUndo',\n\t\t'controllers/app/cloneModelDeep',\n\t\t'controllers/app/getSettingChildView',\n\t\t'controllers/app/changeSettingDefault',\n\t\t'controllers/app/fieldset',\n\t\t'controllers/app/textboxSetting',\n\t\t'controllers/app/toggleSetting',\n\t\t'controllers/app/buttonToggleSetting',\n\t\t'controllers/app/numberSetting',\n\t\t'controllers/app/radioSetting',\n\t\t'controllers/app/itemControls',\n\t\t'controllers/app/mergeTags',\n\t\t'controllers/app/mergeTagBox',\n\t\t'controllers/app/itemSettingFill',\n\t\t'controllers/app/confirmPublish',\n\t\t'controllers/app/rte',\n\t\t'controllers/app/settingFieldSelect',\n\t\t'controllers/app/settingFieldList',\n\t\t'controllers/app/settingHTML',\n\t\t'controllers/app/settingColor',\n\t\t'controllers/app/changeMenu',\n\t\t'controllers/app/mobile',\n\t\t'controllers/app/notices',\n\t\t'controllers/app/unloadCheck',\n\t\t'controllers/app/formContentFilters',\n\t\t'controllers/app/formContentGutterFilters',\n\t\t'controllers/app/cloneCollectionDeep',\n\t\t'controllers/app/trackKeyDown',\n\t\t'controllers/app/perfectScroll',\n\t\t'controllers/app/getNewSettingGroupCollection',\n\t\t'controllers/app/settingMedia',\n\t\t'controllers/app/publicLink',\n\t\t/*\n\t\t * Fields domain controllers\n\t\t */\n\t\t'controllers/fields/types',\n\t\t'controllers/fields/fieldTypeDrag',\n\t\t'controllers/fields/stagingDrag',\n\t\t'controllers/fields/staging',\n\t\t'controllers/fields/stagingSortable',\n\t\t'controllers/fields/filterTypes',\n\t\t'controllers/fields/sortable',\n\t\t'controllers/fields/data',\n\t\t'controllers/app/optionRepeater',\n\t\t'controllers/app/imageOptionRepeater',\n\t\t'controllers/fields/editActive',\n\t\t'controllers/fields/fieldSettings',\n\t\t'controllers/fields/fieldCreditCard',\n\t\t'controllers/fields/fieldList',\n\t\t'controllers/fields/fieldPassword',\n\t\t'controllers/fields/fieldQuantity',\n\t\t'controllers/fields/fieldShipping',\n\t\t'controllers/fields/key',\n\t\t'controllers/fields/notices',\n\t\t'controllers/fields/mobile',\n\t\t'controllers/fields/savedFields',\n\t\t'controllers/fields/fieldDatepicker',\n\t\t'controllers/fields/fieldDisplayCalc',\n\t\t'controllers/fields/fieldRepeater',\n\n\t\t/*\n\t\t * TODO: Actions domain controllers\n\t\t */\n\t\t'controllers/actions/types',\n\t\t'controllers/actions/data',\n\t\t'controllers/actions/actionSettings',\n\t\t'controllers/actions/editActive',\n\t\t'controllers/actions/emailFromSetting',\n\t\t'controllers/actions/addActionTypes',\n\t\t'controllers/actions/typeDrag',\n\t\t'controllers/actions/droppable',\n\t\t'controllers/actions/filterTypes',\n\t\t'controllers/actions/newsletterList',\n\t\t'controllers/actions/deleteFieldListener',\n\t\t'controllers/actions/collectPaymentFields',\n\t\t'controllers/actions/collectPaymentCalculations',\n\t\t'controllers/actions/collectPaymentFixed',\n\t\t'controllers/actions/collectPayment',\n\t\t'controllers/actions/save',\n\n\t\t/*\n\t\t * TODO: Settings domain controllers\n\t\t */\n\t\t'controllers/advanced/types',\n\t\t'controllers/advanced/data',\n\t\t'controllers/advanced/formSettings',\n\t\t'controllers/advanced/editActive',\n\t\t'controllers/advanced/clickEdit',\n\t\t'controllers/advanced/calculations'\n\t],\n\tfunction(\n\t\t/*\n\t\t * Application controllers\n\t\t */\n\t\tRemote,\n\t\tDrawer,\n\t\tDrawerConfig,\n\t\tDomainConfig,\n\t\tAppData,\n\t\tDrawerToggleSettingGroup,\n\t\tUpdateDB,\n\t\tFormData,\n\t\tPreviewLink,\n\t\tAppMenuButtons,\n\t\tAppTrackChanges,\n\t\tAppUndoChanges,\n\t\tAppPublishResponse,\n\t\tAppChangeDomain,\n\t\tPushstate,\n\t\tHotkeys,\n\t\tCleanState,\n\t\tCoreUndo,\n\t\tCloneModelDeep,\n\t\tDrawerSettingChildView,\n\t\tChangeSettingDefault,\n\t\tFieldset,\n\t\tTextboxSetting,\n\t\tToggleSetting,\n\t\tButtonToggleSetting,\n\t\tNumberSetting,\n\t\tRadioSetting,\n\t\tItemControls,\n\t\tMergeTags,\n\t\tMergeTagsBox,\n\t\tItemSettingFill,\n\t\tConfirmPublish,\n\t\tRTE,\n\t\tSettingFieldSelect,\n\t\tSettingFieldList,\n\t\tSettingHTML,\n\t\tSettingColor,\n\t\tChangeMenu,\n\t\tAppMobile,\n\t\tAppNotices,\n\t\tAppUnloadCheck,\n\t\tFormContentFilters,\n\t\tFormContentGutterFilters,\n\t\tCloneCollectionDeep,\n\t\tTrackKeyDown,\n\t\tPerfectScroll,\n\t\tGetNewSettingGroupCollection,\n\t\tSettingMedia,\n\t\tPublicLink,\n\t\t/*\n\t\t * Fields domain controllers\n\t\t */\n\t\tFieldTypes,\n\t\tFieldTypeDrag,\n\t\tFieldStagingDrag,\n\t\tStagedFieldsData,\n\t\tStagedFieldsSortable,\n\t\tDrawerFilterFieldTypes,\n\t\tMainContentFieldsSortable,\n\t\tFieldData,\n\t\tOptionRepeater,\n\t\timageOptionRepeater,\n\t\tFieldsEditActive,\n\t\tFieldSettings,\n\t\tFieldCreditCard,\n\t\tFieldList,\n\t\tFieldPassword,\n\t\tFieldQuantity,\n\t\tFieldShipping,\n\t\tFieldKey,\n\t\tNotices,\n\t\tFieldsMobile,\n\t\tSavedFields,\n\t\tFieldDatepicker,\n\t\tFieldDisplayCalc,\n\t\tFieldRepeater,\n\t\t/*\n\t\t * TODO: Actions domain controllers\n\t\t */\n\t\tActionTypes,\n\t\tActionData,\n\t\tActionSettings,\n\t\tActionEditActive,\n\t\tActionEmailFromSetting,\n\t\tActionAddTypes,\n\t\tActionTypeDrag,\n\t\tActionDroppable,\n\t\tActionFilterTypes,\n\t\tActionNewsletterList,\n\t\tActionDeleteFieldListener,\n\t\tActionCollectPaymentFields,\n\t\tActionCollectPaymentCalculations,\n\t\tActionCollectPaymentFixed,\n\t\tActionCollectPayment,\n\t\tActionSave,\n\n\t\t/*\n\t\t * TODO: Settings domain controllers\n\t\t */\n\t\tSettingTypes,\n\t\tSettingData,\n\t\tFormSettings,\n\t\tSettingsEditActive,\n\t\tSettingsClickEdit,\n\t\tAdvancedCalculations\n\t\t\n\t) {\n\t\tvar controller = Marionette.Object.extend( {\n\t\t\tinitialize: function() {\n\t\t\t\t/*\n\t\t\t\t * Application controllers\n\t\t\t\t */\n\t\t\t\tnew FormContentFilters();\n\t\t\t\tnew FormContentGutterFilters();\n\t\t\t\tnew Hotkeys();\n\t\t\t\tnew Remote();\n\t\t\t\tnew Drawer();\n\t\t\t\tnew DrawerConfig();\n\t\t\t\tnew DomainConfig();\n\t\t\t\tnew DrawerToggleSettingGroup();\n\t\t\t\tnew PreviewLink();\n\t\t\t\tnew AppMenuButtons();\n\t\t\t\tnew AppTrackChanges();\n\t\t\t\tnew AppUndoChanges();\n\t\t\t\tnew AppPublishResponse();\n\t\t\t\tnew AppChangeDomain();\n\t\t\t\tnew CleanState();\n\t\t\t\tnew CoreUndo();\n\t\t\t\tnew CloneModelDeep();\n\t\t\t\tnew ItemControls();\n\t\t\t\tnew ConfirmPublish();\n\t\t\t\tnew RTE();\n\t\t\t\tnew SettingFieldSelect();\n\t\t\t\tnew SettingFieldList();\n\t\t\t\tnew SettingHTML();\n\t\t\t\tnew SettingColor();\n\t\t\t\tnew SettingMedia();\n\t\t\t\tnew ChangeMenu();\n\t\t\t\tnew AppMobile();\n\t\t\t\tnew AppNotices();\n\t\t\t\tnew AppUnloadCheck();\n\t\t\t\tnew UpdateDB();\n\t\t\t\tnew CloneCollectionDeep();\n\t\t\t\tnew TrackKeyDown();\n\t\t\t\tnew PerfectScroll();\n\t\t\t\tnew GetNewSettingGroupCollection();\n\t\t\t\tnew PublicLink();\n\t\t\t\t// new Pushstate();\n\t\t\t\t/*\n\t\t\t\t * Fields domain controllers\n\t\t\t\t * \n\t\t\t\t * Field-specific controllers should be loaded before our field type controller.\n\t\t\t\t * This ensures that any 'init' hooks are properly registered.\n\t\t\t\t */\n\t\t\t\tnew Fieldset();\n\t\t\t\tnew OptionRepeater();\n\t\t\t\tnew imageOptionRepeater();\n\t\t\t\tnew FieldTypes();\n\t\t\t\tnew FieldTypeDrag();\n\t\t\t\tnew FieldStagingDrag();\n\t\t\t\tnew StagedFieldsData();\n\t\t\t\tnew StagedFieldsSortable();\n\t\t\t\tnew DrawerFilterFieldTypes();\n\t\t\t\tnew MainContentFieldsSortable();\n\t\t\t\tnew ChangeSettingDefault();\n\t\t\t\tnew TextboxSetting(),\n\t\t\t\tnew ToggleSetting();\n\t\t\t\tnew ButtonToggleSetting();\n\t\t\t\tnew NumberSetting();\n\t\t\t\tnew RadioSetting();\n\t\t\t\tnew DrawerSettingChildView();\n\t\t\t\tnew FieldsEditActive();\n\t\t\t\tnew FieldSettings();\n\t\t\t\tnew FieldCreditCard();\n\t\t\t\tnew FieldList();\n\t\t\t\tnew FieldPassword;\n\t\t\t\tnew FieldQuantity();\n\t\t\t\tnew FieldShipping();\n\t\t\t\tnew FieldKey();\n\t\t\t\tnew Notices();\n\t\t\t\tnew FieldsMobile();\n\t\t\t\tnew SavedFields();\n\t\t\t\tnew FieldDatepicker();\n\t\t\t\tnew FieldDisplayCalc();\n\t\t\t\tnew FieldRepeater();\n\t\t\t\t/*\n\t\t\t\t * TODO: Actions domain controllers\n\t\t\t\t */\n\t\t\t\tnew ActionNewsletterList();\n\t\t\t\tnew ActionDeleteFieldListener();\n\t\t\t\tnew ActionCollectPaymentCalculations();\n\t\t\t\tnew ActionCollectPayment();\n\t\t\t\tnew ActionSave();\n\t\t\t\tnew ActionTypes();\n\t\t\t\tnew ActionData();\n\t\t\t\tnew ActionSettings();\n\t\t\t\tnew ActionEditActive();\n\t\t\t\tnew ActionEmailFromSetting();\n\t\t\t\tnew ActionAddTypes();\n\t\t\t\tnew ActionTypeDrag();\n\t\t\t\tnew ActionDroppable();\n\t\t\t\tnew ActionFilterTypes();\n\t\t\t\tnew ActionCollectPaymentFields();\n\t\t\t\tnew ActionCollectPaymentFixed();\n\n\t\t\t\t/*\n\t\t\t\t * TODO: Settings domain controllers\n\t\t\t\t */\n\t\t\t\tnew SettingTypes();\n\t\t\t\tnew FormSettings();\n\t\t\t\tnew AdvancedCalculations();\n\t\t\t\tnew SettingData();\n\t\t\t\tnew SettingsEditActive();\n\t\t\t\tnew SettingsClickEdit();\n\t\t\t\t\n\t\t\t\t/*\n\t\t\t\t * Data controllers need to be set after every other controller has been setup, even if they aren't domain-specific.\n\t\t\t\t * AppData() was after FormData();\n\t\t\t\t */\n\t\t\t\tnew AppData();\n\t\t\t\tnew FieldData();\n\t\t\t\tnew FormData();\n\t\t\t\tnew MergeTags();\n\t\t\t\tnew MergeTagsBox();\n\t\t\t\tnew ItemSettingFill();\n\t\t\t}\n\t\t});\n\n\t\treturn controller;\n} );\n\n","define( 'views/fields/mainContentEmpty',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-main-content-fields-empty',\n\n\t\tonBeforeDestroy: function() {\n\t\t\tjQuery( this.el ).parent().removeClass( 'nf-fields-empty-droppable' ).droppable( 'destroy' );\n\t\t},\n\n\t\tonRender: function() {\n\t\t\tthis.$el = this.$el.children();\n\t\t\tthis.$el.unwrap();\n\t\t\tthis.setElement( this.$el );\n\t\t},\n\n\t\tonShow: function() {\n\t\t\tif ( jQuery( this.el ).parent().hasClass( 'ui-sortable' ) ) {\n\t\t\t\tjQuery( this.el ).parent().sortable( 'destroy' );\n\t\t\t}\n\t\t\tjQuery( this.el ).parent().addClass( 'nf-fields-empty-droppable' );\n\t\t\tjQuery( this.el ).parent().droppable( {\n\t\t\t\taccept: function( draggable ) {\n\t\t\t\t\tif ( jQuery( draggable ).hasClass( 'nf-stage' ) || jQuery( draggable ).hasClass( 'nf-field-type-button' ) ) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tactiveClass: 'nf-droppable-active',\n\t\t\t\thoverClass: 'nf-droppable-hover',\n\t\t\t\ttolerance: 'pointer',\n\t\t\t\tover: function( e, ui ) {\n\t\t\t\t\tui.item = ui.draggable;\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'over:fieldsSortable', ui );\n\t\t\t\t},\n\t\t\t\tout: function( e, ui ) {\n\t\t\t\t\tui.item = ui.draggable;\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'out:fieldsSortable', ui );\n\t\t\t\t},\n\t\t\t\tdrop: function( e, ui ) {\n\t\t\t\t\tui.item = ui.draggable;\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'receive:fieldsSortable', ui );\n\t\t\t\t\tvar fieldCollection = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\t\t\t\t\tfieldCollection.trigger( 'reset', fieldCollection );\n\t\t\t\t},\n\t\t\t} );\n\t\t}\n\t});\n\n\treturn view;\n} );\n","/**\n * Renders our form title.\n *\n * @package Ninja Forms builder\n * @subpackage App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/app/formTitle',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-header-form-title',\n\n\t\tinitialize: function() {\n\t\t\t// When we change the model (to disable it, for example), re-render.\n\t\t\tthis.model.on( 'change:title', this.render, this );\n\t\t},\n\n\t\t/**\n\t\t * These functions are available to templates, and help us to remove logic from template files.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return Object\n\t\t */\n\t\ttemplateHelpers: function() {\n\t\t\tvar that = this;\n\t    \treturn {\n\t    \t\trenderTitle: function(){\n\t    \t\t\tvar formData = nfRadio.channel( 'app' ).request( 'get:formModel' );\n\t    \t\t\treturn _.escape( formData.get( 'settings' ).get( 'title' ) );\n\t\t\t\t},\n\t\t\t}\n\t\t}\n\n\t});\n\n\treturn view;\n} );\n","/**\n * Return views that might be used in extensions.\n * These are un-instantiated views.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/loadViews',[ 'views/fields/fieldItem', 'views/fields/mainContentEmpty', 'views/app/formTitle' ], function( fieldItemView, mainContentEmptyView, FormTitleView ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Reply to requests for our field item view.\n\t\t\tnfRadio.channel( 'views' ).reply( 'get:fieldItem', this.getFieldItem );\n\t\t\n\t\t\t// Reply to requests for our empty content view.\n\t\t\tnfRadio.channel( 'views' ).reply( 'get:mainContentEmpty', this.getMainContentEmpty );\n\t\t\n\t\t\t// Reply to requests for our form title view.\n\t\t\tnfRadio.channel( 'views' ).reply( 'get:formTitle', this.getFormTitle );\n\t\t},\n\n\t\tgetFieldItem: function( model ) {\n\t\t\treturn fieldItemView;\n\t\t},\n\n\t\tgetMainContentEmpty: function() {\n\t\t\treturn mainContentEmptyView;\n\t\t},\n\n\t\tgetFormTitle: function() {\n\t\t\treturn FormTitleView;\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","var nfRadio = Backbone.Radio;\n/** \n * Inline data converted to globally available vars sent via wp_localize_script\n * We keep them globally accessible for backwards compatibility, \n * we may want to remove them from global scope and communicate about that breaking change in the future\n **/\nwindow.actionSettings = nfDashInlineVars.actionSettings;\nwindow.preloadedFormData = nfDashInlineVars.preloadedFormData;\nwindow.actionTypeData = nfDashInlineVars.actionTypeData;\nwindow.formSettings = nfDashInlineVars.formSettings;\nwindow.formSettingTypeData = nfDashInlineVars.formSettingTypeData;\nwindow.mergeTags = nfDashInlineVars.mergeTags;\nwindow.fieldTypeData = nfDashInlineVars.fieldTypeData;\nwindow.fieldSettings = nfDashInlineVars.fieldSettings;\nwindow.fieldTypeSections = nfDashInlineVars.fieldTypeSections;\n\ndocument.addEventListener(\"DOMContentLoaded\", function() {\n\trequire( ['views/app/builder', 'controllers/loadControllers', 'views/loadViews'], function( BuilderView, LoadControllers, LoadViews ) {\n\n\t\tvar NinjaForms = Marionette.Application.extend( {\n\n\t\t\tinitialize: function( options ) {\n\n\t\t\t\tvar that = this;\n\t\t\t\tMarionette.Renderer.render = function(template, data){\n\t\t\t\t\tvar template = that.template( template );\n\t\t\t\t\treturn template( data );\n\t\t\t\t};\n\n\t\t\t\t// Trigger an event before we load our controllers.\n\t\t\t\tnfRadio.channel( 'app' ).trigger( 'before:loadControllers', this );\n\t\t\t\t// Load our controllers.\n\t\t\t\tvar loadControllers = new LoadControllers();\n\t\t\t\t// Trigger an event after we load our controllers.\n\t\t\t\tnfRadio.channel( 'app' ).trigger( 'after:loadControllers', this );\n\n\t\t\t\t// Trigger an event before we load un-instantiated views\n\t\t\t\tnfRadio.channel( 'app' ).trigger( 'before:loadViews', this );\n\t\t\t\tvar loadViews = new LoadViews();\n\t\t\t\t// Trigger an event after we load un-instantiated views.\n\t\t\t\tnfRadio.channel( 'app' ).trigger( 'after:loadViews', this );\n\n\t\t\t\tnfRadio.channel( 'app' ).reply( 'get:template', this.template );\n\t\t\t},\n\n\t\t\tonStart: function() {\n\t\t\t\tvar builderView = new BuilderView();\n\t\t\t\t// Trigger our after start event.\n\t\t\t\tnfRadio.channel( 'app' ).trigger( 'after:appStart', this );\n\n\t\t\t\t/*\n\t\t\t\t * If we're on the new forms builder, open the add fields drawer.\n\t\t\t\t */\n\t\t\t\tif ( 0 == nfAdmin.formID ) {\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'open:drawer', 'addField' );\n\t\t\t\t}\n\n\t\t\t\t/*\n\t\t\t\t * Onboarding hooks\n\t\t\t\t */\n\t\t\t\tif ('function' == typeof(NinjaOnboarding)) {\n\t\t\t\t\twindow.nfOB = new NinjaOnboarding();\n\t\t\t\t\tnfOB.step(parseInt(nfAdmin.onboardingStep));\n\t\t\t\t\tthis.listenTo(nfRadio.channel('app'), 'change:clean', function(isClean) {\n\t\t\t\t\t\tnfOB.cleanChanged(isClean);\n\t\t\t\t\t});\n\t\t\t\t\tthis.listenTo(nfRadio.channel('drawer'), 'closed', function() {\n\t\t\t\t\t\tnfOB.drawerClosed()\n\t\t\t\t\t});\n\t\t\t\t\tthis.listenTo(nfRadio.channel('drawer'), 'opened', function() {\n\t\t\t\t\t\tnfOB.drawerOpened()\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t},\n\n\t\t\ttemplate: function( template ) {\n\t\t\t\tif (!template.startsWith('script')) {\n\t\t\t\t\ttemplate = 'script'+template;\n\t\t\t\t}\n\t\t\t\treturn _.template( jQuery( template ).html(),  {\n\t\t\t\t\tevaluate:    /<#([\\s\\S]+?)#>/g,\n\t\t\t\t\tinterpolate: /\\{\\{\\{([\\s\\S]+?)\\}\\}\\}/g,\n\t\t\t\t\tescape:      /\\{\\{([^\\}]+?)\\}\\}(?!\\})/g,\n\t\t\t\t\tvariable:    'data'\n\t\t\t\t} );\n\t\t\t}\n\t\t} );\n\t\n\t\tvar ninjaForms = new NinjaForms();\n\t\tninjaForms.start();\n\t} );\n} );\ndefine(\"main\", function(){});\n\n"]}PK     =E)\)ދ  ދ    js/min/dashboard.min.jsnu [        !function(){var e,t,n;!function(i){function o(e,t){return C.call(e,t)}function s(e,t){var n,i,o,s,a,r,l,d,c,u,h,m,f=t&&t.split("/"),p=b.map,g=p&&p["*"]||{};if(e){for(e=e.split("/"),a=e.length-1,b.nodeIdCompat&&T.test(e[a])&&(e[a]=e[a].replace(T,"")),"."===e[0].charAt(0)&&f&&(m=f.slice(0,f.length-1),e=m.concat(e)),c=0;c<e.length;c++)if("."===(h=e[c]))e.splice(c,1),c-=1;else if(".."===h){if(0===c||1===c&&".."===e[2]||".."===e[c-1])continue;c>0&&(e.splice(c-1,2),c-=2)}e=e.join("/")}if((f||g)&&p){for(n=e.split("/"),c=n.length;c>0;c-=1){if(i=n.slice(0,c).join("/"),f)for(u=f.length;u>0;u-=1)if((o=p[f.slice(0,u).join("/")])&&(o=o[i])){s=o,r=c;break}if(s)break;!l&&g&&g[i]&&(l=g[i],d=c)}!s&&l&&(s=l,r=d),s&&(n.splice(0,r,s),e=n.join("/"))}return e}function a(e,t){return function(){var n=j.call(arguments,0);return"string"!=typeof n[0]&&1===n.length&&n.push(null),f.apply(i,n.concat([e,t]))}}function r(e){return function(t){return s(t,e)}}function l(e){return function(t){w[e]=t}}function d(e){if(o(v,e)){var t=v[e];delete v[e],y[e]=!0,m.apply(i,t)}if(!o(w,e)&&!o(y,e))throw new Error("No "+e);return w[e]}function c(e){var t,n=e?e.indexOf("!"):-1;return n>-1&&(t=e.substring(0,n),e=e.substring(n+1,e.length)),[t,e]}function u(e){return e?c(e):[]}function h(e){return function(){return b&&b.config&&b.config[e]||{}}}var m,f,p,g,w={},v={},b={},y={},C=Object.prototype.hasOwnProperty,j=[].slice,T=/\.js$/;p=function(e,t){var n,i=c(e),o=i[0],a=t[1];return e=i[1],o&&(o=s(o,a),n=d(o)),o?e=n&&n.normalize?n.normalize(e,r(a)):s(e,a):(e=s(e,a),i=c(e),o=i[0],e=i[1],o&&(n=d(o))),{f:o?o+"!"+e:e,n:e,pr:o,p:n}},g={require:function(e){return a(e)},exports:function(e){var t=w[e];return void 0!==t?t:w[e]={}},module:function(e){return{id:e,uri:"",exports:w[e],config:h(e)}}},m=function(e,t,n,s){var r,c,h,m,f,b,C,j=[],T=typeof n;if(s=s||e,b=u(s),"undefined"===T||"function"===T){for(t=!t.length&&n.length?["require","exports","module"]:t,f=0;f<t.length;f+=1)if(m=p(t[f],b),"require"===(c=m.f))j[f]=g.require(e);else if("exports"===c)j[f]=g.exports(e),C=!0;else if("module"===c)r=j[f]=g.module(e);else if(o(w,c)||o(v,c)||o(y,c))j[f]=d(c);else{if(!m.p)throw new Error(e+" missing "+c);m.p.load(m.n,a(s,!0),l(c),{}),j[f]=w[c]}h=n?n.apply(w[e],j):void 0,e&&(r&&r.exports!==i&&r.exports!==w[e]?w[e]=r.exports:h===i&&C||(w[e]=h))}else e&&(w[e]=n)},e=t=f=function(e,t,n,o,s){if("string"==typeof e)return g[e]?g[e](t):d(p(e,u(t)).f);if(!e.splice){if(b=e,b.deps&&f(b.deps,b.callback),!t)return;t.splice?(e=t,t=n,n=null):e=i}return t=t||function(){},"function"==typeof n&&(n=o,o=s),o?m(i,e,t,n):setTimeout(function(){m(i,e,t,n)},4),f},f.config=function(e){return f(e)},e._defined=w,n=function(e,t,n){if("string"!=typeof e)throw new Error("See almond README: incorrect module build, no module name");t.splice||(n=t,t=[]),o(w,e)||o(v,e)||(v[e]=[e,t,n])},n.amd={jQuery:!0}}(),n("../../node_modules/almond/almond",function(){}),n("models/formModel",[],function(){return Backbone.Model.extend({defaults:{objectType:"form",id:0,title:"unknown",created_at:"unknown"},url:function(){return ajaxurl+"?action=nf_forms&form_id="+this.get("id")},initialize:function(){this.set("id",Number(this.get("id"))),this.get("id")&&this.initShortcode(this.get("id")),this.get("title")&&this.set("title",this.get("title").replace(/<\/?[^>]+(>|$)/g,""))},initShortcode:function(e){var t="[ninja_form id="+e+"]";this.set("shortcode",t)},destroy:function(){var e=this;jQuery.ajax({type:"POST",url:ajaxurl+"?action=nf_forms&method_override=delete&form_id="+this.get("id")+"&security="+nfAdmin.ajaxNonce,success:function(t){var t=JSON.parse(t);e.collection.remove(e)}})}})}),n("models/formCollection",["models/formModel"],function(e){return Backbone.Collection.extend({model:e,comparator:"title",tmpNum:1,url:function(){return ajaxurl+"?action=nf_forms&security="+nfAdmin.ajaxNonce},initialize:function(){this.newIDs=[],this.baseUrl=window.location.href.split("?")[0],this.listenTo(i.channel("dashboard"),"forms:delete",this.modalConfirm),this.listenTo(i.channel("dashboard"),"forms:duplicate",this.duplicate),this.modal=new jBox("Modal",{width:400,addClass:"dashboard-modal",overlay:!0,closeOnClick:"body"})},parse:function(e,t){return e.data.hasOwnProperty("error")?(alert(e.data.error),null):e.data},modalConfirm:function(e){var t,n,i,o,s,a,r,l=e.model.get("id"),d=e.model.get("title");n=document.createElement("div"),n.style.paddingRight="20px",n.style.paddingLeft="20px",n.style.paddingBottom="20px",i=document.createElement("p"),o=document.createElement("em"),s=document.createElement("div"),a=document.createElement("button"),r=document.createElement("div"),n.classList.add("message"),o.innerHTML=d,i.innerHTML+=nfi18n.deleteWarningA+" (<strong>"+d+"</strong>). "+nfi18n.deleteWarningB,i.appendChild(document.createElement("br")),i.appendChild(document.createElement("br"));var c=document.createElement("a");c.href=this.baseUrl+"?page=nf-import-export&exportFormId="+l,c.innerHTML='<i class="fa fa-download" style="padding:5px;"></i>'+nfi18n.deleteXForm,c.target="_blank",i.appendChild(c),i.appendChild(document.createElement("br"));var u=document.createElement("a");u.href=this.baseUrl+"?page=nf-processing&action=download_all_subs&form_id="+l+"&redirect="+encodeURIComponent(this.baseUrl.replace("admin.php","edit.php")+"?post_status=all&post_type=nf_sub&form_id="+l)+"&security="+nfAdmin.batchNonce,u.target="_blank",u.innerHTML='<i class="fa fa-download" style="padding:5px;"></i>'+nfi18n.deleteXSubs,i.appendChild(u),i.appendChild(document.createElement("br")),n.appendChild(i);var h=document.createElement("label");h.for="confirmDeleteFormInput",h.innerHTML=nfi18n.deleteConfirmA+' <span style="color:red;">DELETE</span> '+nfi18n.deleteConfirmB;var m=document.createElement("input");m.type="text",m.id="confirmDeleteFormInput",m.style.marginTop="10px",m.style.width="100%",m.style.height="2.5em",m.style.fontSize="1em",n.appendChild(h),n.appendChild(document.createElement("br")),n.appendChild(m),n.appendChild(document.createElement("br")),n.appendChild(document.createElement("br")),a.innerHTML=nfi18n.delete,a.classList.add("confirm","nf-button","primary","pull-right"),r.innerHTML=nfi18n.cancel,r.classList.add("cancel","nf-button","secondary"),s.appendChild(r),s.appendChild(a),s.classList.add("buttons"),n.appendChild(s),t=document.createElement("div"),t.appendChild(n),this.modal.setContent(t.innerHTML),this.modal.setTitle(nfi18n.deleteTitle),this.modal.open();var f=this;this.modal.container[0].getElementsByClassName("cancel")[0].addEventListener("click",function(){f.modalClose()}),this.modal.container[0].getElementsByClassName("confirm")[0].addEventListener("click",function(t){t.preventDefault(),"DELETE"===document.getElementById("confirmDeleteFormInput").value?f.confirmDelete(e):f.modalClose()})},modalClose:function(){this.modal.close()},confirmDelete:function(e){jQuery(e.el).removeClass("show-actions"),jQuery(e.el).addClass("deleting"),jQuery(e.el).animate({opacity:0,"line-height":0,display:"none"},500),console.log(e),e.model.destroy(),this.modalClose()},duplicate:function(e){var t='<div class="message">Duplicating <em>'+e.model.get("title")+'</em>...<div class="nf-loading-spinner"></div></div>';this.modal.setContent(t),this.modal.setTitle("Please Wait"),this.modal.open();var n=this;jQuery.ajax({type:"POST",url:ajaxurl+"?action=nf_forms&clone_id="+e.model.get("id")+"&security="+nfAdmin.ajaxNonce,success:function(t){var t=JSON.parse(t);if(t.data.hasOwnProperty("error"))alert(t.data.error);else{var i=t.data.new_form_id,o=e.model.clone();o.set({id:i,title:o.get("title")+" - copy",created_at:new Date}),o.initShortcode(i),e.model.collection.add(o)}n.modalClose()}})}})}),n("controllers/formsController",["models/formModel","models/formCollection"],function(e,t){return Marionette.Object.extend({initialize:function(){this.forms=new t,i.channel("dashboard").reply("get:forms",this.getForms,this),this.forms.fetch({success:function(e){i.channel("dashboard").trigger("fetch:forms",e)}})},getForms:function(){return this.forms}})}),n("models/oauthModel",[],function(){return Backbone.Model.extend({defaults:{connected:null,connect_url:""},url:function(){return ajaxurl+"?action=nf_oauth"},initialize:function(){},parse:function(e,t){return e.data}})}),n("controllers/oauthController",["models/oauthModel"],function(e){return Marionette.Object.extend({initialize:function(){this.oauth=new e,i.channel("dashboard").reply("get:oauth",this.getOAuth,this),i.channel("dashboard").reply("disconnect:oauth",this.disconnect,this),i.channel("dashboard").reply("oauth:learn-more",this.learnMoreModal,this),this.initOAuth()},getOAuth:function(){return this.oauth},initOAuth:function(){this.oauth.fetch({success:function(e){i.channel("dashboard").trigger("fetch:oauth")}})},disconnect:function(){var e=this;new jBox("Confirm",{width:750,content:nfi18n.oauthDisconnectContent,confirmButton:nfi18n.oauthDisconnectConfirm,cancelButton:nfi18n.oauthDisconnectCancel,closeOnConfirm:!0,confirm:function(){jQuery.ajax({type:"POST",url:ajaxurl+"?action=nf_oauth_disconnect&nonce="+nfAdmin.disconnectNonce,success:function(t){e.initOAuth()}})}}).open()},learnMoreModal:function(){new jBox("Modal",{width:500,content:nfi18n.oauthLearnMoreContent}).open()}})}),n("models/serviceModel",[],function(){return Backbone.Model.extend({defaults:{objectType:"service",name:"",slug:"",installPath:"",description:"",enabled:null,infoLink:null,serviceLink:null,is_installing:!1,classes:""},url:function(){return ajaxurl+"?action=nf_service_"+this.get("slug")},initialize:function(){this.get("slug")==nfDashInlineVars.serviceSuccess&&this.get("successMessage")&&new jBox("Modal",{width:300,addClass:"dashboard-modal",overlay:!0,closeOnClick:!0,content:this.get("successMessage"),title:this.get("successMessageTitle"),closeButton:"box"}).open();var e=this;i.channel("dashboard").reply("install:service:"+this.get("slug"),function(){if(e.get("serviceLink")&&e.get("serviceLink").href){var t=e.get("serviceLink").href;new jBox("Modal",{width:300,addClass:"dashboard-modal",overlay:!0,closeOnClick:"body",content:nfi18n.serviceRedirect}).open();var n=i.channel("dashboard").request("get:oauth");if(n.get("connected"))window.location=t;else{if(e.get("connect_url"))return window.location=e.get("connect_url")+"&redirect="+t;window.location=n.get("connect_url")+"&redirect="+t}}})},save:function(){var e=this;jQuery.ajax({type:"POST",url:this.url(),data:this.toJSON()}).done(function(t){var n=JSON.parse(t);void 0!==n.error&&(alert(nfi18n.serviceUpdateError+" "+n.error),e.set("enabled",!e.get("enabled"))),i.channel("dashboard").trigger("save:service-"+e.get("slug"))})}})}),n("models/serviceCollection",["models/serviceModel"],function(e){return Backbone.Collection.extend({model:e,comparator:"name",url:function(){return ajaxurl+"?action=nf_services"},initialize:function(){},parse:function(e,t){return e.data}})}),n("controllers/servicesController",["models/serviceCollection"],function(e){return Marionette.Object.extend({initialize:function(){this.services=new e,i.channel("dashboard").reply("install:service",this.installService,this),i.channel("dashboard").reply("get:services",this.getServices,this),this.fetchServices()},getServices:function(){return this.services},fetchServices:function(e){this.services.fetch({success:function(t){e&&e(t),i.channel("dashboard").trigger("fetch:services")}})},installService:function(e){var t=this;if(!(e instanceof Backbone.Model))var e=this.services.find(function(t){return e==t.get("slug")});e.set("is_installing",!0);var n=e.get("slug"),o=e.get("installPath");jQuery.post(ajaxurl,{action:"nf_services_install",security:nfAdmin.ajaxNonce,plugin:n,install_path:o},function(e){if("sendwp"!==n&&"ninja-forms-addon-manager"!==n)return!1;t.fetchServices(function(){if("sendwp"===n)return ninja_forms_sendwp_remote_install();i.channel("dashboard").request("install:service:"+n)})})}})}),n("models/formTemplateModel",[],function(){return Backbone.Model.extend({defaults:{objectType:"template",id:"none",title:"unknown",type:""},initialize:function(){this.set("desc",this.get("template-desc")),this.set("modal-content",this.get("modal-content")),this.set("modal-title",this.get("modal-title"))}})}),n("models/formTemplateCollection",["models/formTemplateModel"],function(e){return Backbone.Collection.extend({model:e,tmpNum:1,url:function(){return ajaxurl+"?action=nf_new_form_templates&security="+nfAdmin.ajaxNonce},parse:function(e,t){return e.data.hasOwnProperty("error")?(alert(e.data.error),null):e.data},initialize:function(){this.fetch({success:function(e){},error:function(e){}})}})}),n("controllers/templatesController",["models/formTemplateModel","models/formTemplateCollection"],function(e,t){return Marionette.Object.extend({initialize:function(){this.templates=new t,this.installed=new Backbone.Collection,this.available=new Backbone.Collection,i.channel("dashboard").reply("get:formTemplates",this.getTemplates,this),i.channel("dashboard").reply("get:installedFormTemplates",this.getInstalledTemplates,this),i.channel("dashboard").reply("get:availableFormTemplates",this.getAvailableTemplates,this),this.listenTo(i.channel("dashboard"),"fetch:formTemplates",this.sortTemplates,this),this.templates.fetch({success:function(e){i.channel("dashboard").trigger("fetch:formTemplates",e)}})},getTemplates:function(){return this.templates},getInstalledTe