    /* Console Debug Messages */\n            if( 'undefined' != typeof response.debug.console ) {\n                var style = '';\n                console.log( '%c%s', style, 'NINJA SUPPORT' );\n                _.each(response.debug.console, function (message, index) {\n                    console.log( message );\n                });\n                console.log( '%c%s', style, 'END NINJA SUPPORT' );\n            }\n        }\n\n    });\n\n    return controller;\n} );\n\n","define('controllers/getFormErrors',[], function() {\n\tvar radioChannel = nfRadio.channel( 'fields' );\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function( model ) {\n\t\t\tnfRadio.channel( 'form' ).reply( 'get:errors', this.getFormErrors );\n\t\t},\n\n\t\tgetFormErrors: function( formID ) {\n\t\t\tvar formModel = nfRadio.channel( 'app' ).request( 'get:form', formID );\n\t\t\tvar errors = false;\n\t\t\t\n\t\t\tif ( formModel ) {\n\t\t\t\t/*\n\t\t\t\t * Check to see if we have any errors on our form model.\n\t\t\t\t */\n\t\t\t\tif ( 0 !== formModel.get( 'errors' ).length ) {\n\t\t\t\t\t_.each( formModel.get( 'errors' ).models, function( error ) {\n\t\t\t\t\t\terrors = errors || {};\n\t\t\t\t\t\terrors[ error.get( 'id' ) ] = error.get( 'msg' );\n\t\t\t\t\t} );\t\t\t\t\t\t\n\t\t\t\t}\n\n\t\t\t\t_.each( formModel.get( 'fields' ).models, function( field ) {\n\t\t\t\t\tif ( field.get( 'type' ) != 'submit' && field.get( 'errors' ).length > 0 ) {\n\t\t\t\t\t\terrors = errors || {};\n\t\t\t\t\t\terrors[ field.get( 'id' ) ] = field.get( 'errors' );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\t\t\treturn errors;\n\t\t},\n\t});\n\n\treturn controller;\n} );\n","define('controllers/validateRequired',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'blur:field', this.validateRequired );\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'change:field', this.validateRequired );\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'keyup:field', this.validateKeyup );\n\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'change:modelValue', this.validateModelData );\n\t\t\tthis.listenTo( nfRadio.channel( 'submit' ), 'validate:field', this.validateModelData );\n\t\t},\n\t\t\n\t\tvalidateKeyup: function( el, model, keyCode ) {\n\t\t\tif ( 1 != model.get( 'required' ) ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tif ( ! model.get( 'clean' ) ) {\n\t\t\t\tthis.validateRequired( el, model );\n\t\t\t}\n\t\t},\n\n\t\tvalidateRequired: function( el, model ) {\n\t\t\tif ( 1 != model.get( 'required' ) || ! model.get( 'visible' ) ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tvar currentValue = jQuery( el ).val();\n\t\t\tvar customReqValidation = nfRadio.channel( model.get( 'type' ) ).request( 'validate:required', el, model );\n\t\t\tvar defaultReqValidation = true;\n\n\t\t\tvar maskPlaceholder = this.getMask( model );\n\n            // If the field has a mask...\n            // AND that mask is equal to the current value...            \n            if ( maskPlaceholder && currentValue === maskPlaceholder ) {\n                // If we have a pre-existing error...\n                // OR if this field has been previously focused...\n                if ( 0 < model.get( 'errors' ).length || ! model.get( 'clean' ) ) {\n                    // Persist that error.\n                    defaultReqValidation = false;\n                }\n            }\n            // If our value is an empty string...\n            if ( ! String(currentValue).trim() ) {\n                // Throw an error.\n                defaultReqValidation = false;\n            }\n\n\t\t\tif ( 'undefined' !== typeof customReqValidation ) {\n\t\t\t\tvar valid = customReqValidation;\n\t\t\t} else {\n\t\t\t\tvar valid = defaultReqValidation;\n\t\t\t}\n\n\t\t\tthis.maybeError( valid, model );\n\t\t},\n\n\t\tgetMask: function( model ) {\n\t\t\tvar mask = model.get( 'mask' );\n\n\t\t\tif(\"undefined\" === typeof mask) return;\n\t\t\t\n\t\t\tswitch(mask) {\n\t\t\t\tcase '':\n\t\t\t\t\tbreak;\n\t\t\t\tcase 'currency':\n\t\t\t\t\tmask = nfi18n.currencySymbol;\n\t\t\t\t\tbreak;\n\t\t\t\tcase 'custom':\n\t\t\t\t\tmask = model.get( 'custom_mask' );\n\t\t\t\t\t/**\n\t\t\t\t\t * Break intentionally excluded so that this case\n\t\t\t\t\t * also executes the contents of default.\n\t\t\t\t\t */\n\t\t\t\tdefault:\n\t\t\t\t\tmask = mask.replace( /9/g, '_' );\n\t\t\t\t\tmask = mask.replace( /a/g, '_' );\n\t\t\t\t\tmask = mask.replace( /\\*/g, '_' );\n\t\t\t}\n\t\t\treturn mask;\n\t\t},\n\n\t\tvalidateModelData: function( model ) {\n\n\t\t\tif ( 1 != model.get( 'required' ) || ! model.get( 'visible' ) || model.get( 'clean' ) ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\t/*\n\t\t\t * If we already have a required error on this model, return false\n\t\t\t */\n\t\t\tif ( model.get( 'errors' ).get( 'required-error' ) ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tcurrentValue = model.get( 'value' );\n\n\t\t\tvar defaultReqValidation = true;\n\n\t\t\tif ( ! String(currentValue).trim() ) {\n\t\t\t\tdefaultReqValidation = false;\n\t\t\t}\n\n\t\t\tvar customReqValidation = nfRadio.channel( model.get( 'type' ) ).request( 'validate:modelData', model );\n\t\t\tif ( 'undefined' !== typeof customReqValidation ) {\n\t\t\t\tvar valid = customReqValidation;\n\t\t\t} else {\n\t\t\t\tvar valid = defaultReqValidation;\n\t\t\t}\n\n\t\t\tthis.maybeError( valid, model );\n\n\t\t},\n\n\t\tmaybeError: function( valid, model ) {\n\t\t\tif ( ! valid ) {\n\n\t\t\t\tvar formModel  = nfRadio.channel( 'form-' + model.get( 'formID' ) ).request( 'get:form' );\n\t\t\t\t\n\t\t\t\tif( 'undefined' != typeof formModel ) {\n\t\t\t\t\tnfRadio.channel('fields').request('add:error', model.get('id'), 'required-error', formModel.get('settings').validateRequiredField );\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'remove:error', model.get( 'id' ), 'required-error' );\n\t\t\t}\t\t\t\n\t\t}\n\t});\n\n\treturn controller;\n} );\n\n","define('controllers/submitError',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'forms' ), 'submit:response', this.submitErrors );\n\t\t\t//Focus first invalid input after catching errors during submission\n\t\t\tnfRadio.channel( 'submit' ).reply( 'focus:firstInvalidInput',  this.focusFirstInvalidInput );\n\t\t},\n\n\t\tsubmitErrors: function( response, textStatus, jqXHR, formID ) {\n\n\t\t\t// Check for nonce error.\n\t\t\tif ( _.size( response.errors.nonce ) > 0 ) {\n\t\t\t\tif( 'undefined' != typeof response.errors.nonce.new_nonce && 'undefined' != typeof response.errors.nonce.nonce_ts ) {\n\t\t\t\t\t// Update nonce from response.\n\t\t\t\t\tnfFrontEnd.ajaxNonce = response.errors.nonce.new_nonce;\n\t\t\t\t\tnfFrontEnd.nonce_ts = response.errors.nonce.nonce_ts;\n\t\t\t\t\t// Re-submit form.\n\t\t\t\t\tvar formModel = nfRadio.channel( 'app' ).request( 'get:form', formID );\n\t\t\t\t\tnfRadio.channel( 'form-' + formID ).request( 'submit', formModel );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( _.size( response.errors.fields ) > 0 ) {\n\t\t\t\t_.each( response.errors.fields, function( data, fieldID ) {\n                    if ( typeof( data ) === 'object' ) {\n                        nfRadio.channel( 'fields' ).request( 'add:error', fieldID, data.slug, data.message );\n                    } else {\n                        nfRadio.channel( 'fields' ).request( 'add:error', fieldID, 'required-error', data );\n                    }\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tif ( _.size( response.errors.form ) > 0 ) {\n\t\t\t\t_.each( response.errors.form, function( msg, errorID ) {\n\t\t\t\t\tnfRadio.channel( 'form-' + formID ).request( 'remove:error', errorID );\n\t\t\t\t\tnfRadio.channel( 'form-' + formID ).request( 'add:error', errorID, msg );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tif ( 'undefined' != typeof response.errors.last ) {\n\t\t\t\tif( 'undefined' != typeof response.errors.last.message ) {\n\t\t\t\t\tvar style = 'background: rgba( 255, 207, 115, .5 ); color: #FFA700; display: block;';\n\t\t\t\t\tconsole.log( '%c NINJA FORMS SUPPORT: SERVER ERROR', style );\n\t\t\t\t\tconsole.log( response.errors.last.message );\n\t\t\t\t\tconsole.log( '%c END SERVER ERROR MESSAGE', style );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * TODO: This needs to be re-worked for backbone. It's not dynamic enough.\n\t\t\t */\n\t\t\t/*\n\t\t\t * Re-show any hidden fields during a form submission re-start.\n\t\t\t */\n\t\t\tjQuery( '#nf-form-' + formID + '-cont .nf-field-container' ).show();\n\t\t},\n\n\t\tfocusFirstInvalidInput: function(errors) {\n\t\t\tconst targetID = nfRadio.channel( 'fields' ).request( 'get:firstFieldByOrder', errors );\n\t\t\tif(document.getElementById(\"nf-field-\"+ targetID) !== null){\n\t\t\t\tdocument.getElementById(\"nf-field-\"+ targetID).focus();\n\t\t\t}\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n\n","define('controllers/actionRedirect',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'forms' ), 'submit:response', this.actionRedirect );\n\t\t},\n\n\t\tactionRedirect: function( response ) {\n\n\t\t\tif ( 'undefined' != typeof response.data.halt && 'undefined' != typeof response.data.halt.redirect && '' != response.data.halt.redirect ) {\n\t\t\t\twindow.location = response.data.halt.redirect;\n\t\t\t}\n\n\t\t\tif ( _.size( response.errors ) == 0 && 'undefined' != typeof response.data.actions ) {\n\n\t\t\t\tif ( 'undefined' != typeof response.data.actions.redirect && '' != response.data.actions.redirect ) {\n\t\t\t\t\twindow.location = response.data.actions.redirect;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","define('controllers/actionSuccess',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'forms' ), 'submit:response', this.actionSubmit );\n\t\t},\n\n\t\tactionSubmit: function( response ) {\n\t\t\tif ( _.size( response.errors ) == 0 && 'undefined' != typeof response.data.actions ) {\n\t\t\t\tif ( 'undefined' != typeof response.data.actions.success_message && '' != response.data.actions.success_message ) {\n\t\t\t\t\tvar form_id = response.data.form_id;\n\t\t\t\t\tvar success_message = jQuery( '#nf-form-' + form_id + '-cont .nf-response-msg' );\n\t\t\t\t\tconst read =