alue.\n             * This is the list equivalent of a 'default value'.\n             */ \n            if ( 0 != model.get( 'image_options' ).length ) {\n                var selected = _.filter( model.get( 'image_options' ), function( opt ) { return 1 == opt.selected } );\n                selected = _.map( selected, function( opt ) { return opt.value } );\n            }\n\n            /*\n            * This part is re-worked to take into account custom user-meta\n            * values for fields.\n             */\n\t        var savedVal = model.get( 'value' );\n\t        if( 'undefined' !== typeof savedVal && Array.isArray( savedVal ) ) {\n\t\t        model.set( 'value', savedVal );\n\t        } else if ( 'undefined' != typeof selected ) {\n\t\t        model.set( 'value', selected );\n\t        }\n        },\n\n        renderOptions: function() {\n            var html = '';\n            \n            if ( '' == this.value || ( Array.isArray( this.value ) && 0 < this.value.length )\n                || 0 < this.value.length ) {\n                var valueFound = true;\n            } else {\n                var valueFound = false;\n            }\n\n            if (this.allow_multi_select === 1) {\n                this.old_classname = 'list-checkbox';\n                this.image_type = 'checkbox';\n            } else {\n                this.image_type = 'radio';\n            }\n\n            if(this.list_orientation === 'horizontal') {\n                this.flex_direction = 'row';\n            } else {\n                this.flex_direction = 'column';\n            }\n            var that = this;\n\n            var num_columns = parseInt(this.num_columns) || 1;\n            var current_column = 1;\n            var current_row = 1;\n            \n            _.each( this.image_options, function( image, index ) {\n                if (!this.show_option_labels) {\n                    image.label = '';\n                } else {\n                    image.label = (typeof nfFrontEnd.filter_esc_status !== \"undefined\" && nfFrontEnd.filter_esc_status === \"true\") ? _.escape(image.label) : image.label;\n                }\n                if( Array.isArray( this.value ) ) {\n                \tif( Array.isArray( this.value[ 0 ] ) && -1 !== _.indexOf( this.value[ 0 ], image.value ) ) {\n                \t\tvalueFound = true;\n\t                }\n                    else if( _.indexOf( this.value, image.value ) ) {\n                        valueFound = true;\n\t                }\n                }\n\n                if ( image.value == this.value ) {\n                    valueFound = true;\n                }\n\n                /*\n                 * TODO: This is a bandaid fix for making sure that each option has a \"visible\" property.\n                 * This should be moved to creation so that when an option is added, it has a visible property by default.\n                 */\n                if ( 'undefined' == typeof image.visible ) {\n                    image.visible = true;\n                }\n                \n                if(that.list_orientation === 'horizontal' && current_column <= num_columns) {\n                    image.styles = \"margin:auto;grid-column: \" + current_column + \"; grid-row = \" + current_row;\n\n                    if(current_column === num_columns) {\n                        current_column = 1;\n                        current_row += 1;\n                    } else {\n                        current_column += 1;\n                    }\n                }\n\n                image.image_type = that.image_type; \n                image.fieldID = this.id;\n                image.classes = this.classes;\n                image.index = index;\n\n                var selected = false;\n\t\t\t\t/*\n\t\t\t\t* This part has been re-worked to account for values passed in\n\t\t\t\t* via custom user-meta ( a la User Mgmt add-on)\n\t\t\t\t */\n\t            if( Array.isArray( this.value ) && 0 < this.value.length ) {\n\t            \tif ( -1 !== _.indexOf( this.value[ 0 ].split( ',' ), image.value )\n\t\t                || -1 !== _.indexOf( this.value, image.value ) ) {\n\t\t\t            selected = true;\n\t            \t}\n\t            } else if ( ! _.isArray( this.value ) && image.value == this.value ) {\n\t\t            selected = true;\n\t            } else if ( ( 1 == image.selected && this.clean ) && ('undefined' === typeof this.value || '' === this.value)) {\n\t\t            selected = true;\n\t            }\n\n\t            image.selected = selected;\n\t            image.isSelected = selected;\n\t            image.required = this.required;\n                image.maybeFilterHTML = this.maybeFilterHTML;\n                var template = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-field-listimage-option' );\n                html += template( image );\n            }, this );\n\n            if ( 1 == this.show_other ) {\n                if ( 'nf-other' == this.value ) {\n                    valueFound = false;\n                }\n                var data = {\n                    fieldID: this.id,\n                    classes: this.classes,\n                    value: this.value,\n                    currentValue: this.value,\n                    renderOtherText: this.renderOtherText,\n                    valueFound: valueFound\n                };\n\n                var template = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-field-listimage-other' );\n                html += template( data );\n\n            }\n\n            return html;\n        },\n\n        renderOtherText: function() {\n            if ( 'nf-other' == this.currentValue || ! this.valueFound ) {\n                if ( 'nf-other' == this.currentValue ) {\n                    this.currentValue = '';\n                }\n                var data = {\n                    fieldID: this.fieldID,\n                    classes: this.classes,\n                    currentValue: this.currentValue\n                };\n                var template = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-field-listimage-other-text' );\n                return template( data );\n            }\n        },\n\n        getCalcValue: function( fieldModel ) {\n\t\t\tvar calc_value = 0;\n\t\t\tvar options = fieldModel.get( 'options' );\n\t\t\tif ( 0 != options.length ) {\n\t\t\t\t/*\n\t\t\t\t * Check to see if this is a multi-select list.\n\t\t\t\t */\n\t\t\t\tif ( 1 == parseInt( fieldModel.get( 'allow_multi_select' ) ) ) {\n\t\t\t\t\t/*\n\t\t\t\t\t * We're using a multi-select, so we need to check out any selected options and add them together.\n\t\t\t\t\t */\n\t\t\t\t\t_.each( fieldModel.get( 'value' ), function( val ) {\n\t\t\t\t\t\tvar tmp_opt = _.find( options, function( opt ) { return opt.value == val } );\n\t\t\t\t\t\tcalc_value += Number( tmp_opt.calc );\n\t\t\t\t\t} );\n\t\t\t\t} else {\n\t\t\t\t\t/*\n\t\t\t\t\t * We are using a single select, so our selected option is in the 'value' attribute.\n\t\t\t\t\t */\n\t\t\t\t\tvar selected = _.find( options, function( opt ) { return fieldModel.get( 'value' ) == opt.value } );\n\t\t\t\t\t/*\n\t\t\t\t\t * If we have a selcted value, use it.\n\t\t\t\t\t */\n\t\t\t\t\tif ( 'undefined' !== typeof selected ) {\n                        calc_value = selected.calc;\n\t\t\t\t\t}\t\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn calc_value;\n        },\n\n        beforeUpdateField: function( el, model ) {\n\n            if(model.get('allow_multi_select') !== 1) {\n                var selected = jQuery( el ).val();\n                var options = model.get('image_options');\n                _.each(options, function(option, index) {\n                    if(option.value === selected) {\n                        option.isSelected = true;\n                        option.selected = true;\n                    } else {\n                        option.isSelected = false;\n                        option.selected = false;\n                    }\n                    if(!option.isSelected) {\n                        option.selected = false;\n                        jQuery(\"#nf-field-\" + option.fieldID + \"-\" + index).removeClass('nf-checked');\n                        jQuery(\"#nf-label-field-\" + option.fieldID + \"-\" + index).removeClass('nf-checked-label');\n                    } else {\n                        jQuery(\"#nf-field-\" + option.fieldID + \"-\" + index).addClass('nf-checked');\n                        jQuery(\"#nf-label-field-\" + option.fieldID + \"-\" + index).addClass('nf-checked-label');\n                    }\n                });\n            } else {\n                var selected = model.get( 'value' ) || [];\n                if ( typeof selected == 'string' ) selected = [ selected ];\n                var value = jQuery( el ).val();\n                var checked = jQuery( el ).prop( 'checked' );\n                if ( checked ) {\n                    selected.push( value );\n                    jQuery( el ).addClass( 'nf-checked' );\n                    jQuery( el ).parent().find( 'label[for=\"' + jQuery( el ).prop( 'id' ) + '\"]' ).addClass( 'nf-checked-label' );\n                } else {\n                    jQuery( el ).removeClass( 'nf-checked' );\n                    jQuery( el ).parent().find( 'label[for=\"' + jQuery( el ).prop( 'id' ) + '\"]' ).removeClass( 'nf-checked-label' );\n                    var i = selected.indexOf( value );\n                    if( -1 != i ){\n                        selected.splice( i, 1 );\n                    } else if ( Array.isArray( selected ) ) {\n                        var optionArray = selected[0].split( ',' );\n                        var valueIndex = optionArray.indexOf( value );\n                        if( -1 !== valueIndex) {\n                            optionArray.splice( valueIndex, 1 );\n                        }\n                        selected = optionArray.join( ',' );\n                    }\n                }\n            }\n\n            return _.clone( selected );\n        }\n    });\n\n    return controller;\n} );\n","define('controllers/fieldRadio',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'listradio' ), 'change:modelValue', this.changeModelValue );\n\t\t\tthis.listenTo( nfRadio.channel( 'listradio' ), 'init:model', this.register );\n\t\t\tnfRadio.channel( 'listradio' ).reply( 'get:calcValue', this.getCalcValue, this );\n\t\t\t\n\t\t\tthis.listenTo( nfRadio.channel( 'listradio' ), 'change:field', this.updateCheckedClass, this );\n\t\t},\n\n\t\tregister: function( model ) {\n\t\t\tmodel.set( 'renderOptions', this.renderOptions );\n\t\t\tmodel.set( 'renderOtherText', this.renderOtherText );\n\t\t\t/*\n\t\t\t * When we init a model, we need to set our 'value' to the selected option's value.\n\t\t\t * This is the list equivalent of a 'default value'.\n\t\t\t */ \n\t\t\tif ( 0 != model.get( 'options' ).length ) {\n\t\t\t\t/*\n\t\t\t\t * Check to see if we have a selected value.\n\t\t\t\t */\n\t\t\t\tvar selected = _.find( model.get( 'options' ), function( opt ) { return 1 == opt.selected } );\n\n\t\t\t\tif ( 'undefined' != typeof selected ) {\n\t\t\t\t\tmodel.set( 'value', selected.value );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tchangeModelValue: function( model ) {\n\t\t\tif ( 1 == model.get( 'show_other' ) ) {\n\t\t\t\t// model.set( 'reRender', true );\n\t\t\t\tmodel.trigger( 'reRender');\n\t\t\t}\n\t\t},\n\n\t\trenderOptions: function() {\n\t\t\tvar html = '';\n\t\t\tif ( '' == this.value ) {\n\t\t\t\tvar valueFound = true;\n\t\t\t} else {\n\t\t\t\tvar valueFound = false;\n\t\t\t}\n\t\t\t\n\t\t\t_.each( this.options, function( option, index ) {\n\t\t\t\tif ( option.value == this.value ) {\n\t\t\t\t\tvalueFound = true;\n\t\t\t\t}\n\n\t\t\t\t/*\n                 * TODO: This is a bandaid fix for making sure that each option has a \"visible\" property.\n                 * This should be moved to creation so that when an option is added, it has a visible property by default.\n                 */\n                if ( 'undefined' == typeof option.visible ) {\n                    option.visible = true;\n                }\n\n                option.selected = false;\n\t\t\t\toption.fieldID = this.id;\n\t\t\t\toption.classes = this.classes;\n\t\t\t\toption.currentValue = this.value;\n\t\t\t\toption.index = index;\n\t\t\t\toption.label = (typeof nfFrontEnd.filter_esc_status !== \"undefined\" && nfFrontEnd.filter_esc_status === \"true\") ? _.escape(option.label) : option.label;\n\t\t\t\toption.required = this.required;\n\n\t\t\t\t/*\n\t\t\t\t * If we haven't edited this field yet, use the default checked\n\t\t\t\t */\n\t\t\t\tif ( this.clean && 1 == this.selected ) {\n\t\t\t\t\toption.selected = true;\n\t\t\t\t} else if ( this.value == option.value ) {\n\t\t\t\t\toption.selected = true;\n\t\t\t\t} else {\n\t\t\t\t\toption.selected = false;\n\t\t\t\t}\n\n                option.maybeFilterHTML = this.maybeFilterHTML;\n\t\t\t\tvar template = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-field-listradio-option' );\n\n\t\t\t\thtml += template( option );\n\t\t\t}, this );\n\n\t\t\tif ( 1 == this.show_other ) {\n\t\t\t\tif ( 'nf-other' == this.value ) {\n\t\t\t\t\tvalueFound = false;\n\t\t\t\t}\n\t\t\t\tvar data = {\n\t\t\t\t\tfieldID: this.id,\n\t\t\t\t\tclasses: this.classes,\n\t\t\t\t\tcurrentValue: this.value,\n\t\t\t\t\trenderOtherText: this.renderOtherText,\n\t\t\t\t\tvalueFound: valueFound\n\t\t\t\t};\n\t\t\t\tvar template = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-field-listradio-other' );\n\t\t\t\thtml += template( data );\n\t\t\t}\n\n\t\t\treturn html;\n\t\t},\n\n\t\trenderOtherText: function() {\n\t\t\tif ( 'nf-other' == this.currentValue || ! this.valueFound ) {\n\t\t\t\tif ( 'nf-other' == this.currentValue ) {\n\t\t\t\t\tthis.currentValue = '';\n\t\t\t\t}\n\t\t\t\tvar data = {\n\t\t\t\t\tfieldID: this.fieldID,\n\t\t\t\t\tclasses: this.classes,\n\t\t\t\t\tcurrentValue: this.currentValue\n\t\t\t\t};\n\t\t\t\tvar template = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-field-listradio-other-text' );\n\t\t\t\treturn template( data );\n\t\t\t}\n\t\t},\n\n\t\tgetCalcValue: function( fieldModel ) {\n\t\t\t\n            /*\n             * Default to 0, in case we have no selection.\n             */\n            var calc_value = 0;\n            \n\t\t\tif ( 0 != fieldModel.get( 'options' ).length ) {\n\t\t\t\t/*\n\t\t\t\t * Check to see if we have a selected value.\n\t\t\t\t */\n\t\t\t\tvar selected = _.find( fieldModel.get( 'options' ), function( opt ) { return fieldModel.get( 'value' ) == opt.value } );\n\t\t\t\tif ( 'undefined' !== typeof selected ) {\n                    calc_value = selected.calc;\n\t\t\t\t}\n\n\t\t\t}\n\t\t\treturn calc_value;\n\t\t},\n\n\t\tupdateCheckedClass: function( el, model ) {\n\t\t\tjQuery( '[name=\"' + jQuery( el ).attr( 'name' ) + '\"]' ).removeClass( 'nf-checked' );\n\t\t\tjQuery( el ).closest( 'ul' ).find( 'label' ).removeClass( 'nf-checked-label' );\n\t\t\tjQuery( el ).addClass( 'nf-checked' );\n\t\t\tjQuery( el ).closest( 'li' ).find( 'label[for=\"' + jQuery( el ).prop( 'id' ) + '\"]' ).addClass( 'nf-checked-label' );\n\n\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","define('controllers/fieldNumber',[], function() {\n    var controller = Marionette.Object.extend( {\n        initialize: function() {\n            this.listenTo( nfRadio.channel( 'number' ), 'init:model', this.maybeMinDefault );\n            this.listenTo( nfRadio.channel( 'number' ), 'keyup:field', this.validateEntry );\n        },\n\n        maybeMinDefault: function( model ) {\n\n            if( '' == model.get( 'value' ) && '' == model.get( 'placeholder' ) ){\n                var min = model.get( 'num_min' );\n                model.set( 'placeholder', min );\n            }\n        },\n\n        validateEntry: function( el, model ) {\n            var $el = jQuery( el );\n            var val = $el.val();\n            var floatVal = parseFloat( val );\n            var min = $el.attr( 'min' );\n            var max = $el.attr( 'max' );\n            var step = $el.attr( 'step' ) ? $el.attr( 'step' ) : '1';\n\n            if( min && floatVal < min ){\n                var fieldModel = nfRadio.channel( 'fields' ).request( 'get:field', model.get( 'id' ) );\n                var formModel  = nfRadio.channel( 'app'    ).request( 'get:form',  fieldModel.get( 'formID' ) );\n                nfRadio.channel( 'fields' ).request( 'add:error', model.get( 'id' ), 'number-min', formModel.get( 'settings' ).fieldNumberNumMinError );\n            } else {\n                nfRadio.channel( 'fields' ).request( 'remove:error', model.get( 'id' ), 'number-min' );\n            }\n\n            if ( max && floatVal > max ){\n                var fieldModel = nfRadio.channel( 'fields' ).request( 'get:field', model.get( 'id' ) );\n                var formModel  = nfRadio.channel( 'app'    ).request( 'get:form',  fieldModel.get( 'formID' ) );\n                nfRadio.channel( 'fields' ).request( 'add:error', model.get( 'id' ), 'number-max', formModel.get( 'settings' ).fieldNumberNumMaxError );\n            } else {\n                nfRadio.channel( 'fields' ).request( 'remove:error', model.get( 'id' ), 'number-max' );\n            }\n\n            let testVal = val.split('.');\n            testVal = typeof(testVal[1]) !== 'undefined' ? testVal[1].length : 0;\n            let testStep = step.split('.');\n            testStep = typeof(testStep[1]) !== 'undefined' ? testStep[1].length : 0;\n            let factor = Math.pow(10, testStep);\n\n            if( step && val && ( testVal > testStep\n                || 0 !== parseInt((factor * floatVal).toFixed()) % parseInt((factor * parseFloat(step)).toFixed()) ) ){\n                var fieldModel = nfRadio.channel( 'fields' ).request( 'get:field', model.get( 'id' ) );\n                var formModel  = nfRadio.channel( 'app' ).request( 'get:form',  fieldModel.get( 'formID' ) );\n                nfRadio.channel( 'fields' ).request( 'add:error', model.get( 'id' ), 'number-step', formModel.get( 'settings' ).fieldNumberIncrementBy + step );\n            } else {\n                nfRadio.channel( 'fields' ).request( 'remove:error', model.get( 'id' ), 'number-step' );\n            }\n        }\n\n    });\n\n    return controller;\n} );\n","define( 'controllers/mirrorField',[], function() {\n\tvar radioChannel = nfRadio.channel( 'fields' );\n\n\tvar controller = Marionette.Object.extend( {\n\t\tlisteningModel: '',\n\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( radioChannel, 'init:model', this.registerMirror );\n\t\t},\n\n\t\tregisterMirror: function( model ) {\n\t\t\tif ( model.get( 'mirror_field' ) ) {\n\t\t\t\tthis.listeningModel = model;\n\t\t\t\tvar targetID = model.get( 'mirror_field' );\n\t\t\t\tthis.listenTo( nfRadio.channel( 'field-' + targetID ), 'change:modelValue', this.changeValue );\n\t\t\t}\n\t\t},\n\n\t\tchangeValue: function( targetModel ) {\n\t\t\tthis.listeningModel.set( 'value', targetModel.get( 'value' ) );\n\t\t\t// this.listeningModel.set( 'reRender', true );\n\t\t\tthis.listeningModel.trigger( 'reRender' );\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","define( 'controllers/confirmField',[], function() {\n\tvar radioChannel = nfRadio.channel( 'fields' );\n\tvar errorID = 'confirm-mismatch';\n\n\tvar controller = Marionette.Object.extend( {\n\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( radioChannel, 'init:model', this.registerConfirm );\n\t\t\tthis.listenTo( radioChannel, 'keyup:field', this.confirmKeyup );\n\t\t},\n\n\t\tregisterConfirm: function( confirmModel ) {\n\t\t\tif ( ! confirmModel.get( 'confirm_field' ) ) return;\n\n\t\t\tthis.listenTo( nfRadio.channel( 'form' ), 'loaded', function( formModal ){\n\t\t\t\tthis.registerConfirmListeners( confirmModel );\n\t\t\t});\n\t\t},\n\n\t\tregisterConfirmListeners: function( confirmModel ) {\n\t\t\t\n\t\t\tvar targetModel = nfRadio.channel( 'form-' + confirmModel.get( 'formID' ) ).request( 'get:fieldByKey', confirmModel.get( 'confirm_field' ) );\n\n\t\t\t//TODO: Add better handling for password confirm fields on the front end.\n\t\t\tif( 'undefined' == typeof targetModel ) return;\n\n\t\t\ttargetModel.set( 'confirm_with', confirmModel.get( 'id' ) );\n\t\t\tthis.listenTo( nfRadio.channel( 'field-' + targetModel.get( 'id' ) ), 'change:modelValue', this.changeValue );\n\t\t\tthis.listenTo( nfRadio.channel( 'field-' + confirmModel.get( 'id' ) ), 'change:modelValue', this.changeValue );\n\t\t},\n\n\t\tchangeValue: function( model ) {\n\t\t\tif ( 'undefined' == typeof model.get( 'confirm_with' ) ) {\n\t\t\t\tvar confirmModel = model;\n\t\t\t\tvar targetModel = nfRadio.channel( 'form-' + model.get( 'formID' ) ).request( 'get:fieldByKey', confirmModel.get( 'confirm_field' ) );\n\t\t\t} else {\n\t\t\t\tvar targetModel = model;\n\t\t\t\tvar confirmModel = radioChannel.request( 'get:field', targetModel.get( 'confirm_with' ) );\n\t\t\t}\n\t\t\tvar targetID = targetModel.get( 'id' );\n\t\t\tvar confirmID = confirmModel.get( 'id' );\n\n\t\t\tif ( '' == confirmModel.get( 'value' ) || confirmModel.get( 'value' ) == targetModel.get( 'value' ) ) {\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'remove:error', confirmID, errorID );\n\t\t\t} else {\n\t\t\t\tvar fieldModel = nfRadio.channel( 'fields' ).request( 'get:field', confirmID );\n\t\t\t\tvar formModel  = nfRadio.channel( 'app'    ).request( 'get:form',  fieldModel.get( 'formID' ) );\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'add:error', confirmID, errorID, formModel.get( 'settings' ).confirmFieldErrorMsg );\n\t\t\t}\n\t\t},\n\t\t\n\t\tconfirmKeyup: function( el, model, keyCode ) {\n\n\t\t\tvar currentValue = jQuery( el ).val();\n\t\t\tif ( model.get( 'confirm_field' ) ) {\n\t\t\t\tvar confirmModel = model;\n\t\t\t\tvar confirmID = model.get( 'id' );\n\t\t\t\tvar targetModel = nfRadio.channel( 'form-' + model.get( 'formID' ) ).request( 'get:fieldByKey', confirmModel.get( 'confirm_field' ) );\n\t\t\t\tvar compareValue = targetModel.get( 'value' );\n\t\t\t\tvar confirmValue = currentValue;\n\t\t\t} else if ( model.get( 'confirm_with' ) ) {\n\t\t\t\tvar confirmModel = nfRadio.channel( 'fields' ).request( 'get:field', model.get( 'confirm_with' ) );\n\t\t\t\tvar confirmID = confirmModel.get( 'id' );\n\t\t\t\tvar confirmValue = confirmModel.get( 'value' );\n\t\t\t\tvar compareValue = confirmValue;\n\t\t\t}\n\n\t\t\tif ( 'undefined' !== typeof confirmModel ) {\n\t\t\t\tif ( '' == confirmValue ) {\n\t\t\t\t\tnfRadio.channel( 'fields' ).request( 'remove:error', confirmID, errorID );\n\t\t\t\t} else if ( currentValue == compareValue ) {\n\t\t\t\t\tnfRadio.channel( 'fields' ).request( 'remove:error', confirmID, errorID );\n\t\t\t\t} else {\n\t\t\t\t\tvar fieldModel = nfRadio.channel( 'fields' ).request( 'get:field', confirmID );\n\t\t\t\t\tvar formModel  = nfRadio.channel( 'app'    ).request( 'get:form',  fieldModel.get( 'formID' ) );\n\t\t\t\t\tnfRadio.channel( 'fields' ).request( 'add:error', confirmID, errorID, formModel.get( 'settings' ).confirmFieldErrorMsg );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","define('controllers/updateFieldModel',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tnfRadio.channel( 'nfAdmin' ).reply( 'update:field', this.updateField );\n\t\t},\n\n\t\tupdateField: function( model, value ) {\n\t\t\tif ( ! model.get( 'isUpdated' ) ) {\n\t\t\t\tmodel.set( 'value', value );\n\t\t\t\tmodel.set( 'isUpdated', true );\n\t\t\t\t/*\n\t\t\t\t * If we're working with an array, it won't trigger a change event on the value attribute.\n\t\t\t\t * Instead, we have to manually trigger a change event.\n\t\t\t\t */ \n\t\t\t\tif ( _.isArray( value ) ) {\n\t\t\t\t\tmodel.trigger( 'change:value', model );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","define('controllers/submitButton',['controllers/submitButton'], function( submitButton ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tbound: {},\n\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'submit' ), 'init:model', this.registerHandlers );\n\t\t},\n\n\t\tregisterHandlers: function( fieldModel ) {\n\t\t\tif ( 'undefined' != typeof this.bound[ fieldModel.get( 'id' ) ] ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tthis.listenTo( nfRadio.channel( 'field-' + fieldModel.get( 'id' ) ), 'click:field', this.click, this );\n\t\t\t/*\n\t\t\t * Register an interest in the 'before:submit' event of our form.\n\t\t\t */\n\t\t\tfieldModel.listenTo( nfRadio.channel( 'form-' + fieldModel.get( 'formID' ) ), 'before:submit', this.beforeSubmit, fieldModel );\n\t\t\tfieldModel.listenTo( nfRadio.channel( 'form-' + fieldModel.get( 'formID' ) ), 'submit:failed', this.resetLabel, fieldModel );\n\t\t\tfieldModel.listenTo( nfRadio.channel( 'form-' + fieldModel.get( 'formID' ) ), 'submit:response', this.resetLabel, fieldModel );\n\t\t\tfieldModel.listenTo( nfRadio.channel( 'form-' + fieldModel.get( 'formID' ) ), 'enable:submit', this.maybeEnable, fieldModel );\n\t\t\tfieldModel.listenTo( nfRadio.channel( 'form-' + fieldModel.get( 'formID' ) ), 'disable:submit', this.maybeDisable, fieldModel );\n\t\t\tfieldModel.listenTo( nfRadio.channel( 'form-' + fieldModel.get( 'formID' ) ), 'processingLabel', this.processingLabel, fieldModel );\n\n\t\t\tfieldModel.listenTo( nfRadio.channel( 'fields' ), 'add:error', this.maybeDisable, fieldModel );\n\t\t\tfieldModel.listenTo( nfRadio.channel( 'fields' ), 'remove:error', this.maybeEnable, fieldModel );\n\t\t\t\n\t\t\tthis.bound[ fieldModel.get( 'id') ] = true;\n\t\t},\n\n\t\tclick: function( e, fieldModel ) {\n\t\t\tvar formModel = nfRadio.channel( 'app' ).request( 'get:form', fieldModel.get( 'formID' ) );\n\t\t\tif(_.size(formModel.get('fieldErrors')) > 0){\n\t\t\t\tnfRadio.channel( 'submit' ).request( 'focus:firstInvalidInput', Object.keys(formModel.get('fieldErrors')) );\n\t\t\t}\n\t\t\tnfRadio.channel( 'form-' + fieldModel.get( 'formID' ) ).request( 'submit', formModel );\n\t\t},\n\n\t\tbeforeSubmit: function() {\n\t\t\tif(this.get('disabled')) return;\n\n\t\t\tthis.set( 'disabled', true );\n\t\t\tnfRadio.channel( 'form-' + this.get( 'formID' ) ).trigger( 'processingLabel', this );\n\t\t},\n\n\t\tmaybeDisable: function( fieldModel ) {\n\n\t\t\tif( 'undefined' != typeof fieldModel && fiel