\t\t\t}\n\t\t\t// use moment's isValid to check against the fields format setting\n\t\t\telse if ( this.isDateValid(value, format, fieldID) ) {\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'remove:error', fieldID, errorID );\n\t\t\t\t/*\n\t\t\t\t * Add nf-pass class to the wrapper.\n\t\t\t\t */\n\t\t\t\tmodel.addWrapperClass( 'nf-pass' );\n\t\t\t\tmodel.set( 'clean', false );\n\t\t\t}\n\t\t\tmoment.locale(original);\n\t\t},\n\n\t\tchangeHoursMinutes: function( e, fieldModel ) {\n\t\t\tlet type = '';\n\t\t\tlet container = jQuery( e.target ).closest( '.nf-field-element' );\n\n\t\t\t// Set our hour, minute, and ampm\n\t\t\tlet selected_hour = jQuery( container ).find( '.hour' ).val();\n\t\t\tlet selected_minute = jQuery( container ).find( '.minute' ).val();\n\t\t\tlet selected_ampm = jQuery( container ).find( '.ampm' ).val();\n\n\t\t\tfieldModel.set( 'selected_hour', selected_hour );\n\t\t\tfieldModel.set( 'selected_minute', selected_minute );\n\t\t\tfieldModel.set( 'selected_ampm', selected_ampm );\n\n\t\t\tif ( 'time_only' === fieldModel.get( 'date_mode' ) ) {\n\t\t\t\tconst setValue = typeof selected_ampm !== \"undefined\" ?\n\t\t\t\t\tselected_hour + \":\" + selected_minute + \" \" + selected_ampm :\n\t\t\t\t\tselected_hour + \":\" + selected_minute;\n\n\t\t\t\tfieldModel.set( 'value', setValue );\n\t\t\t}\n\n\t\t\t// Detect time field inside a repeatable fieldset field to set correct value\n\t\t\tconst fieldId = fieldModel.get( 'id' );\n\t\t\tif(typeof fieldId === 'string' && fieldId.search(\".\") !== -1){\n\t\t\t\tnfRadio.channel('field-repeater').trigger('set:value');\n\t\t\t}\n\t\t},\n\n\t\tisDateValid: function(value, format, fieldID){\n\t\t\tif(document.querySelector(\"[name='nf-field-\" + fieldID + \"']\") === null) return;\n\t\t\t//Get Date and Timestamp using the precise flatPickr instance of the field to catch the locale\n\t\t\tconst parseDate = document.querySelector(\"[name='nf-field-\" + fieldID + \"']\")._flatpickr.parseDate(value, format);\n\t\t\t// If parsedDate is undefined, the date is invalid\n\t\t\tif (!parseDate) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\tconst timestamp = parseDate.getTime();\n\t\t\tif (isNaN(timestamp)) {\n\t\t\t\treturn false; // Invalid date\n\t\t\t}\n\t\t\t//Convert timestamp back to Date object and string\n\t\t\tconst parsedDate = new Date(timestamp);\n\t\t\tconst formattedDate = document.querySelector(\"[name='nf-field-\" + fieldID + \"']\")._flatpickr.formatDate(parsedDate, format);\n\t\t\t// Check vlaue and date string are deeply equals\n\t\t\treturn formattedDate === value;\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","define('controllers/fieldCheckbox',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t/*\n\t\t\t * When we init our checkbox model, register our renderClasses() function\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'checkbox' ), 'init:model', this.registerRenderClasses );\n\n\t\t\tnfRadio.channel( 'checkbox' ).reply( 'validate:required', this.validateRequired );\n\t\t\tnfRadio.channel( 'checkbox' ).reply( 'validate:modelData', this.validateModelData );\n            nfRadio.channel( 'checkbox' ).reply( 'before:updateField', this.beforeUpdateField, this );\n            nfRadio.channel( 'checkbox' ).reply( 'get:calcValue', this.getCalcValue, this );\n\t\t},\n\n\t\tbeforeUpdateField: function( el, model ) {\n\t\t\tvar checked = jQuery( el ).prop( 'checked' );\n\t\t\tif ( checked ) {\n\t\t\t\tvar value = 1;\n\t\t\t\tjQuery( el ).addClass( 'nf-checked' );\n\t\t\t\tjQuery( el ).closest( '.field-wrap' ).find( 'label[for=\"' + jQuery( el ).prop( 'id' ) + '\"]' ).addClass( 'nf-checked-label' );\n\t\t\t} else {\n\t\t\t\tvar value = 0;\n\t\t\t\tjQuery( el ).removeClass( 'nf-checked' );\n\t\t\t\tjQuery( el ).closest( '.field-wrap' ).find( 'label[for=\"' + jQuery( el ).prop( 'id' ) + '\"]' ).removeClass( 'nf-checked-label' );\n\t\t\t}\n\n\t\t\treturn value;\n\t\t},\n\n\t\tvalidateRequired: function( el, model ) {\n\t\t\treturn el[0].checked;\n\t\t},\n\n\t\tvalidateModelData: function( model ) {\n\t\t\treturn model.get( 'value' ) != 0;\n\t\t},\n\n\t\tgetCalcValue: function( fieldModel ) {\n\t\t\tif ( 1 == fieldModel.get( 'value' ) ) {\n\t\t\t\tcalcValue = fieldModel.get( 'checked_calc_value' );\n\t\t\t} else {\n\t\t\t\tcalcValue = fieldModel.get( 'unchecked_calc_value' );\n\t\t\t}\n\n\t\t\treturn calcValue;\n\t\t},\n\n\t\tregisterRenderClasses: function( model ) {\n\t\t\tif ( 'checked' == model.get( 'default_value' ) ) {\n\t\t\t\tmodel.set( 'value', 1 );\n\t\t\t} else {\n\t\t\t\tmodel.set( 'value', 0 );\n\t\t\t}\n\t\t\tmodel.set( 'customClasses', this.customClasses );\n\t\t\tmodel.set( 'customLabelClasses', this.customLabelClasses );\n\t\t\tmodel.set( 'maybeChecked', this.maybeChecked );\n\t\t},\n\n\t\tcustomClasses: function( classes ) {\n\t\t\tif ( 1 == this.value || ( this.clean && 'undefined' != typeof this.default_value && 'checked' == this.default_value ) ) {\n\t\t\t\tclasses += ' nf-checked';\n\t\t\t} else {\n\t\t\t\tclasses.replace( 'nf-checked', '' );\n\t\t\t}\n\t\t\treturn classes;\n\t\t},\n\n\t\tcustomLabelClasses: function( classes ) {\n\t\t\tif ( 1 == this.value || ( this.clean && 'undefined' != typeof this.default_value && 'checked' == this.default_value ) ) {\n\t\t\t\tclasses += ' nf-checked-label';\n\t\t\t} else {\n\t\t\t\tclasses.replace( 'nf-checked-label', '' );\n\t\t\t}\n\t\t\treturn classes;\n\t\t},\n\n\t\tmaybeChecked: function() {\n\t\t\tif ( 1 == this.value || ( this.clean && 'undefined' != typeof this.default_value && 'checked' == this.default_value ) ) {\n\t\t\t\treturn ' checked';\n\t\t\t} else {\n\t\t\t\treturn '';\n\t\t\t}\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","define('controllers/fieldCheckboxList',[], function() {\n    var controller = Marionette.Object.extend( {\n        initialize: function() {\n            this.listenTo( nfRadio.channel( 'listcheckbox' ), 'init:model', this.register );\n            this.listenTo( nfRadio.channel( 'terms' ), 'init:model', this.register );\n            nfRadio.channel( 'listcheckbox' ).reply( 'before:updateField', this.beforeUpdateField, this );\n            nfRadio.channel( 'terms' ).reply( 'before:updateField', this.beforeUpdateField, this );\n            nfRadio.channel( 'listcheckbox' ).reply( 'get:calcValue', this.getCalcValue, this );\n            nfRadio.channel( 'terms' ).reply( 'get:calcValue', this.getCalcValue, this );\n        },\n\n        register: function( model ) {\n            model.set( 'renderOptions', this.renderOptions );\n            model.set( 'renderOtherText', this.renderOtherText );\n            model.set( 'selected', [] );\n\n            /*\n             * When we init a model, we need to set our 'value' to the selected option's value.\n             * This is the list equivalent of a 'default value'.\n             */ \n            if ( 0 != model.get( 'options' ).length ) {\n                var selected = _.filter( model.get( 'options' ), function( opt ) { return 1 == opt.selected } );\n                selected = _.map( selected, function( opt ) { return opt.value } );\n            }\n\n            /*\n            * This part is re-worked to take into account custom user-meta\n            * values for fields.\n             */\n\t        var savedVal = model.get( 'value' );\n\t        if( 'undefined' !== typeof savedVal && Array.isArray( savedVal ) ) {\n\t\t        model.set( 'value', savedVal );\n\t        } else if ( 'undefined' != typeof selected ) {\n\t\t        model.set( 'value', selected );\n\t        }\n        },\n\n        renderOptions: function() {\n            var html = '';\n\n            if ( '' == this.value || ( Array.isArray( this.value ) && 0 < this.value.length )\n                || 0 < this.value.length ) {\n                var valueFound = true;\n            } else {\n                var valueFound = false;\n            }\n\n            _.each( this.options, function( option, index ) {\n                if( Array.isArray( this.value ) ) {\n                \tif( Array.isArray( this.value[ 0 ] ) && -1 !== _.indexOf( this.value[ 0 ], option.value ) ) {\n                \t\tvalueFound = true;\n\t                }\n                    else if( _.indexOf( this.value, option.value ) ) {\n                        valueFound = true;\n\t                }\n                }\n\n                if ( option.value == this.value ) {\n                    valueFound = true;\n                }\n\n                /*\n                 * TODO: This is a bandaid fix for making sure that each option has a \"visible\" property.\n                 * This should be moved to creation so that when an option is added, it has a visible property by default.\n                 */\n                if ( 'undefined' == typeof option.visible ) {\n                    option.visible = true;\n                }\n\n                option.fieldID = this.id;\n                option.classes = this.classes;\n                option.index = index;\n                option.label = (typeof nfFrontEnd.filter_esc_status !== \"undefined\" && nfFrontEnd.filter_esc_status === \"true\") ? _.escape(option.label) : option.label;\n                \n                var selected = false;\n\t\t\t\t/*\n\t\t\t\t* This part has been re-worked to account for values passed in\n\t\t\t\t* via custom user-meta ( a la User Mgmt add-on)\n\t\t\t\t */\n\t            if( Array.isArray( this.value ) && 0 < this.value.length ) {\n\t            \tif ( -1 !== _.indexOf( this.value[ 0 ].split( ',' ), option.value )\n\t\t                || -1 !== _.indexOf( this.value, option.value ) ) {\n\t\t\t            selected = true;\n\t            \t}\n\t            } else if ( ! _.isArray( this.value ) && option.value == this.value ) {\n\t\t            selected = true;\n\t            } else if ( ( 1 == option.selected && this.clean ) && 'undefined' === typeof this.value ) {\n\t\t            selected = true;\n\t            }\n\n\n                // else if( ( option.selected && \"0\" != option.selected ) && this.clean ){\n\t            //     isSelected = true;\n\t            // } else {\n\t            //     var testValues = _.map( this.value, function( value ) {\n\t            //         return value.toString();\n\t            //     } );\n\t            //\n\t            //     option.isSelected = ( -1 != testValues.indexOf( option.value.toString() ) );\n\t            // }\n\t            option.selected = selected;\n\t            option.isSelected = selected;\n\t            option.required = this.required;\n                option.maybeFilterHTML = this.maybeFilterHTML;\n                var template = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-field-listcheckbox-option' );\n                html += template( option );\n            }, this );\n\n            if ( 1 == this.show_other ) {\n                if ( 'nf-other' == this.value ) {\n                    valueFound = false;\n                }\n                var data = {\n                    fieldID: this.id,\n                    classes: this.classes,\n                    currentValue: this.value,\n                    renderOtherText: this.renderOtherText,\n                    valueFound: valueFound\n                };\n\n                var template = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-field-listcheckbox-other' );\n                html += template( data );\n\n            }\n\n            return html;\n        },\n\n        renderOtherText: function() {\n            if ( 'nf-other' == this.currentValue || ! this.valueFound ) {\n                if ( 'nf-other' == this.currentValue ) {\n                    this.currentValue = '';\n                }\n                var data = {\n                    fieldID: this.fieldID,\n                    classes: this.classes,\n                    currentValue: this.currentValue\n                };\n                var template = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-field-listcheckbox-other-text' );\n                return template( data );\n            }\n        },\n\n        getCalcValue: function( fieldModel ) {\n            var calc_value = 0;\n            var options = fieldModel.get( 'options' );\n            if ( 0 != options.length ) {\n                _.each( fieldModel.get( 'value' ), function( val ) {\n                    var tmp_opt = _.find( options, function( opt ) { return opt.value == val } );\n                    calc_value = Number( calc_value ) + Number( tmp_opt.calc );\n                } );\n            }\n            return calc_value;\n        },\n\n        beforeUpdateField: function( el, model ) {\n            var selected = model.get( 'value' ) || [];\n            if ( typeof selected == 'string' ) selected = [ selected ];\n\n            var value = jQuery( el ).val();\n            var checked = jQuery( el ).prop( 'checked' );\n            if ( checked ) {\n                selected.push( value );\n                jQuery( el ).addClass( 'nf-checked' );\n                jQuery( el ).parent().find( 'label[for=\"' + jQuery( el ).prop( 'id' ) + '\"]' ).addClass( 'nf-checked-label' );\n            } else {\n                jQuery( el ).removeClass( 'nf-checked' );\n                jQuery( el ).parent().find( 'label[for=\"' + jQuery( el ).prop( 'id' ) + '\"]' ).removeClass( 'nf-checked-label' );\n                var i = selected.indexOf( value );\n                if( -1 != i ){\n                    selected.splice( i, 1 );\n                } else if ( Array.isArray( selected ) ) {\n                \tvar optionArray = typeof selected[0] !== \"undefined\" ? selected[0].split( ',' ) : [];\n                \tvar valueIndex = optionArray.indexOf( value );\n                \tif( -1 !== valueIndex) {\n                \t\toptionArray.splice( valueIndex, 1 );\n\t                }\n                \tselected = optionArray.join( ',' );\n                }\n            }\n\n            // if ( 1 == model.get( 'show_other' ) ) {\n            //     model.set( 'reRender', true );\n            // }\n\n            return _.clone( selected );\n        }\n    });\n\n    return controller;\n} );\n","define('controllers/fieldImageList',[], function() {\n    var controller = Marionette.Object.extend( {\n        initialize: function() {\n            this.listenTo( nfRadio.channel( 'listimage' ), 'init:model', this.register );\n            nfRadio.channel( 'listimage' ).reply( 'before:updateField', this.beforeUpdateField, this );\n            nfRadio.channel( 'listimage' ).reply( 'get:calcValue', this.getCalcValue, this );\n        },\n\n        register: function( model ) {\n            model.set( 'renderOptions', this.renderOptions );\n            model.set( 'renderOtherText', this.renderOtherText );\n            model.set( 'selected', [] );\n\n            /*\n             