deps = callback;\n                callback = relName;\n                relName = null;\n            } else {\n                deps = undef;\n            }\n        }\n\n        //Support require(['a'])\n        callback = callback || function () {};\n\n        //If relName is a function, it is an errback handler,\n        //so remove it.\n        if (typeof relName === 'function') {\n            relName = forceSync;\n            forceSync = alt;\n        }\n\n        //Simulate async callback;\n        if (forceSync) {\n            main(undef, deps, callback, relName);\n        } else {\n            //Using a non-zero value because of concern for what old browsers\n            //do, and latest browsers \"upgrade\" to 4 if lower value is used:\n            //http://www.whatwg.org/specs/web-apps/current-work/multipage/timers.html#dom-windowtimers-settimeout:\n            //If want a value immediately, use require('id') instead -- something\n            //that works in almond on the global level, but not guaranteed and\n            //unlikely to work in other AMD implementations.\n            setTimeout(function () {\n                main(undef, deps, callback, relName);\n            }, 4);\n        }\n\n        return req;\n    };\n\n    /**\n     * Just drops the config on the floor, but returns req in case\n     * the config return value is used.\n     */\n    req.config = function (cfg) {\n        return req(cfg);\n    };\n\n    /**\n     * Expose module registry for debugging and tooling\n     */\n    requirejs._defined = defined;\n\n    define = function (name, deps, callback) {\n        if (typeof name !== 'string') {\n            throw new Error('See almond README: incorrect module build, no module name');\n        }\n\n        //This module may not have dependencies\n        if (!deps.splice) {\n            //deps is not an array, so probably means\n            //an object literal or factory function for\n            //the value. Adjust args.\n            callback = deps;\n            deps = [];\n        }\n\n        if (!hasProp(defined, name) && !hasProp(waiting, name)) {\n            waiting[name] = [name, deps, callback];\n        }\n    };\n\n    define.amd = {\n        jQuery: true\n    };\n}());\n\ndefine(\"../../../node_modules/almond/almond\", function(){});\n\n","define( 'models/fieldErrorModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\n\t} );\n\t\n\treturn model;\n} );\n","define( 'models/fieldErrorCollection',['models/fieldErrorModel'], function( errorModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: errorModel\n\t} );\n\treturn collection;\n} );\n","define( 'models/fieldModel',['models/fieldErrorCollection'], function( fieldErrorCollection ) {\n\tvar model = Backbone.Model.extend( {\n\t\tdefaults: {\n\t\t\tplaceholder: '',\n\t\t\tvalue: '',\n\t\t\tlabel_pos: '',\n\t\t\tclasses: 'ninja-forms-field',\n\t\t\treRender: false,\n\t\t\tmirror_field: false,\n\t\t\tconfirm_field: false,\n\t\t\tclean: true,\n\t\t\tdisabled: '',\n\t\t\tvisible: true,\n\t\t\tinvalid: false\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\tvar type = this.get('type');\n\n\t\t\tthis.set( 'formID', this.collection.options.formModel.get( 'id' ) );\n\t\t\tthis.listenTo( nfRadio.channel( 'form-' + this.get( 'formID' ) ), 'reset', this.resetModel );\n\n    \t\tthis.bind( 'change', this.changeModel, this );\n    \t\tthis.bind( 'change:value', this.changeValue, this );\n    \t\tthis.set( 'errors', new fieldErrorCollection() );\n\n\t\t\tif (type === 'listimage') {\n\t\t\t\tthis.get = this.listimageGet;\n\t\t\t\tthis.set = this.listimageSet;\n\t\t\t}\n\n    \t\t/*\n\t\t\t * Trigger an init event on two channels:\n\t\t\t * \n\t\t\t * fields\n\t\t\t * field-type\n\t\t\t *\n\t\t\t * This lets specific field types modify model attributes before anything uses them.\n\t\t\t */\n\t\t\tnfRadio.channel( 'fields' ).trigger( 'init:model', this );\n\t\t\tnfRadio.channel( this.get( 'type' ) ).trigger( 'init:model', this );\n\t\t\tnfRadio.channel( 'fields-' + this.get( 'type' ) ).trigger( 'init:model', this );\n\n\t\t\tif( 'undefined' != typeof this.get( 'parentType' ) ){\n\t\t\t\tnfRadio.channel( this.get( 'parentType' ) ).trigger( 'init:model', this );\n\t\t\t}\n\n\t\t\t/*\n\t\t\t * When we load our form, fire another event for this field.\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'form-' + this.get( 'formID' ) ), 'loaded', this.formLoaded );\n\t\t\n\t\t\t/*\n\t\t\t * Before we submit our form, send out a message so that this field can be modified if necessary.\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'form-' + this.get( 'formID' ) ), 'before:submit', this.beforeSubmit );\n\t\t},\n\n\t\tlistimageGet: function(attr) {\n            if(attr === 'options') {\n\t\t\t\t\tattr = 'image_options';\n\t\t\t}\n\n            return Backbone.Model.prototype.get.call(this, attr);\n\t\t},\n\t\t\n\t\tlistimageSet: function(attributes, options) {\n\t\t\tif ('options' === attributes) {\n\t\t\t\tattributes = 'image_options';\n\t\t\t}\n\t\t\treturn Backbone.Model.prototype.set.call(this, attributes, options);\n\t\t},\n\n\t\tchangeModel: function() {\n\t\t\tnfRadio.channel( 'field-' + this.get( 'id' ) ).trigger( 'change:model', this );\n\t\t\tnfRadio.channel( this.get( 'type' ) ).trigger( 'change:model', this );\n\t\t\tnfRadio.channel( 'fields' ).trigger( 'change:model', this );\n\t\t},\n\n\t\tchangeValue: function() {\n\t\t\tnfRadio.channel( 'field-' + this.get( 'id' ) ).trigger( 'change:modelValue', this );\n\t\t\tnfRadio.channel( this.get( 'type' ) ).trigger( 'change:modelValue', this );\n\t\t\tnfRadio.channel( 'fields' ).trigger( 'change:modelValue', this );\n\t\t},\n\n\t\taddWrapperClass: function( cl ) {\n\t\t\tthis.set( 'addWrapperClass', cl );\n\t\t},\n\n\t\tremoveWrapperClass: function( cl ) {\n\t\t\tthis.set( 'removeWrapperClass', cl );\n\t\t},\n\n\t\tsetInvalid: function( invalid ) {\n\t\t\tthis.set( 'invalid', invalid );\n\t\t},\n\n\t\tformLoaded: function() {\n\t\t\tnfRadio.channel( 'fields' ).trigger( 'formLoaded', this );\n\t\t\tnfRadio.channel( 'fields-' + this.get( 'type' ) ).trigger( 'formLoaded', this );\n\t\t},\n\n\t\tbeforeSubmit: function( formModel ) {\n\t\t\tnfRadio.channel( this.get( 'type' ) ).trigger( 'before:submit', this );\n\t\t\tnfRadio.channel( 'fields' ).trigger( 'before:submit', this );\n\t\t},\n\n\t\t/**\n\t\t * Return the value of this field.\n\t\t * This method exists so that more complex fields can return more than just the field value.\n\t\t * Those advanced fields should create their own method with this name.\n\t\t * \n\t\t * @since  3.5\n\t\t * @return {string} Value of this field.\n\t\t */\n\t\tgetValue: function() {\n\t\t\treturn this.get( 'value' );\n\t\t}\n\n\t} );\n\n\treturn model;\n} );\n\n","define( 'models/fieldCollection',['models/fieldModel'], function( fieldModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: fieldModel,\n\t\tcomparator: 'order',\n\n\t\tinitialize: function( models, options ) {\n\t\t\tthis.options = options;\n            this.on( 'reset', function( fieldCollection ){\n                nfRadio.channel( 'fields' ).trigger( 'reset:collection', fieldCollection );\n            }, this );\n\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:firstFieldByOrder', this.getFirstFieldByOrder );\n\t\t},\n\n\t\tvalidateFields: function() {\n\t\t\t_.each( this.models, function( fieldModel ) {\n\t\t\t\tif(fieldModel.get(\"type\") === \"repeater\"){\n\t\t\t\t\tconst repeaterModels = nfRadio.channel( \"field-repeater\" ).request( 'get:repeaterFieldsModelsArrayByForm', fieldModel.get('formID') );\n\t\t\t\t\t_.each( repeaterModels, function( repeaterFieldModel ) {\n\t\t\t\t\t\t// added here for help with multi-part part validation\n\t\t\t\t\t\trepeaterFieldModel.set( 'clean', false );\n\t\t\t\t\t\tnfRadio.channel( 'submit' ).trigger( 'validate:field', repeaterFieldModel );\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\t// added here for help with multi-part part validation\n\t\t\t\t\tfieldModel.set( 'clean', false );\n\t\t\t\t\tnfRadio.channel( 'submit' ).trigger( 'validate:field', fieldModel );\n\t\t\t\t}\n\t\t\t}, this );\n\t\t\t//Focus the first invalid input when found\n\t\t\tvar formModel  = nfRadio.channel( 'form-' + this.models[0].get( 'formID' ) ).request( 'get:form' );\n\t\t\tif(_.size(formModel.get('fieldErrors')) > 0){\n\t\t\t\tnfRadio.channel( 'submit' ).request( 'focus:firstInvalidInput', Object.keys(formModel.get('fieldErrors')) );\n\t\t\t}\n\t\t},\n\n\t\tshowFields: function() {\n\t\t\tthis.invoke( 'set', { visible: true } );\n            this.invoke( function() {\n                this.trigger( 'change:value', this );\n            });\n\t\t},\n\n\t\thideFields: function() {\n\t\t\tthis.invoke( 'set', { visible: false } );\n            this.invoke( function() {\n                this.trigger( 'change:value', this );\n            });\n\t\t},\n\n\t\tgetFirstFieldByOrder: function( ids_array ) {\n\t\t\tlet targetID = 0;\n\t\t\t//Loop through an array of fieldIDs to return the one that is positioned first\n\t\t\t_.each(ids_array, function( id ) {\n\t\t\t\t//Get field order\n\t\t\t\tconst order = nfRadio.channel( 'fields' ).request( 'get:field', id ).get('order');\n\t\t\t\t//Set it as the target when the lowest order is found\n\t\t\t\ttargetID = (targetID === 0 || order < targetID) ? id : targetID;\n\t\t\t});\n\n\t\t\treturn targetID;\n\t\t}\n\t} );\n\treturn collection;\n} );\n\n","define( 'models/formErrorModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\n\t} );\n\t\n\treturn model;\n} );\n","define( 'models/formErrorCollection',['models/formErrorModel'], function( errorModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: errorModel\n\t} );\n\treturn collection;\n} );\n","define( 'models/formModel',[\n\t'models/fieldCollection',\n\t'models/formErrorCollection'\n\t], function(\n\t\tFieldCollection,\n\t\tErrorCollection\n\t) {\n\tvar model = Backbone.Model.extend({\n\t\tdefaults: {\n\t\t\tbeforeForm: '',\n\t\t\tafterForm: '',\n\t\t\tbeforeFields: '',\n\t\t\tafterFields: '',\n\t\t\twrapper_class: '',\n\t\t\telement_class: '',\n\t\t\thp: '',\n\t\t\tfieldErrors: {},\n\t\t\textra: {}\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\t// Loop over settings and map to attributes\n\t\t\t_.each( this.get( 'settings' ), function( value, setting ) {\n\t\t\t\tthis.set( setting, value );\n\t\t\t}, this );\n\n\t\t\tthis.set( 'loadedFields', this.get( 'fields' ) );\n\t\t\tthis.set( 'fields', new FieldCollection( this.get( 'fields' ), { formModel: this } ) );\n\t\t\tthis.set( 'errors', new ErrorCollection() );\n\n\t\t\t/*\n\t\t\t * Send out a radio message so that anyone who wants to filter our content data can register their filters.\n\t\t\t */\n\t\t\tnfRadio.channel( 'form' ).trigger( 'before:filterData', this );\n\n\t\t\t/*\n\t\t\t * Set our formContentData to our form setting 'formContentData'\n\t\t\t */\n\t\t\tvar formContentData = this.get( 'formContentData' );\n\n\t\t\t/*\n\t\t\t * The formContentData variable used to be fieldContentsData.\n\t\t\t * If we don't have a 'formContentData' setting, check to see if we have an old 'fieldContentsData'.\n\t\t\t * \n\t\t\t * TODO: This is for backwards compatibility and should be removed eventually. \n\t\t\t */\n\t\t\tif ( ! formContentData ) {\n\t\t\t\tformContentData = this.get( 'fieldContentsData' );\n\t\t\t}\n\t\t\t\n\t\t\tvar formContentLoadFilters = nfRadio.channel( 'formContent' ).request( 'get:loadFilters' );\n\t\t\t/* \n\t\t\t* Get our first filter, this will be the one with the highest priority.\n\t\t\t*/\n\t\t\tvar sortedArray = _.without( formContentLoadFilters, undefined );\n\t\t\tvar callback = _.first( sortedArray );\n\t\t\tformContentData = callback( formContentData, this, this );\n\t\t\t\n\t\t\tthis.set( 'formContentData', formContentData );\n\n\t\t\tnfRadio.channel( 'forms' ).trigger( 'init:model', this );\n\t\t\tnfRadio.channel( 'form-' + this.get( 'id' ) ).trigger( 'init:model', this );\n\n\t\t\t// Fields\n\t\t\tnfRadio.channel( 'form-' + this.get( 'id' ) ).reply( 'get:fieldByKey', this.getFieldByKey, this );\n\n\t\t\t// Form Errors\n\t\t\tnfRadio.channel( 'form-' + this.get( 'id' ) ).reply( 'add:error',    this.addError, this    );\n\t\t\tnfRadio.channel( 'form-' + this.get( 'id' ) ).reply( 'remove:error', this.removeError, this );\n\n\t\t\t// Extra Data\n\t\t\tnfRadio.channel( 'form-' + this.get( 'id' ) ).reply( 'get:extra',    this.getExtra,    this );\n\t\t\tnfRadio.channel( 'form-' + this.get( 'id' ) ).reply( 'add:extra',    this.addExtra,    this );\n\t\t\tnfRadio.channel( 'form-' + this.get( 'id' ) ).reply( 'remove:extra', this.removeExtra, this );\n\t\t\n\t\t\t// Respond to requests to get this model.\n\t\t\tnfRadio.channel( 'form-' + this.get( 'id' ) ).reply( 'get:form', \t this.getForm, \t   this );\n\n\t\t\tnfRadio.channel( 'form' ).trigger( 'loaded', this );\n\t\t\tnfRadio.channel( 'form' ).trigger( 'after:loaded', this );\n\t\t\tnfRadio.channel( 'form-' + this.get( 'id' ) ).trigger( 'loaded', \t this );\n\t\t},\n\n\t\t/*\n\t\t |--------------------------------------------------------------------------\n\t\t | Fields\n\t\t |--------------------------------------------------------------------------\n\t\t */\n\n\t\tgetFieldByKey: function( key ) {\n\t\t\treturn this.get( 'fields' ).findWhere( { key: key } );\n\t\t},\n\n\t\t/*\n\t\t |--------------------------------------------------------------------------\n\t\t | Form Errors\n\t\t |--------------------------------------------------------------------------\n\t\t */\n\n\t\taddError: function( id, msg ) {\n\t\t\tvar errors = this.get( 'errors' );\n\t\t\terrors.add( { id: id, msg: msg } );\n\t\t\tnfRadio.channel( 'form-' + this.get( 'id' ) ).trigger( 'add:error', this, id, msg );\n\t\t},\n\n\t\tremoveError: function( id ) {\n\t\t\tvar errors = this.get( 'errors' );\n\t\t\tvar errorModel = errors.get( id );\n\t\t\terrors.remove( errorModel );\n\t\t\tnfRadio.channel( 'form-' + this.get( 'id' ) ).trigger( 'remove:error', this, id );\n\t\t},\n\n\t\t/*\n\t\t |--------------------------------------------------------------------------\n\t\t | Extra Data\n\t\t |--------------------------------------------------------------------------\n\t\t */\n\n\t\tgetExtra: function( key ) {\n\t\t\tvar extraData = this.get( 'extra' );\n\t\t\tif( 'undefined' == typeof key ) return extraData;\n\t\t\treturn extraData[ key ];\n\t\t},\n\n\t\taddExtra: function( key, value ) {\n\t\t\tvar extraData = this.get( 'extra' );\n\t\t\textraData[ key ] = value;\n\t\t\tnfRadio.channel( 'form-' + this.get( 'id' ) ).trigger( 'add:extra', this, key, value );\n\t\t},\n\n\t\tremoveExtra: function( key ) {\n\t\t\tvar extraData = this.get( 'extra' );\n\t\t\tdelete extraData[ key ];\n\t\t\tnfRadio.channel( 'form-' + this.get( 'id' ) ).trigger( 'remove:extra', this, key );\n\t\t},\n\n\t\t/*\n\t\t |--------------------------------------------------------------------------\n\t\t | Get this form\n\t\t |--------------------------------------------------------------------------\n\t\t */\n\t\tgetForm: function() {\n\t\t\treturn this;\n\t\t}\n\t} );\n\n\treturn model;\n} );\n","define( 'models/formCollection',['models/formModel'], function( formModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: formModel\n\t} );\n\treturn collection;\n} );\n","/*\n * Handles setting up our form.\n *\n * Holds a collection of our fields.\n * Replies to requests for field data.\n * Updates field models.\n */\ndefine('controllers/formData',['models/formModel', 'models/formCollection', 'models/fieldCollection', 'models/formErrorCollection'], function( FormModel, FormCollection, FieldCollection, ErrorCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\n\t\t\t/*\n\t\t\t * Setup our field collections.\n\t\t\t */\n\t\t\tvar that = this;\n\n\t\t\t/*\n\t\t\t * Initialize our form collection (incase we have multiple forms on the page)\n\t\t\t */\n\t\t\tthis.collection = new FormCollection( nfForms );\t\t\n\t\t\tnfRadio.channel( 'forms' ).trigger( 'loaded', this.collection );\n\t\t\tnfRadio.channel( 'app' ).trigger( 'forms:loaded', this.collection );\n\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:form', this.getForm, this );\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:forms', this.getForms, this );\n\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:field', this.getField, this );\n\t\t},\n\n\t\tgetForm: function( id ) {\n\t\t\treturn this.collection.get( id );\n\t\t},\n\n\t\tgetForms: function() {\n\t\t\treturn this.collection;\n\t\t},\n\n\t\tgetField: function( id ) {\n\t\t\tvar model = false;\n\t\t\t\n\t\t\t_.each( this.collection.models, function( form ) {\n\t\t\t\tif ( ! model ) {\n\t\t\t\t\tmodel = form.get( 'fields' ).get( id );\t\n\t\t\t\t}\t\t\t\n\t\t\t} );\n\n\t\t\tif(typeof model == \"undefined\" && String(id).indexOf('.') !== -1){\n\t\t\t\tmodel = nfRadio.channel( \"field-repeater\" ).request( 'get:repeaterFieldById', id );\n\t\t\t}\n\t\t\t\n\t\t\treturn model;\n\t\t}\n\t});\n\n\treturn controller;\n} );\n\n","define('controllers/fieldError',['models/fieldErrorModel'], function( fieldErrorModel ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tnfRadio.channel( 'fields' ).reply( 'add:error', this.addError );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'remove:error', this.removeError );\n\t\t\tnfRadio.channel( 'fields' ).reply( 'get:error', this.getError );\n\t\t},\n\n\t\taddError: function( targetID, id, msg ) {\n\t\t\tvar model = nfRadio.channel( 'fields' ).request( 'get:field', targetID );\n\n\t\t\tif( 'undefined' == typeof model ) return;\n\n\t\t\tvar errors = model.get( 'errors' );\n\t\t\terrors.add( { 'id': id, 'msg' : msg } );\n\t\t\tmodel.set( 'errors', errors );\n\t\t\tmodel.trigger( 'change:errors', model );\n\t\t\tmodel.set( 'clean', false );\n\t\t\tnfRadio.channel( 'fields' ).trigger( 'add:error', model, id, msg );\n\t\t},\n\n\t\tremoveError: function( targetID, id ) {\n\t\t\tvar model = nfRadio.channel( 'fields' ).request( 'get:field', targetID );\n\n\t\t\tif( 'undefined' == typeof model ) return;\n\t\t\tvar errors = model.get( 'errors' );\n\t\t\tvar targetError = errors.get( id );\n\n\t\t\tif ( 'undefined' != typeof targetError ) {\n\t\t\t\terrors.remove( targetError );\n\t\t\t\tmodel.set( 'errors', errors );\n\t\t\t\tmodel.trigger( 'change:errors', model );\n\t\t\t\tnfRadio.channel( 'fields' ).trigger( 'remove:error', model, id );\n\t\t\t}\n\t\t},\n\n\t\tgetError: function( targetID, id ) {\n\t\t\tvar model = nfRadio.channel( 'fields' ).request( 'get:field', targetID );\n\t\t\tvar errors = model.get( 'errors' );\n\t\t\tvar targetError = errors.get( id );\n\t\t\tif ( 'undefined' != targetError ) {\n\t\t\t\treturn targetError;\n\t\t\t} else {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Controller responsible for replying to a Radio request stating that a field has been changed.\n *\n * This controller sends out a message to the field-specific channel, the field type channel,\n * and the public fields channel so that the data model can be updated.\n */\n\ndefine('controllers/changeField',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\n\t\tinitialize: function() {\n\t\t\t/*\n\t\t\t * Reply to our request for changing a field.\n\t\t\t */\n\t\t\tnfRadio.channel( 'nfAdmin' ).reply( 'change:field', this.changeField );\n\n\t\t\t/*\n\t\t\t * If we blur our field, set the model attribute of 'clean' to false.\n\t\t\t * 'clean' tracks whether or not the user has every interacted with this element.\n\t\t\t * Some validation, like required, uses this to decide whether or not to add an error.\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'blur:field', this.blurField );\n\t\t},\n\n\t\tchangeField: function( el, model ) {\n\t\t\t// Get our current value.\n\t\t\tvar value = nfRadio.channel( model.get( 'type' ) ).request( 'before:updateField', el, model );\n\t\t\tvalue = ( 'undefined' != typeof value ) ? value : nfRadio.channel( model.get( 'parentType' ) ).request( 'before:updateField', el, model );\n\t\t\tvalue = ( 'undefined' != typeof value ) ? value : jQuery( el ).val();\n\n\t\t\t// Set our 'isUpdated' flag to false.\n\t\t\tmodel.set( 'isUpdated', false );\n\n\t\t\t// Set our 'clean' flag to false.\n\t\t\tmodel.set( 'clean', false );\n\n\t\t\t/*\n\t\t\t * Send out a message saying that we've changed a field.\n\t\t\t * The first channel is field id/key specific.\n\t\t\t * The second channel is the field type, i.e. text, email, radio\n\t\t\t * The third channel is a generic 'field' channel.\n\t\t\t *\n\t\t\t * If the submitted value you wish to store in the data model isn't the same as the value received above,\n\t\t\t * you can set that model in the actions below and set the 'isUpdated' model attribute to true.\n\t\t\t * i.e. model.set( 'isUpdated', true );\n\t\t\t */\n\t\t\tnfRadio.channel( 'field-' + model.get( 'id' ) ).trigger( 'change:field', el, model );\n\t\t\tnfRadio.channel( model.get( 'type' ) ).trigger( 'change:field', el, model );\n\t\t\tnfRadio.channel( 'fields' ).trigger( 'change:field', el, model );\n\n\t\t\t/*\n\t\t\t * Send a request out on our nfAdmin channel to update our field model.\n\t\t\t * If the field model has a 'isUpdated' property of false, nothing will be updated.\n\t\t\t */\n\t\t\tnfRadio.channel( 'nfAdmin' ).request( 'update:field', model, value );\n\n\t\t\t/*\n\t\t\t * If the field is in a repeater, update the repeater Value\n\t\t\t */\n\t\t\tif(model.get(\"repeaterField\")){\n\t\t\t\tnfRadio.channel( \"field-repeater\" ).trigger( 'set:value' );\n\t\t\t}\n\t\t},\n\n\t\tblurField: function( el, model ) {\n\t\t\t// Set our 'clean' flag to false.\n\t\t\tmodel.set( 'clean', false );\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","define('controllers/changeEmail',[], function() {\n\tvar radioChannel = nfRadio.channel( 'email' );\n\t// var emailReg = /^([\\w-]+(?:\\.[\\w-]+)*)@((?:[\\w-]+\\.)*\\w[\\w-]{0,66})\\.([a-z]{2,6}(?:\\.[a-z]{2})?)$/i;\n\tvar emailReg = /^(([^<>()\\[\\]\\\\.,;:\\s@\"]+(\\.[^<>()\\[\\]\\\\.,;:\\s@\"]+)*)|(\".+\"))@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$/;\n\tvar errorID = 'invalid-email';\n\n\tvar controller = Marionette.Object.extend( {\n\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( radioChannel, 'change:modelValue', this.onChangeModelValue );\n\t\t\tthis.listenTo( radioChannel, 'keyup:field', this.emailKeyup );\n\t\t\tthis.listenTo( radioChannel, 'blur:field', this.onBlurField );\n\t\t},\n\n\t\tonChangeModelValue: function( model ) {\n\t\t\tvar value = model.get( 'value' );\n\t\t\tvar fieldID = model.get( 'id' );\n\t\t\tthis.emailChange( value, fieldID );\n\t\t},\n\n\t\tonBlurField: function( el, model ) {\n\t\t\tvar value = jQuery( el ).val();\n\t\t\tvar fieldID = model.get( 'id' );\n\t\t\tthis.emailChange( value, fieldID );\n\t\t},\n\n\t\temailChange: function( value, fieldID ) {\n\t\t\tif ( 0 < value.length ) {\n\t\t\t\tif( emailReg.test( value ) ) {\n\t\t\t\t\tnfRadio.channel( 'fields' ).request( 'remove:error', fieldID, errorID );\n\t\t\t\t} else {\n\t\t\t\t\tvar fieldModel = nfRadio.channel( 'fields' ).request( 'get:field', fieldID );\n\t\t\t\t\tvar formModel  = nfRadio.channel( 'app'    ).request( 'get:form',  fieldModel.get( 'formID' ) );\n\t\t\t\t\tnfRadio.channel( 'fields' ).request( 'add:error', fieldID, errorID, formModel.get( 'settings' ).changeEmailErrorMsg );\n\t\t\t\t}\t\t\t\t\n\t\t\t} else {\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'remove:error', fieldID, errorID );\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * When a user types inside of an email field, track their keypresses and add the appropriate class.\n\t\t * If the value validates as an email, add a class of nf-pass\n\t\t * If the value does not validate as email, add a class of nf-fail\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  {object} el    Element that triggered the keyup event.\n\t\t * @param  {object} model Model connected to the element that triggered the event\n\t\t * @return {void}\n\t\t */\n\t\temailKeyup: function( el, model, keyCode ) {\n\t\t\t\n\t\t\t/*\n\t\t\t * If we pressed the 'tab' key to get to this field, return false.\n\t\t\t */\n\t\t\tif ( 9 == keyCode ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\t/*\n\t\t\t * Get the current value from our element.\n\t\t\t */\n\t\t\tvar value = jQuery( el ).val();\n\n\t\t\t/*\n\t\t\t * Get our current ID\n\t\t\t */\n\t\t\tvar fieldID = model.get( 'id' );\n\n\t\t\t/*\n\t\t\t * Check our value to see if it is a valid email.\n\t\t\t */\n\t\t\tif ( 0 == value.length ) {\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'remove:error', fieldID, errorID );\n\t\t\t} else if ( ! emailReg.test( value ) && ! model.get( 'clean' ) ) {\n\n\t\t\t\tvar fieldModel = nfRadio.channel( 'fields' ).request( 'get:field', fieldID );\n\t\t\t\tvar formModel  = nfRadio.channel( 'app'    ).request( 'get:form',  fieldModel.get( 'formID' ) );\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'add:error', fieldID, errorID, formModel.get( 'settings' ).changeEmailErrorMsg );\n\n\t\t\t\tmodel.removeWrapperClass( 'nf-pass' );\n\t\t\t} else if ( emailReg.test( value ) ) {\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'remove:error', fieldID, errorID );\n\t\t\t\t/*\n\t\t\t\t * Add nf-pass class to the wrapper.\n\t\t\t\t */\n\t\t\t\tmodel.addWrapperClass( 'nf-pass' );\n\t\t\t\tmodel.set( 'clean', false );\n\t\t\t}\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","define('controllers/changeDate',[], function() {\n\tvar radioChannel = nfRadio.channel( 'date' );\n\tvar errorID = 'invalid-date';\n\n\tvar controller = Marionette.Object.extend( {\n\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( radioChannel, 'change:modelValue', this.onChangeModelValue );\n\t\t\tthis.listenTo( radioChannel, 'keyup:field', this.dateKeyup );\n\t\t\tthis.listenTo( radioChannel, 'blur:field', this.onBlurField );\n\t\t\t\n\t\t\tthis.listenTo( radioChannel, 'change:extra', this.changeHoursMinutes, this)\n\t\t},\n\n\t\tonChangeModelValue: function( model ) {\n\t\t\tvar original = moment.locale();\n\t\t\tmoment.locale('ninja-forms');\n\t\t\tthis.dateChange( model );\n\t\t\tmoment.locale(original);\n\t\t},\n\n\t\tonBlurField: function( el, model ) {\n\t\t\tvar original = moment.locale();\n\t\t\tmoment.locale('ninja-forms');\n\t\t\tthis.dateChange( model );\n\t\t\tmoment.locale(original);\n\t\t},\n\n\t\tdateChange: function( model ) {\n\t\t\tvar fieldID = model.get( 'id' );\n\t\t\tvar value = model.get( 'value' );\n\t\t\tvar format = model.get( 'date_format' );\n\n\t\t\t// If we are dealing with purely a time field, bail early.\n\t\t\tif ( 'time_only' == model.get( 'date_mode' ) ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tif ( 0 < value.length ) {\n\t\t\t\t// use moment's isValid to check against the fields format setting\n\t\t\t\tif( this.isDateValid(value, format, fieldID) ) {\n\t\t\t\t\tnfRadio.channel( 'fields' ).request( 'remove:error', fieldID, errorID );\n\t\t\t\t} else {\n\t\t\t\t\tvar fieldModel = nfRadio.channel( 'fields' ).request( 'get:field', fieldID );\n\t\t\t\t\tvar formModel  = nfRadio.channel( 'app'    ).request( 'get:form',  fieldModel.get( 'formID' ) );\n\t\t\t\t\tnfRadio.channel( 'fields' ).request( 'add:error', fieldID, errorID, formModel.get( 'settings' ).changeDateErrorMsg );\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'remove:error', fieldID, errorID );\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * When a user types inside of an dat field, track their keypresses\n\t\t * and add the appropriate class.\n\t\t * If the value validates as an date, add a class of nf-pass\n\t\t * If the value does not validate as date, add a class of nf-fail\n\t\t *\n\t\t * @since  3.0\n\t\t * @param  {object} el    Element that triggered the keyup event.\n\t\t * @param  {object} model Model connected to the element that triggered the event\n\t\t * @return {void}\n\t\t */\n\t\tdateKeyup: function( el, model, keyCode ) {\n\n\t\t\t/*\n\t\t\t * If we pressed the 'tab' key to get to this field, return false.\n\t\t\t */\n\t\t\tif ( 9 == keyCode ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\t/*\n\t\t\t * Get the current value from our element.\n\t\t\t */\n\t\t\tvar value = jQuery( el ).val();\n\n\t\t\t/*\n\t\t\t * Get our current ID\n\t\t\t */\n\t\t\tvar fieldID = model.get( 'id' );\n\n\t\t\t/*\n\t\t\t* Get our current date format\n\t\t\t */\n\t\t\tvar format = model.get( 'date_format' );\n\n\t\t\tvar original = moment.locale();\n\t\t\tmoment.locale('ninja-forms');\n\n\t\t\t/*\n\t\t\t * Check our value to see if it is a valid date.\n\t\t\t */\n\t\t\tif ( 0 == value.length ) {\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'remove:error', fieldID, errorID );\n\t\t\t}\n\t\t\t// use moment's isValid to check against the fields format setting\n\t\t\telse if ( ! this.isDateValid(value, format, fieldID) && ! model.get( 'clean' ) ) {\n\n\t\t\t\tvar fieldModel = nfRadio.channel( 'fields' ).request( 'get:field', fieldID );\n\t\t\t\tvar formModel  = nfRadio.channel( 'app'    ).request( 'get:form',  fieldModel.get( 'formID' ) );\n\t\t\t\tnfRadio.channel( 'fields' ).request( 'add:error', fieldID, errorID, formModel.get( 'setting