 {\n\t\t\treturn nfAllRepeaterFieldsModels;\n\t\t},\n\n\t\tgetAllFieldsetsByForm: function(formID) {\n\t\t\tconst allFormsModels = this.getAllRepeaterFieldsModels();\n\t\t\tconst thisFormModels = allFormsModels.filter( model => model.form === formID );\n\n\t\t\treturn thisFormModels;\n\t\t},\n\n\t\tgetAllFieldsModelsArrayByForm: function(formID) {\n\t\t\tconst thisFormModels = this.getAllFieldsetsByForm(formID);\n\t\t\tlet singleArray = [];\n\t\t\tthisFormModels.map( model => {\n\t\t\t\tsingleArray = singleArray.concat(model.fields);\n\t\t\t});\n\n\t\t\treturn singleArray;\n\t\t},\n\n\t\tgetRepeaterFields: function(repeaterID) {\n\t\t\tconst allModels = this.getAllRepeaterFieldsModels();\n\t\t\tlet fields = allModels.find(model => String(model.id) === String(repeaterID));\n\t\t\tif(typeof fields === \"undefined\"){\n\t\t\t\tfields = this.reverseResearchFieldsetModel(repeaterID, allModels);\n\t\t\t}\n\n\t\t\treturn fields;\n\t\t},\n\n\t\treverseResearchFieldsetModel: function(repeaterID, allModels) {\n\t\t\tlet fields;\n\t\t\t_.each(allModels, function(fieldsetModel) {\n\t\t\t\t_.each(fieldsetModel.fields, function(fieldModel){\n\t\t\t\t\tif(String(fieldModel.id).startsWith(repeaterID)){\n\t\t\t\t\t\tfields = fieldsetModel;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t});\n\n\t\t\treturn fields;\n\t\t},\n\n\t\tgetRepeaterFieldById: function( id ){\n\t\t\tconst repeaterID = String(id).split('.')[0];\n\t\t\tconst fieldObject = this.getRepeaterFields(repeaterID);\n\t\t\t//return early if no match found by ID\n\t\t\tif(typeof fieldObject === 'undefined') return;\n\n\t\t\tconst model = fieldObject.fields.find(field => field.id === id);\n\n\t\t\treturn model;\n\t\t},\n\n\t\tsetAllRepeatersValues: function() {\n\t\t\tconst repeaters = this.getAllRepeaterFieldsModels();\n\t\t\tif(repeaters.length > 0) {\n\t\t\t\t\n\t\t\t\t_.each(repeaters, function(repeater){\n\t\t\t\t\tlet fields = repeater.fields;\n\t\t\t\t\tlet repeaterFieldModel = nfRadio.channel( 'fields' ).request( 'get:field', repeater.id );\n\n\t\t\t\t\tif(fields.length > 0){\n\t\t\t\t\t\tlet repeaterFieldValue = {};\n\t\t\t\t\t\t//Loop through fields\n\t\t\t\t\t\t_.each( fields, function( field ){\n\t\t\t\t\t\t\t//Get ID and Value to format and store them in the repeaterFieldValue object\n\t\t\t\t\t\t\tlet value = field.get('value');\n\t\t\t\t\t\t\tlet id = field.get('id');\n\t\t\t\t\t\t\t//Refactor ID used in case we have multiple same form on the DOM and using a changed ID for main repeater field.\n\t\t\t\t\t\t\tif(id.split(\"_\").length > 2){\n\t\t\t\t\t\t\t\tlet idArray = id.split(\"_\");\n\t\t\t\t\t\t\t\tidArray[1] = idArray[1].split(\".\")[1];\n\t\t\t\t\t\t\t\tlet newID = idArray[0] + \".\" + idArray[1] + \"_\" + idArray[2];\n\t\t\t\t\t\t\t\tdelete repeaterFieldValue[id];\n\t\t\t\t\t\t\t\tid = newID;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t\trepeaterFieldValue[id] = {\n\t\t\t\t\t\t\t\t\"value\": value,\n\t\t\t\t\t\t\t\t\"id\": id\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t//Check if time is correctly added on Date/time fields\n\t\t\t\t\t\t\tif(field.get('type') === \"date\" && typeof value === \"string\" && ( field.get('date_mode') === \"date_and_time\" || field.get('date_mode') === \"time_only\" )){\n\t\t\t\t\t\t\t\trepeaterFieldValue[id].value = {\n\t\t\t\t\t\t\t\t\t\"date\": value,\n\t\t\t\t\t\t\t\t\t\"hour\": field.attributes.selected_hour,\n\t\t\t\t\t\t\t\t\t\"minute\": field.attributes.selected_minute,\n\t\t\t\t\t\t\t\t\t\"ampm\": field.attributes.selected_ampm\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif(field.get('type') === \"file_upload\" && field.get('value')){\n\t\t\t\t\t\t\t\trepeaterFieldValue[id].files = field.attributes.files;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t\t\n\t\t\t\t\t\trepeaterFieldModel.set( 'isUpdated', false);\n\t\t\t\t\t\t//Update repeater field value with repeaterFieldValue \n\t\t\t\t\t\tnfRadio.channel( 'nfAdmin' ).request( 'update:field', repeaterFieldModel, repeaterFieldValue);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t} );\n\n\treturn model;\n} );\n\n","define( 'models/fieldRepeaterSetCollection',['models/fieldRepeaterSetModel', 'models/fieldCollection' ], function( repeaterSetModel, fieldCollection ) {\n\tvar collection = Backbone.Col