if ( 0 == this.fieldModel.get( 'errors' ).models.length ) {\n                this.fieldModel.removeWrapperClass( 'nf-error' );\n                this.fieldModel.removeWrapperClass( 'nf-fail' );\n                this.fieldModel.addWrapperClass( 'nf-pass' );\n                this.fieldModel.setInvalid( false );\n            } else {\n                this.fieldModel.removeWrapperClass( 'nf-pass' );\n                this.fieldModel.addWrapperClass( 'nf-fail' );\n                this.fieldModel.addWrapperClass( 'nf-error' );\n                this.fieldModel.setInvalid( true );\n            }\n\n\t\t}\n\t});\n\n\treturn view;\n} );\n\n","define( 'views/inputLimit',[], function() {\n    var view = Marionette.ItemView.extend({\n        tagName: 'nf-section',\n        template: '#tmpl-nf-field-input-limit',\n\n        initialize: function() {\n        \tthis.listenTo( nfRadio.channel( 'field-' + this.model.get( 'id' ) ), 'keyup:field', this.updateCount );\n        \tthis.count = this.model.get( 'input_limit' );\n        \tthis.render();\n        },\n\n        updateCount: function( el, model ) {\n            var value = jQuery( el ).val();\n            var regex = /\\s+/gi;\n            var words = String(value).trim().replace(regex, ' ').split(' ');\n            var wordCount = words.length;\n            var charCount = value.length;\n            \n            /**\n             * PHP Config has 'char' instead of 'characters', so I changed it to\n             * 'characters', but added 'char' here so existing form fields will\n             * act correctly\n             **/\n            if ( 'characters' == this.model.get( 'input_limit_type' )\n                    || 'char' == this.model.get( 'input_limit_type' ) ) {\n                jQuery( el ).attr( 'maxlength', this.model.get( 'input_limit' ) );\n                this.count = this.model.get( 'input_limit' ) - charCount;\n            } else {\n                this.count = this.model.get( 'input_limit' ) - wordCount;\n                var limit = this.model.get( 'input_limit' );\n                if( wordCount > limit ){\n                    jQuery( el ).val( words.slice( 0, limit).join( ' ' ) );\n                }\n            }\n\n        \tthis.render();\n        },\n\n        templateHelpers: function() {\n        \tvar that = this;\n        \treturn {\n        \t\tcurrentCount: function() {\n        \t\t\treturn that.count;\n        \t\t}\n        \t}\n        }\n\n    });\n\n    return view;\n} );\n","define( 'views/afterField',['views/fieldErrorCollection', 'views/inputLimit'], function( fieldErrorCollection, InputLimitView ) {\n    var view = Marionette.ItemView.extend({\n        tagName: 'nf-section',\n        template: '#tmpl-nf-field-after',\n\n        initialize: function() {\n    \t\tthis.model.on( 'change:errors', this.changeError, this );\n        },\n\n        onRender: function() {\n        \t/*\n        \t * If we have an error, render our error view.\n        \t * TODO: Perhaps move to a controller?\n        \t */\n        \tvar errorEl = jQuery( this.el ).children( '.nf-error-wrap' );\n    \t\tthis.errorCollectionView = new fieldErrorCollection( { el: errorEl, collection: this.model.get( 'errors' ), fieldModel: this.model } );\n            if ( 0 < this.model.get( 'errors' ).length ) {\n               this.errorCollectionView.render(); \n            }\n            \n    \t\t/*\n    \t\t * If we have an input limit set, render the view that contains our counter\n    \t\t * TODO: Move this to a controller so that the logic isn't in the view.\n    \t\t */\n    \t\tif ( 'undefined' != typeof this.model.get( 'input_limit' ) && '' != String(this.model.get( 'input_limit' )).trim() ){\n    \t\t\tvar inputLimitEl = jQuery( this.el ).children( '.nf-input-limit');\n    \t\t\tthis.inputLimitView = new InputLimitView( { el: inputLimitEl, model: this.model } );\n\t\t\t\tinputLimitEl.attr('aria-live', 'polite');\n\t\t\t\tinputLimitEl.attr('role', 'status');\n\t\t\t\tinputLimitEl.attr('aria-relevant', 'additions');\n\t\t\t\tinputLimitEl.attr( 'aria-atomic', true );\n    \t\t}\n        },\n\n        changeError: function() {\n\t\t\tthis.errorCollectionView.render();\n\t\t},\n\n    });\n\n    return view;\n} );\n","define( 'views/fieldRepeaterFieldLayout',['views/fieldItem', 'views/beforeField', 'views/afterField'], function( fieldItem, beforeField, afterField ) {\n\n    var view = Marionette.LayoutView.extend({\n        tagName: 'nf-field',\n\n        regions: {\n            beforeField: '.nf-before-field',\n            field: '.nf-field',\n            afterField: '.nf-after-field',\n        },\n\n        initialize: function() {\n            this.listenTo( this.model, 'change:visible', this.render, this );\n        },\n\n        getTemplate: function() {\n            if ( this.model.get( 'visible' ) ) {\n                return '#tmpl-nf-field-layout';\n            } else {\n                return '#tmpl-nf-empty';\n            }\n        },\n\n        onRender: function() {\n            if ( this.model.get( 'visible' ) ) {\n                this.beforeField.show( new beforeField( { model: this.model } ) );\n                this.field.show( new fieldItem( { model: this.model } ) ); \n                this.afterField.show( new afterField( { model: this.model } ) );\n            }\n        },\n\n        templateHelpers: function() {\n            return {\n                renderContainerClass: function() {\n                    var containerClass = ' label-' + this.label_pos + ' ';\n                    // If we have a description position, add that to our container.\n                    if ( 'undefined' != typeof this.desc_pos ) {\n                        containerClass += 'desc-' + this.desc_pos + ' ';\n                    }\n                    // if we have a container_class field setting, add that to our container.\n                    if ( 'undefined' != typeof this.container_class && 0 < String(this.container_class).trim().length ) {\n                        containerClass += this.container_class + ' ';\n                    }\n\n                    //check if the parent type and type are different. If\n                    // so, add parent type container styling\n                    \n                    if( this.type !== this.parentType ) {\n                        containerClass += ' ' + this.parentType + '-container';\n                    }\n                    return containerClass;\n                }\n            }\n        }\n    });\n\n    return view;\n} );\n\n","define( 'views/fieldRepeaterFieldCollection',['views/fieldRepeaterFieldLayout'], function( fieldLayout ) {\n\tvar view = Marionette.CollectionView.extend({\n\t\ttagName: 'nf-fields-wrap',\n\t\tchildView: fieldLayout,\n\t});\n\n\treturn view;\n} );\n","define( 'views/fieldRepeaterSetLayout',[ 'views/fieldRepeaterFieldCollection' ], function( fieldCollection ) {\n    var view = Marionette.LayoutView.extend({\n        tagName: 'fieldset',\n        template: '#tmpl-nf-field-repeater-set',\n\n        regions: {\n            fields: '.nf-repeater-fieldset',\n        },\n\n        onRender: function() {\n            this.fields.show( new fieldCollection( { collection: this.model.get( 'fields' ) } ) );\n        },\n\n\t\ttemplateHelpers: function() {\n\t\t\treturn {\n\t\t\t\tmaybeFilterHTML: function()  {\n\t\t\t\t\treturn typeof nfFrontEnd.filter_esc_status !== \"undefined\" ? nfFrontEnd.filter_esc_status : \"false\";\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n        events: {\n            'click .nf-remove-fieldset': 'removeSet',\n        },\n\n        removeSet: function() {\n            nfRadio.channel( \"field-repeater\" ).trigger( 'remove:fieldset',  this.model )\n        }\n\n    });\n\n    return view;\n} );\n","define( 'views/fieldRepeaterSetCollection',['views/fieldRepeaterSetLayout'], function( repeaterSetLayout ) {\n\tvar view = Marionette.CollectionView.extend({\n\t\ttagName: 'div',\n\t\tchildView: repeaterSetLayout,\n\t});\n\n\treturn view;\n} );\n","define( 'views/fieldRepeaterLayout',[ 'views/fieldRepeaterSetCollection' ], function( repeaterSetCollection ) {\n\n    var view = Marionette.LayoutView.extend({\n        tagName: 'div',\n        template: '#tmpl-nf-field-repeater',\n\n        regions: {\n            sets: '.nf-repeater-fieldsets',\n        },\n\n        initialize: function(