elClasses ) {\n\t\t\t\t\t\tclasses = this.customLabelClasses( classes );\n\t\t\t\t\t}\n\t\t\t\t\treturn classes;\n\t\t\t\t},\n\n\t\t\t\trenderPlaceholder: function() {\n\t\t\t\t\tvar placeholder = this.placeholder;\n\n\t\t\t\t\tif ( 'undefined' != typeof this.customPlaceholder ) {\n\t\t\t\t\t\tplaceholder = this.customPlaceholder( placeholder );\n\t\t\t\t\t}\n\t\t\t\t\t\n\t\t\t\t\tif( '' != String(placeholder).trim() ) {\n\t\t\t\t\t\treturn 'placeholder=\"' + _.escape( placeholder ) + '\"';\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn '';\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\trenderWrapClass: function() {\n\t\t\t\t\tvar wrapClass = 'field-wrap ' + this.type + '-wrap';\n\n\t\t\t\t\t// Check if type and parentType are different. If, so\n\t\t\t\t\t// then add appropriate parentType wrap class\n\t\t\t\t\tif ( this.type !== this.parentType ) {\n\t\t\t\t\t\twrapClass = wrapClass + ' ' + this.parentType + '-wrap';\n\t\t\t\t\t}\n\t\t\t\t\t// If we have an old_classname defined, output wrap class for backward compatibility\n\t\t\t\t\tif ( 'undefined' != typeof this.old_classname && 0 < String(this.old_classname).trim().length ) {\n\t\t\t\t\t\twrapClass += ' ' + this.old_classname + '-wrap';\n\t\t\t\t\t}\n\n\t\t\t\t\tif ( 'undefined' != typeof customWrapClass ) {\n\t\t\t\t\t\twrapClass = customWrapClass( wrapClass );\n\t\t\t\t\t}\n\n\t\t\t\t\treturn wrapClass;\n\t\t\t\t},\n\n\t\t\t\trenderClasses: function() {\n\t\t\t\t\tvar classes = this.classes;\n\n\t\t\t\t\tif ( this.error ) {\n\t\t\t\t\t\tclasses += ' nf-error';\n\t\t\t\t\t} else {\n\t\t\t\t\t\tclasses = classes.replace( 'nf-error', '' );\n\t\t\t\t\t}\n\n\t\t\t\t\tif ( 'undefined' != typeof this.element_class && 0 < String(this.element_class).trim().length ) {\n\t\t\t\t\t\tclasses += ' ' + this.element_class;\n\t\t\t\t\t}\n\n\t\t\t\t\t/*\n\t\t\t\t\t * If we have a function for adding extra classes, add those.\n\t\t\t\t\t */\n\n\t\t\t\t\tif ( 'undefined' != typeof this.customClasses ) {\n\t\t\t\t\t\tclasses = this.customClasses( classes );\n\t\t\t\t\t}\n\t\t\t\t\t\n\t\t\t\t\treturn classes;\n\t\t\t\t},\n\n\t\t\t\tmaybeFilterHTML: function() {\n\t\t\t\t\treturn typeof nfFrontEnd.filter_esc_status !== \"undefined\" ? nfFrontEnd.filter_esc_status : \"false\";\n\t\t\t\t},\n\n\t\t\t\tmaybeDisabled: function() {\n\t\t\t\t\tif ( 1 == this.disable_input ) {\n\t\t\t\t\t\treturn 'disabled';\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn '';\n\t\t\t\t\t}\n\t\t\t\t},\n                \n                maybeRequired: function() {\n                    if ( 1 == this.required ) {\n                        return 'aria-required=\"true\" required';\n                    } else {\n                        return '';\n                    }\n                },\n\n\t\t\t\tmaybeDisableAutocomplete: function() {\n\t\t\t\t\tif ( 1 == this.disable_browser_autocomplete ) {\n\t\t\t\t\t\treturn 'autocomplete=\"off\"';\n\t\t\t\t\t} else if ( this.custom_autocomplete && this.custom_autocomplete.trim() !== '' ) {\n\t\t\t\t\t\treturn 'autocomplete=\"' + this.custom_autocomplete.trim() + '\"';\n\t\t\t\t\t} else {\n\t\t\t\t\t\tconst autoType = this.translateAutoCompletionType( this.type );\n\t\t\t\t\t\treturn 'autocomplete=\"' + autoType + '\"';\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\ttranslateAutoCompletionType: function( type ){\n\t\t\t\t\t//https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/autocomplete\n\t\t\t\t\tswitch( type ){\n\t\t\t\t\t\tcase 'address':\n\t\t\t\t\t\t\treturn 'street-address';\n\t\t\t\t\t\tcase 'address2':\n\t\t\t\t\t\t\treturn 'address-line2';\n\t\t\t\t\t\tcase 'city':\n\t\t\t\t\t\t\treturn 'address-level2';\n\t\t\t\t\t\tcase 'email':\n\t\t\t\t\t\t\treturn 'email';\n\t\t\t\t\t\tcase 'firstname':\n\t\t\t\t\t\t\treturn 'given-name';\n\t\t\t\t\t\tcase 'lastname':\n\t\t\t\t\t\t\treturn 'family-name';\n\t\t\t\t\t\tcase 'zip':\n\t\t\t\t\t\t\treturn 'postal-code';\n\t\t\t\t\t\tcase 'phone':\n\t\t\t\t\t\t\treturn 'tel';\n\t\t\t\t\t\tdefault:\n\t\t\t\t\t\t\treturn 'on';\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tmaybeInputLimit: function() {\n\t\t\t\t\tif ( 'characters' == this.input_limit_type && '' != String(this.input_limit).trim() ) {\n\t\t\t\t\t\treturn 'maxlength=\"' + this.input_limit + '\"';\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn '';\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tgetHelpText: function() {\n\t\t\t\t\t// this.help_text = jQuery( this.help_text ).html();\n\t\t\t\t\t// return ( 'undefined' != typeof this.help_text ) ? this.help_text.replace(/\"/g, \"&quot;\") : '';\n\t\t\t\t\treturn ( 'undefined' != typeof this.help_text ) ? this.help_text : '';\n\t\t\t\t},\n\n\t\t\t\tmaybeRenderHelp: function() {\n\n\t\t\t\t\t// use jQuery().text() to make sure help_text has actual\n\t\t\t\t\t// text and not just HTML tags.\n\t\t\t\t\tvar check_text_par = document.createElement( 'p' );\n                    check_text_par.innerHTML = this.help_text;\n\n                    var shouldRenderHelpText = false;\n                    // Check for text or image tags\n\t\t\t\t\tif ( 0 != String(jQuery( check_text_par ).text()).trim().length\n\t\t\t\t\t\t|| 0 < jQuery( check_text_par ).find('img').length ) {\n                    \tshouldRenderHelpText = true;\n                    }\n\n\t\t\t\t\tif ( 'undefined' != typeof this.help_text && shouldRenderHelpText ) {\n\n\t\t\t\t\t\t// Strip HTML tags for accessibility\n\t\t\t\t\t\tfunction stripTags( input ) {\n\t\t\t\t\t\t\treturn input.replace(/<\\/?[^>]+(>|$)/g, \"\").trim();\n\t\t\t\t\t\t}\n \n\t\t\t\t\t\tvar icon = document.createElement( 'span' );\n\t\t\t\t\t\ticon.classList.add( 'fa', 'fa-info-circle', 'nf-help' );\n\t\t\t\t\t\ticon.setAttribute( 'data-text', this.getHelpText() );\n\t\t\t\t\t\ticon.setAttribute( 'tabindex', '0' ); // Make it focusable\n\t\t\t\t\t\ticon.setAttribute( 'aria-describedby',  'hidden-help-text-' + this.id ); // Link to the hidden description\n\t\t\t\t\t   \n\t\t\t\t\t\t// Create a hidden element for screen readers\n\t\t\t\t\t\tvar hiddenHelpText = document.createElement( 'span' );\n\t\t\t\t\t\thiddenHelpText.textContent = stripTags( this.help_text ); // Output the help text without tags\n\t\t\t\t\t\thiddenHelpText.id = 'hidden-help-text-' + this.id;\n\t\t\t\t\t\thiddenHelpText.classList.add( 'nf-sr-only' ); // Visually hidden but available for screen readers\n\t\t\t\t\t\thiddenHelpText.setAttribute( 'role', 'tooltip' );\n\t\t\t\t\t   \n\t\t\t\t\t\ticon.appendChild( hiddenHelpText ); // Append the hidden help text\n \n\t\t\t\t\t\treturn icon.outerHTML;\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn '';\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\trenderDescText: function() {\n\t\t\t\t\tif ( 'undefined' == typeof this.desc_text ) {\n\t\t\t\t\t\treturn '';\n\t\t\t\t\t}\n\n\t\t\t\t\t// Creates an element so we can check to see if the text is empty.\n\t\t\t\t\tvar text = document.createElement( 'p' );\n\t\t\t\t\ttext.innerHTML = this.desc_text;\n\t\t\t\t\tif( 0 == String(text.innerText).trim().length ) return '';\n\n                    var check, checkText;\n\t\t\t\t\tcheckText = document.createTextNode( this.desc_text );\n\t\t\t\t\tcheck = document.createElement( 'p' );\n\t\t\t\t\tcheck.appendChild( checkText );\n\t\t\t\t\tif ( 0 != String(jQuery( check ).text()).trim().length ) {\n\t\t\t\t\t\tvar descriptionText, fieldDescription;\n                        descriptionText  = document.createRange().createContextualFragment( this.desc_text );\n                        fieldDescription  = document.createElement( 'div' );\n\t\t\t\t\t\tfieldDescription.classList.add( 'nf-field-description' );\n\t\t\t\t\t\tfieldDescription.setAttribute('aria-hidden', 'true');\n\t\t\t\t\t\tfieldDescription.setAttribute('id', 'nf-description-' + this.id);\n\t\t\t\t\t\tfieldDescription.appendChild( descriptionText );\n\t\t\t\t\t\treturn fieldDescription.outerHTML;\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn '';\n\t\t\t\t\t}\n\t\t\t\t},\n                \n                renderNumberDefault: function() {\n                    // If the field is clean...\n                    if ( this.clean ) {\n                        // If we have a default...\n                        if ( 0 === this.default || this.default ) {\n                            return this.default;\n                        } // If we do not have a placeholder...\n                        else if ( ! this.placeholder ) {\n                            return this.value;\n                        } // Otherwise...\n                        else {\n                            return '';\n                        }\n                    } // Otherwise... (The field is not clean.)\n                    else {\n                        return this.value;\n                    }\n                },\n\n\t\t\t\t