o( nfRadio.channel('field-repeater'), 'rerender:fieldsets', this.render );\n\n        },\n\n        onRender: function() { \n            this.sets.show( new repeaterSetCollection( { collection: this.collection } ) );\n        },\n\n\t\ttemplateHelpers: function() {\n\t\t\treturn {\n\t\t\t\tmaybeFilterHTML: function()  {\n\t\t\t\t\treturn typeof nfFrontEnd.filter_esc_status !== \"undefined\" ? nfFrontEnd.filter_esc_status : \"false\";\n\t\t\t\t},\n                renderDescText: function() {\n\t\t\t\t\tif ( 'undefined' == typeof this.desc_text ) {\n\t\t\t\t\t\treturn '';\n\t\t\t\t\t}\n\n\t\t\t\t\t// Creates an element so we can check to see if the text is empty.\n\t\t\t\t\tvar text = document.createElement( 'p' );\n\t\t\t\t\ttext.innerHTML = this.desc_text;\n\t\t\t\t\tif( 0 == String(text.innerText).trim().length ) return '';\n\n                    var check, checkText;\n\t\t\t\t\tcheckText = document.createTextNode( this.desc_text );\n\t\t\t\t\tcheck = document.createElement( 'p' );\n\t\t\t\t\tcheck.appendChild( checkText );\n\t\t\t\t\tif ( 0 != String(jQuery( check ).text()).trim().length ) {\n\t\t\t\t\t\tvar descriptionText, fieldDescription;\n                        descriptionText  = document.createRange().createContextualFragment( this.desc_text );\n                        fieldDescription  = document.createElement( 'div' );\n\t\t\t\t\t\tfieldDescription.classList.add( 'nf-field-description' );\n\t\t\t\t\t\tfieldDescription.appendChild( descriptionText );\n\t\t\t\t\t\treturn fieldDescription.outerHTML;\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn '';\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t}\n\t\t},\n\n        events: {\n            'click .nf-add-fieldset': 'addSet'\n        },\n\n        addSet: function() {\n            nfRadio.channel( 'field-repeater' ).trigger( 'add:fieldset', this.model.id );   \n        },\n\n        beforeSubmit: function() {\n\t\t\tthis.collection.beforeSubmit( this.model.get( 'sets' ) );\n\t\t}\n        \n\n    });\n\n    return view;\n} );\n","define( 'views/fieldLayout',['views/fieldItem', 'views/beforeField', 'views/afterField', 'views/fieldRepeaterLayout'], function( fieldItem, beforeField, afterField, repeaterFieldLayout ) {\n\n    var view = Marionette.LayoutView.extend({\n        tagName: 'nf-field',\n\n        regions: {\n            beforeField: '.nf-before-field',\n            field: '.nf-field',\n            afterField: '.nf-after-field',\n        },\n\n        initialize: function() {\n            this.listenTo( this.model, 'change:visible', this.render, this );\n        },\n\n        getTemplate: function() {\n            if ( this.model.get( 'visible' ) ) {\n                return '#tmpl-nf-field-layout';\n            } else {\n                return '#tmpl-nf-empty';\n            }\n        },\n\n        onRender: function() {\n            if ( this.model.get( 'visible' ) ) {\n                \n                if ( 'repeater' == this.model.get( 'type' ) ) {\n                    this.field.show( new repeaterFieldLayout( { model: this.model } ) );\n                } else {\n                    this.beforeField.show( new beforeField( { model: this.model } ) );\n                    this.field.show( new fieldItem( { model: this.model } ) ); \n                    this.afterField.show( new afterField( { model: this.model } ) );\n                }\n                \n            }\n        },\n\n        templateHelpers: function() {\n            return {\n                renderContainerClass: function() {\n                    var containerClass = ' label-' + this.label_pos + ' ';\n                    // If we have a description position, add that to our container.\n                    if ( 'undefined' != typeof this.desc_pos ) {\n                        containerClass += 'desc-' + this.desc_pos + ' ';\n                    }\n                    // if we have a container_class field setting, add that to our container.\n                    if ( 'undefined' != typeof this.container_class && 0 < String(this.container_class).trim().length ) {\n                        containerClass += this.container_class + ' ';\n                    }\n\n                    //check if the parent type and type are different. If\n                    // so, add parent type container styling\n                    \n                    if( this.type !== this.parentType ) {\n                        containerClass += ' ' + this.parentType + '-container';\n                    }\n\n                    return containerClass;\n                }\n            }\n        }\n\n    });\n\n    return view;\n} );\n\n","/**\n * Return views that might be used in extensions.\n * These are un-instantiated views.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/loadViews',['views/fieldItem', 'views/fieldLayout'], function( fieldItemView, fieldLayoutView ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Reply to requests for our field item view.\n\t\t\tnfRadio.channel( 'views' ).reply( 'get:fieldItem', this.getFieldItem );\n\n\t\t\tnfRadio.channel( 'views' ).reply( 'get:fieldLayout', this.getFieldLayout );\n\t\t},\n\n\t\tgetFieldItem: function( model ) {\n\t\t\treturn fieldItemView;\n\t\t},\n\n\t\tgetFieldLayout: function() {\n\t\t\treturn fieldLayoutView;\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * If a form has at least one field error, we should disable the submit button and add a form error.\n * If a form had errors, but all the field errors have been removed, we should remove the form error.\n *\n * @since 3.0\n */\ndefine('controllers/formErrors',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t/*\n\t\t\t * Listen for error messages being added to and removed from fields.\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'add:error', this.addError );\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'remove:error', this.removeError );\n\n\t\t\t/*\n\t\t\t * Respond to requests to get form errors\n\t\t\t */\n\t\t\tnfRadio.channel( 'form' ).reply( 'get:errors', this.getFormErrors );\n\t\t},\n\n\t\taddError: function( fieldModel, errorID, errorMsg ) {\n\t\t\tvar formModel = nfRadio.channel( 'app' ).request( 'get:form', fieldModel.get( 'formID' ) );\n\t\t\t/*\n\t\t\t * We store our errors in this object by field ID so that we don't have to loop over all our fields when we're testing for errors.\n\t\t\t * They are stored as an object within an array, using the field ID as the key.\n\t\t\t *\n\t\t\t * If we haven't setup an array item for this field, set it as an object.\n\t\t\t */\n\t\t\tif ( 'undefined' == typeof formModel.get( 'fieldErrors' )[ fieldModel.get( 'id' ) ] ) {\n\t\t\t\tformModel.get( 'fieldErrors' )[ fieldModel.get( 'id' ) ] = {};\n\t\t\t}\n\t\t\t// Add an error to our tracking array\n\t\t\tformModel.get( 'fieldErrors' )[ fieldModel.get( 'id' ) ][ errorID ] = errorMsg;\n\t\t\t/*\n\t\t\t * We have at least one field error, so submmission should be prevented.\n\t\t\t * Add a form error.\n\t\t\t */\n\t\t\tnfRadio.channel( 'form-' + fieldModel.get( 'formID' ) ).request( 'add:error', 'field-errors', formModel.get( 'settings' ).formErrorsCorrectErrors );\n\t\t},\n\n\t\tremoveError: function( fieldModel, errorID ) {\n\t\t\tvar formModel = nfRadio.channel( 'app' ).request( 'get:form', fieldModel.get( 'formID' ) );\n\t\t\t// Remove this error ID from our tracking array.\n\t\t\tformModel.get( 'fieldErrors' )[ fieldModel.get( 'id' ) ] = _.omit( formModel.get( 'fieldErrors' )[ fieldModel.get( 'id' ) ], errorID );\n\t\t\t/*\n\t\t\t * If we don't have any more error IDs on this field, then we need to remove this field from the array.\n\t\t\t *\n\t\t\t * Then, if the fieldErrors tracking array has a length of 0, we remove our form error, because all field errors have been dealt with.\n\t\t\t */\n\t\t\tif ( 0 == _.size( formModel.get( 'fieldErrors' )[ fieldModel.get( 'id' ) ] ) ) {\n\t\t\t\tdelete formModel.get( 'fieldErrors' )[ fieldModel.get( 'id' ) ];\n\t\t\t}\n\n\t\t\tif ( 0 == _.size( formModel.get( 'fieldErrors' ) ) ) {\n\t\t\t\t// Remove our form error.\n\t\t\t\tnfRadio.channel( 'form-' + fieldModel.get( 'formID' ) ).request( 'remove:error', 'field-errors' );\n\t\t\t}\n\t\t},\n\n\t\tgetFormErrors: function( formID ) {\n\t\t\tvar formModel = nfRadio.channel( 'app' ).request( 'get:form', formID );\n\t\t\tvar errors = false;\n\t\t\t\n\t\t\tif ( formModel ) {\n\t\t\t\t/*\n\t\t\t\t * Check to see if we have any errors on our form model.\n\t\t\t\t */\n\t\t\t\tif ( 0 !== formModel.get( 'errors' ).length ) {\n\t\t\t\t\t_.each( formModel.get( 'errors' ).models, function( error ) {\n\t\t\t\t\t\terrors = errors || {};\n\t\t\t\t\t\terrors[ error.get( 'id' ) ] = error.get( 'msg' );\n\t\t\t\t\t} );\t\t\t\t\t\t\n\t\t\t\t}\n\n\t\t\t\t\n\t\t\t}\n\t\t\treturn errors;\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles submission of our form.\n */\ndefine('controllers/submit',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'forms' ), 'init:model', this.registerSubmitHandler );\n\t\t},\n\n\t\t/**\n\t\t * Register the submission handler function.\n\t\t *\n\t\t * @since  3.0\n\t\t * @param  Backbone.model \tformModel\n\t\t * @return void\n\t\t */\n\t\tregisterSubmitHandler: function( formModel ) {\n\t\t\tnfRadio.channel( 'form-' + formModel.get( 'id' ) ).reply( 'submit', this.submit );\n\t\t},\n\n\t\t/**\n\t\t * Handles the actual submission of our form.\n\t\t * When we submit:\n\t\t *\n\t\t * 1) Send out a message saying that we're about to begin form submission.\n\t\t * 2) Check the form for errors\n\t\t * 3) Submit the data\n\t\t * 4) Send out a message with our response\n\t\t *\n\t\t * @since  3.0\n\t\t * @param  Backbone.model \tformModel\n\t\t * @return void\n\t\t */\n\t\tsubmit: function( formModel ) {\n\n\t\t\t/*\n\t\t\t * Send out a radio message saying that we're about to begin submitting.\n\t\t\t * First we send on the generic forms channel, and then on the form-specific channel.\n\t\t\t */\n\t\t\tnfRadio.channel( 'forms' ).trigger( 'before:submit', formModel );\n\t\t\tnfRadio.channel( 'form-' + formModel.get( 'id' ) ).trigger( 'before:submit', formModel );\n\n\t\t\t/*\n\t\t\t * Validate our field models.\n\t\t\t */\n\t\t\tvar validate = nfRadio.channel( 'forms' ).request( 'maybe:validate', formModel );\n\t\t \tif( false !== validate ){\n\n                // When validating all fields, set clean to false to force validation.\n                _.each( formModel.get( 'fields' ).models, function( fieldModel ) {\n                    fieldModel.set( 'clean', false );\n                } );\n\n\t\t\t\t/*\n\t\t\t\t * This method is defined in our models/fieldCollection.js file,\n\t\t\t\t * except where overridden by an add-on (ie Layout & Styles).\n\t\t\t\t */\n\t\t\t\tformModel.get( 'formContentData' ).validateFields();\n\t\t\t}\n\n\t\t\tvar submit = nfRadio.channel( 'form-' + formModel.get( 'id' ) ).request( 'maybe:submit', formModel );\n\t\t\tif ( false == submit ) {\n\t\t\t\tnfRadio.channel( 'forms' ).trigger( 'submit:cancel', formModel );\n\t\t\t\tnfRadio.channel( 'form-' + formModel.get( 'id' ) ).trigger( 'submit:cancel', formModel );\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif( false !== validate ){\n\n\t\t\t\t// Ignore non-blocking errors.\n\t\t\t\tvar blockingFormErrors = _.filter( formModel.get( 'errors' ).models, function( error ){\n\n\t\t\t\t\t// Ignore email action related errors.\n\t\t\t\t\tif( 'invalid_email' == error.get( 'id' ) || 'email_not_sent' == error.get( 'id' ) ) return false;\n\n\t\t\t\t\treturn true; // Error is blocking.\n\t\t\t\t});\n\n\t\t\t\t/*\n\t\t\t\t * Make sure we don't have any form errors before we submit.\n\t\t\t\t * Return false if we do.\n\t\t\t\t */\n\t\t\t\tif ( 0 != _.size( blockingFormErrors ) ) {\n\t\t\t\t\tnfRadio.channel( 'forms' ).trigger( 'submit:failed', formModel );\n\t\t\t\t\tnfRadio.channel( 'form-' + formModel.get( 'id' ) ).trigger( 'submit:failed', formModel );\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t/*\n\t\t\t * Send out a radio message saying that we're about to begin submitting.\n\t\t\t * First we send on the generic forms channel, and then on the form-specific channel.\n\t\t\t */\n\t\t\tnfRadio.channel( 'forms' ).trigger( 'after:submitValidation', formModel );\n\t\t\tnfRadio.channel( 'form-' + formModel.get( 'id' ) ).trigger( 'after:submitValidation', formModel );\n\n\t\t\t/*\n\t\t\t * Actually submit our form, and send out a message with our response.\n\t\t\t */\n\n \t\t\tvar formID = formModel.get( 'id' );\n\t\t\tvar fields = {};\n\t\t\t_.each( formModel.get( 'fields' ).models, function( field ) {\n\t\t\t\tvar fieldDataDefaults = { value:field.get( 'value' ), id:field.get( 'id' ) };\n\n\t\t\t\t// Add field data at the field ID for efficient access.\n\t\t\t\tfields[ field.get( 'id' ) ] = nfRadio.channel( field.get( 'type' ) ).request( 'get:submitData', fieldDataDefaults, field ) || fieldDataDefaults;;\n\t\t\t} );\n\t\t\tvar extra = formModel.get( 'extra' );\n\t\t\tvar settings = formModel.get( 'settings' );\n\t\t\tdelete settings.formContentData;\n\t\t\tvar formData = JSON.stringify( { id: formID, fields: fields, settings: settings, extra: extra } );\n\t\t\tvar data = {\n\t\t\t\t'action': 'nf_ajax_submit',\n\t\t\t\t'security': nfFrontEnd.ajaxNonce,\n\t\t\t\t'nonce_ts': nfFrontEnd.nonce_ts,\n\t\t\t\t'formData': formData\n\t\t\t}\n\n\t\t\tvar that = this;\n\n\t\t\tjQuery.ajax({\n\t\t\t    url: nfFrontEnd.adminAjax,\n\t\t\t    type: 'POST',\n\t\t\t    data: data,\n\t\t\t    cache: false,\n\t\t\t   \tsuccess: function( data, textStatus, jqXHR ) {\n\t\t\t   \t\ttry {\n\t\t\t\t   \t\tvar response = data;\n\t\t\t\t        nfRadio.channel( 'forms' ).trigger( 'submit:response', response, textStatus, jqXHR, formModel.get( 'id' ) );\n\t\t\t\t    \tnfRadio.channel( 'form-' + formModel.get( 'id' ) ).trigger( 'submit:response', response, textStatus, jqXHR );\n\t\t\t\t    \tjQuery( document ).trigger( 'nfFormSubmitResponse', { response: response, id: formModel.get( 'id' ) } );\n\t\t\t   \t\t} catch( e ) {\n\t\t\t   \t\t\tconsole.log( e );\n\t\t\t   \t\t\tconsole.log( 'Parse Error' );\n\t\t\t\t\t\tconsole.log( e );\n\t\t\t   \t\t}\n\n\t\t\t    },\n\t\t\t    error: function( jqXHR, textStatus, errorThrown ) {\n\t\t\t        // Handle errors here\n\t\t\t        console.log('ERRORS: ' + errorThrown);\n\t\t\t\t\tconsole.log( jqXHR );\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\tvar response = jQuery.parseJSON( jqXHR.responseText );\n\t\t\t\t\t\tnfRadio.channel( 'forms' ).trigger( 'submit:response', response, textStatus, jqXHR, formModel.get( 'id' ) );\n\t\t\t\t\t\tnfRadio.channel( 'form-' + formModel.get( 'id' ) ).trigger( 'submit:response', response, textStatus, jqXHR );\n\t\t\t\t\t} catch( e ) {\n\t\t\t\t\t\tconsole.log( 'Parse Error: ' + jqXHR.responseText);\n\t\t\t\t\t\tnfRadio.channel( 'form-' + formModel.get( 'id' ) ).request( 'add:error', 'parse-response-ERROR', errorThrown );\n\t\t\t\t\t}\n\n\t\t\t    }\n\t\t\t});\n\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n\n","define( 'views/fieldCollection',['views/fieldLayout'], function( fieldLayout ) {\n\tvar view = Marionette.CollectionView.extend({\n\t\ttagName: 'nf-fields-wrap',\n\t\tchildView: fieldLayout\n\n\t});\n\n\treturn view;\n} );\n","/**\n * Default filters\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/defaultFilters',[ 'views/fieldCollection', 'models/fieldCollection' ], function( FieldCollectionView, FieldCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'form' ), 'before:filterData', this.registerDefaultDataFilter );\n\t\t},\n\n\t\tregisterDefaultDataFilter: function( formModel ) {\n\t\t\t/*\n\t\t\t * Set our default formContent load filter\n\t\t\t */\n\t\t\tnfRadio.channel( 'formContent' ).request( 'add:loadFilter', this.defaultFormContentLoad, 10, this );\n\t\t\t/*\n\t\t\t * Set our default formContentView.\n\t\t\t */\n\t\t\tnfRadio.channel( 'formContent' ).request( 'add:viewFilter', this.defaultFormContentView, 10, this );\n\t\t},\n\n\t\tdefaultFormContentLoad: function( formContentData, formModel, context ) {\n\t\t\tvar fieldCollection = formModel.get( 'fields' );\n\t\t\t/*\n\t\t\t * If we only have one load filter, we can just return the field collection.\n\t\t\t */\n\t\t\tvar formContentLoadFilters = nfRadio.channel( 'formContent' ).request( 'get:loadFilters' );\n\t\t\tvar sortedArray = _.without( formContentLoadFilters, undefined );\n\t\t\tif ( 1 == sortedArray.length || 'undefined' == typeof formContentData || true === formContentData instanceof Backbone.Collection ) return formModel.get( 'fields' );\n\n        \tvar fieldModels = _.map( formContentData, function( key ) {\n        \t\treturn formModel.get( 'fields' ).findWhere( { key: key } );\n        \t}, this );\n\n        \tvar currentFieldCollection = new FieldCollection( fieldModels );\n\n        \tfieldCollection.on( 'reset', function( collection ) {\n        \t\tvar resetFields = [];\n        \t\tcurrentFieldCollection.each( function( fieldModel ) {\n        \t\t\tif ( 'submit' != fieldModel.get( 'type' ) ) {\n        \t\t\t\tresetFields.push( collection.findWhere( { key: fieldModel.get( 'key' ) } ) );\n        \t\t\t} else {\n        \t\t\t\tresetFields.push( fieldModel );\n        \t\t\t}\n        \t\t} );\n\n                currentFieldCollection.options = { formModel: formModel };\n        \t\tcurrentFieldCollection.reset( resetFields );\n        \t} );\n\n        \treturn currentFieldCollection;\n        },\n\n        defaultFormContentView: function() {\n        \treturn FieldCollectionView;\n        }\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Controller responsible for removing unique field errors.\n */\n\ndefine('controllers/uniqueFieldError',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\n\t\tinitialize: function() {\n\t\t\t/*\n\t\t\t * Listen to keyup and field changes.\n\t\t\t *\n\t\t\t * If those fields have a unique field error, remove that error.\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'change:modelValue', this.removeError );\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'keyup:field', this.removeError );\n\t\t\tthis.listenTo( nfRadio.channel( 'fields' ), 'blur:field', this.removeError );\n\n\t\t},\n\n\t\tremoveError: function( el, model ) {\n\t\t\tmodel = model || el;\n\t\t\t/*\n\t\t\t * Remove any unique field errors.\n\t\t\t */\n\t\t\tnfRadio.channel( 'fields' ).request( 'remove:error', model.get( 'id' ), 'unique_field' );\n\t\t},\n\n\t});\n\n\treturn controller;\n} );\n","let nfAllRepeaterFieldsModels = [];\ndefine( 'models/fieldRepeaterSetModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\n\t\tinitialize: function(collection, options) {\n\n\t\t\tthis.repeaterFieldModel = options.repeaterFieldModel;\n\n\t\t\tthis.set( 'label', this.repeaterFieldModel.get('label') );\n\n\t\t\tif(collection && options){\n\t\t\t\tthis.initAllRepeaterFieldsModels(collection, options);\n\t\t\t}\n\n\t\t\tnfRadio.channel( \"field-repeater\" ).reply( 'get:repeaterFields', this.getRepeaterFields, this );\n\t\t\tnfRadio.channel( \"field-repeater\" ).reply( 'get:repeaterFieldById', this.getRepeaterFieldById, this );\n\t\t\tnfRadio.channel( \"field-repeater\" ).reply( 'get:repeaterModels', this.getAllRepeaterFieldsModels, this );\n\t\t\tnfRadio.channel( \"field-repeater\" ).reply( 'get:repeaterFieldsetsByForm', this.getAllFieldsetsByForm, this );\n\t\t\tnfRadio.channel( \"field-repeater\" ).reply( 'get:repeaterFieldsModelsArrayByForm', this.getAllFieldsModelsArrayByForm, this );\n\t\t\tthis.listenTo( nfRadio.channel('field-repeater'), 'set:repeaterModels', this.setAllRepeaterFieldsModels);\n\t\t\tthis.listenTo( nfRadio.channel('field-repeater'), 'set:value', this.setAllRepeatersValues );\n\t\t},\n\n\t\tsetAllRepeaterFieldsModels: function() {\n\t\t\tthis.set( 'repeaterFieldsetsModels', nfAllRepeaterFieldsModels );\n\t\t\tthis.allRepeatersFieldsetsModels = nfAllRepeaterFieldsModels;\n\t\t},\n\n\t\tinitAllRepeaterFieldsModels: function(collection, options) {\t\n\t\t\tconst formID = options.repeaterFieldModel.get('formID');\n\t\t\tconst repeaterID = options.repeaterFieldModel.get('id');\n\t\t\tconst currentModels = collection.fields.models;\n\t\t\t\n\t\t\tlet isModelSet = nfAllRepeaterFieldsModels.find(model => model.id === repeaterID && model.form === formID);\n\n\t\t\tif ( isModelSet ){\n\t\t\t\tisModelSet.fields = isModelSet.fields.concat(currentModels);\n\t\t\t} else {\n\t\t\t\tnfAllRepeaterFieldsModels.push( {\n\t\t\t\t\tform: formID,\n\t\t\t\t\tid: repeaterID,\n\t\t\t\t\tfields: currentModels\n\t\t\t\t});\n\t\t\t}\n\n\t\t\