Helpers: function () {\n            return {\n\n                renderFieldsMarkedRequired: function() {\n\n                    var requiredFields = this.fields.filter( { required: 1 } );\n                    return ( requiredFields.length ) ? this.fieldsMarkedRequired : '';\n                },\n            };\n        },\n\n    });\n\n    return view;\n} );\n","define( 'views/formLayout',[ 'views/afterFormContent', 'views/beforeFormContent', 'models/fieldCollection' ], function( AfterFormContent, BeforeFormContent, FieldCollection ) {\n\n\tvar view = Marionette.LayoutView.extend({\n\t\ttagName: \"nf-section\",\n\t\ttemplate: \"#tmpl-nf-form-layout\",\n\n\t\tregions: {\n\t\t\tbeforeFormContent: \".nf-before-form-content\",\n\t\t\tformContent: \".nf-form-content\",\n\t\t\tafterFormContent: \".nf-after-form-content\"\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\tnfRadio.channel( 'form-' + this.model.get( 'id' ) ).reply( 'get:el', this.getEl, this );\n\t\t\t\n\t\t\t/*\n\t\t\t * If we need to hide a form, set the visibility of this form to hidden.\n\t\t\t */\n\t\t\t this.listenTo( this.model, 'hide', this.hide );\n\t\t},\n\n\t\tonRender: function() {\n\t\t\tthis.$el = this.$el.children();\n\t\t\tthis.$el.unwrap();\n\t\t\tthis.setElement( this.$el );\n\t\t},\n\n\t\tonShow: function() {\n\t\t\tthis.beforeFormContent.show( new BeforeFormContent( { model: this.model } ) );\n\t\t\t\n\t\t\t/*\n\t\t\t * Set our formContentData to our form setting 'formContentData'\n\t\t\t */\n\t\t\tvar formContentData = this.model.get( 'formContentData' );\n\t\t\t\n\t\t\t/*\n\t\t\t * Check our fieldContentViewsFilter to see if we have any defined.\n\t\t\t * If we do, overwrite our default with the view returned from the filter.\n\t\t\t */\n\t\t\tvar formContentViewFilters = nfRadio.channel( 'formContent' ).request( 'get:viewFilters' );\n\t\t\t\n\t\t\t/* \n\t\t\t* Get our first filter, this will be the one with the highest priority.\n\t\t\t*/\n\t\t\tvar sortedArray = _.without( formContentViewFilters, undefined );\n\t\t\tvar callback = _.first( sortedArray );\n\t\t\tformContentView = callback();\n\t\t\t\n\t\t\tvar options = {\n\t\t\t\tdata: formContentData,\n\t\t\t\tformModel: this.model\n\t\t\t};\n\t\t\t\n\t\t\t/*\n\t\t\t * If we have a collection, pass the returned data as the collection.\n\t\t\t *\n\t\t\t * If we have a model, pass the returned data as the collection.\n\t\t\t */\n\t\t\tif ( false !== formContentData instanceof Backbone.Collection ) {\n\t\t\t\toptions.collection = formContentData;\n\t\t\t} else if ( false !== formContentData instanceof Backbone.Model ) {\n\t\t\t\toptions.model = formContentData;\n\t\t\t}\n\n\t\t\tthis.formContent.show( new formContentView( options ) );\n\t\t\tthis.afterFormContent.show( new AfterFormContent( { model: this.model } ) );\n\t\t},\n\n\t\tgetEl: function() {\n\t\t\treturn this.el;\n\t\t},\n\n        templateHelpers: function () {\n            return {\n\n                renderClasses: function() {\n                    return '';\n                }\n\n            };\n        },\n\n        hide: function() {\n        \tjQuery( this.el ).hide();\n        }\n\n\t});\n\n\treturn view;\n} );\n","define( 'views/afterForm',[], function( ) {\n\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: \"nf-section\",\n\t\ttemplate: \"#tmpl-nf-after-form\",\n\t\t\n\t});\n\n\treturn view;\n} );\n","define( 'views/mainLayout',['views/beforeForm', 'views/formLayout', 'views/afterForm'], function( BeforeForm, FormLayout, AfterForm ) {\n\n\tvar view = Marionette.LayoutView.extend({\n\t\ttemplate: '#tmpl-nf-layout',\n\n\t\tregions: {\n\t\t\tresponseMsg: '.nf-response-msg',\n\t\t\tbeforeForm: '.nf-before-form',\n\t\t\tformLayout: '.nf-form-layout',\n\t\t\tafterForm: '.nf-after-form'\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\tthis.$el = jQuery( '#nf-form-' + this.model.id + '-cont' );\n\t\t\tthis.el = '#nf-form-' + this.model.id + '-cont';\n\n\t\t\tthis.render();\n\n\t\t\tthis.beforeForm.show( new BeforeForm( { model: this.model } ) );\n\t\t\tthis.formLayout.show( new FormLayout( { model: this.model, fieldCollection: this.options.fieldCollection } ) );\n\t\t\tthis.afterForm.show( new AfterForm( { model: this.model } ) );\n\n\t\t\t/*\n\t\t\t * If we need to hide a form, set the visibility of this form to hidden.\n\t\t\t */\n\t\t\t this.listenTo( this.model, 'hide', this.hide );\n\t\t},\n\n        hide: function() {\n        \tjQuery( this.el ).find( '.nf-form-title' ).hide();\n        }\n\n\t});\n\n\treturn view;\n} );\n","// const Intl = require('intl');\n\n// class nfLocaleConverter {\nvar nfLocaleConverter = function(newLocale, thousands_sep, decimal_sep) {\n\n    // constructor(