\tHelpText,\n\t\tFieldTextbox,\n\t\tFieldTextareaRTE,\n\t\tFieldStarRating,\n\t\tFieldTerms,\n\t\tFormContentFilters,\n\t\tLoadViews,\n\t\tFormErrors,\n\t\tSubmit,\n\t\tDefaultFilters,\n\t\tUniqueFieldError,\n\t\tFieldRepeater,\n\t\tActionGA\n\t) {\n\t\tvar controller = Marionette.Object.extend( {\n\t\t\tinitialize: function() {\n\n\t\t\t\t/**\n\t\t\t\t * App Controllers\n\t\t\t\t */\n\t\t\t\tnew LoadViews();\n\t\t\t\tnew FormErrors();\n\t\t\t\tnew Submit();\n\t\t\t\t\n\t\t\t\t/**\n\t\t\t\t * Field type controllers\n\t\t\t\t */\n\t\t\t\tnew FieldCheckbox();\n\t\t\t\tnew FieldCheckboxList();\n\t\t\t\tnew FieldImageList();\n\t\t\t\tnew FieldRadio();\n\t\t\t\tnew FieldNumber();\n\t\t\t\tnew FieldSelect();\n\t\t\t\tnew FieldProduct();\n\t\t\t\tnew FieldTotal();\n\t\t\t\tnew FieldQuantity();\n\t\t\t\tnew FieldRecaptcha();\n\t\t\t\tnew FieldRecaptchaV3();\n\t\t\t\tnew FieldTurnstile();\n\t\t\t\tnew FieldHcaptcha();\n\t\t\t\tnew FieldHTML();\n\t\t\t\tnew HelpText();\n\t\t\t\tnew FieldTextbox();\n\t\t\t\tnew FieldTextareaRTE();\n\t\t\t\tnew FieldStarRating();\n\t\t\t\tnew FieldTerms();\n\t\t\t\tnew FormContentFilters();\n\t\t\t\tnew UniqueFieldError();\n\t\t\t\tnew FieldRepeater();\n\t\t\t\t\n\t\t\t\t/**\n\t\t\t\t * Misc controllers\n\t\t\t\t */\n\t\t\t\tnew FieldError();\n\t\t\t\tnew ChangeField();\n\t\t\t\tnew ChangeEmail();\n\t\t\t\tnew ChangeDate();\n\t\t\t\t\n\t\t\t\tnew MirrorField();\n\t\t\t\tnew ConfirmField();\n\t\t\t\tnew UpdateFieldModel();\n\t\t\t\tnew SubmitButton();\n\t\t\t\tnew SubmitDebug();\n\t\t\t\tnew GetFormErrors();\n\t\t\t\tnew ValidateRequired();\n\t\t\t\tnew SubmitError();\n\t\t\t\tnew ActionRedirect();\n\t\t\t\tnew ActionSuccess();\n\t\t\t\tnew ActionGA();\n\t\t\t\t\n\t\t\t\tnew CoreSubmitResponse();\n\t\t\t\tnew Calculations();\n\n\t\t\t\tnew DefaultFilters();\n\n\t\t\t\t/**\n\t\t\t\t * Data controllers\n\t\t\t\t */\n\t\t\t\tnew DateBackwardsCompat();\n\t\t\t\tnew FieldDate();\n\t\t\t\tnew FormData();\n\t\t\t\t\n\t\t\t}\n\t\t});\n\n\t\treturn controller;\n} );\n\n","define( 'views/beforeForm',[], function( ) {\n\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: \"nf-section\",\n\t\ttemplate: \"#tmpl-nf-before-form\",\n\n\t});\n\n\treturn view;\n} );\n","define( 'views/formErrorItem',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'nf-section',\n\t\ttemplate: '#tmpl-nf-form-error',\n\n\t\tonRender: function() {\n\t\t\t// this.$el = this.$el.children();\n\t\t\t// this.$el.unwrap();\n\t\t\t// this.setElement( this.$el );\n\t\t},\n\t});\n\n\treturn view;\n} );\n","define( 'views/formErrorCollection',['views/formErrorItem'], function( formErrorItem ) {\n\tvar view = Marionette.CollectionView.extend({\n\t\ttagName: \"nf-errors\",\n\t\tchildView: formErrorItem\n\t});\n\n\treturn view;\n} );\n","define( 'views/honeyPot',[], function() {\n    var view = Marionette.ItemView.extend({\n        tagName: 'nf-section',\n        template: '#tmpl-nf-form-hp',\n\n        events: {\n        \t'keyup .nf-field-hp': 'maybeError',\n            'change .nf-field-hp': 'maybeError'\n        },\n\n        maybeError: function( e ) {\n            /*\n             * If we have an empty honeyPot field, remove the honeypot form error.\n             * If we do not have an empty honeyPot field, add the honeypot form error.\n             */\n            if ( 0 == jQuery( e.target ).val().length ) {\n                nfRadio.channel( 'form-' + this.model.get( 'id' ) ).request( 'remove:error', 'honeyPot' );\n            } else {\n                var formModel  = nfRadio.channel( 'app'    ).request( 'get:form',  this.model.get( 'id' ) );\n                nfRadio.channel( 'form-' + this.model.get( 'id' ) ).request( 'add:error', 'honeyPot', formModel.get( 'settings' ).honeypotHoneypotError );\n            }\n        }\n    });\n\n    return view;\n} );\n","define( 'views/afterFormContent',['views/formErrorCollection', 'views/honeyPot'], function( FormErrors, HoneyPot ) {\n\n    var view = Marionette.LayoutView.extend({\n        tagName: \"nf-section\",\n        template: \"#tmpl-nf-after-fields\",\n\n\t\tregions: {\n\t\t\terrors: \".nf-form-errors\",\n            hp: \".nf-form-hp\"\n\t\t},\n\n        onShow: function() {\n        \tthis.errors.show( new FormErrors( { collection: this.model.get( 'errors' ) } ) );\n            this.hp.show( new HoneyPot( { model: this.model } ) );\n        }\n\n    });\n\n    return view;\n} );\n","define( 'views/beforeFormContent',[], function( ) {\n\n    var view = Marionette.ItemView.extend({\n        tagName: \