Modal', {
        addClass: 'nf-onboarding-modal',
    });
    this.congratulationsBox = new jBox('Modal', {
        addClass: 'nf-onboarding-modal',
        title: '',
        closeButton: 'title',
        onClose: function(e) {
            nfOB.step(0);
        },
        content: '<img src="' + nfAdmin.requireBaseUrl + '../img/onboarding/congratulations.png" alt="' + nfOBi18n.congratulations + '" /><p>' + nfOBi18n.congratulations1 + '</p><p>' + nfOBi18n.congratulations2 + '</p><a href="https://wordpress.org/support/plugin/ninja-forms/reviews/#new-post" target="_blank" class="nf-button primary">' + nfOBi18n.rateUs + '</a>'
    });
}

/**
 * Show the beacon over a target element.
 * @param {String} ref
 */
NinjaOnboarding.prototype.beacon = function (ref = '', offset = {}) {
    if(typeof(offset.y) == 'undefined') offset.y = 0;
    if(typeof(offset.x) == 'undefined') offset.x = 0;
    if(this.target !== '') {
        this.target.unbind('mouseenter mouseleave');
    }
    if(ref === '') {
        this.pointer.hide();
        this.target = '';
        return;
    }
    this.target = jQuery(ref);
    let pos = this.target.offset();
    let h = this.target.outerHeight();
    let w = this.target.outerWidth();
    this.pointer.css({
        position: 'fixed',
        top: (pos.top + h / 2 - 24 + offset.y) + 'px',
        left: (pos.left + w / 2 - 24 + offset.x) + 'px'
    })
    .show();
    this.target.hover( function(e) {
        nfOB.pointer.hide();
    }, function(e) {
        nfOB.pointer.show();
    });
}

/**
 * Toggle visibility of the backdrop.
 * @param {Boolean} hide 
 */
NinjaOnboarding.prototype.curtain = function (hide = false) {
    if(hide) {
        this.backdrop.hide();
    } else {
        this.backdrop.show();
    }
}

NinjaOnboarding.prototype.say = function (message) {
    this.mute();
    // Show speech bubble.
    this.tip.speech.html(message).show();
}

NinjaOnboarding.prototype.mute = function () {
    // Hide speech bubble.
    this.tip.speech.html('').hide();
    // Hide thought bubble.
    this.tip.bubble.hide();
    this.tip.thought.html('').hide();
}

NinjaOnboarding.prototype.think = function (message) {
    this.mute();
    // Show thought bubble.
    left = this.pointer.offset().left + 12 + 'px';
    this.tip.bubble.show();
    this.tip.thought.html(this.star + message).css({'left': left, 'top': '125px