  },\n\n        onChangeQuantity: function( model ){\n            var productID = model.get( 'product_assignment' );\n            var productField = nfRadio.channel( 'fields' ).request( 'get:field', productID );\n            var productPrice = Number( productField.get( 'product_price' ) );\n\n            var quantity = Number( model.get( 'value' ) );\n\n            var newTotal = quantity * productPrice;\n\n            this.productTotals[ productID ] = newTotal;\n\n            this.updateTotal();\n        },\n\n        updateTotal: function(){\n\n            var newTotal = 0;\n\n            for( var product in this.productTotals ){\n                newTotal += Number( this.productTotals[ product ] );\n            }\n\n            if( newTotal && this.shippingCost ) {\n                // Only add shipping if there is a cost.\n                newTotal += Number(this.shippingCost);\n            }\n\n            this.totalModel.set( 'value', newTotal.toFixed( 2 ) );\n            this.totalModel.trigger( 'reRender' );\n        }\n    });\n\n    return controller;\n});\n","define('controllers/fieldQuantity',[], function() {\n    var controller = Marionette.Object.extend( {\n\n        initialize: function() {\n            this.listenTo( nfRadio.channel( 'quantity' ), 'init:model', this.registerQuantity );\n        },\n\n        registerQuantity: function( model ){\n            var productID = model.get( 'product_assignment' );\n            var product = nfRadio.channel( 'fields' ).request( 'get:field', productID );\n\n            if( product ) {\n                product.set('product_use_quantity', 0);\n            }\n        },\n\n    });\n\n    return controller;\n});\n","/**\n * Model that represents a calculation.\n *\n * On init, we trigger a radio message so that controllers can do things when a calc model inits.\n */\ndefine( 'models/calcModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\t\tinitialize: function() {\n\t\t\t// Set our form id\n\t\t\tthis.set( 'formID', this.collection.options.formModel.get( 'id' ) );\n\t\t\t// Set our initial fields object to empty. This will hold our key/value pairs.\n\t\t\tthis.set( 'fields', {} );\n\t\t\t// Trigger a radio message to let controllers know we've inited this model.\n\t\t\tnfRadio.channel( 'calc' ).trigger( 'init:model', this );\n\t\t\t// When we change the value of this calculation, send out a radio message\n\t\t\tthis.on( 'change:value', this.changeValue, this );\n\t\t},\n\n\t\t/**\n\t\t * Trigger a radio message when a field present in our calculation changes\n\t\t *\n\t\t * The listener that triggers/calls this function is in controllers/calculations\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tchangeField: function( fieldModel ) {\n\t\t\tnfRadio.channel( 'calc' ).trigger( 'change:field', this, fieldModel );\n\t\t},\n\n\t\tchangeCalc: function( targetCalcModel ) {\n\t\t\tnfRadio.channel( 'calc' ).trigger( 'change:calc', this, targetCalcModel );\n\t\t},\n\n\t\tchangeValue: function() {\n\t\t\tnfRadio.channel( 'calc' ).trigger( 'change:value', this );\n\t\t}\n\t} );\n\n\treturn model;\n} );\n\n","define( 'models/calcCollection',['models/calcModel'], function( CalcModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: CalcModel,\n\t\tcomparator: 'order',\n\n\t\tinitialize: function( models, options ) {\n\t\t\tthis.options = options;\n            _.each( models, function( model ) {\n            \tif( 'undefined' == typeof model.dec ) return;\n                if ( '' === model.dec.toString().trim() ) model.dec = 2;\n                model.dec = parseInt( model.dec );\n            } );\n\t\t\t/*\n\t\t\t * Respond to requests for our calc model\n\t\t\t */\n\t\t\tnfRadio.channel( 'form-' + options.formModel.get( 'id' ) ).reply( 'get:calc', this.getCalc, this );\n\t\t},\n\n\t\tgetCalc: function( key ) {\n\t\t\treturn this.findWhere( { name: key } );\n\t\t}\n\t} );\n\treturn collection;\n} );\n","/**\n * Controller responsible for keeping up with calculations.\n */\ndefine('controllers/calculations',['models/calcCollection'], function( CalcCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.calcs = {};\n\t\t\tthis.displayFields = {};\n\t\t\t// When our form initialises, check to see if there are any calculations that need to be tracked.\n\t\t\tthis.listenTo( nfRadio.channel( 'form' ), 'loaded', this.registerCalcs );\n            \n            // When our collection gets reset, reset calculation tracking as well.\n            this.listenTo( nfRadio.channel( 'fields' ), 'reset:collection', this.resetCalcs );\n\n\t\t\t// When a calc model is initialised, run a setup function.\n\t\t\t// this.listenTo( nfRadio.channel( 'calc' ), 'init:model', this.setupCalc );\n\n\t\t\t// When a field referenced by a calc model changes, update our calc.\n\t\t\tthis.listenTo( nfRadio.channel( 'calc' ), 'change:field', this.changeField );\n\n\t\t\t// When a calculation referenced by a calc model changes, update our calc.\n\t\t\tthis.listenTo( nfRadio.channel( 'calc' ), 'change:calc', this.changeCalc );\n\n\t\t\t/*\n\t\t\t * Listen to our field model init for fields that want to display calc values.\n\t\t\t * If that field has a calc merge tag, replace it with the default calc value.\n\t\t\t */\n\t\t\tvar that = this;\n\t\t\t_.each( nfFrontEnd.use_merge_tags.calculations, function( fieldType ) {\n\t\t\t\tthat.listenTo( nfRadio.channel( 'fields-' + fieldType ), 'init:model', that.initDisplayField );\n\t\t\t} );\n\t\t\t\n\t\t\t// When we change our calc value, update any display fields.\n\t\t\tthis.listenTo( nfRadio.channel( 'calc' ), 'change:value', this.updateDisplayFields );\n\n\t\t\t// Set an init variable so that we only call reRender on the display field on change, not on init.\n\t\t\tthis.init = {};\n\t\t},\n        \n        /**\n         * Passthrough function to reset tracking of calculations when the fieldCollection is reset.\n         * \n         * @since 3.2\n         * @param backbone.collection fieldCollection\n         * @return void\n         */\n        resetCalcs: function( fieldCollection ) {\n            if( 'undefined' != typeof( fieldCollection.options.formModel ) ) {\n                this.registerCalcs( fieldCollection.options.formModel );  \n            }\n        },\n\n\t\t/**\n\t\t * When our form loads, create a collection out of any calculations.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  backbone.model formModel\n\t\t * @return void\n\t\t */\n\t\tregisterCalcs: function( formModel ) {\n\t\t\tvar calcCollection = new CalcCollection( formModel.get( 'settings' ).calculations, { formModel: formModel } );\n\t\t\tthis.calcs[ formModel.get( 'id' ) ] = calcCollection;\n\t\t\tvar that = this;\n\n\t\t\t_.each( calcCollection.models, function( calcModel ) {\n\t\t\t\t/*\n\t\t\t\t * We set a property on our init variable for the calc model we're looping over.\n\t\t\t\t * This property is set to true so that when we make changes to the calc model on the next line\n\t\t\t\t * the field view doesn't try to redraw itself.\n\t\t\t\t * If we don't do this, the 'reRender' attribute of the model will be set before the view is initialized,\n\t\t\t\t * which means that setting 'reRender' to true will never re-render the view.\n\t\t\t\t */\n\t\t\t\tthat.init[ calcModel.get( 'name' ) ] = true;\n\t\t\t\t// Setup our calculation models with initial values and register listeners for calc-related fields.\n\t\t\t\tthat.setupCalc( calcModel );\n\t\t\t} );\n\t\t},\n\n\t\t/**\n\t\t * When a calculation model is instantiated from the registerCalcs function:\n\t\t *\n\t\t * Use a regex to get an array of the field keys\n\t\t * Setup an initial key/values array\n\t\t * Check for any references to other calculations\n\t\t * Set the initial value of our calculation\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  backbone.model calcModel\n\t\t * @return void\n\t\t */\n\t\tsetupCalc: function( calcModel ) {\n\t\t\t// Setup our that var so we can access 'this' context in our loop.\n\t\t\tvar that = this;\n\t\t\t// Get our equation\n\t\t\tvar eq = calcModel.get( 'eq' );\n\t\t\t// We want to keep our original eq intact, so we use a different var for string replacment.\n\t\t\tvar eqValues = eq;\n            // Store the name for debugging later.\n            var calcName = calcModel.get( 'name' );\n\n\t\t\t/* TODO:\n\t\t\t * It might be possible to refactor these two if statements.\n\t\t\t * The difficulty is that each has a different method of retreiving the specific data model.\n\t\t\t */\n\t\t\t// Check to see if we have any field merge tags in our equation.\n\t\t\tvar fields = eq.match( new RegExp( /{field:(.*?)}/g ) );\n\t\t\tif ( fields ) {\n\t\t\t\t/*\n\t\t\t\t * fields is now an array of field keys that looks like:\n\t\t\t\t * ['{field:key'], ['{field:key'], etc.\n\t\t\t\t *\n\t\t\t\t * We need to run a function with each of our field keys to setup our field key array and hook up our field change listner.\n\t\t\t\t */\n\t\t\t\t\n\t\t\t\tfields = fields.map( function( field ) {\n\t\t\t\t\t// field will be {field:key}\n\t\t\t\t\tvar key = field.replace( ':calc}', '' ).replace( '}', '' ).replace( '{field:', '' );\n\n\t\t\t\t\t// Get our field model\n\t\t\t\t\tfieldModel = nfRadio.channel( 'form-' + calcModel.get( 'formID' ) ).request( 'get:fieldByKey', key );\n\n                    if( 'undefined' == typeof fieldModel ) return;\n\n                    fieldModel.set( 'clean', false );\n\n\t\t\t\t\t// Register a listener in our field model for value changes.\n\t\t\t\t\tfieldModel.on( 'change:value', calcModel.changeField, calcModel );\n\t\t\t\t\t// Get our calc value from our field model.\n\t\t\t\t\tvar calcValue = that.getCalcValue( fieldModel );\n\t\t\t\t\t// Add this field to our internal key/value object.\n\t\t\t\t\tthat.updateCalcFields( calcModel, key, calcValue );\n\t\t\t\t\t// Update the string tracking our merged eq with the calc value.\n\t\t\t\t\teqValues = that.replaceKey( 'field', key, calcValue, eqValues );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\t// Check to see if we have any calc merge tags in our equation.\n\t\t\tvar calcs = eq.match( new RegExp( /{calc:(.*?)}/g ) );\n\t\t\tif ( calcs ) {\n\t\t\t\t/*\n\t\t\t\t * calcs is now an array of calc keys that looks like:\n\t\t\t\t * ['{calc:key'], ['{calc:key'], etc.\n\t\t\t\t *\n\t\t\t\t * We need to run a function with each of our calc keys to setup our calc key array and hook up our calc change listner.\n\t\t\t\t */\n\t\t\t\t\n\t\t\t\tcalcs = calcs.map( function( calc ) {\n\t\t\t\t\t// calc will be {calc:name}\n\t\t\t\t\tvar name = calc.replace( '}', '' ).replace( '{calc:', '' );\n\t\t\t\t\t// Get our calc model\n\t\t\t\t\tvar targetCalcModel = calcModel.collection.findWhere( { name: name } );\n\n\t\t\t\t\tif( 'undefined' == typeof targetCalcModel ) return;\n\n\t\t\t\t\t// Listen for changes on our calcluation, since we need to update our calc when it changes.\n\t\t\t\t\ttargetCalcModel.on( 'change:value', calcModel.changeCalc, calcModel );\n\t\t\t\t\t// // Get our calc value from our calc model.\n\t\t\t\t\tvar calcValue = targetCalcModel.get( 'value' );\n\t\t\t\t\t// Update the string tracking our merged eq with the calc value.\n\t\t\t\t\teqValues = that.replaceKey( 'calc', name, calcValue, eqValues );\n\t\t\t\t} );\n\n\t\t\t}\n\n            // Scrub unmerged tags (ie deleted/nox-existent fields/calcs, etc).\n            eqValues = eqValues.replace( /{([a-zA-Z0-9]|:|_|-)*}/g, 0 );\n            // Scrub line breaks.\n            eqValues = eqValues.replace( /\\r?\\n|\\r/g, '' );\n\t\t\t// Evaluate the equation and update the value of this model.\n\t\t\ttry {\n\t\t\t\tthis.debug('Calculation Decoder ' + eqValues + ' -> ' + this.localeDecodeEquation(eqValues) + ' (Setup)');\n\t\t\t\tconst mexp = new Mexp;\n\t\t\t\tcalcModel.set( 'value', Number( mexp.eval( this.localeDecodeEquation(eqValues) ) ).toFixed( calcModel.get( 'dec' ) ) );\n\t\t\t} catch( e ) {\n                //console.log( calcName );\n\t\t\t\tconsole.log( e );\n\t\t\t}\n            \n            // If for whatever reason, we got NaN, reset that to 0.\n            if( calcModel.get( 'value' ) === 'NaN' ) calcModel.set( 'value', '0' );\n\n\t\t\t// Debugging console statement.\n\t\t\t// console.log( eqValues + ' = ' + calcModel.get( 'value' ) );\n\t\t},\n\n\t\t/**\n\t\t * Update an item in our key/value pair that represents our fields and calc values.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  backbone.model \tcalcModel\n\t\t * @param  string \t\t\tkey\n\t\t * @param  string \t\t\tcalcValue\n\t\t * @return void\n\t\t */\n\t\tupdateCalcFields: function( calcModel, key, calcValue ) {\n\t\t\tvar fields = calcModel.get( 'fields' );\n\t\t\tfields[ key ] = calcValue;\n\t\t\tcalcModel.set( 'fields', fields );\n\t\t},\n\n\t\t/**\n\t\t * Get a calc value from a field model.\n\t\t *\n\t\t * Sends a request to see if there's a special calc value\n\t\t * Uses the value of the field if there is not.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  backbone.model fieldModel\n\t\t * @return value\n\t\t */\n\t\tgetCalcValue: function( fieldModel ) {\n\t\t\t/*\n\t\t\t * Send out a request on the field type and parent type channel asking if they need to modify the calc value.\n\t\t\t * This is helpful for fields like lists that can have a different calc_value than selected value.\n\t\t\t */\n\t\t\tvar value = nfRadio.channel( fieldModel.get( 'type' ) ).request( 'get:calcValue', fieldModel );\n\t\t\t\n\t\t\t// Preset with our field value.\n\t\t\tvar calcValue = fieldModel.get( 'value' );\n\t\t\tif( 'undefined' !== typeof value ) {\n\t\t\t\tif( value || 0 === value ) {\n\t\t\t\t\t// If we got a valid number, use that instead.\n\t\t\t\t\tcalcValue = value;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tvar localeConverter = new nfLocaleConverter(nfi18n.siteLocale, nfi18n.thousands_sep, nfi18n.decimal_point);\n\t\t\tvar machineNumber = localeConverter.numberDecoder(calcValue);\n\t\t\tvar formattedNumber = localeConverter.numberEncoder(calcValue);\n\n\t\t\tif ( 'undefined' !== typeof machineNumber && jQuery.isNumeric( machineNumber ) ) {\n\t\t\t\tvalue = formattedNumber;\n\t\t\t} else {\n\t\t\t\tvalue = 0;\n\t\t\t}\n\t\t\t// }\n\n\t\t\tif ( ! fieldModel.get( 'visible' ) ) {\n\t\t\t\tvalue = 0;\n\t\t\t}\n\t\t\n\t\t\treturn value;\n\t\t},\n\n\t\t/**\n\t\t * Replace instances of key with calcValue. This is used to replace one key at a time.\n\t\t *\n\t\t * If no eq is passed, use calcModel eq.\n\t\t *\n\t\t * Returns a string with instances of key replaced with calcValue.\n\t\t * \n\t\t * @since  version\n\t\t * @param  string \tkey       \n\t\t * @param  string \tcalcValue \n\t\t * @param  string \teq        \n\t\t * @return string \teq      \n\t\t */\n\t\treplaceKey: function( type, key, calcValue, eq ) {\n\t\t\teq = eq || calcModel.get( 'eq' );\n\n\t\t\ttag = '{' + type + ':' + key + '}';\n\t\t\tvar reTag = new RegExp( tag, 'g' );\n\n\t\t\tcalcTag = '{' + type + ':' + key + ':calc}';\n\t\t\tvar reCalcTag = new RegExp( calcTag, 'g' );\n\n\t\t\teq = eq.replace( reTag, calcValue );\n\t\t\teq = eq.replace( reCalcTag, calcValue );\n\n\t\t\treturn eq;\n\t\t},\n\n\t\t/**\n\t\t * Takes a calcModel and returns a string eq with all keys replaced by their appropriate calcValues.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  backbone.model \tcalcModel\n\t\t * @return string\t\t\teq\n\t\t */\n\t\treplaceAllKeys: function( calcModel ) {\n\t\t\tvar eq = calcModel.get( 'eq' );\n\t\t\tvar that = this;\n\t\t\t_.each( calcModel.get( 'fields' ), function( value, key ) {\n\t\t\t\teq = that.replaceKey( 'field', key, value, eq );\n\t\t\t} );\n\n\t\t\t// If we have any calc merge tags, replace those as well.\n\t\t\tvar calcs = eq.match( new RegExp( /{calc:(.*?)}/g ) );\n\t\t\tif ( calcs ) {\n\t\t\t\t_.each( calcs, function( calc ) {\n\t\t\t\t\t// calc will be {calc:key}\n\t\t\t\t\tvar name = calc.replace( '}', '' ).replace( '{calc:', '' );\n\t\t\t\t\tvar targetCalcModel = calcModel.collection.findWhere( { name: name } );\n                    if( 'undefined' == typeof targetCalcModel ) return;\n\t\t\t\t\tvar re = new RegExp( calc, 'g' );\n\t\t\t\t\teq = eq.replace( re, targetCalcModel.get( 'value' ) );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\treturn eq;\n\t\t},\n\n\t\t/**\n\t\t * Function that's called when a field within the calculation changes.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  backbone.model calcModel\n\t\t * @param  backbone.model fieldModel\n\t\t * @return void\n\t\t */\n\t\tchangeField: function( calcModel, fieldModel ) {\n\t\t\n\t\t\tvar key = fieldModel.get( 'key' );\n\t\t\tvar value = this.getCalcValue( fieldModel );\n\t\t\t\n\t\t\tthis.updateCalcFields( calcModel, key, value );\n\t\t\tvar eqValues = this.replaceAllKeys( calcModel );\n\n            // Scrub unmerged tags (ie deleted/nox-existent fields/calcs, etc).\n            eqValues = eqValues.replace( /{([a-zA-Z0-9]|:|_|-)*}/g, '0' );\n            eqValues = eqValues.replace( /\\r?\\n|\\r/g, '' );\n            try {\n\t\t\t\tthis.debug('Calculation Decoder ' + eqValues + ' -> ' + this.localeDecodeEquation(eqValues) + ' (Change Field)');\n\t\t\t\tconst mexp = new Mexp;\n\t\t\t\tcalcModel.set( 'value', Number( mexp.eval( this.localeDecodeEquation(eqValues) ) ).toFixed( calcModel.get( 'dec' ) ) );\n            } catch( e ) {\n                if(this.debug())console.log( e );\n            }\n            if( calcModel.get( 'value' ) === 'NaN' ) calcModel.set( 'value', '0' );\n\n\t\t\t// Debugging console statement.\n\t\t\t// console.log( eqValues + ' = ' + calcModel.get( 'value' ) );\t\t\n\t\t},\n\n\t\tinitDisplayField: function( fieldModel ) {\n\n\t\t\tif( ! fieldModel.get( 'default' ) || 'string' != typeof fieldModel.get( 'default' ) ) return;\n\n\t\t\tvar calcs = fieldModel.get( 'default' ).match( new RegExp( /{calc:(.*?)}/g ) );\n\t\t\tif ( calcs ) {\n\t\t\t\t_.each( calcs, function( calcName ) {\n\t\t\t\t\tcalcName = calcName.replace( '{calc:', '' ).replace( '}', '' ).replace( ':2', '' );\n\t\t\t\t\tthis.displayFields[ calcName ] = this.displayFields[ calcName ] || [];\n\t\t\t\t\tthis.displayFields[ calcName ].push( fieldModel );\n\t\t\t\t}, this );\n\t\t\t}\n\t\t},\n\n\t\tupdateDisplayFields: function( calcModel ) {\n\t\t\tvar that = this;\n\t\t\tif ( 'undefined' != typeof this.displayFields[ calcModel.get( 'name' ) ] ) {\n\t\t\t\t_.each( this.displayFields[ calcModel.get( 'name' ) ], function( fieldModel ) {\n\n\t\t\t\t\tvar value = '';\n\n\t\t\t\t\t/**\n\t\t\t\t\t * if we have a html field, we want to use the actual\n\t\t\t\t\t * value and re-evaluate\n\t\t\t\t    **/\n\t\t\t\t\tif( \"html\" === fieldModel.get( 'type' ) ) {\n\t\t\t\t\t\tvalue = fieldModel.get( 'value' );\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// if not a html field, use default to re-evaluate\n\t\t\t\t\t\tvalue = fieldModel.get( 'default' );\n\t\t\t\t\t}\n\n\t\t\t\t\t/*\n\t\t\t\t\t This is a fix for the issue of the merge tags being\n\t\t\t\t\t display'd\n\t\t\t\t\t */\n\n\t\t\t\t\t// Find spans with calc data-key values\n\t\t\t\t\tvar spans = value.match( new RegExp( /<span data-key=\"calc:(.*?)<\\/span>/g ));\n\t\t\t\t\t_.each( spans, function( spanVar ) {\n\t\t\t\t\t\t// transform the span back into a merge tag\n\t\t\t\t\t\tvar tmpCalcTag = \"{\" + spanVar.replace(\"<span\" +\n\t\t\t\t\t\t\t\" data-key=\\\"\", \"\" ).replace( /\">(.*?)<\\/span>/, \"\" ) + \"}\";\n\n\t\t\t\t\t\tvalue = value.replace( spanVar, tmpCalcTag );\n\t\t\t\t\t} );\n\t\t\t\t\tvar calcs = value.match( new RegExp( /{calc:(.*?)}/g ) );\n\t\t\t\t\t_.each( calcs, function( calc ) {\n//\t\t\t\t\t\tvar rounding = false;\n\t\t\t\t\t\t// calc will be {calc:key} or {calc:key:2}\n\t\t\t\t\t\tvar name = calc.replace( '}', '' ).replace( '{calc:', '' ).replace( ':2', '' );\n\n\t\t\t\t\t\t/*\n\t\t\t\t\t\t * TODO: Bandaid for rounding calculations to two decimal places when displaying the merge tag.\n\t\t\t\t\t\t * Checks to see if we have a :2. If we do, remove it and set our rounding variable to true.\n\t\t\t\t\t\t */\n//\t\t\t\t\t\tif ( -1 != name.indexOf( ':2' ) ) {\n//\t\t\t\t\t\t\trounding = true;\n//\t\t\t\t\t\t\tname = name.replace( ':2', '' );\n//\t\t\t\t\t\t}\n\n\t\t\t\t\t\tvar calcModel = that.calcs[ fieldModel.get( 'formID' ) ].findWhere( { name: name } );\n\t\t\t\t\t\tvar re = new RegExp( calc, 'g' );\n\t\t\t\t\t\tvar calcValue = calcModel.get( 'value' ) ;\n//\t\t\t\t\t\tif ( rounding ) {\n//\t\t\t\t\t\t\tcalcValue = calcValue.toFixed( 2 );\n//\t\t\t\t\t\t\trounding = false;\n//\t\t\t\t\t\t}\n\t\t\t\t\t\t\n                        if( 'undefined' != typeof( calcValue ) ) {\n                            calcValue = that.applyLocaleFormatting( calcValue, calcModel );\n\t\t\t\t\t\t}\n                        /*\n                         * We replace the merge tag with the value\n\t\t\t\t\t\t * surrounded by a span so that we can still find it\n\t\t\t\t\t\t * and not affect itself or other field merge tags\n\t\t\t\t\t\t *\n\t\t\t\t\t\t * Unless this isn't a html field, then we just set\n\t\t\t\t\t\t  * value to calcValue\n\t\t\t\t\t\t*/\n                        if( \"html\" === fieldModel.get( 'type' ) ) {\n\t                        value = value.replace(re, \"<span data-key=\\\"calc:\" + name + \"\\\">\"\n\t\t                        + calcValue + \"</span>\");\n                        } else {\n                        \tvalue = calcValue;\n                        }\n\t\t\t\t\t} );\n\t\t\t\t\t\n\t\t\t\t\tfieldModel.set( 'value', value );\n\t\t\t\t\tif ( ! that.init[ calcModel.get( 'name' ) ] ) {\n\t\t\t\t\t\t// fieldModel.set( 'reRender', true );\n\t\t\t\t\t\tfieldModel.trigger( 'reRender' );\n\t\t\t\t\t}\n\t\t\t\t\tthat.init[ calcModel.get( 'name' ) ] = false;\n\t\t\t\t} );\n\t\t\t}\n\t\t},\n\n\t\tgetCalc: function( name, formID ) {\n\t\t\treturn this.calcs[ formID ].findWhere( { name: name } );\n\t\t},\n\n\t\tchangeCalc: function( calcModel, targetCalcModel ) {\n\t\t\tvar eqValues = this.replaceAllKeys( calcModel );\n\t\t\t\n\t\t\teqValues = eqValues.replace( '[', '' ).replace( ']', '' );\n            eqValues = eqValues.replace( /\\r?\\n|\\r/g, '' );\n            try {\n\t\t\t\tthis.debug('Calculation Decoder ' + eqValues + ' -> ' + this.localeDecodeEquation(eqValues) + ' (Change Calc)');\n\t\t\t\tconst mexp = new Mexp;\n\t\t\t\tcalcModel.set( 'value', Number( mexp.eval( this.localeDecodeEquation( eqValues ) ) ).toFixed( calcModel.get( 'dec' ) ) );\n            } catch( e ) {\n                console.log( e );\n            }\n            if( calcModel.get( 'value' ) === 'NaN' ) calcModel.set( 'value', '0' );\n\t\t},\n        \n        /**\n         * Function to apply Locale Formatting to Calculations\n         * @since Version 3.1\n         * @param Str number\n         * \n         * @return Str\n         */\n        applyLocaleFormatting: function( number, calcModel ) {\n\n\t\t\tvar localeConverter = new nfLocaleConverter(nfi18n.siteLocale, nfi18n.thousands_sep, nfi18n.decimal_point);\n\n\t\t\tvar formattedNumber = localeConverter.numberEncoder(number, calcModel.get('dec'));\n            \n            // // Split our string on the decimal to preserve context.\n            // var splitNumber = number.split('.');\n            // // If we have more than one element (if we had a decimal point)...\n            // if ( splitNumber.length > 1 ) {\n            //     // Update the thousands and remerge the array.\n            //     splitNumber[ 0 ] = splitNumber[ 0 ].replace( /\\B(?=(\\d{3})+(?!\\d))/g, nfi18n.thousands_sep );\n            //     var formattedNumber = splitNumber.join( nfi18n.decimal_point );\n            // }\n            // // Otherwise (we had no decimal point)...\n            // else {\n            //     // Update the thousands.\n            //     var formattedNumber = number.replace( /\\B(?=(\\d{3})+(?!\\d))/g, nfi18n.thousands_sep );\n            // }\n            return formattedNumber;\n\t\t},\n\t\t\n\t\tlocaleDecodeEquation: function( eq ) {\n\t\t\tvar result = '';\n\t\t\tvar expression = '';\n\t\t\tvar pattern = /[0-9.,]/;\n\t\t\tvar localeConverter = new nfLocaleConverter(nfi18n.siteLocale, nfi18n.thousands_sep, nfi18n.decimal_point);\n\t\t\t// This pattern accounts for all whitespace characters (including thin space).\n\t\t\teq = eq.replace( /\\s/g, '' );\n\t\t\teq = eq.replace( /&nbsp;/g, '' );\n\t\t\tvar characters = eq.split('');\n\t\t\t// foreach ( characters as character ) {\n\t\t\tcharacters.forEach( function( character ) {\n\t\t\t\t// If the character is numeric or '.' or ','\n\t\t\t\tif (pattern.test(character)) {\n\t\t\t\t\texpression = expression + character;\n\t\t\t\t} else {\n\t\t\t\t\t// If we reach an operator char, append the expression to the result\n\t\t\t\t\tif ( 0 < expression.length ) {\n\t\t\t\t\t\tresult = result + localeConverter.numberDecoder( expression );\n\t\t\t\t\t\texpression = '';\n\t\t\t\t\t}\n\t\t\t\t\tresult = result + character;\n\t\t\t\t}\n\t\t\t});\n\t\t\t// The following catches the case of the last character being a digit.\n\t\t\tif ( 0 < expression.length ) {\n\t\t\t\tresult = result + localeConverter.numberDecoder( expression );\n\t\t\t}\n\t\t\treturn result;\n\t\t},\n\n\t\tdebug: function(message) {\n\t\t\tif ( window.nfCalculationsDebug || false ) console.log(message);\n\t\t}\n\t\n\t});\n\n\treturn controller;\n} );\n\n","define('controllers/dateBackwardsCompat',[], function() {\n    var controller = Marionette.Object.extend({\n\n        initialize: function () {\n            this.listenTo( Backbone.Radio.channel( 'pikaday-bc' ), 'init', this.dateBackwardsCompat );\t\n        },\n\n        dateBackwardsCompat: function( dateObject, fieldModel ) {\n           \n            /**\n             * Start backwards compatibility for old pikaday customisation\n             */\n            // Legacy properties\n            dateObject.pikaday = {};\n            dateObject.pikaday._o = {};\n\n            //Old hook for Pikaday Custom code\n            nfRadio.channel( 'pikaday' ).trigger( 'init', dateObject, fieldModel );\n\n            // If we've set a disableDayFn property in custom code, hook it up to Flatpickr\n            if ( typeof dateObject.pikaday._o.disableDayFn !== 'undefined') {\n                dateObject.set( 'disable', [ dateObject.pikaday._o.disableDayFn ] );\n            }\n\n            //Compatibility for i18n pikaday function\n            if ( typeof dateObject.pikaday._o.i18n !== 'undefined' || typeof dateObject.pikaday._o.firstDay !== 'undefined') {\n\n                let locale = dateObject.config.locale;\n\n                if ( typeof dateObject.pikaday._o.firstDay !== 'undefined') {\n                    locale.firstDayOfWeek = dateObject.pikaday._o.firstDay;\n                }\n\n                if ( typeof dateObject.pikaday._o.i18n !== 'undefined') {\n                    if ( typeof dateObject.pikaday._o.i18n.weekdays !== 'undefined') {\n                        locale.weekdays.longhand = dateObject.pikaday._o.i18n.weekdays;\n                    }\n\n                    if ( typeof dateObject.pikaday._o.i18n.weekdaysShort !== 'undefined') {\n                        locale.weekdays.shorthand = dateObject.pikaday._o.i18n.weekdaysShort;\n                    }\n                    \n                    if ( typeof dateObject.pikaday._o.i18n.months !== 'undefined') {\n                        jQuery( '.flatpickr-monthDropdown-months > option' ).each( function() {\n                            this.text = dateObject.pikaday._o.i18n.months[ this.value ];\n                        } );\n                    }\n                }\n\n                dateObject.set( 'locale', locale );\n                \n            }\n\n            if ( Object.keys(dateObject.pikaday._o).length > 0 ) {\n                console.log(\"%cDeprecated Ninja Forms Pikaday custom code detected.\", \"color: Red; font-size: large\");\n                console.log(\"You are using deprecated Ninja Forms Pikaday custom code. Support for this custom code will be removed in a future version of Ninja Forms. Please contact Ninja Forms support for more details.\");\n            }\n\n        }\n\n    });\n\n    return controller;\n});\n","define('controllers/fieldDate',[], function() {\n    var controller = Marionette.Object.extend({\n\n        initialize: function () {\n            this.listenTo( nfRadio.channel( 'date' ), 'init:model', this.initModel );\n            this.listenTo( nfRadio.channel( 'date' ), 'render:view', this.initDatepicker );\n        },\n\n        initModel: function(model) {\n            this.registerFunctions(model);\n        },\n\n        registerFunctions: function( model ) {\n            model.set( 'renderHourOptions', this.renderHourOptions );\n            model.set( 'renderMinuteOptions', this.renderMinuteOptions );\n            model.set( 'maybeRenderAMPM', this.maybeRenderAMPM );\n            model.set( 'customClasses', this.customClasses );\n            // Overwrite the default getValue() method.\n            model.getValue = this.getValue;\n        },\n\n        renderHourOptions: function() {\n            return this.hours_options;\n        },\n\n        renderMinuteOptions: function() {\n            return this.minutes_options;\n        },\n\n        maybeRenderAMPM: function() {\n            if ( 'undefined' == typeof this.hours_24 || 1 == this.hours_24 ) {\n                return;\n            }\n            var requiredAttr = (this.required == 1) ? 'aria-required=\"true\" required' : '';\n            return `<div style=\"float:left;\" class=\"time-wrap\"><select id=\"ampm-select\" class=\"ampm extra\" aria-label=\"am-pm-select\" ${requiredAttr}><option value=\"am\">AM</option><option value=\"pm\">PM</option></select></div>`;\n        },\n\n        initDatepicker: function ( view ) {\n            view.model.set( 'el', view.el );\n            var el = jQuery( view.el ).find( '.nf-element' )[0];\n            view.listenTo( nfRadio.channel( 'form-' + view.model.get( 'formID' ) ), 'before:submit', this.beforeSubmit, view );\n\n            // If we are using a time_only date_mode, then hide the date input.\n            if ( 'undefined' != typeof view.model.get( 'date_mode' ) && 'time_only' == view.model.get( 'date_mode' ) ) {\n                jQuery( el ).hide();\n                return false;\n            }\n\n            // Make sure date format is correctly converted.\n            var dateFormat = this.convertDateFormat( view.model.get( 'date_format' ) );\n            // Make sure this is a deep conversion of the original model.\n            view.model.set('date_format', dateFormat);\n\n            var dateSettings = {\n                onReady: ( selectedDates, datestr, dateObject ) => {\n                    dateObject.altInput.setAttribute( 'aria-labelledby', jQuery( el ).attr( \"aria-labelledby\" ) );\n                    dateObject.altInput.setAttribute( 'aria-invalid', false );\n                },\n                dateFormat: dateFormat,\n                altFormat: dateFormat,\n                altInput: true,\n                ariaDateFormat: dateFormat,\n                mode: \"single\",\n                allowInput: true,\n                disableMobile: \"true\",\n                minDate: this.getMinDate(view.model),\n                maxDate: this.getMaxDate(view.model),\n            };\n            \n            const nfCustomLocale = this.checkCustomLocale();\n            if(nfCustomLocale){\n                dateSettings.locale = nfCustomLocale;\n            }\n\n            // Filter our datepicker settings object.\n            let filteredDatePickerSettings = nfRadio.channel( 'flatpickr' ).request( 'filter:settings', dateSettings, view );\n            if ( 'undefined' != typeof filteredDatePickerSettings ) {\n                dateSettings = filteredDatePickerSettings;\n            }\n\n            var dateObject = flatpickr( el, dateSettings );\n            // Set default value only when value is missing\n            if ( 1 == view.model.get( 'date_default' ) && ! view.model.get( 'value' ) ) {\n                dateObject.defaultDate = new Date();\n                dateObject.setDate(dateObject.defaultDate);\n                view.model.set( 'value', dateObject.defaultDate );\n            }\n            // Set default value in RFF context, only if value equals today's date\n            if( 1 == view.model.get( 'date_default' ) && \n                typeof view.model.get('id') === \"string\" && \n                view.model.get('id').includes('.') && \n                typeof view.model.get( 'value' ) === \"object\" && \n                this.isSameDay( view.model.get( 'value' ), new Date() )\n            ) {\n                dateObject.defaultDate = new Date();\n                dateObject.setDate(dateObject.defaultDate, true);\n                view.model.set( 'value', dateObject.defaultDate );\n            }\n\n            //Trigger Pikaday backwards compatibility\n            nfRadio.channel( 'pikaday-bc' ).trigger( 'init', dateObject, view.model, view );\n\n            nfRadio.channel( 'flatpickr' ).trigger( 'init', dateObject, view.model, view );\n        },\n\n        beforeSubmit: function( formModel ) { \n            //Get value from input if the default date wasn't edited in the field and the value is still a global unformatted date object\n            if( _.isObject( this.model.get( 'value' ) ) ){\n                // We detect the flatpickr input inside the element by its type instead of ID as the dot in the repeater children ID is not compatible with query selector\n                const date_value = this.el.querySelector(\"input[type='hidden']\").value;\n                this.model.set( 'value', date_value );\n            }\n            //Detect repeater and set data at the repeater level\n            const inputID = this.el.dataset.fieldId;\n            if(inputID.search(\".\") !== -1){\n                nfRadio.channel('field-repeater').trigger('set:value');\n                // Don't convert string value into object for time_only type in repeatable fieldset field\n                if(this.model.get( 'date_mode' ) === \"time_only\"){\n                    return;\n                }\n            }\n\n            if ( 'date_only' == this.model.get( 'date_mode' ) ) {\n                return false;\n            }\n            let hour = jQuery( this.el ).find( '.hour' ).val();\n            let minute = jQuery( this.el ).find( '.minute' ).val();\n            let ampm = jQuery( this.el ).find( '.ampm' ).val();\n            let current_value = this.model.get( 'value' );\n            let date = false;\n\n            if ( _.isObject( current_value ) ) {\n                date = current_value.date;\n            } else {\n                date = current_value;\n            }\n\n            let date_value = {\n                date: date,\n                hour: hour,\n                minute: minute,\n                ampm: ampm,\n            };\n\n            this.model.set( 'value', date_value );\n        },\n\n        getMinDate: function( fieldModel ) {\n            let minDate = null;\n            if(typeof fieldModel.get( 'year_range_start' ) !== \"undefined\"){\n                const yearRangeStart = fieldModel.get( 'year_range_start' );\n                if( yearRangeStart ) {\n                    minDate = flatpickr.formatDate(new Date(String( yearRangeStart )), fieldModel.get('date_format'));\n                }\n            } \n            return minDate;\n        },\n\n        getMaxDate: function( fieldModel ) {\n            let maxDate = null;\n            if(typeof fieldModel.get( 'year_range_end' ) !== \"undefined\"){\n                const yearRangeEnd = fieldModel.get( 'year_range_end' );\n                if( yearRangeEnd ) {\n                    maxDate = flatpickr.formatDate(new Date(String( yearRangeEnd )), fieldModel.get('date_format'));\n                }\n            }\n            return maxDate;\n        },\n\n        convertDateFormat: function( dateFormat ) {\n            //If dateFormat is empty or null, try to get a value from the Field's model\n            if(!dateFormat && this.model){\n                dateFormat = this.model.get('date_format');\n            } \n            //If it is still empty or null set it to be \"default\"\n            if (!dateFormat){\n                dateFormat = \"default\";\n            }\n            //Convert PHP format in setting to flatPickr expected setting if needed\n            const lookup = {\n                'MM/DD/YYYY': 'm/d/Y',\n                'MM-DD-YYYY': 'm-d-Y',\n                'MM.DD.YYYY': 'm.d.Y',\n                'DD/MM/YYYY': 'd/m/Y',\n                'DD-MM-YYYY': 'd-m-Y',\n                'DD.MM.YYYY': 'd.m.Y',\n                'YYYY-MM-DD': 'Y-m-d',\n                'YYYY/MM/DD': 'Y/m/d',\n                'YYYY.MM.DD': 'Y.m.d',\n                'dddd, MMMM D YYYY': 'l, F d Y',\n                'default': nfi18n.dateFormat ? nfi18n.dateFormat : 'default'\n            };\n            return Object.keys(lookup).includes(dateFormat) ? lookup[dateFormat] : dateFormat;\n        },\n\n        customClasses: function( classes ) {\n            if ( 'date_and_time' == this.date_mode ) {\n                classes += ' date-and-time';\n            }\n            return classes;\n        },\n        //retrieve localized values and assign them to flatpickr locale format\n        checkCustomLocale: function() {\n            let customLocale = {};\n            if(nfi18n){\n                if(nfi18n.months || nfi18n.monthsShort){\n                    customLocale.months = {};\n                    if(nfi18n.months){\n                        customLocale.months.longhand = nfi18n.months;\n                    }\n                    if(nfi18n.monthsShort){\n                        customLocale.months.shorthand = nfi18n.monthsShort;\n                    }\n                }\n                if(nfi18n.weekdays || nfi18n.weekdaysShort){\n                    customLocale.weekdays = {};\n                    if(nfi18n.weekdays){\n                        customLocale.weekdays.longhand = nfi18n.weekdays;\n                    }\n                    if(nfi18n.weekdaysShort){\n                        customLocale.weekdays.shorthand = nfi18n.weekdaysShort;\n                    }\n                }\n                if(nfi18n.startOfWeek){\n                    customLocale.firstDayOfWeek = nfi18n.startOfWeek;\n                }\n            }\n            return _.isEmpty(customLocale) ? false : customLocale;\n        },\n\n        // This function is called whenever we want to know the value of the date field.\n        // Since it could be a date/time field, we can't return just the value.\n        getValue: function() {\n\n            if ( 'date_only' == this.get( 'date_mode' ) ) {\n                return this.get( 'value' );\n            }\n            let el = this.get( 'el' );\n            let hour = jQuery( el ).find( '.hour' ).val();\n            let minute = jQuery( el ).find( '.minute' ).val();\n            let ampm = jQuery( el ).find( '.ampm' ).val();\n            let current_value = this.get( 'value' );\n            let date = false;\n\n            if ( _.isObject( current_value ) ) {\n                date = current_value.date;\n            } else {\n                date = current_value;\n            }\n\n            let value = '';\n\n            if ( 'undefined' != typeof date ) {\n                value += date;\n            }\n\n            if ( 'undefined' != typeof hour && 'undefined' != typeof minute ) {\n                value += ' ' + hour + ':' + minute;\n            }\n\n            if ( 'undefined' != typeof ampm ) {\n                value += ' ' + ampm;\n            }\n\n            return value;\n\n            // let date_value = {\n            //     date: date,\n            //     hour: hour,\n            //     minute: minute,\n            //     ampm: ampm,\n            // };\n\n            // this.model.set( 'value', date_value );\n        },\n\n        isSameDay: function(date1, date2) {\n            const d1 = new Date(date1);\n            const d2 = new Date(date2);\n            d1.setHours(0, 0, 0, 0);\n            d2.setHours(0, 0, 0, 0);\n            return d1.getTime() === d2.getTime();\n        }\n\n    });\n\n    return controller;\n});\n\n","define('controllers/fieldRecaptcha',[], function() {\n    var controller = Marionette.Object.extend({\n\n        initialize: function () {\n            this.listenTo( nfRadio.channel( 'recaptcha' ), 'init:model',      this.initRecaptcha  );\n            this.listenTo( nfRadio.channel( 'forms' ),     'submit:response', this.resetRecaptcha );\n        },\n\n       \tinitRecaptcha: function ( model ) {\n       \t\tnfRadio.channel( 'recaptcha' ).reply( 'update:response', this.updateResponse, this, model.id );\n        },\n\n        updateResponse: function( response, fieldID ) {\n        \tvar model = nfRadio.channel( 'fields' ).request( 'get:field', fieldID );\n\t\t\tmodel.set( 'value', response );\n            nfRadio.channel( 'fields' ).request( 'remove:error', model.get( 'id' ), 'required-error' );\n        },\n\n        resetRecaptcha: function() {\n\t\t\tvar recaptchaID = 0;\n\t\t\tjQuery( '.g-recaptcha' ).each( function() {\n\t\t\t\ttry {\n\t\t\t\t\tgrecaptcha.reset( recaptchaID );\n\t\t\t\t} catch( e ){\n\t\t\t\t\tconsole.log( 'Notice: Error trying to reset grecaptcha.' );\n\t\t\t\t}\n\t\t\t\trecaptchaID++;\n\t\t\t} );\n        }\n    });\n\n    return controller;\n} );\n","define('controllers/fieldRecaptchaV3',[], function() {\n    var controller = Marionette.Object.extend({\n\n        initialize: function () {\n            this.listenTo( nfRadio.channel( 'recaptcha_v3' ), 'init:model', this.initRecaptcha  );\n        },\n\n       \tinitRecaptcha: function ( model ) {\t\t\t\n\t        const formID = model.get( 'formID' );\n\t\t\t//Run recaptcha on init to allow cookie validation process\n\t\t\tthis.processRecaptcha(formID, model);\n\t\t\t//Rerun process every 110 seconds ( prevent Google recaptcha timeout out at 12O seconds )\n\t\t\tsetInterval(this.processRecaptcha, 110000, formID, model );\n        },\n\n\t\tprocessRecaptcha: function(formID, model) {\n\t\t\ttry{\n\t\t\t\tnfRadio.channel( 'form-' + formID ).trigger( 'disable:submit', model );\n\t\t\t\tgrecaptcha.ready( function() {\n\t\t\t\t\tgrecaptcha.execute( model.get( 'site_key' ), {\n\t\t\t\t\t\taction: 'register'\n\t\t\t\t\t} ).then( function( token ) {\n\t\t\t\t\t\tmodel.set( 'value', token );\n\t\t\t\t\t\tnfRadio.channel( 'form-' + formID ).trigger( 'enable:submit', model );\n\t\t\t\t\t} );\n\t\t\t\t} );\n\t\t\t} catch (e) {\n\t\t\t\t//Wait for the form to fully load and display error\n\t\t\t\tjQuery(document).on( 'nfFormReady', (layoutView) => {\n\t\t\t\t\t//Get consent details as recaptcha failed to load\n\t\t\t\t\tlet consent = nf_check_recaptcha_consent();\n\t\t\t\t\n\t\t\t\t\t//Get submit button\n\t\t\t\t\tlet submitFieldID;\n\t\t\t\t\tmodel.collection.models.forEach( (fieldModel) => {\n\t\t\t\t\t\tif(fieldModel.get(\"type\") === \"submit\"){\n\t\t\t\t\t\t\tsubmitFieldID = fieldModel.get(\"id\");\n\t\t\t\t\t\t};\n\t\t\t\t\t});\n\t\t\t\t\t//Display generic error\n\t\t\t\t\tnfRadio.channel( 'fields' ).request(\"add:error\", submitFieldID, \"recaptcha-v3-missing\", model.collection.options.formModel.get(\"settings\").recaptchaConsentMissing );\n\t\t\t\t\t//Create error message and add possible interaction with cookie consent depending on consent result\n\t\t\t\t\t//Display filterable error to add consent\n\t\t\t\t\tthis.nf_build_default_consent_action(model, consent.services, submitFieldID, layoutView );\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\tnf_build_default_consent_action: function ( model, services, submitFieldID, layoutView ) {\n\t\t\t//Return if no consent management is detected\n\t\t\tconst returnIf = services.length <= 1 && services.includes(\"missing_cookie\") || services.length <= 0;\n\t\t\tif( !returnIf ){ \n\t\t\t\tlet actionElement = document.createElement(\"div\");\n\t\t\t\tactionElement.setAttribute(\"id\", \"nf_recaptcha_consent_event\");\n\t\t\t\tactionElement.innerText += model.collection.options.formModel.get(\"settings\").recaptchaConsentEvent;\n\n\t\t\t\tconst detailData = {\n\t\t\t\t\t\"services\": services,\n\t\t\t\t\t\"element\": actionElement,\n\t\t\t\t\t\"submitFieldID\": submitFieldID, \n\t\t\t\t\t\"layoutView\": layoutView\n\t\t\t\t}\n\t\t\t\t//Allow filtering of the element before printing it\n\t\t\t\tlet nf_consent_link_event = new CustomEvent('nf_consent_link', {detail: detailData});\n\t\t\t\tdocument.dispatchEvent(nf_consent_link_event);\n\n\t\t\t\t//Append action to error element\n\t\t\t\tconst genericErrorElements = document.getElementsByClassName(\"nf-error-recaptcha-v3-missing\");\n\t\t\t\tconst genericErrorElementsList = Array.prototype.slice.call(genericErrorElements);\n\t\t\t\tgenericErrorElementsList.forEach( (error) => {\n\t\t\t\t\terror.append( actionElement );\n\t\t\t\t});\n\t\t\t\t\n\t\t\t}\n\t\t}\n\t\t\n    });\n\n    return controller;\n} );\n","define('controllers/fieldTurnstile',[], function() {\n    var controller = Marionette.Object.extend({\n\n        initialize: function () {\n            this.listenTo( nfRadio.channel( 'turnstile' ), 'init:model',      this.initTurnstile  );\n            this.listenTo( nfRadio.channel( 'forms' ),     'submit:response', this.resetTurnstile );\n            \n            // Setup turnstile global functions and event bindings\n            this.setupTurnstileGlobals();\n            this.bindTurnstileEvents();\n        },\n\n       \tinitTurnstile: function ( model ) {\n       \t\tnfRadio.channel( 'turnstile' ).reply( 'update:response', this.updateResponse, this, model.id );\n        },\n\n        updateResponse: function( response, fieldID ) {\n        \tvar model = nfRadio.channel( 'fields' ).request( 'get:field', fieldID );\n\t\t\tmodel.set( 'value', response );\n            nfRadio.channel( 'fields' ).request( 'remove:error', model.get( 'id' ), 'required-error' );\n        },\n\n        resetTurnstile: function() {\n\t\t\tvar turnstileID = 0;\n\t\t\tjQuery( '.cf-turnstile, .nf-cf-turnstile' ).each( function() {\n\t\t\t\ttry {\n\t\t\t\t\tturnstile.reset( turnstileID );\n\t\t\t\t} catch( e ){\n\t\t\t\t\t// Silent fail\n\t\t\t\t}\n\t\t\t\tturnstileID++;\n\t\t\t} );\n        },\n\n        setupTurnstileGlobals: function() {\n            var self = this;\n            \n            // Setup global callback function\n            window.nfTurnstileCallback = function(token) {\n                var completedWidget = null;\n                jQuery(\".cf-turnstile, .nf-cf-turnstile\").each(function() {\n                    if (this.querySelector(\"iframe\")) {\n                        completedWidget = this;\n                        return false;\n                    }\n                });\n\n                if (completedWidget && token) {\n                    var fieldID = jQuery(completedWidget).data(\"fieldid\");\n                    var input = document.getElementById(\"nf-field-\" + fieldID);\n                    if (input) {\n                        input.value = token;\n                        jQuery(input).trigger(\"change\");\n                        jQuery(input).closest(\".field-wrap\").removeClass(\"nf-error\");\n                        jQuery(input).closest(\".field-wrap\").find(\".nf-error-msg\").remove();\n                    }\n\n                    if (typeof nfRadio !== \"undefined\" && nfRadio.channel) {\n                        try {\n                            nfRadio.channel(\"turnstile\").request(\"update:response\", token, fieldID);\n                        } catch(e) {}\n                    }\n                }\n            };\n\n            // Setup global render function\n            window.nfRenderTurnstile = function() {\n                if (typeof turnstile === \"undefined\") {\n                    setTimeout(window.nfRenderTurnstile, 100);\n                    return;\n                }\n\n                var allTurnstileElements = jQuery(\".cf-turnstile, .nf-cf-turnstile\");\n\n                if (allTurnstileElements.length === 0) {\n                    setTimeout(function() {\n                        window.nfRenderTurnstile();\n                    }, 200);\n                    return;\n                }\n\n                jQuery(\".cf-turnstile:empty, .nf-cf-turnstile:empty\").each(function() {\n                    var element = this;\n                    var sitekey = jQuery(element).data(\"sitekey\");\n                    var fieldId = jQuery(element).data(\"fieldid\");\n\n                    if (!sitekey) {\n                        return;\n                    }\n\n                    try {\n                        turnstile.render(element, {\n                            sitekey: sitekey,\n                            theme: jQuery(element).data(\"theme\") || \"auto\",\n                            size: jQuery(element).data(\"size\") || \"normal\",\n                            callback: function(token) {\n                                var fieldID = jQuery(element).data(\"fieldid\");\n                                var input = document.getElementById(\"nf-field-\" + fieldID);\n                                if (input) {\n                                    input.value = token;\n                                    jQuery(input).trigger(\"change\");\n                                    jQuery(input).closest(\".field-wrap\").removeClass(\"nf-error\");\n                                    jQuery(input).closest(\".field-wrap\").find(\".nf-error-msg\").remove();\n                                }\n\n                                if (typeof nfRadio !== \"undefined\" && nfRadio.channel) {\n                                    try {\n                                        nfRadio.channel(\"turnstile\").request(\"update:response\", token, fieldID);\n                                    } catch(e) {}\n                                }\n                            }\n                        });\n                    } catch(e) {}\n                });\n            };\n        },\n\n        bindTurnstileEvents: function() {\n            var self = this;\n            \n            // Initial render attempt\n            if (typeof window.nfRenderTurnstile === \"function\") {\n                window.nfRenderTurnstile();\n            }\n\n            // Bind to document ready\n            jQuery(document).ready(function() {\n                setTimeout(window.nfRenderTurnstile, 100);\n            });\n\n            // Bind to Ninja Forms events\n            jQuery(document).on(\"nfFormReady\", function() {\n                setTimeout(window.nfRenderTurnstile, 100);\n            });\n\n            if (typeof nfRadio !== \"undefined\") {\n                try {\n                    nfRadio.channel(\"form\").on(\"render:view\", function() {\n                        setTimeout(window.nfRenderTurnstile, 100);\n                    });\n                } catch(e) {}\n            }\n\n            // Retry mechanism for delayed element appearance\n            var retryCount = 0;\n            var maxRetries = 10;\n            var retryInterval = setInterval(function() {\n                retryCount++;\n                if (retryCount >= maxRetries) {\n                    clearInterval(retryInterval);\n                    return;\n                }\n\n                if (jQuery(\".cf-turnstile, .nf-cf-turnstile\").length > 0) {\n                    window.nfRenderTurnstile();\n                    clearInterval(retryInterval);\n                }\n            }, 500);\n        }\n    });\n\n    return controller;\n} );\n\n","define('controllers/fieldHcaptcha',[], function() {\n    \n    var controller = Marionette.Object.extend({\n\n        initialize: function () {\n            \n            this.listenTo( nfRadio.channel( 'hcaptcha' ), 'init:model',      this.initHcaptcha  );\n            this.listenTo( nfRadio.channel( 'forms' ),     'submit:response', this.resetHcaptcha );\n            \n            // Setup hCaptcha global functions and event bindings\n            this.setupHcaptchaGlobals();\n            this.bindHcaptchaEvents();\n        },\n\n       \tinitHcaptcha: function ( model ) {\n       \t\tnfRadio.channel( 'hcaptcha' ).reply( 'update:response', this.updateResponse, this, model.id );\n        },\n\n        updateResponse: function( response, fieldID ) {\n        \tvar model = nfRadio.channel( 'fields' ).request( 'get:field', fieldID );\n\t\t\tmodel.set( 'value', response );\n            nfRadio.channel( 'fields' ).request( 'remove:error', model.get( 'id' ), 'required-error' );\n        },\n\n        resetHcaptcha: function() {\n\t\t\tvar hcaptchaID = 0;\n\t\t\tjQuery( '.h-captcha, .nf-h-captcha' ).each( function() {\n\t\t\t\ttry {\n\t\t\t\t\thcaptcha.reset( hcaptchaID );\n\t\t\t\t} catch( e ){\n\t\t\t\t\t// Silent fail\n\t\t\t\t}\n\t\t\t\thcaptchaID++;\n\t\t\t} );\n        },\n\n        setupHcaptchaGlobals: function() {\n            var self = this;\n            \n            // Setup global callback function\n            window.nfHcaptchaCallback = function(token) {\n                var completedWidget = null;\n                jQuery(\".h-captcha, .nf-h-captcha\").each(function() {\n                    if (this.querySelector(\"iframe\")) {\n                        completedWidget = this;\n                        return false;\n                    }\n                });\n\n                if (completedWidget && token) {\n                    var fieldID = jQuery(completedWidget).data(\"fieldid\");\n                    var input = document.getElementById(\"nf-field-\" + fieldID);\n                    if (input) {\n                        input.value = token;\n                        jQuery(input).trigger(\"change\");\n                        jQuery(input).closest(\".field-wrap\").removeClass(\"nf-error\");\n                        jQuery(input).closest(\".field-wrap\").find(\".nf-error-msg\").remove();\n                    }\n\n                    if (typeof nfRadio !== \"undefined\" && nfRadio.channel) {\n                        try {\n                            nfRadio.channel(\"hcaptcha\").request(\"update:response\", token, fieldID);\n                        } catch(e) {}\n                    }\n                }\n            };\n\n            // Setup global render function\n            window.nfRenderHcaptcha = function() {\n                \n                if (typeof hcaptcha === \"undefined\") {\n                    setTimeout(window.nfRenderHcaptcha, 100);\n                    return;\n                }\n\n                var allHcaptchaElements = jQuery(\".h-captcha, .nf-h-captcha\");\n\n                if (allHcaptchaElements.length === 0) {\n                    setTimeout(function() {\n                        window.nfRenderHcaptcha();\n                    }, 200);\n                    return;\n                }\n                \n                jQuery(\".h-captcha, .nf-h-captcha\").each(function() {\n                    // Check if element is effectively empty (no content or only whitespace)\n                    var isEmpty = this.innerHTML.trim() === \"\";\n                    \n                    if (!isEmpty) {\n                        return; // Skip this element\n                    }\n                    var element = this;\n                    var sitekey = jQuery(element).data(\"sitekey\");\n                    var fieldId = jQuery(element).data(\"fieldid\");\n\n                    if (!sitekey) {\n                        return;\n                    }\n\n                    try {\n                        var widgetId = hcaptcha.render(element, {\n                            sitekey: sitekey,\n                            theme: jQuery(element).data(\"theme\") || \"light\",\n                            size: jQuery(element).data(\"size\") || \"normal\",\n                            callback: function(token) {\n                                var fieldID = jQuery(element).data(\"fieldid\");\n                                var input = document.getElementById(\"nf-field-\" + fieldID);\n                                if (input) {\n                                    input.value = token;\n                                    jQuery(input).trigger(\"change\");\n                                    jQuery(input).closest(\".field-wrap\").removeClass(\"nf-error\");\n                                    jQuery(input).closest(\".field-wrap\").find(\".nf-error-msg\").remove();\n                                }\n\n                                if (typeof nfRadio !== \"undefined\" && nfRadio.channel) {\n                                    try {\n                                        nfRadio.channel(\"hcaptcha\").request(\"update:response\", token, fieldID);\n                                    } catch(e) {}\n                                }\n                            }\n                        });\n                    } catch(e) {\n                        console.error('hCaptcha render error:', e);\n                    }\n                });\n            };\n        },\n\n        bindHcaptchaEvents: function() {\n            var self = this;\n            \n            // Initial render attempt\n            if (typeof window.nfRenderHcaptcha === \"function\") {\n                window.nfRenderHcaptcha();\n            }\n\n            // Bind to document ready\n            jQuery(document).ready(function() {\n                setTimeout(window.nfRenderHcaptcha, 100);\n            });\n\n            // Bind to Ninja Forms events\n            jQuery(document).on(\"nfFormReady\", function() {\n                setTimeout(window.nfRenderHcaptcha, 100);\n            });\n\n            if (typeof nfRadio !== \"undefined\") {\n                try {\n                    nfRadio.channel(\"form\").on(\"render:view\", function() {\n                        setTimeout(window.nfRenderHcaptcha, 100);\n                    });\n                } catch(e) {}\n            }\n\n            // Retry mechanism for delayed element appearance\n            var retryCount = 0;\n            var maxRetries = 10;\n            var retryInterval = setInterval(function() {\n                retryCount++;\n                if (retryCount >= maxRetries) {\n                    clearInterval(retryInterval);\n                    return;\n                }\n\n                if (jQuery(\".h-captcha, .nf-h-captcha\").length > 0) {\n                    window.nfRenderHcaptcha();\n                    clearInterval(retryInterval);\n                }\n            }, 500);\n        }\n    });\n\n    return controller;\n} );\n","define('controllers/fieldHTML',[], function() {\n    var controller = Marionette.Object.extend({\n\n        htmlFields: [],\n        trackedMergeTags: [],\n\n        initialize: function () {\n            this.listenTo( Backbone.Radio.channel( 'fields-html' ), 'init:model', this.setupFieldMergeTagTracking );\n            \n            // Ensure signature fonts are loaded\n            this.loadSignatureFonts();\n        },\n        \n        /**\n         * Load Google Fonts for signature display\n         */\n        loadSignatureFonts: function() {\n            // Check if fonts are already loaded\n            if (document.getElementById('nf-signature-fonts')) {\n                return;\n            }\n            \n            // Create link element for Google Fonts\n            var link = document.createElement('link');\n            link.id = 'nf-signature-fonts';\n            link.rel = 'stylesheet';\n            link.href = 'https://fonts.googleapis.com/css2?family=Dancing+Script&family=Great+Vibes&family=Pacifico&family=Satisfy&display=swap';\n            document.head.appendChild(link);\n        },\n\n        setupFieldMergeTagTracking: function( fieldModel ) {\n            this.htmlFields.push( fieldModel );\n\n            var formID = fieldModel.get( 'formID' );\n            var self = this;\n\n            this.listenTo( nfRadio.channel( 'form-' + formID ), 'init:model', function( formModel ){\n\n                var mergeTags = fieldModel.get( 'default' ).match( new RegExp( /{field:(.*?)}/g ) );\n                if ( ! mergeTags ) return;\n\n                _.each( mergeTags, function( mergeTag ) {\n                    var fieldKey = mergeTag.replace( '{field:', '' ).replace( '}', '' );\n                    var fieldModel = formModel.get( 'fields' ).findWhere({ key: fieldKey });\n                    if( 'undefined' == typeof fieldModel ) return;\n\n                    this.trackedMergeTags.push( fieldModel );\n                    this.listenTo( nfRadio.channel( 'field-' + fieldModel.get( 'id' ) ), 'change:modelValue', this.updateFieldMergeTags );\n                    \n                    // Special handling for repeater fields\n                    if (fieldModel.get('type') === 'repeater') {\n                        // Listen to all field changes to catch repeater sub-field updates\n                        this.listenTo( nfRadio.channel( 'fields' ), 'change:modelValue', function(changedField) {\n                            \n                            // Check if this is a sub-field of our repeater\n                            var changedKey = changedField.get('key');\n                            if (changedKey && changedKey.indexOf(fieldKey + '_') === 0) {\n                                // This is a sub-field of our repeater, trigger update\n                                self.updateFieldMergeTags(fieldModel);\n                            }\n                        });\n                    }\n                }, this );\n\n                // Let's get this party started!\n                this.updateFieldMergeTags();\n            }, this );\n        },\n\n        updateFieldMergeTags: function( fieldModel ) {\n            var self = this;\n            _.each( this.htmlFields, function( htmlFieldModel ){\n                // Get the current HTML field value\n                var value = htmlFieldModel.get( 'value' ) || htmlFieldModel.get( 'default' ) || '';\n                \n               _.each( self.trackedMergeTags, function( fieldModel ){\n\n                   /* Search the value for any spans with mergetag data-key\n                   * values\n                   */\n                   var spans = value.match( new RegExp( /<span data-key=\"field:(.*?)<\\/span>/g ) );\n\t               _.each( spans, function( spanVar ) {\n\t                   /* See if the span string contains the current\n                       * fieldModel's key. If so replace the span with a\n                       * merge tag for evaluation.\n                       */\n                       if( -1 < spanVar.indexOf( \"data-key=\\\"field:\" + fieldModel.get( 'key' ) ) ) {\n\t                       value = value.replace( spanVar, \"{field:\" + fieldModel.get( 'key' ) + \"}\" );\n                       }\n\t               } );\n\n                    var mergeTag = '{field:' + fieldModel.get( 'key' ) + '}';\n\n                    let fieldValue;\n                    // Handle different field types\n                    if (fieldModel.get('type') === \"repeater\") {\n                        fieldValue = self.displayRepeaterData(fieldModel);\n                    } else if (fieldModel.get('type') === \"signature\") {\n                        fieldValue = self.displaySignatureData(fieldModel);\n                    } else {\n                        fieldValue = fieldModel.getValue();\n                    }\n\n\t               /* We replace the merge tag with the value\n\t               * surrounded by a span so that we can still find it\n\t               * and not affect itself or other field merge tags\n\t               */\n                    value = value.replace( mergeTag, \"<span data-key=\\\"field:\"\n                        + fieldModel.get( 'key' ) + \"\\\">\"\n                        + fieldValue + \"</span>\" );\n               }) ;\n               htmlFieldModel.set( 'value', value );\n               htmlFieldModel.trigger( 'reRender' );\n            });\n        },\n\n        displayRepeaterData: function(fieldModel) {\n                // Get the current value which contains all sub-field IDs\n                var repeaterValue = fieldModel.getValue();\n                if (!repeaterValue || typeof repeaterValue !== 'object') {\n                    return '';\n                }\n                \n                const repeaterFieldIDs = Object.keys(repeaterValue);\n                let returnHTML = \"\", passedFields = [];\n\n                _.each(repeaterFieldIDs, function(fieldID){\n                    if(passedFields.indexOf(fieldID) === -1) {\n                        const field = nfRadio.channel( 'fields' ).request( 'get:field', fieldID );\n                        if(typeof field !== \"undefined\"){\n                            const excluded = ['submit', 'html', 'hidden', 'password', 'passwordconfirm', 'divider', 'hr', 'note', 'unknown', 'button', 'confirm', 'creditcard', 'creditcardcvc', 'creditcardexpiration', 'creditcardfullname', 'creditcardnumber', 'creditcardzip', 'recaptcha', 'recaptcha_v3' ];\n                            if(excluded.indexOf(field.get('type')) === -1 && field.getValue().toString().length > 0){\n                                const index = Number(fieldID.split(\"_\").pop()) + 1;\n                                \n                                let fieldValue;\n                                if (field.get('type') === 'signature') {\n                                    fieldValue = this.displaySignatureData(field);\n                                } else {\n                                    fieldValue = field.getValue();\n                                }\n                                \n                                returnHTML += \"<p>\"+ field.get(\"label\") + \" \" + index + \" : \" + fieldValue + \"</p>\";\n                                passedFields.push(fieldID);\n                            } \n                        }\n                    }\n                }, this);\n\n                return returnHTML;\n        },\n\n        /**\n         * Display signature field data as HTML image or styled text\n         * \n         * @param {Object} fieldModel The signature field model\n         * @returns {string} HTML string containing the signature display\n         */\n        displaySignatureData: function(fieldModel) {\n            var value = fieldModel.getValue();\n            \n            // Return empty if no value\n            if (!value || value === '') {\n                return '';\n            }\n            \n            // Try to parse JSON data\n            var signatureData;\n            try {\n                // If it's already an object, use it directly\n                if (typeof value === 'object') {\n                    signatureData = value;\n                } else if (typeof value === 'string' && value.charAt(0) === '{') {\n                    // Parse JSON string\n                    signatureData = JSON.parse(value);\n                } else {\n                    // Not JSON, return as-is\n                    return value;\n                }\n            } catch (e) {\n                // If JSON parsing fails, return the original value\n                console.warn('Failed to parse signature data:', e);\n                return value;\n            }\n            \n            // Check if we have valid signature data\n            if (!signatureData || !signatureData.signature_type) {\n                return value;\n            }\n            \n            // Handle typed signatures\n            if (signatureData.signature_type === 'typed' && signatureData.typed_name) {\n                // Get font from field settings first, then signature data, then default\n                // This ensures the HTML field merge tag uses the field's configured font\n                var configuredFont = fieldModel.get('signature_font');\n                var font = configuredFont || signatureData.signature_font || 'dancing-script';\n                var fontFamily = this.getSignatureFontFamily(font);\n\n                return '<div class=\"nf-signature-typed\" style=\"font-family: ' + fontFamily + '; font-size: 28px; color: #000000; padding: 10px 0;\">' +\n                       _.escape(signatureData.typed_name) +\n                       '</div>';\n            }\n            \n            // Handle drawn signatures\n            if (signatureData.signature_type === 'drawn' && signatureData.signature_data) {\n                // Ensure the signature data is a valid data URI\n                if (signatureData.signature_data.indexOf('data:image') === 0) {\n                    return '<img class=\"nf-signature-drawn\" src=\"' + _.escape(signatureData.signature_data) + '\" ' +\n                           'alt=\"Signature\" style=\"max-width: 400px; height: auto; display: block;\" />';\n                }\n            }\n            \n            // If we couldn't process the signature, return empty\n            return '';\n        },\n        \n        /**\n         * Get the appropriate font family for signature display\n         * Matches the valid fonts defined in PHP (Signature.php VALID_FONTS constant)\n         * Uses single quotes to avoid HTML escaping issues\n         *\n         * @param {string} font The font identifier\n         * @returns {string} CSS font-family value\n         */\n        getSignatureFontFamily: function(font) {\n            var fontMap = {\n                'dancing-script': '\\'Dancing Script\\', cursive',\n                'satisfy': '\\'Satisfy\\', cursive',\n                'cursive': 'cursive'\n            };\n\n            return fontMap[font] || fontMap['dancing-script'];\n        },\n        \n\n    });\n\n    return controller;\n});\n\n","/**\n* When a form is loaded, enable any help text that appears on the page.\n*/\ndefine('controllers/helpText',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'form' ), 'render:view', this.initHelpText );\n\t\t\tthis.listenTo( nfRadio.channel( 'field-repeater' ), 'fieldset:added', this.initHelpText );\n\n\t\t\tnfRadio.channel( 'form' ).reply( 'init:help', this.initHelpText );\n\t\t},\n\n\t\tinitHelpText: function( view ) {\n\n\t\t\tif(view && !view.el && typeof view.get === 'function'){\n\t\t\t\t//Catch repeater fieldset added event\n\t\t\t\tif(view.get(\"type\") === \"repeater\"){\n\t\t\t\t\tview.el = \"#nf-form-\" + view.get(\"formID\") + \"-cont\";\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tjQuery( view.el ).find( '.nf-help' ).each( function(el) {\n\t\t\t\tvar jBox = jQuery( this ).jBox( 'Tooltip', {\n\t\t\t\t\ttheme: 'TooltipBorder',\n\t\t\t\t\tcontent: jQuery( this ).data( 'text' ),\n\t\t\t\t\ttrigger: 'mouseenter focus',\n\t\t\t\t\tcloseOnMouseleave: true,\n\t\t\t\t\tcloseOnClick: true\n\t\t\t\t});\n\t\t\t// Hide tooltip on keydown and mouseleave\n\t\t\tjQuery(this).on('keydown mouseleave', function() {\n\t\t\t\tjBox.close();\n\t\t\t});\n\t\t\t} );\n\t\t}\n\t});\n\n\treturn controller;\n } );\n\n","define('controllers/fieldTextbox',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n            nfRadio.channel( 'textbox' ).reply( 'get:calcValue', this.getCalcValue, this );\n\t\t},\n\n\t\tgetCalcValue: function( fieldModel ) {\n            if('currency' == fieldModel.get('mask')){\n                var form = nfRadio.channel( 'app' ).request( 'get:form', fieldModel.get( 'formID' ) );\n                var currencySymbol = ('undefined' !== typeof form) ? form.get( 'currencySymbol' ) : '';\n                var currencySymbolDecoded = jQuery('<textarea />').html(currencySymbol).text();\n                return fieldModel.get( 'value' ).replace(currencySymbolDecoded, '');\n            }\n\n\t\t\treturn fieldModel.get( 'value' );\n\t\t},\n\t});\n\n\treturn controller;\n} );\n","/**\n * When a form is loaded, enable any rtes in textareas.\n */\ndefine('controllers/fieldTextareaRTE',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.listenTo( nfRadio.channel( 'textarea' ), 'render:view', this.initTextareaRTEs );\n\t\t\tthis.listenTo( nfRadio.channel( 'textarea' ), 'click:extra', this.clickExtra );\n\n\t\t\t// Instantiates the variable that holds the media library frame.\n\t\t\tthis.meta_image_frame;\n\n\t\t\tthis.currentContext = {};\n\n\t\t\tif( 'undefined' == typeof jQuery.summernote ) return;\n\n\t\t\tjQuery.summernote.options.icons = {\n\t\t        'align': 'dashicons dashicons-editor-alignleft',\n\t\t        'alignCenter': 'dashicons dashicons-editor-aligncenter',\n\t\t        'alignJustify': 'dashicons dashicons-editor-justify',\n\t\t        'alignLeft': 'dashicons dashicons-editor-alignleft',\n\t\t        'alignRight': 'dashicons dashicons-editor-alignright',\n\t\t        'indent': 'dashicons dashicons-editor-indent',\n\t\t        'outdent': 'dashicons dashicons-editor-outdent',\n\t\t        // 'arrowsAlt': 'dashicons fa-arrows-alt',\n\t\t        'bold': 'dashicons dashicons-editor-bold',\n\t\t        'caret': 'dashicons dashicons-arrow-down',\n\t\t        // 'circle': 'dashicons fa-circle',\n\t\t        'close': 'dashicons dashicons-dismiss',\n\t\t        'code': 'dashicons dashicons-editor-code',\n\t\t        'eraser': 'dashicons dashicons-editor-removeformatting',\n\t\t        // 'font': 'dashicons fa-font',\n\t\t        // 'frame': 'dashicons fa-frame',\n\t\t        'italic': 'dashicons dashicons-editor-italic',\n\t\t        'link': 'dashicons dashicons-admin-links',\n\t\t        'unlink': 'dashicons dashicons-editor-unlink',\n\t\t        'magic': 'dashicons dashicons-editor-paragraph',\n\t\t        // 'menuCheck': 'dashicons fa-check',\n\t\t        'minus': 'dashicons dashicons-minus',\n\t\t        'orderedlist': 'dashicons dashicons-editor-ol',\n\t\t        // 'pencil': 'dashicons fa-pencil',\n\t\t        // 'picture': 'dashicons fa-picture-o',\n\t\t        // 'question': 'dashicons fa-question',\n\t\t        'redo': 'dashicons dashicons-redo',\n\t\t        'square': 'dashicons fa-square',\n\t\t        // 'strikethrough': 'dashicons fa-strikethrough',\n\t\t        // 'subscript': 'dashicons fa-subscript',\n\t\t        // 'superscript': 'dashicons fa-superscript',\n\t\t        'table': 'dashicons dashicons-editor-table',\n\t\t        // 'textHeight': 'dashicons fa-text-height',\n\t\t        // 'trash': 'dashicons fa-trash',\n\t\t        'underline': 'dashicons dashicons-editor-underline',\n\t\t        'undo': 'dashicons dashicons-undo',\n\t\t        'unorderedlist': 'dashicons dashicons-editor-ul',\n\t\t        // 'video': 'dashicons fa-youtube-play'\n\t\t      };\n\n\t\t},\n\n\t\tinitTextareaRTEs: function( view ) {\n\t\t\tif ( 1 != view.model.get( 'textarea_rte' ) ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\t/*\n\t\t\t * Custom Button for links\n\t\t\t */\n\t\t\tvar that = this;\n\t\t\t// var linkButton = this.linkButton();\n\t\t\tvar linkButton = function( context ) {\n\t\t\t\treturn that.linkButton( context );\n\t\t\t}\n\t\t\tvar mediaButton = function( context ) {\n\t\t\t\treturn that.mediaButton( context );\n\t\t\t}\n\n\t\t\tvar toolbar = [\n\t\t\t\t[ 'paragraphStyle', ['style'] ],\n\t\t\t\t[ 'fontStyle', [ 'bold', 'italic', 'underline','clear' ] ],\n\t\t\t\t[ 'lists', [ 'ul', 'ol' ] ],\n\t\t\t    [ 'paragraph', [ 'paragraph' ] ],\n\t\t\t    [ 'customGroup', [ 'linkButton', 'unlink' ] ],\n\t\t\t    [ 'table', [ 'table' ] ],\n\t\t\t    [ 'actions', [ 'undo', 'redo' ] ],\n\t\t\t];\n\n\t\t\tif ( 1 == view.model.get( 'textarea_media' ) && 0 != userSettings.uid ) {\n\t\t\t\ttoolbar.push( [ 'tools', [ 'mediaButton' ] ] );\n\t\t\t}\n\n\t\t\tjQuery( view.el ).find( '.nf-element' ).summernote( {\n\t\t\t\ttoolbar: toolbar,\n\t\t\t\tbuttons: {\n\t\t\t\t\tlinkButton: linkButton,\n\t\t\t\t\tmediaButton: mediaButton\n\t\t\t\t},\n\t\t\t\theight: 150,   //set editable area's height\n\t\t\t\tcodemirror: { // codemirror options\n\t\t\t\t    theme: 'monokai',\n\t\t\t\t    lineNumbers: true\n\t\t\t\t},\n\t\t\t\tprettifyHtml: true,\n\t\t\t\tcallbacks: {\n\t\t\t\t\tonChange: function( e ) {\n\t\t\t\t\t\tview.model.set( 'value', jQuery( this ).summernote( 'code' ) );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} );\n\n\t\t\tvar linkMenu = jQuery( view.el ).find( '.link-button' ).next( '.dropdown-menu' ).find( 'button' );\n\t\t\tlinkMenu.replaceWith(function () {\n\t\t\t    return jQuery( '<div/>', {\n\t\t\t        class: jQuery( linkMenu ).attr( 'class' ),\n\t\t\t        html: this.innerHTML\n\t\t\t    } );\n\t\t\t} );\n\t\t},\n\n\t\tlinkButton: function( context ) {\n\t\t\tvar that = this;\n\t\t\tvar ui = jQuery.summernote.ui;\n\t\t\tvar linkButton = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-rte-link-button' );\n\t\t\tvar linkDropdown = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-rte-link-dropdown' );\n\t\t\treturn ui.buttonGroup([\n\t\t\t\tui.button({\n\t            className: 'dropdown-toggle link-button',\n\t            contents: linkButton({}),\n\t            tooltip: nfi18n.fieldTextareaRTEInsertLink,\n\t            click: function( e ) {\n\t            \tthat.clickLinkButton( e, context );\n\t            },\n\t            data: {\n\t              toggle: 'dropdown'\n\t            }\n\t          }),\n\t\t\t\tui.dropdown([\n\t            ui.buttonGroup({\n\t              children: [\n\t                ui.button({\n\t                  contents: linkDropdown({}),\n\t                  tooltip: ''\n\t                }),\n\t              ]\n\t            })\n\t          ])\n\t\t\t]).render();\n\t\t},\n\n\t\tmediaButton: function( context ) {\n\t\t\tvar that = this;\n\t\t\tvar ui = jQuery.summernote.ui;\n\t\t\tvar mediaButton = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-rte-media-button' );\n\t\t\treturn ui.button({\n\t            className: 'dropdown-toggle',\n\t            contents: mediaButton({}),\n\t            tooltip: nfi18n.fieldTextareaRTEInsertMedia,\n\t            click: function( e ) {\n\t            \tthat.openMediaManager( e, context );\n\t            }\n\t          }).render();\n\t\t},\n\n\t\topenMediaManager: function( e, context ) {\n\t\t\tcontext.invoke( 'editor.saveRange' );\n\t\t\t// If the frame already exists, re-open it.\n\t\t\tif ( this.meta_image_frame ) 