trollers/fieldProduct',[], function() {\n    var controller = Marionette.Object.extend( {\n        initialize: function() {\n            this.listenTo( nfRadio.channel( 'product' ), 'init:model', this.register );\n            nfRadio.channel( 'product' ).reply( 'get:calcValue', this.getCalcValue, this );\n        },\n\n        register: function( model ) {\n            model.set( 'renderProductQuantity', this.renderProductQuantity );\n            model.set( 'renderProduct', this.renderProduct );\n            model.set( 'renderOptions', this.renderOptions );\n        },\n\n        renderProduct: function(){\n            switch( this.product_type ) {\n                case 'user':\n                    var template = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-field-textbox' );\n                    return template( this );\n                    break;\n                case 'hidden':\n                    var template = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-field-hidden' );\n                    return template( this );\n                    break;\n\n                case 'dropdown':\n                    var template = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-product-dropdown' );\n                    return template( this );\n                    break;\n                default:\n                    var template = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-product-single' );\n                    return template( this );\n            }\n        },\n\n        renderProductQuantity: function(){\n            if ( 1 == this.product_use_quantity ) {\n                var template = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-product-quantity' );\n                return template( this );\n            }\n        },\n\n        renderOptions: function() {\n            var that = this;\n            var html = '';\n            _.each( this.options, function( option ) {\n                if ( 1 == option.selected ) {\n                    var selected = true;\n                } else {\n                    var selected = false;\n                }\n\n                option.selected = selected;\n                option.fieldID = that.id;\n                option.classes = that.classes;\n                option.currentValue = that.value;\n\n                var template = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-product-' + that.product_type + '-option' );\n                html += template( option );\n            } );\n\n            return html;\n        },\n\n        getCalcValue: function( fieldModel ) {\n\n            var product_price = fieldModel.get( 'product_price' );\n            var product_quantity = fieldModel.get( 'value' );\n\n            return product_price * product_quantity;\n        }\n    });\n\n    return controller;\n} );\n\n","define('controllers/fieldTotal',[], function() {\n    var controller = Marionette.Object.extend( {\n\n        totalModel: {},\n\n        productTotals: {},\n\n        initialize: function() {\n            this.listenTo( nfRadio.channel( 'total' ), 'init:model', this.register );\n            this.listenTo( nfRadio.channel( 'shipping' ), 'init:model', this.registerShipping );\n        },\n\n        register: function( totalModel ){\n            this.totalModel = totalModel;\n\n            var formID = totalModel.get( 'formID' );\n            this.listenTo( nfRadio.channel( 'form-' + formID ), 'loaded', this.onFormLoaded );\n\n            this.listenTo( nfRadio.channel( 'product' ), 'change:modelValue', this.onChangeProduct );\n            this.listenTo( nfRadio.channel( 'quantity' ), 'change:modelValue', this.onChangeQuantity );\n        },\n\n        registerShipping: function( shippingModel ){\n            this.shippingCost = shippingModel.get( 'shipping_cost' );\n        },\n\n        onFormLoaded: function( for